/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.guigraphics.renderer;

import com.comsol.guigraphics.views.d;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ViewBase;
import com.comsol.model.dbimodel.ViewFeature;
import com.comsol.model.dbimodel.ViewList;
import com.comsol.model.operations.operationID.PostOperationID;
import com.comsol.model.operations.operationID.ViewOperationID;
import com.comsol.model.util.CameraFromCanvas;
import com.comsol.renderer.interfaces.ICameraLoader;
import com.comsol.renderer.interfaces.ICameraSaver;
import com.comsol.renderer.interfaces.ICsOnScreenContext3d;
import com.comsol.renderer.server.canvas.CameraParameters;
import com.comsol.renderer.server.canvas.CameraParameters1d;
import com.comsol.renderer.server.canvas.CameraParameters2d;
import com.comsol.renderer.server.canvas.CameraParameters3d;
import com.comsol.renderer.server.canvas.CameraParametersDiagram;
import com.comsol.renderer.server.canvas.CameraParametersFactory;
import com.comsol.renderer.server.canvas.CameraParametersGraph;
import com.comsol.renderer.server.canvas.CameraParametersKey;
import com.comsol.renderer.server.canvas.CameraParametersPolar;
import com.comsol.renderer.server.canvas.CameraParametersSmith;
import com.comsol.renderer.server.graphics3d.Camera;
import com.comsol.renderer.server.graphics3d.Camera2d;
import com.comsol.renderer.server.graphics3d.Camera3d;
import com.comsol.renderer.server.graphics3d.CameraGraph;
import com.comsol.renderer.server.graphics3d.Direction;
import com.comsol.renderer.server.graphics3d.Position;
import com.comsol.util.methods.q;
import com.comsol.util.renderer.RenderLogger;

public class c {
    private final ICsOnScreenContext3d b;
    private static double c = Math.log10(1.1754943508222875E-38);
    private static double d = Math.log10(3.4028234663852886E38);

    public c(ICsOnScreenContext3d iCsOnScreenContext3d) {
        this.b = iCsOnScreenContext3d;
    }

    public void a(final ViewBase viewBase, final boolean bl2) {
        if (viewBase == null || this.b == null) {
            RenderLogger.b((RenderLogger.ContentType)RenderLogger.ContentType.e, (String)("failed to loadCameraToCanvas, view is null: " + (viewBase == null) + ", canvas is null: " + (this.b == null)));
            return;
        }
        RenderLogger.a((RenderLogger.ContentType)RenderLogger.ContentType.e, (String)"loadCameraToCanvas", (Object[])new Object[]{viewBase.getTag(), viewBase.getType(), viewBase.getObjectID(), this.b.getTargetAxis()});
        this.b.loadCamera(new ICameraLoader(){

            public CameraParameters loadCamera() {
                return c.this.b(viewBase, bl2);
            }
        });
    }

    public static ViewFeature a(ViewBase viewBase) {
        if (viewBase != null && viewBase.isInModel()) {
            return viewBase.getViewDim() <= 2 ? viewBase.axis() : viewBase.camera();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraParameters b(ViewBase viewBase, boolean bl2) {
        int n2 = viewBase.getViewDim();
        String string = viewBase.getOperationID();
        ViewFeature viewFeature = com.comsol.guigraphics.renderer.c.a(viewBase);
        if (viewFeature == null) {
            return null;
        }
        d d2 = new d(viewBase);
        ViewFeature viewFeature2 = viewFeature;
        synchronized (viewFeature2) {
            if (n2 == 1) {
                return this.b(viewFeature, d2);
            }
            if (n2 == 2) {
                if (PostOperationID.PLOTGROUP1D.toString().equals(string)) {
                    boolean bl3 = viewBase.hasProperty("xlog") && viewBase.getBoolean("xlog");
                    boolean bl4 = viewBase.hasProperty("ylog") && viewBase.getBoolean("ylog");
                    boolean bl5 = viewBase.hasProperty("ylogsec") && viewBase.getBoolean("ylogsec");
                    boolean bl6 = viewBase.hasProperty("twoyaxes") && viewBase.getBoolean("twoyaxes");
                    return this.a(viewFeature, string, d2, bl6, bl3, bl4, bl5);
                }
                return this.a(viewFeature, string, d2, bl2);
            }
            if (n2 == 3) {
                return this.a(viewFeature, d2);
            }
        }
        return null;
    }

    private CameraParameters a(ViewFeature viewFeature, CameraParametersKey cameraParametersKey) {
        CameraParameters3d cameraParameters3d = CameraParametersFactory.createCameraParameters3d((CameraParametersKey)cameraParametersKey);
        boolean bl2 = !viewFeature.getString("projection").equals(viewFeature.getCameraProjection());
        cameraParameters3d.setIsNewProjection(bl2);
        boolean bl3 = viewFeature.getString("projection").equals("perspective");
        double[] dArray = viewFeature.getDoubleArray("position");
        double[] dArray2 = viewFeature.getDoubleArray("target");
        double[] dArray3 = viewFeature.getDoubleArray("up");
        double[] dArray4 = viewFeature.getDoubleArray("viewoffset");
        double[] dArray5 = viewFeature.getDoubleArray("rotationpoint");
        if (viewFeature.hasProperty("viewscaletype")) {
            String string = viewFeature.getString("viewscaletype");
            if (viewFeature.getBoolean("forcenoviewscaling")) {
                string = "none";
            }
            if ("none".equalsIgnoreCase(string)) {
                cameraParameters3d.resetAxisViewScales();
            } else if ("automatic".equalsIgnoreCase(string)) {
                cameraParameters3d.setAxisViewScalesAuto();
                String string2 = viewFeature.getString("autocontext");
                if ("isotropic".equalsIgnoreCase(string2)) {
                    cameraParameters3d.setAxisViewScaleAutoRatios(1.0f, 1.0f, 1.0f);
                    cameraParameters3d.setAutoUpdate(viewFeature.getBoolean("autoupdate"));
                } else if ("anisotropic".equalsIgnoreCase(string2)) {
                    float f2 = (float)viewFeature.getDouble("xweight");
                    float f3 = (float)viewFeature.getDouble("yweight");
                    float f4 = (float)viewFeature.getDouble("zweight");
                    cameraParameters3d.setAutoUpdate(viewFeature.getBoolean("autoupdate"));
                    cameraParameters3d.setAxisViewScaleAutoRatios(f2, f3, f4);
                }
            } else if ("manual".equalsIgnoreCase(string)) {
                float f5 = (float)viewFeature.getDouble("xscale");
                float f6 = (float)viewFeature.getDouble("yscale");
                float f7 = (float)viewFeature.getDouble("zscale");
                cameraParameters3d.setAxisViewScales(f5, f6, f7);
            }
        }
        if (bl3) {
            cameraParameters3d.setProjectionType(CameraParameters3d.Projection.PERSPECTIVE);
            double d2 = viewFeature.getDouble("zoomanglefull");
            cameraParameters3d.setFieldOfView((float)d2 / 2.0f);
        } else {
            cameraParameters3d.setProjectionType(CameraParameters3d.Projection.ORTHOGRAPHIC);
            double d3 = viewFeature.getDouble("orthoscale");
            cameraParameters3d.setOrthographicWidth((float)d3);
        }
        cameraParameters3d.setRotationPoint(new Position((float)dArray5[0], (float)dArray5[1], (float)dArray5[2]));
        cameraParameters3d.setPosition(new Position((float)dArray[0], (float)dArray[1], (float)dArray[2]), new Position((float)dArray2[0], (float)dArray2[1], (float)dArray2[2]), new Direction((float)dArray3[0], (float)dArray3[1], (float)dArray3[2]));
        cameraParameters3d.setRelativeViewOffset((float)dArray4[0], (float)dArray4[1]);
        CameraParameters3d cameraParameters3d2 = cameraParameters3d;
        return cameraParameters3d2;
    }

    private void a(double[] dArray, boolean[] blArray) {
        int n2 = 0;
        while (n2 < dArray.length) {
            if (blArray[n2 / 2]) {
                dArray[n2] = Math.pow(10.0, dArray[n2]);
                dArray[n2 + 1] = Math.pow(10.0, dArray[n2 + 1]);
            }
            n2 += 2;
        }
    }

    private void b(double[] dArray, boolean[] blArray) {
        int n2 = 0;
        while (n2 < dArray.length) {
            boolean bl2 = blArray[n2 / 2];
            if (bl2) {
                dArray[n2] = com.comsol.guigraphics.renderer.c.a(dArray[n2]);
                dArray[n2 + 1] = com.comsol.guigraphics.renderer.c.a(dArray[n2 + 1]);
            }
            n2 += 2;
        }
    }

    private CameraParameters a(ViewFeature viewFeature, String string, CameraParametersKey cameraParametersKey, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (!PostOperationID.PLOTGROUP1D.toString().equals(string)) {
            throw new IllegalArgumentException("createGraphCameraParameters is only used to create PLOTGROUP1D");
        }
        CameraParametersGraph cameraParametersGraph = CameraParametersFactory.createCameraParametersGraph((CameraParametersKey)cameraParametersKey);
        if (viewFeature.hasProperty("preserveaspect")) {
            if (viewFeature.getBoolean("preserveaspect")) {
                cameraParametersGraph.setResetAxisViewScales(true);
            } else {
                cameraParametersGraph.setAxisViewScalesAuto(true);
            }
        }
        cameraParametersGraph.setAutoAxisLimits(!viewFeature.getBoolean("axislimits"));
        double[] dArray = new double[]{viewFeature.getDouble("xmin"), viewFeature.getDouble("xmax"), viewFeature.getDouble("xmin"), viewFeature.getDouble("xmax")};
        double[] dArray2 = new double[]{viewFeature.getDouble("ymin"), viewFeature.getDouble("ymax"), viewFeature.getDouble("yminsec"), viewFeature.getDouble("ymaxsec")};
        boolean[] blArray = new boolean[]{bl3, bl3};
        boolean[] blArray2 = new boolean[]{bl4, bl5};
        this.b(dArray, blArray);
        this.b(dArray2, blArray2);
        cameraParametersGraph.setXAxes(dArray, blArray);
        cameraParametersGraph.setYAxes(dArray2, blArray2);
        return cameraParametersGraph;
    }

    private CameraParameters a(ViewFeature viewFeature, String string, CameraParametersKey cameraParametersKey, boolean bl2) {
        CameraParametersSmith cameraParametersSmith;
        if (ViewOperationID.DIAGRAMVIEW.toString().equalsIgnoreCase(string)) {
            CameraParametersDiagram cameraParametersDiagram = CameraParametersFactory.createCameraParametersDiagram((CameraParametersKey)cameraParametersKey);
            double d2 = viewFeature.getDouble("xmin");
            double d3 = viewFeature.getDouble("xmax");
            double d4 = viewFeature.getDouble("ymin");
            double d5 = viewFeature.getDouble("ymax");
            cameraParametersDiagram.setLimits((float)d2, (float)d3, (float)d4, (float)d5);
            cameraParametersSmith = cameraParametersDiagram;
        } else if (PostOperationID.POLARGROUP.toString().equalsIgnoreCase(string)) {
            CameraParametersPolar cameraParametersPolar = CameraParametersFactory.createCameraParametersPolar((CameraParametersKey)cameraParametersKey);
            cameraParametersPolar.setLimits((float)viewFeature.getDouble("rmin"), (float)viewFeature.getDouble("rmax"));
            cameraParametersPolar.setAutoAxisLimits(!viewFeature.getBoolean("axislimits"));
            cameraParametersSmith = cameraParametersPolar;
        } else if (PostOperationID.SMITHGROUP.toString().equals(string)) {
            CameraParametersSmith cameraParametersSmith2;
            cameraParametersSmith = cameraParametersSmith2 = CameraParametersFactory.createCameraParametersSmith((CameraParametersKey)cameraParametersKey);
        } else {
            if (PostOperationID.PLOTGROUP1D.toString().equals(string)) {
                throw new IllegalArgumentException("PLOTGROUP1D should be handled separately.");
            }
            CameraParameters2d cameraParameters2d = CameraParametersFactory.createCameraParameters2d((CameraParametersKey)cameraParametersKey);
            boolean bl3 = viewFeature.getBoolean("forcenoviewscaling");
            boolean bl4 = !bl3 && viewFeature.hasProperty("viewscaletype") && viewFeature.getString("viewscaletype").equalsIgnoreCase("automatic") && viewFeature.getString("autocontext").equalsIgnoreCase("autofit");
            double d6 = viewFeature.getDouble("xmin");
            double d7 = viewFeature.getDouble("xmax");
            double d8 = viewFeature.getDouble("ymin");
            double d9 = viewFeature.getDouble("ymax");
            if (viewFeature.hasProperty("viewscaletype")) {
                float f2;
                String string2 = viewFeature.getString("viewscaletype");
                if (bl3) {
                    string2 = "none";
                }
                if ("none".equalsIgnoreCase(string2)) {
                    cameraParameters2d.setResetAxisViewScales(true);
                } else if ("automatic".equalsIgnoreCase(string2)) {
                    float f3;
                    cameraParameters2d.setAxisViewScalesAuto(true);
                    String string3 = viewFeature.getString("autocontext");
                    if ("autofit".equalsIgnoreCase(string3)) {
                        if (!bl2) {
                            f2 = (float)viewFeature.getDouble("xscale");
                            f3 = (float)viewFeature.getDouble("yscale");
                            cameraParameters2d.setAxisViewScales(f2, f3);
                        }
                    } else if ("isotropic".equalsIgnoreCase(string3)) {
                        cameraParameters2d.setAxisViewScaleAutoRatios(1.0f, 1.0f);
                    } else if ("anisotropic".equalsIgnoreCase(string3)) {
                        f2 = (float)viewFeature.getDouble("xweight");
                        f3 = (float)viewFeature.getDouble("yweight");
                        cameraParameters2d.setAxisViewScaleAutoRatios(f2, f3);
                    }
                } else if ("manual".equalsIgnoreCase(string2)) {
                    float f4 = (float)viewFeature.getDouble("xscale");
                    f2 = (float)viewFeature.getDouble("yscale");
                    cameraParameters2d.setAxisViewScales(f4, f2);
                }
            } else {
                RenderLogger.b((RenderLogger.ContentType)RenderLogger.ContentType.g, (String)"Normal 2d view does not have property 'viewscaletype'!");
            }
            boolean bl5 = true;
            boolean bl6 = true;
            if (viewFeature.hasProperty("xminhidden") && viewFeature.hasProperty("xmaxhidden") && viewFeature.hasProperty("yminhidden") && viewFeature.hasProperty("ymaxhidden")) {
                if (viewFeature.getString("xmin").equals(viewFeature.getString("xminhidden")) && viewFeature.getString("xmax").equals(viewFeature.getString("xmaxhidden"))) {
                    bl5 = false;
                }
                if (viewFeature.getString("ymin").equals(viewFeature.getString("yminhidden")) && viewFeature.getString("ymax").equals(viewFeature.getString("ymaxhidden"))) {
                    bl6 = false;
                }
            }
            if (bl4 && (bl5 || bl6)) {
                bl5 = true;
                bl6 = true;
            }
            if (bl5 && bl6) {
                if (bl4) {
                    cameraParameters2d.setLimits((float)d6, (float)d7, (float)d8, (float)d9, false);
                } else {
                    cameraParameters2d.setLimits((float)d6, (float)d7, (float)d8, (float)d9);
                }
            } else if (bl5) {
                cameraParameters2d.setLimitsX((float)d6, (float)d7);
            } else if (bl6) {
                cameraParameters2d.setLimitsY((float)d8, (float)d9);
            } else {
                cameraParameters2d.setLimits((float)d6, (float)d7, (float)d8, (float)d9);
            }
            if (bl5 || bl6) {
                if (viewFeature.hasProperty("abstractviewsetting") && viewFeature.getBoolean("abstractviewsetting")) {
                    cameraParameters2d.updateAbstractViewSetting();
                }
            } else if (viewFeature.hasProperty("abstractviewsetting") && viewFeature.getBoolean("abstractviewsetting")) {
                double[] dArray = new double[]{viewFeature.getDouble("abstractviewlratio"), viewFeature.getDouble("abstractviewrratio"), viewFeature.getDouble("abstractviewbratio"), viewFeature.getDouble("abstractviewtratio"), viewFeature.getDouble("abstractviewxscale"), viewFeature.getDouble("abstractviewyscale")};
                float[] fArray = new float[dArray.length];
                int n2 = 0;
                while (n2 < dArray.length) {
                    fArray[n2] = (float)dArray[n2];
                    ++n2;
                }
                cameraParameters2d.setAbstractViewSetting(fArray);
            }
            cameraParametersSmith = cameraParameters2d;
        }
        return cameraParametersSmith;
    }

    private CameraParameters b(ViewFeature viewFeature, CameraParametersKey cameraParametersKey) {
        CameraParameters1d cameraParameters1d = CameraParametersFactory.createCameraParameters1d((CameraParametersKey)cameraParametersKey);
        cameraParameters1d.setLimits((float)viewFeature.getDouble("xmin"), (float)viewFeature.getDouble("xmax"));
        CameraParameters1d cameraParameters1d2 = cameraParameters1d;
        return cameraParameters1d2;
    }

    public boolean a(final Model model, final ViewBase viewBase) {
        if (viewBase == null) {
            return false;
        }
        return this.b.saveCamera(new ICameraSaver(){

            public boolean storeCamera() {
                return c.this.b(model, viewBase);
            }
        });
    }

    private boolean b(Model model, ViewBase viewBase) {
        if (model != null) {
            ViewList viewList = model.view();
            viewList.lockViewCreationOrRemoval(true);
            try {
                if (!viewBase.isInModel()) {
                    return false;
                }
                boolean bl2 = this.c(viewBase);
                return bl2;
            }
            finally {
                viewList.lockViewCreationOrRemoval(false);
            }
        }
        return this.c(viewBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean c(ViewBase viewBase) {
        int n2 = viewBase.getViewDim();
        String string = viewBase.getOperationID();
        ViewFeature viewFeature = n2 <= 2 ? viewBase.axis() : viewBase.camera();
        Camera camera = this.b.getCamera();
        if (!camera.hasBeenInitializedByClient()) {
            return false;
        }
        ViewFeature viewFeature2 = viewFeature;
        synchronized (viewFeature2) {
            if (n2 <= 2) {
                boolean bl2;
                boolean bl3 = viewBase.hasProperty("xlog") && viewBase.getBoolean("xlog");
                boolean bl4 = viewBase.hasProperty("ylog") && viewBase.getBoolean("ylog");
                boolean bl5 = bl2 = viewBase.hasProperty("ylogsec") && viewBase.getBoolean("ylogsec");
                if (PostOperationID.PLOTGROUP1D.toString().equals(string)) {
                    return this.b(n2, string, viewFeature, camera, bl3, bl4, bl2);
                }
                return this.a(n2, string, viewFeature, camera, bl3, bl4, bl2);
            }
            if (n2 == 3) {
                return this.a(viewFeature, camera, viewBase.getBoolean("rotcenlocked"));
            }
        }
        return false;
    }

    private boolean a(ViewFeature viewFeature, Camera camera, boolean bl2) {
        if (!(camera instanceof Camera3d)) {
            RenderLogger.b((RenderLogger.ContentType)RenderLogger.ContentType.h, (String)("Update camera model 3d with the wrong camera type: " + camera.getType()));
            return false;
        }
        Camera3d camera3d = (Camera3d)camera;
        Position position = camera3d.getPosition();
        Position position2 = camera3d.getTargetPosition();
        Direction direction = camera3d.getUpIndication();
        Position position3 = camera3d.getRotationPoint();
        float f2 = camera3d.getFieldOfView();
        double d2 = camera3d.getRelativeViewOffsetX();
        double d3 = camera3d.getRelativeViewOffsetY();
        double d4 = camera3d.getOrthographicWidth();
        CameraFromCanvas cameraFromCanvas = new CameraFromCanvas();
        viewFeature.setCameraProjection(viewFeature.getString("projection"));
        cameraFromCanvas.set("position", new double[]{position.getX(), position.getY(), position.getZ()});
        cameraFromCanvas.set("target", new double[]{position2.getX(), position2.getY(), position2.getZ()});
        cameraFromCanvas.set("up", new double[]{direction.getX(), direction.getY(), direction.getZ()});
        cameraFromCanvas.set("zoomanglefull", (double)(f2 * 2.0f));
        cameraFromCanvas.set("viewoffset", new double[]{d2, d3});
        cameraFromCanvas.set("orthoscale", d4);
        if (!bl2) {
            cameraFromCanvas.set("rotationpoint", new double[]{position3.getX(), position3.getY(), position3.getZ()});
        }
        if (viewFeature.hasProperty("viewscaletype") && !"manual".equalsIgnoreCase(viewFeature.getString("viewscaletype"))) {
            cameraFromCanvas.set("xscale", (double)camera3d.getAxisViewScaleX());
            cameraFromCanvas.set("yscale", (double)camera3d.getAxisViewScaleY());
            cameraFromCanvas.set("zscale", (double)camera3d.getAxisViewScaleZ());
        }
        return viewFeature.setPropertiesFromCanvas(cameraFromCanvas);
    }

    private boolean a(int n2, String string, ViewFeature viewFeature, Camera camera, boolean bl2, boolean bl3, boolean bl4) {
        if (!(camera instanceof Camera2d)) {
            RenderLogger.b((RenderLogger.ContentType)RenderLogger.ContentType.h, (String)("Update camera model 2d with the wrong camera type: " + camera.getType()));
            return false;
        }
        Camera2d camera2d = (Camera2d)camera;
        CameraFromCanvas cameraFromCanvas = new CameraFromCanvas();
        float[] fArray = camera2d.getViewLimits();
        if (PostOperationID.POLARGROUP.toString().equals(string)) {
            cameraFromCanvas.set("rmin", (double)fArray[0]);
            cameraFromCanvas.set("rmax", (double)fArray[1]);
        } else if (!PostOperationID.SMITHGROUP.toString().equals(string)) {
            float[] fArray2;
            double d2 = fArray[0];
            double d3 = fArray[1];
            if (bl2) {
                d2 = Math.pow(10.0, d2);
                d3 = Math.pow(10.0, d3);
            }
            cameraFromCanvas.set("xmin", d2);
            cameraFromCanvas.set("xmax", d3);
            if (n2 == 2) {
                double d4 = fArray[2];
                double d5 = fArray[3];
                if (bl3) {
                    d4 = Math.pow(10.0, d4);
                    d5 = Math.pow(10.0, d5);
                }
                cameraFromCanvas.set("ymin", d4);
                cameraFromCanvas.set("ymax", d5);
            }
            if (viewFeature.hasProperty("xminhidden") && viewFeature.hasProperty("xmaxhidden") && viewFeature.hasProperty("yminhidden") && viewFeature.hasProperty("ymaxhidden")) {
                cameraFromCanvas.setHidden("xminhidden", "xmin");
                cameraFromCanvas.setHidden("xmaxhidden", "xmax");
                cameraFromCanvas.setHidden("yminhidden", "ymin");
                cameraFromCanvas.setHidden("ymaxhidden", "ymax");
            }
            if (viewFeature.hasProperty("viewscaletype") && !"manual".equalsIgnoreCase(viewFeature.getString("viewscaletype"))) {
                cameraFromCanvas.set("xscale", (double)camera2d.getAxisViewScaleX());
                cameraFromCanvas.set("yscale", (double)camera2d.getAxisViewScaleY());
            }
            if (n2 == 2 && viewFeature.hasProperty("abstractviewsetting") && viewFeature.getBoolean("abstractviewsetting") && camera2d.getAbstractViewSettings().isViewSettingChanged() && (fArray2 = camera2d.getAbstractViewSettings().getViewSetting()) != null && fArray2.length == 6) {
                double[] dArray = q.c((float[])fArray2);
                cameraFromCanvas.set("abstractviewlratio", dArray[0]);
                cameraFromCanvas.set("abstractviewrratio", dArray[1]);
                cameraFromCanvas.set("abstractviewbratio", dArray[2]);
                cameraFromCanvas.set("abstractviewtratio", dArray[3]);
                cameraFromCanvas.set("abstractviewxscale", dArray[4]);
                cameraFromCanvas.set("abstractviewyscale", dArray[5]);
            }
        }
        return viewFeature.setPropertiesFromCanvas(cameraFromCanvas);
    }

    private boolean b(int n2, String string, ViewFeature viewFeature, Camera camera, boolean bl2, boolean bl3, boolean bl4) {
        if (!(camera instanceof CameraGraph)) {
            RenderLogger.b((RenderLogger.ContentType)RenderLogger.ContentType.h, (String)("Update camera model Graph with the wrong camera type: " + camera.getType()));
            return false;
        }
        CameraGraph cameraGraph = (CameraGraph)camera;
        double[] dArray = cameraGraph.getXAxes();
        double[] dArray2 = cameraGraph.getYAxes();
        boolean[] blArray = new boolean[]{bl2, bl2};
        boolean[] blArray2 = new boolean[]{bl3, bl4};
        this.a(dArray, blArray);
        this.a(dArray2, blArray2);
        CameraFromCanvas cameraFromCanvas = new CameraFromCanvas();
        cameraFromCanvas.set("xmin", dArray[0]);
        cameraFromCanvas.set("xmax", dArray[1]);
        cameraFromCanvas.set("ymin", dArray2[0]);
        cameraFromCanvas.set("ymax", dArray2[1]);
        cameraFromCanvas.set("yminsec", dArray2[2]);
        cameraFromCanvas.set("ymaxsec", dArray2[3]);
        return viewFeature.setPropertiesFromCanvas(cameraFromCanvas);
    }

    public void b(ViewBase viewBase) {
    }

    private static double a(double d2) {
        if (d2 <= 0.0 || Double.isNaN(d2) || Double.NEGATIVE_INFINITY == d2) {
            return c;
        }
        if (Double.POSITIVE_INFINITY == d2) {
            return d;
        }
        if (d2 > 0.0) {
            return Math.log10(d2);
        }
        assert (false);
        return c;
    }
}

