/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.guimph.util;

import com.comsol.gui.CsApplication;
import com.comsol.gui.DesktopWindow;
import com.comsol.gui.ViewManager;
import com.comsol.gui.WindowType;
import com.comsol.gui.views.QuestionView;
import com.comsol.guimph.MphApplication;
import com.comsol.guimph.MphDesktopWindow;
import com.comsol.guimph.actions.FileAction;
import com.comsol.guimph.actions.cp;
import com.comsol.guimph.aj;
import com.comsol.guimph.d.h;
import com.comsol.guimph.l;
import com.comsol.guimph.progress.i;
import com.comsol.guimph.util.RecentModels;
import com.comsol.guimph.util.k;
import com.comsol.guimph.util.w;
import com.comsol.model.database.DatabaseModelDescriptor;
import com.comsol.model.database.DatabaseMphProviderFactory;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.View;
import com.comsol.model.operations.MissingGeometryBuildData;
import com.comsol.model.util.IModelManager;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ModelLoadUtil;
import com.comsol.model.util.ModelType;
import com.comsol.nativemph.util.b;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.nativeutil.runnable.c;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.application.CsBaseApplication;
import com.comsol.util.classes.CsPermission;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.FlFileTypes;
import com.comsol.util.classes.FlVersion;
import com.comsol.util.classes.af;
import com.comsol.util.classes.by;
import com.comsol.util.compile.e;
import com.comsol.util.exceptions.CadKernelException;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.exceptions.LicenseException;
import com.comsol.util.file.FileLockManager;
import com.comsol.util.interfaces.f;
import com.comsol.util.interfaces.m;
import com.comsol.util.location.IModelSaveLocation;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import com.comsol.widgets.actions.CsAction;
import com.comsol.widgets.actions.CsActionInfo;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    private static /* synthetic */ int[] a;
    private static /* synthetic */ int[] b;

    public static boolean isSaved(Model model) {
        IModelSaveLocation.LocationType locationType = model.getSaveLocation().a();
        return locationType == IModelSaveLocation.LocationType.b || locationType == IModelSaveLocation.LocationType.d;
    }

    private static boolean a(Model model) {
        String string = Preferences.getInstance().getLibraryRoot("applications");
        String string2 = SystemUtil.standardizeClientPath((String)model.getFilePath());
        return string2.startsWith(string) && FileManagerUtil.a((String)string2, (String)model.tag());
    }

    public static boolean save(MphDesktopWindow mphDesktopWindow, Model model, boolean bl2, boolean bl3) {
        QuestionView.Answer answer;
        if (FileUtil.a(model) && !FileLockManager.isReadOnly((String)model.getSaveLocation().b()) && (answer = mphDesktopWindow.getViewManager().showQuestionDialog(QuestionView.Type.b, "Overwrite_application", "Overwrite_COMSOL_Application_Libraries_application")) == QuestionView.Answer.b) {
            return FileUtil.saveAs(mphDesktopWindow, model, bl2, bl3, false, false, false);
        }
        if (bl3 && SystemUtil.isApplicationServer() && !SystemUtil.isTestInWebBrowser()) {
            answer = new c.a(FileUtil.a(model.getModelType(), model.getModelType()));
            boolean[] blArray = new boolean[1];
            Runnable runnable = FileUtil.a((com.comsol.nativeutil.runnable.k)answer, mphDesktopWindow, model, false, false, blArray);
            i.a(mphDesktopWindow, runnable, answer.a());
            return blArray[0];
        }
        if (!FileUtil.isSaved(model) || FileLockManager.isReadOnly((String)model.getSaveLocation().b())) {
            return FileUtil.saveAs(mphDesktopWindow, model, bl2, bl3, false, false, false);
        }
        boolean bl4 = true;
        boolean bl5 = true;
        if (!(bl3 || (bl4 = FileUtil.a(mphDesktopWindow, model.getSaveLocation().b(), true)) && (bl5 = FileUtil.checkIfOverwriteOlderVersion(mphDesktopWindow, model, null)))) {
            return FileUtil.saveAs(mphDesktopWindow, model, bl2, bl3, false, bl4, bl5);
        }
        boolean[] blArray = new boolean[1];
        if (bl2) {
            FileUtil.b((com.comsol.nativeutil.runnable.k)new com.comsol.nativeutil.runnable.f(), mphDesktopWindow, model);
            return true;
        }
        c.a a2 = new c.a(FileUtil.a(model.getModelType(), model.getModelType()));
        Runnable runnable = new Runnable((com.comsol.nativeutil.runnable.k)a2, mphDesktopWindow, model, blArray){
            private final /* synthetic */ com.comsol.nativeutil.runnable.k a;
            private final /* synthetic */ MphDesktopWindow b;
            private final /* synthetic */ Model c;
            private final /* synthetic */ boolean[] d;
            {
                this.a = k2;
                this.b = mphDesktopWindow;
                this.c = model;
                this.d = blArray;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        FileUtil.b(this.a, this.b, this.c);
                        this.d[0] = true;
                    }
                    catch (FlException flException) {
                        if (flException.isCancelException()) break block2;
                        throw flException;
                    }
                }
            }
        };
        i.a(mphDesktopWindow, runnable, a2.a());
        return blArray[0];
    }

    private static String a(ModelType modelType, ModelType modelType2) {
        if (modelType == null) {
            return "Saving_application";
        }
        switch (FileUtil.a()[modelType.ordinal()]) {
            case 2: {
                return "Saving_application";
            }
            case 3: {
                return "Saving_physics";
            }
        }
        return "Saving_application";
    }

    private static void b(com.comsol.nativeutil.runnable.k k2, MphDesktopWindow mphDesktopWindow, Model model) {
        FileUtil.prepareGuiProgress(k2, mphDesktopWindow);
        d d2 = new d(model, k2);
        d2.run();
        IOException iOException = d2.h();
        if (iOException != null) {
            throw new FlException((Throwable)iOException);
        }
        k2.e();
    }

    public static boolean saveAs(MphDesktopWindow mphDesktopWindow, Model model, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        String string = model.getSaveLocation().b();
        if (bl3) {
            String[] stringArray = FileManagerUtil.d((String)FileManagerUtil.n((String)model.comments()));
            String string2 = stringArray[0] != null ? stringArray[0] : "";
            String string3 = stringArray[1] != null ? stringArray[1] : "";
            String string4 = SystemUtil.isApplicationServer() && !SystemUtil.isTestInWebBrowser() ? System.getProperty("cs.applicationtitle", string2) : string2;
            ViewManager.a a2 = new ViewManager.a("Save_application_on_server_as", "Enter_a_new_title_for_the_application");
            String string5 = mphDesktopWindow.getViewManager().showRequestDialog(a2, string4, false, false);
            if (string5 != null) {
                String string6;
                model.comments(FileManagerUtil.c((String)model.comments(), (String)string5, (String)string3));
                if (SystemUtil.isApplicationServer() && !SystemUtil.isTestInWebBrowser()) {
                    System.setProperty("cs.applicationtitle", string5);
                    c.a a3 = new c.a(FileUtil.a(model.getModelType(), model.getModelType()));
                    boolean[] blArray = new boolean[1];
                    Runnable runnable = FileUtil.a((com.comsol.nativeutil.runnable.k)a3, mphDesktopWindow, model, true, bl4, blArray);
                    i.a(mphDesktopWindow, runnable, a3.a());
                    return blArray[0];
                }
                String string7 = null;
                String string8 = null;
                if (string != null && !string.isEmpty()) {
                    string7 = af.g().l(string, m.a);
                    string8 = af.g().m(string, m.a);
                }
                if (string8 == null || string8.isEmpty() || string7 == null || string7.isEmpty()) {
                    string6 = FileUtil.a(mphDesktopWindow, model, "Save_application_on_server_as", string);
                    if (string6 == null) {
                        return false;
                    }
                } else {
                    string6 = FileUtil.b(string8, string7, af.g());
                }
                return FileUtil.saveAs(string6, mphDesktopWindow, model, bl2, bl4);
            }
            return false;
        }
        String string9 = FileUtil.a(mphDesktopWindow, model, "Save_as", string);
        if (string9 == null) {
            return false;
        }
        if (!bl5 && bl6 ? !FileUtil.checkIfOverwriteOlderVersion(mphDesktopWindow, model, string9) || !FileUtil.a(mphDesktopWindow, string9, bl5) : !FileUtil.a(mphDesktopWindow, string9, bl5) || bl6 && !FileUtil.checkIfOverwriteOlderVersion(mphDesktopWindow, model, string9)) {
            return false;
        }
        return FileUtil.saveAs(string9, mphDesktopWindow, model, bl2, bl4);
    }

    private static String a(MphDesktopWindow mphDesktopWindow, Model model, String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            string2 = ModelInternalUtil.getFilename((Model)model);
        }
        return mphDesktopWindow.selectFile(string, string2, 1, model.getModelType().getSaveFileTypes(), 0);
    }

    public static boolean checkIfOverwriteOlderVersion(MphDesktopWindow mphDesktopWindow, Model model, String string) {
        FlVersion flVersion = FlVersion.currentVersion();
        if (Preferences.getInstance().getBooleanPreference("tempfiles.saving.warnifoverwriteolder") && !SystemUtil.isRunningTest() && (string == null || string.equals(model.getSaveLocation().b())) && model.getSavedInVersion() < ModelInternalUtil.getCurrentVersion() && !model.getComsolVersion().contains(flVersion.shortNameWithExt())) {
            by by2 = mphDesktopWindow.getViewManager().showQuestionOptionDialog(QuestionView.Type.a, "Confirm_save", "The_file_was_previously_saved_using_X_Saving_will_convert_the_file_so_it_can_only_be_opened_in_Y_or_newer_Do_you_want_to_overwrite_the_file#" + FlVersion.productNameWithExtFromLongString((String)model.getComsolVersion()) + "#" + flVersion.getProductNameWithExt());
            if (((Boolean)by2.b()).booleanValue()) {
                Preferences.getInstance().setBooleanPreference("tempfiles.saving.warnifoverwriteolder", false);
            }
            return QuestionView.Answer.a == by2.a();
        }
        return true;
    }

    private static boolean a(MphDesktopWindow mphDesktopWindow, String string, boolean bl2) {
        if (SystemUtil.isRunningTest()) {
            return true;
        }
        String[] stringArray = ModelInternalUtil.getRecoveriesUsingFile((String)FlFileUtil.B((File)new File(string)));
        if (stringArray.length > 0) {
            Object object;
            QuestionView.Answer answer = QuestionView.Answer.a;
            if (bl2) {
                Object object2;
                object = w.a(stringArray);
                if (stringArray.length > 1) {
                    object2 = w.b(stringArray);
                    w.a((String[])object2, stringArray, (String[])object, new String[stringArray.length], new String[stringArray.length]);
                }
                if (((String[])object).length > 10) {
                    object = (String[])q.a((Object[])object, (int)0, (int)10);
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(stringArray.length == 1 ? "The_file_is_needed_by_a_recovery_file_Overwriting_it_will_delete_this_recovery_file_Do_you_want_to_overwrite_the_file_Recovery_using_the_file#" : "The_file_is_needed_by_several_recovery_files_Overwriting_it_will_delete_these_recovery_files_Do_you_want_to_overwrite_the_file_Recoveries_using_the_file#");
                Object object3 = object;
                int n2 = ((Object[])object).length;
                int n3 = 0;
                while (n3 < n2) {
                    Object object4 = object3[n3];
                    ((StringBuilder)object2).append("\n - " + FlLocale.getString((String)object4));
                    ++n3;
                }
                answer = mphDesktopWindow.getViewManager().showQuestionDialog(QuestionView.Type.a, "Confirm_save", ((StringBuilder)object2).toString());
            }
            if (QuestionView.Answer.a == answer) {
                String[] stringArray2 = stringArray;
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    object = stringArray2[n5];
                    ModelInternalUtil.deleteRecovery((String)object);
                    ++n5;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private static void b(com.comsol.nativeutil.runnable.k k2, MphDesktopWindow mphDesktopWindow, Model model, final boolean bl2, boolean bl3, f f2) {
        if (System.getProperty("cs.applicationserver") == null) {
            throw new NullPointerException("Internal error: No startup application specified");
        }
        final String string = new File(System.getProperty("cs.applicationserver")).getName();
        if (string.isEmpty()) {
            throw new IllegalStateException("Internal error: Couldn't find filename from " + System.getProperty("cs.applicationserver"));
        }
        final String string2 = System.getProperty("cs.appdir");
        if (string2 == null || string2.isEmpty()) {
            throw new FlException("Internal error. Failed to save application on server.");
        }
        try {
            Object object;
            Object object2;
            Object object3;
            if (bl3) {
                object3 = model.getRecoveryDir();
                if (object3 == null || !new File((String)object3).isDirectory()) {
                    throw new IllegalStateException("Model has no recovery");
                }
                object2 = new File((String)object3).getParent();
                int n2 = 0;
                while (new File((String)object2, "tmp" + n2 + ".mph").exists()) {
                    ++n2;
                }
                object = new File((String)object2, "tmp" + n2 + ".mph");
            } else {
                object3 = model.getTemporaryServerFile();
                object = object3 != null ? object3 : new File(SystemUtil.getTempFilePath((String)string, (String)"tmp"));
            }
            FileUtil.prepareGuiProgress(k2, mphDesktopWindow);
            object3 = new c(model, k2, bl3, (File)object);
            object3.run();
            object2 = ((d)((Object)object3)).h();
            if (object2 != null) {
                throw new FlException("Failed_to_save_application", (Throwable)object2);
            }
            try {
                try {
                    CsPermission.a((Permission)CsPermission.a);
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((File)object, f2){
                        private final /* synthetic */ File d;
                        private final /* synthetic */ f e;
                        {
                            this.d = file;
                            this.e = f2;
                        }

                        public Void a() throws IOException {
                            File file = bl2 ? new File(FileUtil.b(string2, string, null)) : new File(string2, string);
                            FlFileUtil.a((File)this.d, (File)file);
                            System.setProperty("cs.applicationserver", file.getAbsolutePath());
                            this.e.notifySaveOnServer(file, bl2);
                            return null;
                        }

                        @Override
                        public /* synthetic */ Object run() throws Exception {
                            return this.a();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getCause() instanceof IOException) {
                        throw (IOException)privilegedActionException.getCause();
                    }
                    throw new FlException("Internal_error", privilegedActionException.getCause());
                }
            }
            finally {
                ((File)object).delete();
                k2.e();
            }
        }
        catch (IOException iOException) {
            throw new FlException("Failed_to_save_application", (Throwable)iOException);
        }
    }

    public static void prepareGuiProgress(com.comsol.nativeutil.runnable.k k2, MphDesktopWindow mphDesktopWindow) {
        l l2 = (l)ModelInternalUtil.getModelManager();
        l2.a(k2);
        l2.a(mphDesktopWindow);
    }

    private static String b(String string, String string2, m m2) {
        Object object;
        Matcher matcher = Pattern.compile("^(.*?)(-\\d*)?(\\.[^.]+)$").matcher(string2);
        if (!matcher.matches()) {
            throw new FlException("Internal error. Invalid filename: " + string2);
        }
        String string3 = matcher.group(1);
        String string4 = matcher.group(2);
        String string5 = matcher.group(3);
        int n2 = 1;
        if (string4 != null && string4.length() > 1) {
            n2 = Integer.parseInt(string4.substring(1));
        }
        boolean bl2 = true;
        while (true) {
            String string6;
            if (bl2) {
                string6 = string2;
                bl2 = false;
            } else {
                string6 = String.valueOf(string3) + "-" + n2 + string5;
                ++n2;
            }
            if (m2 == null) {
                object = new File(string, string6);
                if (((File)object).exists()) continue;
                return ((File)object).getAbsolutePath();
            }
            object = m2.a(string, string6, m.a);
            if (!m2.a((String)object, m.a)) break;
        }
        return object;
    }

    public static boolean saveAs(String string, MphDesktopWindow mphDesktopWindow, Model model, boolean bl2, boolean bl3) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = new FlFileTypes(FlFileTypes.Type.e).getFirstExtension().toLowerCase(Locale.ENGLISH);
        String string4 = new FlFileTypes(FlFileTypes.Type.d).getFirstExtension().toLowerCase(Locale.ENGLISH);
        String string5 = new FlFileTypes(FlFileTypes.Type.f).getFirstExtension().toLowerCase(Locale.ENGLISH);
        if (string2.endsWith("." + string3)) {
            model.save(string, string3);
            mphDesktopWindow.getPrimaryDesktop().appendLogMessage("Saved_file#" + FlLocale.encode((String)string));
            return false;
        }
        if (string2.endsWith("." + string4)) {
            model.save(string, string4);
            mphDesktopWindow.getPrimaryDesktop().appendLogMessage("Saved_file#" + FlLocale.encode((String)string));
            return false;
        }
        if (string2.endsWith("." + string5)) {
            model.save(string, string5);
            mphDesktopWindow.getPrimaryDesktop().appendLogMessage("Saved_file#" + FlLocale.encode((String)string));
            return false;
        }
        boolean bl4 = FileUtil.isSaved(model);
        if (!bl4) {
            String string6 = model.getModelType() == ModelType.DESIGN ? System.getProperty("user.name", Preferences.getInstance().getPreference("general.username.name")) : SystemUtil.getModelUser((String)Preferences.getInstance().getPreference("general.username.name"));
            String string7 = model.author();
            if (!FlStringUtil.equals((String)string7, (String)string6)) {
                model.resetAuthor(string6);
            }
        }
        return FileUtil.saveToFileName(mphDesktopWindow, model, bl2, bl3, string);
    }

    public static boolean saveToFileName(MphDesktopWindow mphDesktopWindow, Model model, boolean bl2, boolean bl3, String string) {
        String string2 = model.getSaveLocation().b();
        if (FileLockManager.isReadOnly((String)string)) {
            mphDesktopWindow.getViewManager().showMessageDialog("COMSOL", "The_model_was_opened_in_read-only_mode_and_must_be_saved_using_a_new_name");
            return false;
        }
        if (FileLockManager.getLockType((String)string) == FileLockManager.LockType.c) {
            mphDesktopWindow.getViewManager().showMessageDialog("COMSOL", "You_cannot_save_a_model_using_that_name_since_it_is_locked_by_another_process");
            return false;
        }
        if (FileLockManager.getLockType((String)string) == FileLockManager.LockType.b && !FileUtil.b(mphDesktopWindow, string)) {
            return false;
        }
        if (string2 != null && !FileLockManager.isReadOnly((String)string2) && !string.equals(string2)) {
            FileLockManager.releaseLock((String)string2);
        }
        if (mphDesktopWindow.shouldCreateLockFile()) {
            FileLockManager.acquireLock((String)string);
        }
        boolean[] blArray = new boolean[1];
        if (bl2) {
            FileUtil.b((com.comsol.nativeutil.runnable.k)new com.comsol.nativeutil.runnable.f(), mphDesktopWindow, model, string, false, bl3);
            return true;
        }
        c.a a2 = new c.a(FileUtil.a(model.getModelType(), model.getModelType()));
        Runnable runnable = FileUtil.a((com.comsol.nativeutil.runnable.k)a2, mphDesktopWindow, model, string, false, bl3, blArray);
        i.a(mphDesktopWindow, runnable, a2.a());
        if (blArray[0]) {
            FileUtil.updateAfterSaveAs(mphDesktopWindow, model, string, null);
        } else {
            FileLockManager.releaseLock((String)string);
            if (FileUtil.isSaved(model) && mphDesktopWindow.shouldCreateLockFile()) {
                FileLockManager.acquireLock((String)model.getSaveLocation().b());
            }
        }
        return blArray[0];
    }

    private static Runnable a(final com.comsol.nativeutil.runnable.k k2, final MphDesktopWindow mphDesktopWindow, final Model model, final String string, final boolean bl2, final boolean bl3, final boolean[] blArray) {
        return new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        FileUtil.b(k2, mphDesktopWindow, model, string, bl2, bl3);
                        blArray[0] = true;
                    }
                    catch (FlException flException) {
                        if (flException.isCancelException()) break block2;
                        throw flException;
                    }
                }
            }
        };
    }

    private static Runnable a(final com.comsol.nativeutil.runnable.k k2, final MphDesktopWindow mphDesktopWindow, final Model model, final boolean bl2, final boolean bl3, final boolean[] blArray) {
        return new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        FileUtil.b(k2, mphDesktopWindow, model, bl2, bl3, mphDesktopWindow.getApplication().getAppServerObserver());
                        blArray[0] = true;
                    }
                    catch (FlException flException) {
                        if (flException.isCancelException()) break block2;
                        throw flException;
                    }
                }
            }
        };
    }

    public static void updateAfterSaveAs(MphDesktopWindow mphDesktopWindow, Model model, String string, DatabaseModelDescriptor databaseModelDescriptor) {
        mphDesktopWindow.updateTitle();
        if (model.getModelType() != ModelType.APPLICATION_MODEL) {
            if (SystemUtil.isPreviewModelDatabase()) {
                FileUtil.b(model);
                RecentModels.a().a(model.getModelType(), FileUtil.a(model, string), string, databaseModelDescriptor);
            } else if (Preferences.getInstance().addRecentFile(string)) {
                FileUtil.updateRecentFiles(mphDesktopWindow);
            }
        }
    }

    public static boolean exportModel(MphDesktopWindow mphDesktopWindow, Model model, String string) {
        return FileUtil.exportModel(mphDesktopWindow, model, string, (com.comsol.nativeutil.runnable.k)new c.a(FileUtil.a(model.getModelType(), model.getModelType())));
    }

    public static boolean exportModel(MphDesktopWindow mphDesktopWindow, Model model, String string, com.comsol.nativeutil.runnable.k k2) {
        if (string == null) {
            return false;
        }
        boolean[] blArray = new boolean[1];
        Runnable runnable = FileUtil.a(k2, mphDesktopWindow, model, string, true, false, blArray);
        i.a(mphDesktopWindow, runnable, k2.a());
        return blArray[0];
    }

    private static void b(com.comsol.nativeutil.runnable.k k2, MphDesktopWindow mphDesktopWindow, Model model, String string, boolean bl2, boolean bl3) {
        model.setEntityCreationTime(new Date().getTime());
        FileUtil.prepareGuiProgress(k2, mphDesktopWindow);
        if (bl3) {
            try {
                model.saveFromRecovery(string, false);
            }
            catch (IOException iOException) {
                throw new FlException((Throwable)iOException);
            }
        } else {
            b b2 = new b(model, string, bl2, k2);
            b2.run();
            IOException iOException = b2.h();
            if (iOException != null) {
                throw new FlException((Throwable)iOException);
            }
        }
        k2.e();
    }

    public static boolean openProtected(MphDesktopWindow mphDesktopWindow, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            String string3 = FlStringUtil.encryptString((String)string2, (int)1);
            String string4 = String.valueOf(1);
            return FileUtil.open(mphDesktopWindow, string, string3, string4);
        }
        return FileUtil.open(mphDesktopWindow, string, new String[0]);
    }

    public static boolean open(MphDesktopWindow mphDesktopWindow, String string, String ... stringArray) {
        return FileUtil.a(mphDesktopWindow, string, null, stringArray);
    }

    private static boolean a(final MphDesktopWindow mphDesktopWindow, final String string, final DatabaseModelDescriptor databaseModelDescriptor, final String ... stringArray) {
        if (!FileUtil.a(mphDesktopWindow, string)) {
            return false;
        }
        final com.comsol.nativeutil.runnable.k k2 = new com.comsol.nativeutil.runnable.k(FileUtil.a(string, databaseModelDescriptor)){

            public void a(double d2) {
                super.a(d2);
                if (this.k()) {
                    throw new FlException("<CANCEL>");
                }
            }
        };
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                a a2 = new a(mphDesktopWindow);
                try {
                    FileUtil.b(k2, string, databaseModelDescriptor, false, false, a2, stringArray);
                    blArray[0] = true;
                }
                catch (FlException flException) {
                    if (databaseModelDescriptor == null && !string.equals(mphDesktopWindow.getModel().getSaveLocation().b())) {
                        FileLockManager.releaseLock((String)string);
                    }
                    if (!flException.isCancelException()) {
                        throw flException;
                    }
                    blArray[0] = false;
                }
            }
        };
        i.a(mphDesktopWindow, runnable, k2.a());
        if (blArray[0]) {
            FileUtil.updateAfterOpen(mphDesktopWindow, string, databaseModelDescriptor);
            FileUtil.a(mphDesktopWindow, mphDesktopWindow.getModel());
        }
        return blArray[0];
    }

    public static boolean loadModelGeomSeq(MphDesktopWindow mphDesktopWindow, final String string, final String string2, final boolean bl2, final boolean bl3, final boolean bl4, String string3, final String ... stringArray) {
        final com.comsol.nativeutil.runnable.k k2 = new com.comsol.nativeutil.runnable.k(string3){

            public void a(double d2) {
                super.a(d2);
                if (this.k()) {
                    throw new FlException("<CANCEL>");
                }
            }
        };
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    l l2 = (l)ModelInternalUtil.getModelManager();
                    b.c c2 = bl4 ? new b.c(bl2, bl3) : new b.d();
                    String string3 = af.g().j(string2, string) ? string2 : af.g().a(SystemUtil.getPartsRoot(), string2, string);
                    l2.a(string, string3, k2, (b.b)c2, stringArray);
                    blArray[0] = true;
                }
                catch (FlException flException) {
                    if (!flException.isCancelException()) {
                        throw flException;
                    }
                }
                catch (Throwable throwable) {
                    throw new FlException(throwable);
                }
            }
        };
        i.a(mphDesktopWindow, runnable, k2.a());
        return blArray[0];
    }

    private static String a(String string, DatabaseModelDescriptor databaseModelDescriptor) {
        ModelType modelType = ModelType.fromFileName((String)string);
        switch (FileUtil.a()[modelType.ordinal()]) {
            case 3: {
                return "Opening_physics";
            }
            case 2: {
                com.comsol.util.interfaces.d d2 = null;
                try {
                    d2 = FileManagerUtil.q((String)string, (String)"modelinfo.xml");
                }
                catch (Throwable throwable) {
                    FlLogger.c((String)("Failed to read model-type info from MPH-file '" + string + "'."));
                }
                ModelType modelType2 = ModelLoadUtil.getModelType((com.comsol.util.interfaces.d)d2);
                if (modelType2 != null && modelType2 != ModelType.APPLICATION_MODEL) break;
                return "Opening_application_in_builder_mode";
            }
        }
        String string2 = databaseModelDescriptor != null ? databaseModelDescriptor.getModelVersionTitle() : af.g().l(string, null);
        if (string2.length() > 50) {
            string2 = String.valueOf(string2.substring(0, 25)) + "..." + string2.substring(string2.length() - 25, string2.length());
        }
        return "Opening#" + FlLocale.encode((String)string2);
    }

    private static void a(MphDesktopWindow mphDesktopWindow, Model model) {
        if (mphDesktopWindow != null && model != null) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = true;
            for (String string : model.geom()) {
                MissingGeometryBuildData missingGeometryBuildData = string.getMissingGeometryBuildData();
                if (missingGeometryBuildData.somethingChanged) {
                    bl2 = true;
                    if (missingGeometryBuildData.changedGeomRepToComsol) {
                        mphDesktopWindow.appendLogMessage("X_Changed_representation_to_COMSOL_kernel#" + string.label());
                    } else if (missingGeometryBuildData.missingVirtual) {
                        mphDesktopWindow.appendLogMessage("X_Geometry_was_rebuilt_due_to_updated_virtual_geometry#" + string.label());
                    }
                }
                if (missingGeometryBuildData.missingGeom) {
                    bl3 = true;
                    missingGeometryBuildData.missingGeom = false;
                }
                if (!missingGeometryBuildData.buildFailed) continue;
                missingGeometryBuildData.buildFailed = false;
                bl4 = false;
            }
            if (bl2) {
                String string;
                string = "";
                if (bl3) {
                    string = String.valueOf(string) + FlLocale.getString((String)"Cleared_all_solutions");
                }
                if (!bl4) {
                    if (string.length() > 0) {
                        string = String.valueOf(string) + " ";
                    }
                    string = String.valueOf(string) + FlLocale.getString((String)"Cleared_selections_on_the_finalized_geometry");
                }
                if (string.length() > 0) {
                    mphDesktopWindow.appendLogMessage("#" + string);
                }
            }
        }
    }

    public static void updateAfterOpen(MphDesktopWindow mphDesktopWindow, String string, DatabaseModelDescriptor databaseModelDescriptor) {
        if (SystemUtil.isPreviewModelDatabase()) {
            FileUtil.b(mphDesktopWindow.getModel());
            RecentModels.a().a(mphDesktopWindow.getModel().getModelType(), FileUtil.a(mphDesktopWindow.getModel(), string), string, databaseModelDescriptor);
        } else if (Preferences.getInstance().addRecentFile(string)) {
            FileUtil.updateRecentFiles(mphDesktopWindow);
        }
    }

    private static String a(Model model, String string) {
        String[] stringArray = FileManagerUtil.d((String)model.comments());
        if (!FlStringUtil.isNullOrEmpty((String)stringArray[0])) {
            return stringArray[0];
        }
        if (string != null) {
            return FileManagerUtil.k((String)string, null);
        }
        return "";
    }

    public static void importModel(MphDesktopWindow mphDesktopWindow, final String string) {
        final com.comsol.nativeutil.runnable.k k2 = new com.comsol.nativeutil.runnable.k(FileUtil.a(string, null));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileUtil.b(k2, string, true, false, new String[0]);
            }
        };
        i.a(mphDesktopWindow, runnable, k2.a());
    }

    public static boolean openRecovery(MphDesktopWindow mphDesktopWindow, final String string, final String ... stringArray) {
        final com.comsol.nativeutil.runnable.k k2 = new com.comsol.nativeutil.runnable.k(FileUtil.a(string, null)){

            public void a(double d2) {
                super.a(d2);
                if (this.k()) {
                    throw new FlException("<CANCEL>");
                }
            }
        };
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtil.b(k2, string, true, true, stringArray);
                    blArray[0] = true;
                }
                catch (FlException flException) {
                    if (!flException.isCancelException()) {
                        throw flException;
                    }
                    blArray[0] = false;
                }
            }
        };
        i.a(mphDesktopWindow, runnable, k2.a());
        return blArray[0];
    }

    private static void b(com.comsol.nativeutil.runnable.k k2, String string, boolean bl2, boolean bl3, String ... stringArray) {
        FileUtil.b(k2, string, null, bl2, bl3, null, stringArray);
    }

    private static void b(com.comsol.nativeutil.runnable.k k2, String string, DatabaseModelDescriptor databaseModelDescriptor, boolean bl2, boolean bl3, b.b b2, String ... stringArray) {
        com.comsol.guimph.k k3;
        Object object;
        l l2 = (l)ModelInternalUtil.getModelManager();
        MphDesktopWindow mphDesktopWindow = (MphDesktopWindow)CsApplication.getInstance().getActiveDesktop();
        try {
            if (databaseModelDescriptor != null) {
                object = DatabaseMphProviderFactory.getInstance();
                k3 = (com.comsol.guimph.k)object.loadModelFromDatabase((IModelManager)l2, ModelInternalUtil.uniquetag((String)"Model"), databaseModelDescriptor, k2, b2, false, stringArray);
            } else {
                k3 = bl3 ? (com.comsol.guimph.k)l2.a(ModelInternalUtil.uniquetag((String)"Model"), string, k2, stringArray) : (com.comsol.guimph.k)l2.a(mphDesktopWindow, ModelInternalUtil.uniquetag((String)"Model"), string, k2, bl2, false, b2, stringArray);
            }
        }
        catch (IOException iOException) {
            throw new FlException((Throwable)iOException);
        }
        k2.e();
        mphDesktopWindow.setIsReinitializing(true);
        mphDesktopWindow.pushReinitializationMessage("Initializing_GUI");
        try {
            object = new aj();
            ((aj)object).a(k3.model);
            ((aj)object).a(k3.a);
            ((aj)object).a(k3.b);
            MphApplication.startApplication((aj)object);
        }
        finally {
            mphDesktopWindow.popReinitializationMessage();
            mphDesktopWindow.setIsReinitializing(false);
        }
    }

    public static void openModelClass(MphDesktopWindow mphDesktopWindow, String string, boolean bl2) {
        if (bl2) {
            e.a((CsBaseApplication)CsApplication.getInstance(), (String)string, null, (boolean)true, (boolean)true);
        } else {
            mphDesktopWindow.getWidgetRecorder().a(false);
            cp cp2 = new cp(mphDesktopWindow, string);
            mphDesktopWindow.setDirty(false);
            mphDesktopWindow.clearWidgetRecorders();
            mphDesktopWindow.resetWindow(ModelType.MODEL, false);
            cp2.triggerAction();
        }
    }

    public static void updateRecentFiles(MphDesktopWindow mphDesktopWindow) {
        FileUtil.a(mphDesktopWindow.getPrimaryDesktop());
        WindowType[] windowTypeArray = new WindowType[]{WindowType.b};
        int n2 = windowTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            WindowType windowType = windowTypeArray[n3];
            MphDesktopWindow mphDesktopWindow2 = mphDesktopWindow.getPrimaryDesktop().getSecondaryWindow(windowType);
            if (mphDesktopWindow2 != null) {
                FileUtil.a(mphDesktopWindow2);
            }
            ++n3;
        }
    }

    private static void a(MphDesktopWindow mphDesktopWindow) {
        int n2 = 0;
        while (n2 < 4) {
            String string = Preferences.getInstance().getPreference("file.recent.file" + n2);
            CsActionInfo csActionInfo = new CsActionInfo("recentfile" + n2);
            if (mphDesktopWindow.getActionManager().hasAction(csActionInfo)) {
                CsAction csAction = mphDesktopWindow.getActionManager().getAction(csActionInfo);
                if (string.length() > 0) {
                    csAction.setText("#" + (n2 + 1) + " " + string);
                }
            }
            ++n2;
        }
    }

    private static void b(Model model) {
        for (DesktopWindow desktopWindow : CsApplication.getInstance().getWindowManager()) {
            if (!desktopWindow.getActionManager().hasAction(FileAction.Type.k.a())) continue;
            CsAction csAction = desktopWindow.getActionManager().getAction(FileAction.Type.k.a());
            String string = model.getSaveLocation().a() == IModelSaveLocation.LocationType.d ? "Save_draft" : FileAction.Type.k.b();
            csAction.setText(string);
            csAction.setToolTip(string);
        }
    }

    public static boolean openFile(MphDesktopWindow mphDesktopWindow, String string, boolean bl2, String ... stringArray) {
        String string2 = FileManagerUtil.k((String)string, (String)m.a);
        return FileUtil.a(mphDesktopWindow, string, string2, null, bl2, stringArray);
    }

    public static void openFromDatabase(MphDesktopWindow mphDesktopWindow, DatabaseModelDescriptor databaseModelDescriptor, boolean bl2, String ... stringArray) {
        String string = databaseModelDescriptor.getModelVersionTitle();
        com.comsol.guimph.a.b.a().a(mphDesktopWindow, databaseModelDescriptor.getDatabaseDescriptor(), () -> {
            boolean bl3 = FileUtil.a(mphDesktopWindow, string, string, databaseModelDescriptor, bl2, stringArray);
            if (bl3) {
                mphDesktopWindow.setDirty(false);
            }
        });
    }

    private static boolean a(MphDesktopWindow mphDesktopWindow, String string, String string2, DatabaseModelDescriptor databaseModelDescriptor, boolean bl2, String ... stringArray) {
        Object object;
        if (!bl2 && !mphDesktopWindow.askAboutSavingIfDirty()) {
            return false;
        }
        FlFileTypes flFileTypes = new FlFileTypes(FlFileTypes.Type.c);
        boolean bl3 = true;
        if (flFileTypes.accept(new File(string2))) {
            FileUtil.openModelClass(mphDesktopWindow, string, false);
        } else {
            object = ModelInternalUtil.getModelManager();
            object.setAllowUnavailableLicensesOnLoad(true);
            try {
                bl3 = databaseModelDescriptor != null ? FileUtil.a(mphDesktopWindow, string, databaseModelDescriptor, stringArray) : h.a(ModelType.fromFileName((String)string2)).a(mphDesktopWindow, string, stringArray);
            }
            finally {
                object.setAllowUnavailableLicensesOnLoad(false);
            }
        }
        if (bl3) {
            object = " " + FlLocale.getString((String)("Opened#" + FlLocale.encode((String)string2))) + " ";
            String string3 = FlStringUtil.padLeft((String)object, (char)'=', (int)((int)Math.floor(40.0 - (double)((String)object).length() / 2.0) + ((String)object).length()));
            string3 = FlStringUtil.padRight((String)string3, (char)'=', (int)80);
            mphDesktopWindow.appendProgressLogMessage(string3);
            mphDesktopWindow.appendLogMessage("Opened_file#" + FlLocale.encode((String)string));
            FileUtil.addMessageIfAnythingHidden(mphDesktopWindow);
        }
        return bl3;
    }

    public static void addMessageIfAnythingHidden(MphDesktopWindow mphDesktopWindow) {
        Model model = mphDesktopWindow.getModel();
        if (model.getModelType() != ModelType.MODEL) {
            return;
        }
        boolean bl2 = false;
        for (View view : model.view()) {
            if (!view.isCurrent() || view.hideObjects().stream().filter(hideDraw -> hideDraw.isActive() && !hideDraw.isEmpty()).count() <= 0L && view.hideEntities().stream().filter(hideGeom -> hideGeom.isActive() && !hideGeom.isEmpty()).count() <= 0L && view.hideMesh().stream().filter(hideMesh -> hideMesh.isActive() && !hideMesh.isEmpty()).count() <= 0L) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            mphDesktopWindow.appendLogMessage("Some_geometric_entities_are_hidden");
        }
    }

    public static void checkPasswordAndApply(String string, MphDesktopWindow mphDesktopWindow, k k2) {
        if (FileUtil.isProtected(string)) {
            k2.a(mphDesktopWindow, false);
        } else {
            k2.apply();
        }
    }

    public static void checkRuntimePasswordAndApply(String string, MphDesktopWindow mphDesktopWindow, k k2) {
        if (FileUtil.isRuntimeProtected(string)) {
            k2.a(mphDesktopWindow, true);
        } else {
            k2.apply();
        }
    }

    public static boolean isProtected(String string) {
        return FlFileUtil.b((String)string, (boolean)false);
    }

    public static boolean isRuntimeProtected(String string) {
        return FlFileUtil.c((String)string, (boolean)false);
    }

    private static boolean a(MphDesktopWindow mphDesktopWindow, String string) {
        if (!string.endsWith(".mph") && !string.endsWith(".mphapp")) {
            return true;
        }
        FileLockManager.LockType lockType = FileLockManager.getLockType((String)string);
        if (lockType != FileLockManager.LockType.a) {
            QuestionView.Answer answer;
            String string2 = FileLockManager.getLockingUser((String)string);
            String string3 = FileLockManager.getLockingTime((String)string);
            if (lockType == FileLockManager.LockType.b) {
                QuestionView.Answer[] answerArray = SystemUtil.isMacOSXClient() ? new QuestionView.Answer[]{QuestionView.Answer.i.a("Cancel"), QuestionView.Answer.g.a("Open_as_read-only"), QuestionView.Answer.h.a("Reset_lock_and_open")} : new QuestionView.Answer[]{QuestionView.Answer.g.a("Open_as_read-only"), QuestionView.Answer.h.a("Reset_lock_and_open"), QuestionView.Answer.i.a("Cancel")};
                answer = mphDesktopWindow.getViewManager().showQuestionDialog(QuestionView.Type.f.a(QuestionView.Answer.g).b(QuestionView.Answer.i).a(answerArray), "COMSOL", "The_file_was_locked_by_user_user_at_time#" + string2 + "#" + string3);
            } else {
                QuestionView.Answer[] answerArray = SystemUtil.isMacOSXClient() ? new QuestionView.Answer[]{QuestionView.Answer.i.a("Cancel"), QuestionView.Answer.g.a("Open_as_read-only")} : new QuestionView.Answer[]{QuestionView.Answer.g.a("Open_as_read-only"), QuestionView.Answer.i.a("Cancel")};
                answer = mphDesktopWindow.getViewManager().showQuestionDialog(QuestionView.Type.f.a(QuestionView.Answer.g).b(QuestionView.Answer.i).a(answerArray), "COMSOL", "The_file_was_locked_by_user_user_at_time#" + string2 + "#" + string3);
            }
            switch (FileUtil.b()[answer.ordinal()]) {
                case 7: {
                    FileLockManager.addReadOnlyFile((String)string);
                    return true;
                }
                case 8: {
                    FileLockManager.releaseLock((String)string);
                    FileLockManager.acquireLock((String)string);
                    return true;
                }
                case 9: {
                    return false;
                }
            }
            return true;
        }
        FileLockManager.acquireLock((String)string);
        return true;
    }

    private static boolean b(MphDesktopWindow mphDesktopWindow, String string) {
        String string2 = FileLockManager.getLockingUser((String)string);
        String string3 = FileLockManager.getLockingTime((String)string);
        QuestionView.Answer[] answerArray = SystemUtil.isMacOSX ? new QuestionView.Answer[]{QuestionView.Answer.h.a("Cancel"), QuestionView.Answer.g.a("Reset_lock_and_save")} : new QuestionView.Answer[]{QuestionView.Answer.g.a("Reset_lock_and_save"), QuestionView.Answer.h.a("Cancel")};
        QuestionView.Answer answer = mphDesktopWindow.getViewManager().showQuestionDialog(QuestionView.Type.f.a(QuestionView.Answer.g).b(QuestionView.Answer.h).a(answerArray), "COMSOL", "The_file_was_locked_by_user_user_at_time#" + string2 + "#" + string3);
        switch (FileUtil.b()[answer.ordinal()]) {
            case 7: {
                FileLockManager.releaseLock((String)string);
                return true;
            }
            case 8: {
                return false;
            }
        }
        return false;
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[ModelType.values().length];
        try {
            nArray[ModelType.APPLICATION_MODEL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModelType.DESIGN.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModelType.MODEL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    static /* synthetic */ int[] b() {
        if (b != null) {
            return b;
        }
        int[] nArray = new int[QuestionView.Answer.values().length];
        try {
            nArray[QuestionView.Answer.d.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QuestionView.Answer.g.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QuestionView.Answer.h.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QuestionView.Answer.i.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QuestionView.Answer.f.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QuestionView.Answer.j.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QuestionView.Answer.b.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QuestionView.Answer.c.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QuestionView.Answer.e.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QuestionView.Answer.a.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        b = nArray;
        return nArray;
    }

    private static class a
    extends b.b {
        private final MphDesktopWindow a;
        private boolean f = false;

        public a(MphDesktopWindow mphDesktopWindow) {
            this.a = mphDesktopWindow;
        }

        public void a() {
            block7: {
                LicenseException licenseException;
                block8: {
                    boolean bl2;
                    block6: {
                        if (!this.b || this.c) {
                            return;
                        }
                        bl2 = com.comsol.util.license.d.a();
                        licenseException = bl2 && com.comsol.guimph.util.FileUtil$a.j().equals("model") ? com.comsol.guimph.util.FileUtil$a.a((String)"Model_uses_the_CAD_kernel") : new CadKernelException(null, null, "Model_uses_the_CAD_kernel");
                        if (licenseException != null) break block6;
                        this.f = false;
                        break block7;
                    }
                    if (!bl2 || !com.comsol.guimph.util.FileUtil$a.j().equals("comsol")) break block8;
                    QuestionView.Answer[] answerArray = SystemUtil.isMacOSXClient() ? new QuestionView.Answer[]{QuestionView.Answer.i.a("Cancel"), QuestionView.Answer.h.a("No_keep_models_kernel"), QuestionView.Answer.g.a("Yes")} : new QuestionView.Answer[]{QuestionView.Answer.g.a("Yes"), QuestionView.Answer.h.a("No_keep_models_kernel"), QuestionView.Answer.i.a("Cancel")};
                    QuestionView.Answer answer = this.a.getViewManager().showQuestionDialog(QuestionView.Type.f.a(QuestionView.Answer.g).b(QuestionView.Answer.i).a(answerArray), "COMSOL", "#" + FlLocale.getString((String)"Model_uses_the_CAD_kernel") + " " + FlLocale.getString((String)"Rebuild_geometry_using_COMSOL_kernel"));
                    switch (answer) {
                        case g: {
                            this.f = true;
                            break block7;
                        }
                        case h: {
                            this.f = false;
                            break block7;
                        }
                        default: {
                            throw new FlException("<CANCEL>");
                        }
                    }
                }
                QuestionView.Answer answer = this.a.getViewManager().showQuestionDialog(QuestionView.Type.d, "COMSOL", String.valueOf(licenseException.niceString(true, false)) + FlLocale.getString((String)"Rebuild_geometry_using_COMSOL_kernel"));
                if (answer != QuestionView.Answer.c) {
                    throw new FlException("<CANCEL>");
                }
                this.f = true;
            }
            this.c = true;
        }

        public boolean b() {
            return this.f && this.b;
        }

        public void c() {
            block7: {
                Throwable throwable;
                block8: {
                    boolean bl2;
                    block6: {
                        if (this.d) {
                            return;
                        }
                        bl2 = com.comsol.util.license.d.f();
                        throwable = bl2 && com.comsol.guimph.util.FileUtil$a.l() ? com.comsol.guimph.util.FileUtil$a.b((String)"Model_uses_constraints_and_dimensions") : new FlException("Model_uses_constraints_and_dimensions");
                        if (throwable != null) break block6;
                        this.e = false;
                        break block7;
                    }
                    if (!bl2 || com.comsol.guimph.util.FileUtil$a.l()) break block8;
                    QuestionView.Answer[] answerArray = SystemUtil.isMacOSXClient() ? new QuestionView.Answer[]{QuestionView.Answer.i.a("Cancel"), QuestionView.Answer.h.a("No"), QuestionView.Answer.g.a("Yes")} : new QuestionView.Answer[]{QuestionView.Answer.g.a("Yes"), QuestionView.Answer.h.a("No"), QuestionView.Answer.i.a("Cancel")};
                    QuestionView.Answer answer = this.a.getViewManager().showQuestionDialog(QuestionView.Type.f.a(QuestionView.Answer.g).b(QuestionView.Answer.i).a(answerArray), "COMSOL", "#" + FlLocale.getString((String)"Model_uses_constraints_and_dimensions") + "\n" + FlLocale.getString((String)"Disable_use_of_constraints_and_dimensions"));
                    switch (answer) {
                        case g: {
                            this.e = true;
                            break block7;
                        }
                        case h: {
                            this.e = false;
                            break block7;
                        }
                        default: {
                            throw new FlException("<CANCEL>");
                        }
                    }
                }
                QuestionView.Answer answer = this.a.getViewManager().showQuestionDialog(QuestionView.Type.d, "COMSOL", String.valueOf(throwable.niceString(true, false)) + FlLocale.getString((String)"Disable_use_of_constraints_and_dimensions"));
                if (answer != QuestionView.Answer.c) {
                    throw new FlException("<CANCEL>");
                }
                this.e = true;
            }
            this.d = true;
        }
    }

    private static class b
    extends d {
        protected final String a;
        protected final boolean b;

        public b(Model model, String string, boolean bl2, com.comsol.nativeutil.runnable.k k2) {
            super(model, k2);
            this.a = string;
            this.b = bl2;
        }

        @Override
        protected void e() {
            try {
                this.c.save(this.a, this.b);
            }
            catch (IOException iOException) {
                this.d = iOException;
            }
        }
    }

    private static class c
    extends d {
        private boolean a;
        private File b;

        public c(Model model, com.comsol.nativeutil.runnable.k k2, boolean bl2, File file) {
            super(model, k2);
            this.a = bl2;
            this.b = file;
        }

        @Override
        protected void e() {
            try {
                if (this.a) {
                    this.c.saveFromRecovery(this.b.getAbsolutePath(), true);
                } else {
                    this.c.saveServer(this.b);
                }
            }
            catch (IOException iOException) {
                this.d = iOException;
            }
        }
    }

    private static class d
    extends com.comsol.nativeutil.runnable.l {
        protected final Model c;
        protected IOException d = null;

        public d(Model model, com.comsol.nativeutil.runnable.k k2) {
            super(k2);
            this.c = model;
        }

        protected void e() {
            try {
                this.c.save();
            }
            catch (IOException iOException) {
                this.d = iOException;
            }
        }

        public IOException h() {
            return this.d;
        }

        public boolean c() {
            return true;
        }
    }
}

