/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.applapi;

import com.comsol.model.util.IEnumValue;
import com.comsol.util.classes.an;
import com.comsol.util.exceptions.PhysicsAPIException;

public enum DomainLevel implements IEnumValue
{
    GLOBAL("global", "Global"),
    DOMAIN("domain", "Domain"),
    BOUNDARY("boundary", "Boundary"),
    EDGE("edge", "Edge"),
    POINT("point", "Point"),
    DOMAINREL("domainRel", "Domain_relative"),
    BOUNDARYREL("boundaryRel", "Boundary_relative"),
    EDGEREL("edgeRel", "Edge_relative"),
    PARENTREL("parentRel", "Parent_relative"),
    PARENTBELOWREL("parentBelowRel", "Parent_below_relative");

    private final String value;
    private final String descr;
    private static IEnumValue.EnumValues<DomainLevel> a;

    static {
        a = new IEnumValue.EnumValues<DomainLevel>(DomainLevel.class);
    }

    private DomainLevel(String string2, String string3) {
        this.value = string2;
        this.descr = string3;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return this.descr;
    }

    public static String[] getValues() {
        return a.getValues();
    }

    public static String[] getDescriptions() {
        return a.getDescriptions();
    }

    public static DomainLevel fromValue(String string) {
        return a.fromValue(string);
    }

    public int getEDim(int n2) {
        switch (this) {
            case DOMAIN: {
                return n2;
            }
            case BOUNDARY: {
                if (n2 > 0) {
                    return n2 - 1;
                }
                throw new PhysicsAPIException("There_is_no_boundary_level_for_global_models");
            }
            case EDGE: {
                return 1;
            }
            case POINT: {
                return 0;
            }
        }
        return -1;
    }

    public int getRelativeEDim(int n2, int n3, int n4) {
        switch (this) {
            case DOMAIN: {
                return n2;
            }
            case BOUNDARY: {
                return n2 > 0 ? n2 - 1 : Integer.MIN_VALUE;
            }
            case DOMAINREL: {
                return n3;
            }
            case BOUNDARYREL: {
                return n3 > 0 ? n3 - 1 : Integer.MIN_VALUE;
            }
            case EDGEREL: {
                return n3 > 1 ? n3 - 2 : Integer.MIN_VALUE;
            }
            case EDGE: {
                return 1;
            }
            case POINT: {
                return 0;
            }
            case PARENTREL: {
                return n4;
            }
            case PARENTBELOWREL: {
                return n4 > 0 ? n4 - 1 : Integer.MIN_VALUE;
            }
        }
        return -1;
    }

    public static int[] toEdimArray(int n2, int n3, int n4, String[] stringArray) {
        an an2 = new an(stringArray.length);
        String[] stringArray2 = stringArray;
        int n5 = stringArray.length;
        int n6 = 0;
        while (n6 < n5) {
            String string = stringArray2[n6];
            DomainLevel domainLevel = DomainLevel.fromValue(string);
            int n7 = domainLevel.getRelativeEDim(n2, n3, n4);
            if (n7 > Integer.MIN_VALUE) {
                an2.add(n7);
            }
            ++n6;
        }
        return an2.toArray();
    }
}

