/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.application.util;

import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.operationID.AppOperationID;
import java.util.Locale;

public enum ApplicationEvent {
    OnDataChange("On_data_change"),
    OnPickingChanged("On_picking_changed"),
    FocusGained("Focus_gained"),
    FocusLost("Focus_lost"),
    OnLoad("On_load"),
    OnClose("On_close"),
    OnStartup("On_startup"),
    OnShutdown("About_to_shutdown"),
    OnClick("#On click"),
    OnEvent("#On event");

    private static final String a = "application_local_method_action_";
    private final String description;

    private ApplicationEvent(String string2) {
        this.description = string2;
    }

    public String getDescription() {
        return this.description;
    }

    public String getActionTag(String string) {
        return a + this.name().toLowerCase(Locale.ENGLISH) + string;
    }

    public String getMethodTag() {
        String string = this.name();
        return String.valueOf(Character.toLowerCase(string.charAt(0))) + string.substring(1);
    }

    public static ApplicationEvent findSupportedEvent(PropFeature propFeature) {
        AppOperationID appOperationID = AppOperationID.fromFeature(propFeature);
        if (appOperationID == null) {
            return null;
        }
        switch (appOperationID) {
            case MENU_ITEM: 
            case MENU_TOGGLE_ITEM: 
            case TOOLBAR_ITEM: 
            case TOOLBAR_TOGGLE_ITEM: 
            case BUTTON: {
                return OnClick;
            }
            case ACTION_EVENT: {
                return OnEvent;
            }
            case GRAPHICS: {
                return OnPickingChanged;
            }
        }
        if (propFeature.hasProperty(OnDataChange.getMethodTag())) {
            return OnDataChange;
        }
        return null;
    }
}

