/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.BatchFeatureList;
import com.comsol.model.dbimodel.FEATURE_STATUS;
import com.comsol.model.dbimodel.IFeatureListCreate;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.Study;
import com.comsol.model.operations.IOperation;
import com.comsol.util.api.IApiMigrator;

@PrimitiveModelEntity.TypeDoc(value="A batch job or a task")
public interface BatchFeature
extends IFeatureListCreate<BatchFeature>,
PropFeature {
    public Study getStudyFeature();

    public void setStudyFeature(Study var1);

    public boolean isAttachedFlag();

    public void setExternalProcessData(String[][] var1);

    public String[][] getExternalProcessData();

    @PrimitiveModelEntity.MethodDoc(doc="Runs the batch job", type=PrimitiveModelEntity.MethodType.WRITE)
    public void run();

    @PrimitiveModelEntity.MethodDoc(doc="Continues the batch job", type=PrimitiveModelEntity.MethodType.WRITE)
    public void continueRun();

    @PrimitiveModelEntity.MethodDoc(doc="Computes initial value for the batch job", type=PrimitiveModelEntity.MethodType.WRITE)
    public void getInitialValue();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the tasks of a batch job", ret="List of tasks", type=PrimitiveModelEntity.MethodType.ACCESS)
    public BatchFeatureList<? extends PropFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a task", ret="Task", type=PrimitiveModelEntity.MethodType.ACCESS)
    public BatchFeature feature(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Task tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Test if batch job is attached to a study", ret="<code>true</code> if attached", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isAttached();

    @PrimitiveModelEntity.MethodDoc(doc="Attaches a batch job to a study, which includes assigning it to the study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void attach(@PrimitiveModelEntity.ParamDoc(name="study", doc="Study tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Detaches the batch job from its study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void detach();

    @PrimitiveModelEntity.MethodDoc(doc="Assigns a batch job to a study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void study(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Study tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the study of the batch job", ret="Study tag", type=PrimitiveModelEntity.MethodType.READ)
    public String study();

    public String[] getColumnHeaders();

    public int getNRows();

    public String[] getTableRow(int var1);

    public String[][] getModelData();

    public boolean isResetStateKey();

    public void setResetStateKey(boolean var1);

    public void setAttachedFlag(boolean var1);

    public void setOperation(IOperation var1);

    public void touch();

    @Override
    public IApiMigrator.ModelFeature getFeatureType();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Create a batch feature.", ret="Created batch feature.", type=PrimitiveModelEntity.MethodType.WRITE)
    public BatchFeature create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Feature tag.") String var1, @PrimitiveModelEntity.ParamDoc(name="oper", doc="Type of feature.") String var2);

    public FEATURE_STATUS getStatus();

    public void setStatus(FEATURE_STATUS var1);

    public boolean isBuilt();

    public boolean supportsContinueRun();

    public boolean supportsGetInitialValue();

    public boolean isMoving();
}

