/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.DEPVAR_TYPE;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.Shape;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Field")
public interface Field
extends ModelEntity {
    public static final String typeDoc = " The <code>control</code> type is used to mark a field as intended only for use by the optimization and sensitivity solvers. A control variable field should never actually be solved for by the basic solvers, while an optimization solver will modify them in its outer loop.<br> The <code>discrete</code> and <code>quadrature</code> types are not yet used by fields.<br>";

    public List<? extends Shape> getShapes();

    public boolean isSolveFor();

    public void setSolveFor(boolean var1);

    public String[] getXmeshVars();

    public void setXmeshVars(String[] var1);

    public String[] getErrestXmeshVars();

    public void setErrestXmeshVars(String[] var1);

    public String[] getXmeshVarsStatic();

    public void setXmeshVarsStatic(String[] var1);

    public DEPVAR_TYPE getType();

    public void setType(DEPVAR_TYPE var1);

    public String getPhysicsFieldID();

    public Field setPhysicsFieldID(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the shape functions defining the field variables", ret="Field", type=PrimitiveModelEntity.MethodType.WRITE)
    public Field shape(@PrimitiveModelEntity.ParamDoc(name="shlist", doc="List of shape function tags") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the shape functions as a string vector", ret="Shape function tags", type=PrimitiveModelEntity.MethodType.READ)
    public String[] shape();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the field name as a string", ret="Field name", type=PrimitiveModelEntity.MethodType.READ)
    public String field();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the field name", ret="Field", type=PrimitiveModelEntity.MethodType.WRITE)
    public Field field(@PrimitiveModelEntity.ParamDoc(name="fname", doc="Field name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the geometry associated with the field", ret="Geometry tag", type=PrimitiveModelEntity.MethodType.READ)
    public String geom();

    public void createReset(Field var1, boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the type of field, which can be <code>normal</code>, <code>control</code>, <code>discrete</code>, or <code>quadrature</code>.<br> The <code>control</code> type is used to mark a field as intended only for use by the optimization and sensitivity solvers. A control variable field should never actually be solved for by the basic solvers, while an optimization solver will modify them in its outer loop.<br> The <code>discrete</code> and <code>quadrature</code> types are not yet used by fields.<br>", ret="Field type", type=PrimitiveModelEntity.MethodType.READ)
    public String type();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the type of field, which can be <code>normal</code>, <code>control</code>, <code>discrete</code>, or <code>quadrature</code>.<br> The <code>control</code> type is used to mark a field as intended only for use by the optimization and sensitivity solvers. A control variable field should never actually be solved for by the basic solvers, while an optimization solver will modify them in its outer loop.<br> The <code>discrete</code> and <code>quadrature</code> types are not yet used by fields.<br>", ret="Field", type=PrimitiveModelEntity.MethodType.WRITE)
    public Field type(@PrimitiveModelEntity.ParamDoc(name="shlist", doc="List of shape function tags") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #field()} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public String fieldname();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #field(String)} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public Field fieldname(String var1);
}

