/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.GeomSubsequence;
import com.comsol.model.dbimodel.IListMove;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.definitions.IDefinitionsList;
import com.comsol.model.savepoint.interfaces.IGeomList;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="List of geometry sequences.")
public interface GeomList<T extends GeomSequence>
extends IListMove,
ModelEntityList<T>,
IDefinitionsList<GeomSequence>,
IGeomList<T> {
    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Creates a geometry sequence with a given tag and space dimension", ret="Geometry sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomSequence create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Geometry tag") String var1, @PrimitiveModelEntity.ParamDoc(name="sdim", doc="Geometry dimension") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a geometry sequence with a given tag, type, and space dimension.", ret="Created geometry sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomSequence create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Geometry tag") String var1, @PrimitiveModelEntity.ParamDoc(name="type", doc="Type of geometry, can be \"Sequence\" or \"Part\"") String var2, @PrimitiveModelEntity.ParamDoc(name="sdim", doc="Space dimension") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a geometry sequence and meshing sequence by importing a geometry or a mesh from a file", ret="Geometry sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomSequence create(@PrimitiveModelEntity.ParamDoc(name="geomTag", doc="Geometry tag") String var1, @PrimitiveModelEntity.ParamDoc(name="meshTag", doc="Mesh tag") String var2, @PrimitiveModelEntity.ParamDoc(name="fileName", doc="Imported geometry or mesh file") String var3);

    @PrimitiveModelEntity.MethodDoc(doc="Load one or more geometry parts.", type=PrimitiveModelEntity.MethodType.WRITE)
    public void load(@PrimitiveModelEntity.ParamDoc(name="tags", doc="Tags for the parts.") String[] var1, @PrimitiveModelEntity.ParamDoc(name="filename", doc="The mph file containing the parts.") String var2, @PrimitiveModelEntity.ParamDoc(name="partTagsInFile", doc="The tags of the parts in the mph file.") String[] var3);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #load(String[], String, String[])} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public void link(@PrimitiveModelEntity.ParamDoc(name="tags", doc="Tags for the parts.") String[] var1, @PrimitiveModelEntity.ParamDoc(name="filename", doc="The mph file containing the parts.") String var2, @PrimitiveModelEntity.ParamDoc(name="partTagsInFile", doc="The tags of the parts in the mph file.") String[] var3);

    public void linkFromLoadedModel(Model var1, String[] var2, String var3, String[] var4);

    public void logLink(String[] var1, String var2, String[] var3);

    public GeomSequence createParticleGeometry(String var1, boolean var2);

    public GeomSequence createDerived(String var1, int var2, ModelNode var3, ModelEntity var4);

    public void createReset(GeomList<? extends GeomSequence> var1);

    @PrimitiveModelEntity.MethodDoc(doc="Build the finalized geometry in all geometry sequences in the list", type=PrimitiveModelEntity.MethodType.WRITE)
    public void run();

    public List<? extends GeomSequence> getAllGeomSequences();

    public GeomSubsequence getMainSubsequence();

    public GeomSubsequence findLinkedSubsequence(String var1, String var2);

    public void migrateNativeAfterLoad();
}

