/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.MeshNative;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;

@PrimitiveModelEntity.TypeDoc(value="Mesh data")
public interface MeshData
extends PropFeature {
    public MeshNative getMeshnative();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the coordinates of the mesh vertices", ret="Matrix where each column corresponds to a mesh vertex", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getVertex();

    @PrimitiveModelEntity.MethodDoc(doc="Gets block of coordinates of the mesh vertices", ret="Matrix where each column corresponds to a mesh vertex", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getVertex(@PrimitiveModelEntity.ParamDoc(name="position", doc="Start index") int var1, @PrimitiveModelEntity.ParamDoc(name="number", doc="Length of block") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets elements from the mesh", ret="Matrix where each column contains the mesh vertex indices of an element's corners", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getElem(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of elements from the mesh", ret="Matrix where each column contains the mesh vertex indices of an element's corners", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getElem(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1, @PrimitiveModelEntity.ParamDoc(name="position", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="number", doc="Length of block") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets geometric entity number for the elements of a specific type", ret="Vector of geometric entity numbers", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getElemEntity(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of geometric entity number for the elements of a specific type", ret="Vector of geometric entity numbers", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getElemEntity(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1, @PrimitiveModelEntity.ParamDoc(name="position", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="number", doc="Length of block") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the mesh vertices", ret="Mesh data", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshData setVertex(@PrimitiveModelEntity.ParamDoc(name="vtx", doc="Matrix where each column corresponds to a mesh vertex") double[][] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the mesh data", ret="Mesh data", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshData setElem(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1, @PrimitiveModelEntity.ParamDoc(name="elem", doc="Matrix where each column contains the mesh vertex indices of an element's corners") int[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Inserts block of mesh data", ret="Mesh data", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshData setElem(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1, @PrimitiveModelEntity.ParamDoc(name="position", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="elem", doc="Matrix where each column contains the mesh vertex indices of an element's corners") int[][] var3);

    @PrimitiveModelEntity.MethodDoc(doc="Sets geometric entity number for the elements of a specific type", ret="Mesh data", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshData setElemEntity(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1, @PrimitiveModelEntity.ParamDoc(name="elem", doc="Geometric entity number") int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Inserts block of geometric entity numbers for the elements of a specific type", ret="Mesh type", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshData setElemEntity(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1, @PrimitiveModelEntity.ParamDoc(name="position", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="elem", doc="Geometric entity number") int[] var3);

    @PrimitiveModelEntity.MethodDoc(doc="Inserts a block of mesh vertices", ret="Mesh data", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshData setVertex(@PrimitiveModelEntity.ParamDoc(name="position", doc="Start index") int var1, @PrimitiveModelEntity.ParamDoc(name="vtx", doc="Matrix where each column corresponds to a mesh vertex") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Construct a complete mesh from the MeshData object and store it in the meshing sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public void createMesh();

    @PrimitiveModelEntity.MethodDoc(doc="Clears the MeshData object", type=PrimitiveModelEntity.MethodType.WRITE)
    public void clearData();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the number of elements of a specific type", ret="Number of elements", type=PrimitiveModelEntity.MethodType.READ)
    public int getNumElem(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the element types in the mesh", ret="Vector of element types", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getTypes();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the number of mesh vertices in a mesh", ret="Number of mesh vertices", type=PrimitiveModelEntity.MethodType.READ)
    public int getNumVertex();

    @PrimitiveModelEntity.MethodDoc(doc="Transfers the mesh from the current meshing sequence into the MeshData object", type=PrimitiveModelEntity.MethodType.READ)
    public void transferMesh();

    @PrimitiveModelEntity.MethodDoc(doc="Transfers the mesh from another meshing sequence into the MeshData object", type=PrimitiveModelEntity.MethodType.READ)
    public void transferMesh(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Mesh sequence tag") String var1);
}

