/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.data.events.IEventHandler;
import com.comsol.model.dbimodel.AssocUpdate;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.NodeGroup;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.View;
import com.comsol.model.element.IElementSyntaxContributor;
import com.comsol.model.method.ModelEntityMethod;
import com.comsol.model.properties.ModelEntityPropSet;
import com.comsol.model.savepoint.interfaces.IModelEntity;
import com.comsol.model.savepoint.interfaces.IModelNode;
import com.comsol.model.util.IModelSearch;
import com.comsol.model.util.LicenseRequirement;
import com.comsol.model.util.ReInitInfo;
import com.comsol.nativeutil.ComparisonResult;
import com.comsol.nativeutil.properties.IEntityProperties;
import com.comsol.nativeutil.properties.Property;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.interfaces.g;
import com.comsol.util.interfaces.w;
import java.util.Collection;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Base interface for model object entities")
public interface ModelEntity
extends IEventHandler,
PrimitiveModelEntity,
IElementSyntaxContributor,
IModelEntity,
g,
w {
    public IdentifierType getIdentifierType();

    public ModelEntity getDerivedFrom();

    public void setDerivedFrom(ModelEntity var1);

    public ModelEntityPropSet getPropSet();

    public ModelEntity defaults();

    @PrimitiveModelEntity.MethodDoc(doc="Makes the entity active or inactive", ret="Model entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelEntity active(@PrimitiveModelEntity.ParamDoc(name="flag", doc="<code>true</code>: make active; <code>false</code>: make inactive") boolean var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if the entity is active", ret="<code>true</code> if active", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isActive();

    public boolean isGUIActive();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the tag of the entity", ret="The tag of the entity", type=PrimitiveModelEntity.MethodType.READ)
    public String tag();

    @PrimitiveModelEntity.MethodDoc(doc="Assigns a new tag to the entity", ret="The new re-tagged entity", type=PrimitiveModelEntity.MethodType.READ)
    public ModelEntity tag(@PrimitiveModelEntity.ParamDoc(name="tag", doc="The old tag of the entity") String var1);

    @Deprecated
    public ModelEntity copy();

    public ModelEntity copy(Model var1);

    public boolean equalsValue(Object var1);

    public boolean isRemovable();

    public boolean isRetagable();

    public boolean isDeactivatable();

    public ModelEntityPropSet createPropSet();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the label of the entity", ret="The label of the entity", type=PrimitiveModelEntity.MethodType.READ)
    public String label();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the label of the entity", ret="Model entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelEntity label(@PrimitiveModelEntity.ParamDoc(name="label", doc="Label for the entity") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the icon used in the Model Builder for this entity. If the entity has no icon, <code>null</code> is returned. The return value is the name of the icon file in the folder data/images in the COMSOL installation folder.", ret="The icon or <code>null</code>.", type=PrimitiveModelEntity.MethodType.READ)
    public String icon();

    public IEntityProperties getEntityAnnotation();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the comments of the entity", ret="Comments", type=PrimitiveModelEntity.MethodType.READ)
    public String comments();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the comments of the entity", ret="Model entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelEntity comments(@PrimitiveModelEntity.ParamDoc(name="comment", doc="New comments") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the author of the entity", ret="Model entity author", type=PrimitiveModelEntity.MethodType.READ)
    public String author();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the author of the entity", ret="Model entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelEntity author(@PrimitiveModelEntity.ParamDoc(name="name", doc="Name of author") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the creation date of the entity", ret="Creation date", type=PrimitiveModelEntity.MethodType.READ)
    public String dateCreated();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the creation time of the entity as the number of milliseconds since January 1, 1970, 00:00:00 GMT. For a human readable format use {@link #dateCreated()}.", ret="Creation time", type=PrimitiveModelEntity.MethodType.READ)
    public long timeCreated();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the version of the entity", ret="Version", type=PrimitiveModelEntity.MethodType.READ)
    public String version();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the version of the entity", ret="Model entity", type=PrimitiveModelEntity.MethodType.READ)
    public ModelEntity version(@PrimitiveModelEntity.ParamDoc(name="version", doc="Version") String var1);

    public String getDefaultName();

    public void reInitialize(ReInitInfo var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the model component node tag of the entity", ret="Model component node tag", type=PrimitiveModelEntity.MethodType.READ)
    public String model();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the model component node of the entity", ret="Model node entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelEntity model(@PrimitiveModelEntity.ParamDoc(name="compTag", doc="Model component node tag") String var1);

    public ModelNode getParentModel();

    public Collection<?> getChildren();

    public NodeGroup getNodeGroup();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Return the scope of the entity", ret="Scope of entity", type=PrimitiveModelEntity.MethodType.READ)
    public String scope();

    public String getUniqueName(String var1);

    public String getUniqueName(String var1, boolean var2);

    @Override
    public String scopeDot();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the modification date of the model", ret="Modification date", type=PrimitiveModelEntity.MethodType.READ)
    public String dateModified();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the modification time of the entity as the number of milliseconds since January 1, 1970, 00:00:00 GMT. For a human readable format use {@link #dateModified()}.", ret="Creation time", type=PrimitiveModelEntity.MethodType.READ)
    public long timeModified();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the last user to modify the model", ret="Last author of model", type=PrimitiveModelEntity.MethodType.READ)
    public String lastModifiedBy();

    @Override
    public String shortScopeDot();

    public LicenseRequirement[] getRequiredLicenses(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a URL to an HTML document with help text for a child of this entity.", ret="A documentation URL string.", type=PrimitiveModelEntity.MethodType.READ)
    public String help();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a URL to an HTML document with help text for a child of this entity.", ret="A documentation URL string.", type=PrimitiveModelEntity.MethodType.READ)
    public String help(@PrimitiveModelEntity.ParamDoc(name="name", doc="The child's type name.") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the unique topic key for looking up help for this object using a remote documentation client.", ret="A documentation topic key.", type=PrimitiveModelEntity.MethodType.READ)
    public String docMarker();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the unique topic key for looking up help for this object using a remote documentation client.", ret="A documentation topic key.", type=PrimitiveModelEntity.MethodType.READ)
    public String docMarker(@PrimitiveModelEntity.ParamDoc(name="name", doc="The child's type name.") String var1);

    public void postLoadInitialize(boolean var1);

    @Override
    public IUnitConverter getConverter();

    public String xmeshScopeDot();

    public String shortXmeshScopeDot();

    public void createDuplicate(ModelEntity var1);

    public void batchKeySeed(StringBuilder var1);

    public View getLatestApplicationView();

    public void setLatestApplicationView(View var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the author of the entity and all its children", ret="Model entity", type=PrimitiveModelEntity.MethodType.READ)
    public ModelEntity resetAuthor(@PrimitiveModelEntity.ParamDoc(name="name", doc="Author name") String var1);

    public void setEntityName(String var1);

    public String getCreateJavaCode(String var1);

    public String getSetJavaCode(String var1, boolean var2);

    public String getSetJavaCode(String var1, boolean var2, String[] var3);

    public String getAccessJavaCode(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #isActive()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public boolean isactive();

    public void accessSetIdentifier(String var1);

    public String accessGetIdentifier();

    default public Property accessIdentifierProperty() {
        return null;
    }

    public String getEntityAuthor();

    public void setEntityAuthor(String var1);

    public String getEntityModifiedBy();

    public String getEntityComments();

    public void setEntityComments(String var1);

    public String getIdentifierName();

    public String getEntityName();

    public IModelNode getStoredParent();

    public void setActiveFlag(boolean var1);

    public boolean isActiveFlag();

    public void setEntityModifyTime(long var1);

    public void setEntityModifiedBy(String var1);

    public void setEntityCreationTime(long var1);

    public long getEntityModifyTime();

    public long getEntityCreationTime();

    public void setStoredParent(ModelNode var1);

    public void addFlag(Flags var1);

    public void removeFlag(Flags var1);

    public boolean hasFlag(Flags var1);

    @Override
    public ModelEntityMethod method();

    public boolean doingMultiphysics();

    public void assocUpdateThis(AssocUpdate var1);

    public boolean canUndoRemove();

    public boolean isInvisibleInGui();

    public boolean allowDuplicateLabels();

    public boolean synchronizeUpdate(ModelEntity var1, SYNCHRONIZEPASS var2, List<Exception> var3);

    default public boolean compareWith(ModelEntity modelEntity, ComparisonResult comparisonResult) {
        throw new UnsupportedOperationException();
    }

    public void search(IModelSearch var1);

    public String suggestedVariableName();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #label()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public String name();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #label(String)} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public ModelEntity name(String var1);

    public boolean isAutoGenerated();

    @Override
    default public boolean includeInComparison() {
        return !this.isAutoGenerated();
    }

    public static enum Flags {
        NOREMOVE,
        NORETAG,
        NODEACTIVATE,
        AUTODEACTIVATE,
        HIDDEN,
        AUTOGENERATED;

    }

    public static enum IdentifierType {
        NAME("Name", true, false, false),
        BASE_NAME("Base_name", true, false, false),
        OPERATOR("Operator_name", true, false, false),
        VARIABLE("Variable_name", true, false, false),
        PARAMETER("Parameter_name", true, false, false),
        PAIR("Pair_name", true, false, false),
        FUNCTION("Function_name", true, false, false),
        METHOD_CALL("Tag", true, false, false),
        FORM_INSTANCE("Form", true, false, false),
        ADDIN(null, false, true, true),
        NONE(null, true, false, false),
        NOLABEL(null, false, false, true),
        ONLYLABEL(null, true, true, false),
        ONLYTAG("Name", true, false, false, "New_text", null),
        ONLYTAGEMPTYLABELOK("Name", true, false, false, "New_text", null){

            @Override
            public boolean allowDuplicateLabels() {
                return true;
            }

            @Override
            public boolean allowEmptyLabels() {
                return true;
            }
        }
        ,
        TAGASLABEL("Name", true, true, false, "New_name", null){

            @Override
            public boolean allowDuplicateLabels() {
                return true;
            }

            @Override
            public boolean isTagAsLabel() {
                return true;
            }
        }
        ,
        TAGASLABELEMPTYLABELOK("Name", true, true, false, "New_name", null){

            @Override
            public boolean allowDuplicateLabels() {
                return true;
            }

            @Override
            public boolean allowEmptyLabels() {
                return true;
            }

            @Override
            public boolean isTagAsLabel() {
                return true;
            }
        }
        ,
        STATICLABEL(null, false, true, false, null, null){

            @Override
            public boolean allowDuplicateLabels() {
                return true;
            }
        };

        private final String label;
        private final String changeLabel;
        private final String labelLabel;
        private final boolean allowLabelChange;
        private final boolean hideTag;
        private final boolean skipSection;

        private IdentifierType(String string2, boolean bl2, boolean bl3, boolean bl4) {
            this(string2, bl2, bl3, bl4, "New_label", "Label");
        }

        private IdentifierType(String string2, boolean bl2, boolean bl3, boolean bl4, String string3, String string4) {
            this.label = string2;
            this.changeLabel = string3;
            this.labelLabel = string4;
            this.allowLabelChange = bl2;
            this.hideTag = bl3;
            this.skipSection = bl4;
        }

        public String getLabelLabel() {
            return this.labelLabel;
        }

        public String getChangeLabelLabel() {
            return this.changeLabel;
        }

        public String getNameLabel() {
            return this.label;
        }

        public boolean allowLabelChange() {
            return this.allowLabelChange;
        }

        public boolean hideTagInNodeLabel() {
            return this.hideTag;
        }

        public boolean skipNameLabelSection() {
            return this.skipSection;
        }

        public boolean allowDuplicateLabels() {
            return false;
        }

        public boolean allowEmptyLabels() {
            return false;
        }

        public boolean isTagAsLabel() {
            return false;
        }

        public String getLabel(ModelEntity modelEntity) {
            if (this.isTagAsLabel()) {
                return modelEntity.tag();
            }
            return modelEntity.label();
        }

        public void setLabel(ModelEntity modelEntity, String string) {
            if (this.isTagAsLabel()) {
                modelEntity.tag(string);
            } else {
                modelEntity.label(string);
            }
        }
    }

    public static enum SYNCHRONIZEPASS {
        ALL,
        STRUCTURE,
        VALUES;

    }
}

