/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.AbstractModel;
import com.comsol.model.dbimodel.ComponentCoordsysList;
import com.comsol.model.dbimodel.ComponentCplList;
import com.comsol.model.dbimodel.ComponentExprList;
import com.comsol.model.dbimodel.ComponentExtraDimList;
import com.comsol.model.dbimodel.ComponentFunctionFeatureList;
import com.comsol.model.dbimodel.ComponentGeomList;
import com.comsol.model.dbimodel.ComponentMaterialList;
import com.comsol.model.dbimodel.ComponentMeshList;
import com.comsol.model.dbimodel.ComponentPairList;
import com.comsol.model.dbimodel.ComponentPhysicsList;
import com.comsol.model.dbimodel.ComponentProbeFeatureList;
import com.comsol.model.dbimodel.ComponentSelectionList;
import com.comsol.model.dbimodel.ComponentViewList;
import com.comsol.model.dbimodel.Coordsys;
import com.comsol.model.dbimodel.Cpl;
import com.comsol.model.dbimodel.Expr;
import com.comsol.model.dbimodel.ExtraDimFeature;
import com.comsol.model.dbimodel.FunctionFeature;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.MODEL_NODE_TYPES;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.Pair;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.ProbeFeature;
import com.comsol.model.dbimodel.SORDERS_TYPES;
import com.comsol.model.dbimodel.SelectionFeature;
import com.comsol.model.dbimodel.View;
import com.comsol.model.dbimodel.physics.ComponentMultiphysicsCouplingList;
import com.comsol.model.dbimodel.physics.MultiphysicsCoupling;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.operations.ICommonFeatureID;
import com.comsol.model.savepoint.interfaces.IModelNode;
import com.comsol.util.interfaces.IUnitConverter;
import java.util.Map;
import java.util.stream.Stream;

@PrimitiveModelEntity.TypeDoc(value="Model node")
public interface ModelNode
extends AbstractModel,
IModelNode {
    @PrimitiveModelEntity.MethodDoc(doc="Returns all coordinate systems for this component", ret="List of coordinate systems", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentCoordsysList<? extends Coordsys> coordSystem();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all component couplings for this component", ret="List of component couplings", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentCplList<? extends Cpl> cpl();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all extra dimension features for this component", ret="List of extra dimension features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentExtraDimList<? extends ExtraDimFeature> extraDim();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all functions for this component", ret="List of functions", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentFunctionFeatureList<? extends FunctionFeature> func();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all geometry sequences for this component", ret="List of geometry sequences", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentGeomList<? extends GeomSequence> geom();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all mass properties for this component", ret="List of mass properties", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentProbeFeatureList<? extends ProbeFeature> massProp();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all materials for this component", ret="List of materials", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentMaterialList<? extends Material> material();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all meshing sequences for this component", ret="List of meshing sequences", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentMeshList<? extends MeshSequence> mesh();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all multiphysics couplings for this component", ret="List of multiphysics couplings", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentMultiphysicsCouplingList<? extends MultiphysicsCoupling> multiphysics();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all pairs for this component", ret="List of pairs", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentPairList<? extends Pair> pair();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all physics interfaces for this component", ret="List of physics interfaces", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentPhysicsList<? extends Physics> physics();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all probes for this component", ret="List of probes", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentProbeFeatureList<? extends ProbeFeature> probe();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all named selections for this component", ret="List of named selections", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentSelectionList<? extends SelectionFeature> selection();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all variable collections for this component", ret="List of variable collections", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentExprList<? extends Expr> variable();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all views for this component", ret="List of views", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ComponentViewList<? extends View> view();

    @PrimitiveModelEntity.MethodDoc(doc="Get the type identifier of this component", ret="Type identifier", type=PrimitiveModelEntity.MethodType.READ)
    default public String getType() {
        return this.getModelType().getType();
    }

    public MODEL_NODE_TYPES getModelType();

    public GeomSequence getGeom();

    @Override
    public String[] getAllGeom();

    public void createReset(ModelNode var1, boolean var2);

    public String getBaseSystem();

    public void setBaseSystem(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the geometry shape order used for the model node and its descendants", ret="Geometry shape order", type=PrimitiveModelEntity.MethodType.READ)
    public String sorder();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the geometry shape order used for the model node and its descendants", ret="Model node", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelNode sorder(@PrimitiveModelEntity.ParamDoc(name="sorder", doc="Geometry shape order") String var1);

    public void setSorder(SORDERS_TYPES var1);

    public SORDERS_TYPES getSorderType();

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if curved interior mesh is activated on the model node", ret="Curved interior mesh setting", type=PrimitiveModelEntity.MethodType.READ)
    public boolean curvedInterior();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the curved interior mesh setting on the model node. If true, the interior domain mesh elements can be curved, to avoid inverted elements.", ret="Model node", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelNode curvedInterior(@PrimitiveModelEntity.ParamDoc(name="curvedInterior", doc="Curved interior mesh setting") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if local coordinate variables (xi1, xi2, xi3) will be defined.", ret="True if local coordinates variables exist.", type=PrimitiveModelEntity.MethodType.READ)
    public boolean defineLocalCoord();

    @PrimitiveModelEntity.MethodDoc(doc="Set a flag that determines whether local coordinate variables (xi1, xi2, xi3, also known as barycentric coordinates) will be defined in each mesh element.", ret="Model node", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelNode defineLocalCoord(@PrimitiveModelEntity.ParamDoc(name="define", doc="Flag") boolean var1);

    public IUnitConverter getStoredConverter();

    public void setConverter(IUnitConverter var1);

    public void setIdentifier(String var1);

    public String getIdentifier();

    public ModelNode copyToModel(Model var1);

    public int getSpatialOrder();

    public void touch();

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if all frames are always defined", ret="True if all frames are always defined", type=PrimitiveModelEntity.MethodType.READ)
    public boolean defineAllFrames();

    @PrimitiveModelEntity.MethodDoc(doc="Set whether all frames should always be defined", ret="Model node", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelNode defineAllFrames(@PrimitiveModelEntity.ParamDoc(name="define", doc="Flag") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns names of spatial frame coordinates", ret="Names of spatial frame coordinates", type=PrimitiveModelEntity.MethodType.READ)
    public String[] spatialCoord();

    @PrimitiveModelEntity.MethodDoc(doc="Sets names of spatial frame coordinates", ret="Model node", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelNode spatialCoord(@PrimitiveModelEntity.ParamDoc(name="coord", doc="Spatial frame coordinate names") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns names of material frame coordinates", ret="Names of material frame coordinates", type=PrimitiveModelEntity.MethodType.READ)
    public String[] materialCoord();

    @PrimitiveModelEntity.MethodDoc(doc="Sets names of material frame coordinates", ret="Model node", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelNode materialCoord(@PrimitiveModelEntity.ParamDoc(name="coord", doc="Material frame coordinate names") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns names of geometry frame coordinates", ret="Names of geometry frame coordinates", type=PrimitiveModelEntity.MethodType.READ)
    public String[] geometryCoord();

    @PrimitiveModelEntity.MethodDoc(doc="Sets names of geometry frame coordinates", ret="Model node", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelNode geometryCoord(@PrimitiveModelEntity.ParamDoc(name="coord", doc="Geometry frame coordinate names") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns names of mesh frame coordinates", ret="Names of mesh frame coordinates", type=PrimitiveModelEntity.MethodType.READ)
    public String[] meshCoord();

    @PrimitiveModelEntity.MethodDoc(doc="Sets names of mesh frame coordinates", ret="Model node", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelNode meshCoord(@PrimitiveModelEntity.ParamDoc(name="coord", doc="Mesh frame coordinate names") String[] var1);

    public void setDefineAllFrames(boolean var1);

    public boolean isDefineAllFrames();

    public void setSpatialCoord(String[] var1);

    public void setMaterialCoord(String[] var1);

    public void setGeometryCoord(String[] var1);

    public void setMeshCoord(String[] var1);

    public String[] getSpatialCoord();

    public String[] getMaterialCoord();

    public String[] getGeometryCoord();

    public String[] getMeshCoord();

    public void setDefaultSpatialCoord(boolean var1);

    public void setDefaultMaterialCoord(boolean var1);

    public void setDefaultGeometryCoord(boolean var1);

    public void setDefaultMeshCoord(boolean var1);

    public void setPreferedModel(String var1);

    public boolean isDefaultSpatialCoord();

    public boolean isDefaultMaterialCoord();

    public boolean isDefaultGeometryCoord();

    public boolean isDefaultMeshCoord();

    public ModelEntityList<? extends ModelEntity> getSubEntityList(ICommonFeatureID.ISubListID var1);

    public Stream<Map.Entry<ICommonFeatureID.ISubListID, ModelEntityList<? extends ModelEntity>>> subEntityListStream();

    @Override
    public String getPreferredComponent();

    public void updateFrames();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the node's identifier. @deprecated Use {@link #tag()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public String identifier();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the node's identifier. @deprecated Use {@link #tag(String)} instead", ret="Model node", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public ModelNode identifier(String var1);
}

