/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.DEPVAR_TYPE;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Global equation")
public interface Ode
extends ModelEntity {
    public static final String typeGlobal = "The <code>control</code> type is used to mark an ode as intended only for use by the optimization and sensitivity solvers. A control variable ode should never actually be solved for by the basic solvers, while an optimization solver will modify them in its outer loop.<br> The <code>discrete</code> type is only used for events, and represents variables that can change by the re-initialization of a triggered event.<br> The <code>quadrature</code> type is used by events to define indicator states that indicates when an event will be triggered.";

    public List<String> getWeakequations();

    public boolean isSolveFor();

    public void setSolveFor(boolean var1);

    public String[] getXmeshVars();

    public void setXmeshVars(String[] var1);

    public String[] getXmeshVarsStatic();

    public void setXmeshVarsStatic(String[] var1);

    public DEPVAR_TYPE getType();

    public void setType(DEPVAR_TYPE var1);

    public boolean isCreateTimeVars();

    public void setCreateTimeVars(boolean var1);

    public String timeDerivativeMultiplier();

    public Ode timeDerivativeMultiplier(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the states of the global equation", ret="Global equation", type=PrimitiveModelEntity.MethodType.WRITE)
    public Ode state(@PrimitiveModelEntity.ParamDoc(name="statelist", doc="Vector of states") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a state of the the global equation", ret="Global equation", type=PrimitiveModelEntity.MethodType.WRITE)
    public Ode state(@PrimitiveModelEntity.ParamDoc(name="pos", doc="Index of state") int var1, @PrimitiveModelEntity.ParamDoc(name="state", doc="State") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the equation for a state", ret="Global equation", type=PrimitiveModelEntity.MethodType.WRITE)
    public Ode ode(@PrimitiveModelEntity.ParamDoc(name="state", doc="State name") String var1, @PrimitiveModelEntity.ParamDoc(name="equation", doc="Equation") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the description for the state", ret="Global equation", type=PrimitiveModelEntity.MethodType.WRITE)
    public Ode descr(@PrimitiveModelEntity.ParamDoc(name="state", doc="State name") String var1, @PrimitiveModelEntity.ParamDoc(name="descr", doc="Description") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the weak equations", ret="Global equation", type=PrimitiveModelEntity.MethodType.WRITE)
    public Ode weak(@PrimitiveModelEntity.ParamDoc(name="wlist", doc="List of weak expressions") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets value type as real or complex when splitting of complex variables in real and imaginary parts has been turned on", ret="Global equation", type=PrimitiveModelEntity.MethodType.WRITE)
    public Ode valueType(@PrimitiveModelEntity.ParamDoc(name="valueType", doc="Value type: <code>real</code> or <code>complex</code>") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a weak equation at a position", ret="Global equation", type=PrimitiveModelEntity.MethodType.WRITE)
    public Ode weak(@PrimitiveModelEntity.ParamDoc(name="pos", doc="Position") int var1, @PrimitiveModelEntity.ParamDoc(name="wexpr", doc="") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns all weak equations", ret="List of weak expressions", type=PrimitiveModelEntity.MethodType.READ)
    public String[] weak();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the value type", ret="Value type: <code>real</code> or <code>complex</code>", type=PrimitiveModelEntity.MethodType.READ)
    public String valueType();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the state vector", ret="List of state variables", type=PrimitiveModelEntity.MethodType.READ)
    public String[] state();

    public boolean hasState(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the description for a state", ret="Description", type=PrimitiveModelEntity.MethodType.READ)
    public String descr(@PrimitiveModelEntity.ParamDoc(name="state", doc="State") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the ode for a state", ret="Global equation", type=PrimitiveModelEntity.MethodType.WRITE)
    public String ode(@PrimitiveModelEntity.ParamDoc(name="state", doc="State") String var1);

    public void createReset(Ode var1, boolean var2);

    public String[] expandedState();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the type of global equation, which can be <code>normal</code>,<code>control</code>, <code>discrete</code>, or <code>quadrature</code>.<br>The <code>control</code> type is used to mark an ode as intended only for use by the optimization and sensitivity solvers. A control variable ode should never actually be solved for by the basic solvers, while an optimization solver will modify them in its outer loop.<br> The <code>discrete</code> type is only used for events, and represents variables that can change by the re-initialization of a triggered event.<br> The <code>quadrature</code> type is used by events to define indicator states that indicates when an event will be triggered.", ret="Type of global equation", type=PrimitiveModelEntity.MethodType.READ)
    public String type();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the type of global equation, which can be <code>normal</code>,<code>control</code>, <code>discrete</code>, or <code>quadrature</code>.<br>The <code>control</code> type is used to mark an ode as intended only for use by the optimization and sensitivity solvers. A control variable ode should never actually be solved for by the basic solvers, while an optimization solver will modify them in its outer loop.<br> The <code>discrete</code> type is only used for events, and represents variables that can change by the re-initialization of a triggered event.<br> The <code>quadrature</code> type is used by events to define indicator states that indicates when an event will be triggered.", ret="Global equation", type=PrimitiveModelEntity.MethodType.WRITE)
    public Ode type(@PrimitiveModelEntity.ParamDoc(name="type", doc="Type of global equation") String var1);

    public void addDerivingStudy(PropFeature var1);

    public boolean removeDerivingStudy(PropFeature var1);

    public String[] getDerivingStudy();

    public String getPhysicsFieldID();

    public Ode setPhysicsFieldID(String var1);
}

