/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SOL_ANALYSIS_TYPES;
import com.comsol.model.savepoint.interfaces.IModel;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Solution information")
public interface SolutionInfo
extends ModelEntity {
    public String[] getPNames();

    public void setPNames(String[] var1);

    public String[] getPUnits();

    public void setPUnits(String[] var1);

    public int[] getLooplevel();

    public void setLooplevel(int[] var1);

    public List<double[]> getPLists();

    @PrimitiveModelEntity.MethodDoc(doc="The maximal number of levels any solution can have. The following inequality holds:<br>0 &le; <code>level</code> &lt; <code>getLevels()</code> &le; <code>getMaxLevels()</code>", type=PrimitiveModelEntity.MethodType.READ, ret="Maximal level")
    public int getMaxLevels();

    public void setMaxLevels(int var1);

    public boolean isNativeFilled();

    public void setNativeFilled(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the subset of parameter names that are looped by an outer parametric sweep.", ret="Vector with parameter names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getPNamesOuter();

    public void setPNamesOuter(String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the units for the subset of parameters that are looped by an outer parametric sweep.", ret="Vector with parameter units", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getPUnitsOuter();

    public void setPUnitsOuter(String[] var1);

    public String[][] getPDescsOuter();

    public void setPDescsOuter(String[][] var1);

    public void touch(String var1);

    public void clusterTouch();

    default public void touch() {
        this.touch(null);
    }

    public SolutionInfo getOldInfo();

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> unless the underlying solution object/objects has a parameter variation that depends on the solution process itself. Examples are time-dependent simulations where the output is determined by the steps taken by the solver or eigenvalue simulations.", ret="Boolean describing the state", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isStructured();

    public void setStructured(boolean var1);

    public void setSwitchLevelDescriptions(String[] var1);

    public void setSwitchLevelPnames(String[][] var1);

    public void setSwitchLevelCases(String[][] var1);

    public String getSwitchLevelDescription(int var1);

    public String[] getSwitchLevelPnames(int var1);

    public String[] getSwitchLevelCases(int var1);

    public SOL_ANALYSIS_TYPES getOldAnalysisType();

    public void setOldAnalysisType(SOL_ANALYSIS_TYPES var1);

    public void add(String var1, double[] var2, String var3);

    public void addToLoop(String var1, double[] var2, String var3);

    public void addOuter(String var1, double[] var2, String var3, String[] var4);

    public void addOuterToLoop(String var1, double[] var2, String var3, String[] var4);

    public boolean isOuterFilled();

    public void clear(boolean var1);

    public void add(SolutionInfo var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the number of levels in this solution. The following inequality holds:<br>0 &le; <code>level</code> &lt; <code>getLevels()</code> &le; <code>getMaxLevels()</code>", ret="Levels", type=PrimitiveModelEntity.MethodType.READ)
    public int getLevels();

    public int getLevels(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the names of the different levels. Some of these may be a concatenated string such as '<code>p1, p2</code>'", ret="Level names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getLevelNames();

    public String[] getLevelNames(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the names of the different levels, split into an array for the case when there is more than one.", ret="Split level names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getSplitLevelNames();

    @PrimitiveModelEntity.MethodDoc(doc="Get the description of the different levels, split into an array for the case when there is more than one.", ret="Split level names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getSplitLevelDescriptions();

    @PrimitiveModelEntity.MethodDoc(doc="Get the units of the different levels, split into an array for the case when there is more than one.", ret="Split level units", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getSplitLevelUnits();

    @PrimitiveModelEntity.MethodDoc(doc="Get the unit of the given parameter.", ret="Unit of parameter", type=PrimitiveModelEntity.MethodType.READ)
    public String getUnit(@PrimitiveModelEntity.ParamDoc(name="name", doc="Name of parameter") String var1);

    public String[] getFilledSplitLevelNames(String var1);

    public String[] getFilledSplitLevelDescriptions(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the parameter name for the loop level. This may be a concatenated string of several parameters such as <code>foo, bar</code>.", ret="Parameter name", type=PrimitiveModelEntity.MethodType.READ)
    public String getName(@PrimitiveModelEntity.ParamDoc(name="level", doc="Zero indexed loop level") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns all parameter names for the level.", ret="Vector of parameter names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getSplitName(@PrimitiveModelEntity.ParamDoc(name="level", doc="Zero indexed loop level") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns all parameter units for the level.", ret="Vector of parameter units", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getSplitUnit(@PrimitiveModelEntity.ParamDoc(name="level", doc="Zero indexed loop level") int var1);

    public String[] getSplitName(int var1, boolean var2);

    public String[] getSplitUnit(int var1, boolean var2);

    public String getLevelIndicesDescription(int var1);

    public String getLevelSelectionDescription(int var1);

    public String getLevelValuesDescription(int var1);

    public String getLevelDescription(int var1, boolean var2);

    public String getLevelDescription(int var1, boolean var2, boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Get the descriptions for the solutions in this level, one string for each solution.", ret="Solution descriptions", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getSolDescriptions(@PrimitiveModelEntity.ParamDoc(name="level", doc="Zero indexed loop level") int var1, @PrimitiveModelEntity.ParamDoc(name="levels", doc="One indexed setting for other loop levels. When the format is structured the settings do not matter and this parameter can be null. When format is unstructured the array should have the same length as getLevels().") int[] var2, @PrimitiveModelEntity.ParamDoc(name="paramInclusion", doc="Include the parameter in the description") boolean var3, @PrimitiveModelEntity.ParamDoc(name="indexInclusion", doc="Include the index number in the description") boolean var4);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #getIndices(int, int[])} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public int[] getIndicies(int var1, int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the one based indices available for a given level. These are 1,...,N where N is the number of values or tuples for the given (externally available ) level. When level = getMaxLevel()-1 the indices can be the result of  an outer product between levels. When the format is unstructured, and when levels is set, then the unstructured list of indices is returned. When the format is unstructured, and when levels==null or levels.length==0, an error will be given if level is such that the there are no structured data to return (currently level==0 and multiple inner pnames).", ret="The one based indices available for a given level", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getIndices(@PrimitiveModelEntity.ParamDoc(name="level", doc="Zero indexed loop level") int var1, @PrimitiveModelEntity.ParamDoc(name="levels", doc="One indexed setting for other loop levels. When the format is structured the settings do not matter and this parameter can be null. When format is unstructured the array should have the same length as getLevels().") int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the one based inner solution numbers for the outer solution number outersolnum. If strict is true the inner solnums will be returned if the outersolnum is a valid outer solution number and else a zero array is returned. If strict is false and if the outersolnum does not match, then the solnums for the containing solution object is returned.", ret="Index one based solution numbers", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getSolnum(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="Outer solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="strict", doc="Specifies behaviour when outersolnum does not match") boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the one based indices for the outer solutions. If there are no outer parameters or added corresponding parameter values the array is empty.", ret="The one based indices for the outer solutions.", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getOuterSolnum();

    public SOL_ANALYSIS_TYPES getAnalysisType();

    public boolean canInterp();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the parameter values for a level. For level &lt; getMaxLevels()-1 this is just the values/tuples of the parameters for this level. The number of rows is the same as the number of parameters for this level. The columns are the tuples. For level==getMaxLevels()-1 the values are expanded into tuples for the case that levels have been merged. When the format is unstructured, and when levels is set, then the unstructured lists of values are returned. When the format is unstructured, and when levels==null or levels.length==0, an error will be given if level is such that the there are no structured data to return (currently level==0 and multiple inner pnames).", ret="Parameter values for a level", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getVals(@PrimitiveModelEntity.ParamDoc(name="level", doc="Zero indexed loop level") int var1, @PrimitiveModelEntity.ParamDoc(name="levels", doc="One indexed setting for other loop levels. When the format is structured the settings do not matter and this parameter can be null. When format is unstructured the array should have the same length as getLevels().") int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the imaginary part of the parameter values for a level. For level &lt; getMaxLevels()-1 this is just the values/tuples of the parameters for this level. The number of rows is the same as the number of parameters for this level. The columns are the tuples. For level==getMaxLevels()-1 the values are expanded into tuples for the case that levels have been merged. When the format is unstructured, and when levels is set, then the unstructured lists of values are returned. When the format is unstructured, and when levels==null or levels.length==0, an error will be given if level is such that the there are no structured data to return (currently level==0 and multiple inner pnames).", ret="Imaginary part of the parameter values for a level", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getValsImag(@PrimitiveModelEntity.ParamDoc(name="level", doc="Zero indexed loop level") int var1, @PrimitiveModelEntity.ParamDoc(name="levels", doc="One indexed setting for other loop levels. When the format is structured the settings do not matter and this parameter can be null. When format is unstructured the array should have the same length as getLevels().") int[] var2);

    public double[][] getValsTransformed(int var1, int[] var2);

    public double[][] getValsImagTransformed(int var1, int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the solnum representation of a level setting. The first row is the inner and the second the outer solnums. The levelSettings must have the same number of rows as there are levels. On each row, index one based settings for each level should be given. If expandInput is false the number of columns must be the same and the columns are treated as level-tuples. If expanInput is true, the number of columns can be different and the output is expanded to the outer product of each levels setting. ", ret="The solnum representation of a level setting.", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] mapToSolnum(@PrimitiveModelEntity.ParamDoc(name="levelSetting", doc="Level settings matrix") int[][] var1, @PrimitiveModelEntity.ParamDoc(name="expandInput", doc="Controls format of levelSetting and of output") boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the level representation of index-one based outer and inner solution numbers. The number of rows of the returned data is equal to the number of levels.", ret="Level representation", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] mapToLevel(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="Outer solution numbers") int[] var1, @PrimitiveModelEntity.ParamDoc(name="innersolnum", doc="Inner solution numbers") int[] var2, @PrimitiveModelEntity.ParamDoc(name="compressedOutput", doc="When <code>false</code>, the columns represent the tuples, which is the most general format. When <code>true</code>, the level settings are made unique on each level. NOTE: When <code>true</code> and if the compressed representation does not match the input, an array with the right number of rows but each with zero length will be returned.") boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the level representation of index-one based outer and inner solution numbers. The number of rows of the returned data is equal to the number of levels.", ret="Level representation", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] mapToLevel(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="Outer solution numbers") int[] var1, @PrimitiveModelEntity.ParamDoc(name="innersolnum", doc="Inner solution numbers") int[] var2, @PrimitiveModelEntity.ParamDoc(name="compressedOutput", doc="When <code>false</code>, the columns represent the tuples, which is the most general format. When <code>true</code>, the level settings are made unique on each level. NOTE: When <code>true</code> and if the compressed representation does not match the input, an array with the right number of rows but each with zero length will be returned.") boolean var3, @PrimitiveModelEntity.ParamDoc(name="checkNative", doc="If false, the native object is not checked for consistency.") boolean var4);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the index-zero based solution object number and the index-zero based solution number within for the outer and inner solution numbers (outersolnum,innersolnum). The solution object  number is returned in the first position and the corresponding solution number in the second. The solution object number is normally the same (0) for all innersolnum, but can vary for so called multi-solutions (time-dependent adaption or for automatic remeshing).", ret="Solution numbers", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getISol(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="Outer solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="innersolnum", doc="Inner solution number") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the index-zero based solution object number for the time value <code>t</code>. The returned solution number is normally the same (0) for all <code>t</code>, but can vary for so called multi-solutions (time-dependent adaption or for automatic remeshing).", ret="Solution object number", type=PrimitiveModelEntity.MethodType.READ)
    public int getISol(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="Outer solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="t", doc="Time value") double var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the maximum number of inner solutions for the given outer solution numbers. If outersolnum is <code>null</code>, the maximum is taken over all outer solutions.", ret="Maximum number of inner solutions", type=PrimitiveModelEntity.MethodType.READ)
    public int getMaxInner(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="Outer solution numbers") int[] var1);

    public int[][] mapOldSolnum(int[] var1, int[] var2);

    public int[][] mapOldSolnum(int var1, int var2);

    public int[][] getDefaultSolnum(boolean var1);

    public void initFromOldInfo();

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if the underlying data is consistent with this info object.", ret="Valid state", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isValid();

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if the underlying data is consistent with this info object.", ret="Valid state", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isValid(@PrimitiveModelEntity.ParamDoc(name="checkNative", doc="If false, the native object is not checked for consistency.") boolean var1);

    public boolean[] isOuterLevel();

    @PrimitiveModelEntity.MethodDoc(doc="Get a descriptive 'value' string for one parametric level. For example: 'Parameter value (p1 (m), p2 (mm/s)'. Always include units (if defined) and the parameter names. Shortens the width for many parameters.", ret="Description of the looplevel level", type=PrimitiveModelEntity.MethodType.READ)
    public String getLevelDescription(@PrimitiveModelEntity.ParamDoc(name="level", doc="Zero indexed loop level") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the solver sequence tag for the index one based outer solution number outersolnum. If the outersolnum is invalid <code>null</code> is returned.", ret="Solver sequence tag or <code>null</code>", type=PrimitiveModelEntity.MethodType.READ)
    public String getSol(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="Index one based outer solution number") int var1);

    public boolean registerSolutionVars(IModel var1, boolean var2);

    public String getBaseSystemCompute();

    public void setBaseSystemCompute(String var1);

    @Override
    default public boolean includeInComparison() {
        return false;
    }

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves a list of one-based tuples (outersolnum, innersolnum) for all solutions that match all pnames. This function works even if isValid returns false", ret="One-based tuples of the form (outersolnum, innersolnum)", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getSolnums(@PrimitiveModelEntity.ParamDoc(name="pnames", doc="Parameter names that must be matched") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves units for the parameters associated with the solutions specified by one-based solnums. If, for example, solnums[5] corresponds to the tuple (2,4), then the 5th entry in the return array will be an array containing all units associated with outersolnum 2 and innersolnum 4. The order of units is matched with the order of the parameter names returned by getPNames(solnums). This function works even if isValid returns false", ret="The parameter units for the given solnums ", type=PrimitiveModelEntity.MethodType.READ)
    public String[][] getUnits(@PrimitiveModelEntity.ParamDoc(name="solnums", doc="Array of outer and inner solnums") int[][] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves parameter names for the parameters associated with the solutions specified by one-based solnums. If, for example, solnums[5] corresponds to the tuple (2,4), then the 5th entry in the return array will be an array containing all parameter names associated with outersolnum 2 and innersolnum 4. This function works even if isValid returns false", ret="The parameter names for the given solnums", type=PrimitiveModelEntity.MethodType.READ)
    public String[][] getPNames(@PrimitiveModelEntity.ParamDoc(name="solnums", doc="Array of index one based outer and inner solnums") int[][] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the real part of the parameter values for the parameters associated with the solutions specified by one-based solnums. If, for example, solnums[5] corresponds to the tuple (2,4), then the 5th entry in the return array will be an array containing the real part of all parameter values associated with outersolnum 2 and innersolnum 4. The order of parameter values is matched with the order of the parameter names returned by getPNames(solnums). This function works even if isValid returns false", ret="The real part of the parameter values for the given solnums", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getPvals(@PrimitiveModelEntity.ParamDoc(name="solnums", doc="Array of index one based outer and inner solnums") int[][] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the imaginary part of the parameter values for the parameters associated with the solutions specified by one-based solnums. If, for example, solnums[5] corresponds to the tuple (2,4), then the 5th entry in the return array will be an array containing the imaginary part of all parameter values associated with outersolnum 2 and innersolnum 4. The order of the parameter values is matched with the order of the parameter names returned by getPNames(solnums). This function works even if isValid returns false", ret="The imaginary part of the parameter values for the given solnums", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getPvalsImag(@PrimitiveModelEntity.ParamDoc(name="solnums", doc="Array of index one based outer and inner solnums") int[][] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the real part of all parameter values (without duplicates) for the parameter pname in the solutions associated with solnums. The list of solnums is assumed to be consistent when it comes to parameters names and units.The parameter values are considered as complex numbers so the returned list may contain duplicate real values if the corresponding imaginary values differ. This function works even if isValid returns false", ret="Array of the real part of the parameter values for pname", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUniquePvals(@PrimitiveModelEntity.ParamDoc(name="pname", doc="Parameter name") String var1, @PrimitiveModelEntity.ParamDoc(name="solnums", doc="Array of index one based outer and inner solnums") int[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the imaginary part of all imaginary parameter values (without duplicates) for the parameter pname in the solutions associated with solnums. The list of solnums is assumed to be consistent when it comes to parameters names and units. The parameter values are considered as complex numbers so the returned list may contain duplicate imaginary values if the corresponding real values differ. This function works even if isValid returns false", ret="Array of the imaginary part of the parameter values for pname", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUniquePvalsImag(@PrimitiveModelEntity.ParamDoc(name="pname", doc="Parameter name") String var1, @PrimitiveModelEntity.ParamDoc(name="solnums", doc="Array of index one based outer and inner solnums") int[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the SolverSequence associated with the given one-based outersolnum. This function works even if isValid returns false", ret="SolverSequence tag associated with the given outersolnum", type=PrimitiveModelEntity.MethodType.READ)
    public String getSolverSequence(@PrimitiveModelEntity.ParamDoc(name="solnums", doc="Index one based outer solution number") int var1);
}

