/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.FEATURE_STATUS;
import com.comsol.model.dbimodel.IFeatureListCreate;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SolverFeatureList;
import com.comsol.model.dbimodel.SolverProblemFeature;
import com.comsol.model.dbimodel.SolverProblemFeatureList;
import com.comsol.model.dbimodel.XMeshNative;
import com.comsol.model.dbimodel.XmeshInfo;

@PrimitiveModelEntity.TypeDoc(value="Solver feature")
public interface SolverFeature
extends IFeatureListCreate<SolverFeature>,
PropFeature {
    public FEATURE_STATUS getStatus();

    public void setStatus(FEATURE_STATUS var1);

    public XMeshNative getXmeshNative();

    public void setXmeshNative(XMeshNative var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns all solver features", ret="List of solver features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public SolverFeatureList<? extends PropFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Returns solver feature", ret="Solver feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public SolverFeature feature(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Solver feature tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Check for error in solver feature", ret="<code>true</code> if error", type=PrimitiveModelEntity.MethodType.READ)
    public boolean hasError();

    @PrimitiveModelEntity.MethodDoc(doc="Check for problem in solver feature", ret="<code>true</code> if problem", type=PrimitiveModelEntity.MethodType.READ)
    public boolean hasProblem();

    public boolean hasProblemFeature();

    @PrimitiveModelEntity.MethodDoc(doc="Check for warnings in solver feature", ret="<code>true</code> if warning", type=PrimitiveModelEntity.MethodType.READ)
    public boolean hasWarning();

    public boolean isBuilt();

    @PrimitiveModelEntity.MethodDoc(doc="Returns solver problem feature list", ret="List of solver problems", type=PrimitiveModelEntity.MethodType.ACCESS)
    public SolverProblemFeatureList<? extends SolverProblemFeature> problem();

    @PrimitiveModelEntity.MethodDoc(doc="Returns solver problem feature", ret="Solver problem feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public SolverProblemFeature problem(@PrimitiveModelEntity.ParamDoc(name="fname", doc="Solver problem feature tag") String var1);

    public void resetProblems();

    public void requestRedraw();

    public void clearSolution();

    public void clearSolutionData();

    @PrimitiveModelEntity.MethodDoc(doc="Check if matrix is is real", ret="<code>true</code> if matrix is real", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isReal(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns number of rows in matrix", ret="Number of rows", type=PrimitiveModelEntity.MethodType.READ)
    public int getM(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns number of columns in matrix", ret="Number of columns", type=PrimitiveModelEntity.MethodType.READ)
    public int getN(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get number of non-zeros in sparse matrix", ret="Number of non-zeros", type=PrimitiveModelEntity.MethodType.READ)
    public int getNnz(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns matrix values", ret="Matrix values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getSparseMatrixVal(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns column indices of matrix values", ret="Column indices", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getSparseMatrixCol(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns row indices of matrix values", ret="Row indices", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getSparseMatrixRow(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the real vector associated with the matrix type", ret="Vector representing real part", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[] getVector(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns imaginary matrix values", ret="Matrix values representing imaginary part", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[] getSparseMatrixValImag(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the imaginary part of the vector associated with the matrix type", ret="Vector representing imaginary part", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[] getVectorImag(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="A blocked version of getSparseMatrixVal. Returns matrix values", ret="Matrix values representing real part", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getSparseMatrixValBlock(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="A blocked version of getSparseMatrixCol. Returns column indices of matrix values", ret="Column indices", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getSparseMatrixColBlock(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="A blocked version of getSparseMatrixRow. Returns row indices of matrix values", ret="Row indices", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getSparseMatrixRowBlock(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="A blocked version of getVector. Returns the real vector associated with the matrix type", ret="Vector representing real part", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getVectorBlock(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="A blocked version of getVectorImag. Returns the imaginary part of the vector associated with the matrix type", ret="Vector representing imaginary part", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getSparseMatrixValImagBlock(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="A blocked version of getSparseMatrixValImag. Returns imaginary matrix values.", ret="Matrix values representing imaginary part", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getVectorImagBlock(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Returns extended mesh information", ret="Extended mesh information", type=PrimitiveModelEntity.MethodType.ACCESS)
    public XmeshInfo xmeshInfo();

    public XmeshInfo xmeshInfoNoInternalDofs();

    @PrimitiveModelEntity.MethodDoc(doc="Returns extended mesh information for a mesh case", ret="Extended mesh information", type=PrimitiveModelEntity.MethodType.ACCESS)
    public XmeshInfo xmeshInfo(@PrimitiveModelEntity.ParamDoc(name="meshCase", doc="Mesh case") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Clears the data created by xmeshInfo. Call to release memory after the required extended mesh information has been obtained.", ret="Solver feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public SolverFeature clearXmesh();

    public void meshextend(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Create a matrix", type=PrimitiveModelEntity.MethodType.WRITE)
    public void createSparseMatrix(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1, @PrimitiveModelEntity.ParamDoc(name="M", doc="Number of rows") int var2, @PrimitiveModelEntity.ParamDoc(name="N", doc="Number of columns") int var3, @PrimitiveModelEntity.ParamDoc(name="Nnz", doc="Number of non zeros") int var4, @PrimitiveModelEntity.ParamDoc(name="isReal", doc="<code>true</code> for real matrix") boolean var5);

    @PrimitiveModelEntity.MethodDoc(doc="Create a vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void createVector(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Vector name") String var1, @PrimitiveModelEntity.ParamDoc(name="M", doc="Vector length") int var2, @PrimitiveModelEntity.ParamDoc(name="isReal", doc="<code>true</code> for real vector - <code>false</code> for complex vector") boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Set real part of sparse matrix. Vectors are of length Nnz.", type=PrimitiveModelEntity.MethodType.WRITE)
    public void addSparseMatrixVal(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1, @PrimitiveModelEntity.ParamDoc(name="row", doc="Row index vector") int[] var2, @PrimitiveModelEntity.ParamDoc(name="col", doc="Column index vector") int[] var3, @PrimitiveModelEntity.ParamDoc(name="val", doc="Matrix values") double[] var4);

    @PrimitiveModelEntity.MethodDoc(doc="Set imaginary part of sparse matrix. Vectors are of length Nnz", type=PrimitiveModelEntity.MethodType.WRITE)
    public void addSparseMatrixValImag(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Matrix name") String var1, @PrimitiveModelEntity.ParamDoc(name="row", doc="Row index vector") int[] var2, @PrimitiveModelEntity.ParamDoc(name="col", doc="Column index vector") int[] var3, @PrimitiveModelEntity.ParamDoc(name="val", doc="Matrix values") double[] var4);

    @PrimitiveModelEntity.MethodDoc(doc="Set real part of vector. Vectors are of length M", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setVector(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Vector name") String var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Vector values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Set imaginary part of vector. Vectors are of length M", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setVectorImag(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Vector name.") String var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Vector values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Set real part of block in vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setVectorBlock(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Vector name") String var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Vector values") double[] var2, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Set imaginary part of block in vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setVectorImagBlock(@PrimitiveModelEntity.ParamDoc(name="mName", doc="Vector name") String var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Vector values") double[] var2, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var3);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Create a solver feature.", ret="Created solver feature.", type=PrimitiveModelEntity.MethodType.WRITE)
    public SolverFeature create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Feature tag.") String var1, @PrimitiveModelEntity.ParamDoc(name="oper", doc="Type of feature.") String var2);

    public void labelTouch();

    public boolean isResetStateKey();

    public void setResetStateKey(boolean var1);

    public boolean isMoving();
}

