/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.GeomSequenceWrapper;
import com.comsol.model.dbimodel.IListMove;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.View;
import com.comsol.model.definitions.IDefinitionsList;
import com.comsol.model.savepoint.interfaces.IGeomSequence;

@PrimitiveModelEntity.TypeDoc(value="List of views")
public interface ViewList<T extends View>
extends IListMove,
ModelEntityList<T>,
IDefinitionsList<View> {
    @PrimitiveModelEntity.MethodDoc(doc="Creates a view for a geometry", ret="Created view", type=PrimitiveModelEntity.MethodType.WRITE)
    public View create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="View tag") String var1, @PrimitiveModelEntity.ParamDoc(name="geom", doc="Geometry tag") String var2);

    public View create(String var1, String var2, boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a workplane view for a geometry", ret="Created view", type=PrimitiveModelEntity.MethodType.WRITE)
    public View create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="View tag") String var1, @PrimitiveModelEntity.ParamDoc(name="geom", doc="Geometry tag") String var2, @PrimitiveModelEntity.ParamDoc(name="workPlane", doc="Workplane tag") String var3);

    public View create(String var1, String var2, String var3, boolean var4);

    @PrimitiveModelEntity.MethodDoc(doc="Create a view for a dimension", ret="Created view", type=PrimitiveModelEntity.MethodType.WRITE)
    public View create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="View tag") String var1, @PrimitiveModelEntity.ParamDoc(name="viewdim", doc="View dimension") int var2);

    public View create(String var1, int var2, String var3);

    public View create(String var1, int var2, boolean var3);

    public View createInstance(String var1, String var2, GeomSequenceWrapper var3);

    public void internalAddFeature(View var1, String var2, int var3);

    public void createReset(ViewList var1, boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a copy of a view and inserts it to this list and assigns it to the given geometry. The dimension of the source view and the geometry must match.", ret="The new view", type=PrimitiveModelEntity.MethodType.WRITE)
    public View copyToGeometry(@PrimitiveModelEntity.ParamDoc(name="newTag", doc="The tag of the new view.") String var1, @PrimitiveModelEntity.ParamDoc(name="tag", doc="Tag of the view to copy.") String var2, @PrimitiveModelEntity.ParamDoc(name="geom", doc="Tag of geometry to assign copy to.") String var3);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a copy of a view and inserts it to this list and assigns it to the given work plane. The dimension of the source view must be 2.", ret="The new view", type=PrimitiveModelEntity.MethodType.WRITE)
    public View copyToWorkPlane(@PrimitiveModelEntity.ParamDoc(name="newTag", doc="The tag of the new view.") String var1, @PrimitiveModelEntity.ParamDoc(name="tag", doc="Tag of the view to copy.") String var2, @PrimitiveModelEntity.ParamDoc(name="geom", doc="Tag of geometry containing the work plane.") String var3, @PrimitiveModelEntity.ParamDoc(name="workPlane", doc="Tag of work plane.") String var4);

    public View getCurrentView(IGeomSequence var1);

    public void initLocalProperties();

    public void storeLocalProperties();

    public void lockViewCreationOrRemoval(boolean var1);
}

