/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel.physics;

import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.physics.FeatureInfo;
import com.comsol.model.dbimodel.physics.FeatureInfoList;

@PrimitiveModelEntity.TypeDoc(value="Interface for entities for entities that supports Equation View")
@PrimitiveModelEntity.PureInterface
public interface EquationViewParent {
    @PrimitiveModelEntity.MethodDoc(doc="Returns the variable and system of equation changes", ret="List of variable and system of equation changes", type=PrimitiveModelEntity.MethodType.ACCESS)
    default public FeatureInfoList<FeatureInfo> featureInfo() {
        return this.getFeatureInfo();
    }

    public FeatureInfoList<FeatureInfo> getFeatureInfo();

    default public boolean supportsEquationView() {
        return true;
    }

    @PrimitiveModelEntity.MethodDoc(doc="Returns a variable and system of equation changes object", ret="Variable and system of equation changes object", type=PrimitiveModelEntity.MethodType.ACCESS)
    default public FeatureInfo featureInfo(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Feature tag") String string) {
        if (this.supportsEquationView() && "info".equals(string) && !this.featureInfo().hasTag("info")) {
            FeatureInfo featureInfo = (FeatureInfo)this.featureInfo().create("info");
            featureInfo.addFlag(ModelEntity.Flags.NOREMOVE);
            featureInfo.addFlag(ModelEntity.Flags.NODEACTIVATE);
            return featureInfo;
        }
        FeatureInfoList<FeatureInfo> featureInfoList = this.featureInfo();
        return (FeatureInfo)featureInfoList.findObject(string, "feature_info");
    }

    public FeatureInfoList<? extends FeatureInfo> getFeatureInfoGen();
}

