/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbmodel;

import com.comsol.model.data.Node;
import com.comsol.model.dbimodel.Group;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.dbimodel.physics.PhysicsFeatureList;
import com.comsol.model.dbmodel.ModelDb;
import com.comsol.model.dbmodel.ModelDbUtil;
import com.comsol.model.dbmodel.ModelEntityDb;
import com.comsol.model.properties.AbstractModelEntityGetSetHandler;
import com.comsol.model.properties.ModelEntityPropSet;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.by;
import com.comsol.nativeutil.properties.dr;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlStringUtil;
import java.util.ArrayList;
import java.util.List;

public class GroupDb
extends ModelEntityDb
implements Group {
    protected GroupDb(Node node) {
        super(node);
    }

    @Override
    public String getType() {
        return (String)this.f.dGet("type");
    }

    public void setType(String string) {
        this.f.dSet("type", (Object)string);
    }

    @Override
    public String getIdentifier() {
        return (String)this.f.dGet("identifier");
    }

    public void setIdentifier(String string) {
        this.f.dSet("identifier", (Object)string);
    }

    @Override
    public String paramName() {
        return this.getIdentifier();
    }

    @Override
    public Group paramName(String string) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ModelDbUtil.MethodHandle methodHandle = ModelDbUtil.beginHistoryLog(this, string);){
            if (!FlStringUtil.checkValidTag((String)string)) {
                throw new FlException("X_is_not_a_valid_identifier#" + string);
            }
            for (Group group : this.getModel().group()) {
                if (group.equals(this) || !group.getIdentifier().equals(string)) continue;
                throw new FlException("Identifier_X_is_already_used_in_this_model#" + string);
            }
            this.setIdentifier(string);
            return methodHandle.completeLog(this);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String type() {
        return this.getType();
    }

    @Override
    public void createReset(Group group, boolean bl2) {
        this.createResetCommon(group, bl2);
        String string = this.paramName();
        if (!string.equals(group.paramName())) {
            group.paramName(string);
        }
    }

    @Override
    public String identifier() {
        return this.getIdentifier();
    }

    @Override
    public Group identifier(String string) {
        return this.paramName(string);
    }

    @Override
    protected String c() {
        return this.type().equals("LoadGroup") ? "group_loadgroup" : "group_constraintgroup";
    }

    @Override
    protected String doGetDefaultName() {
        if (this.getType().equals("LoadGroup")) {
            return "Load_group";
        }
        return "Constraint_group";
    }

    @Override
    public String accessGetIdentifier() {
        return this.paramName();
    }

    @Override
    public void accessSetIdentifier(String string) {
        this.paramName(string);
    }

    @Override
    public ModelEntity.IdentifierType getIdentifierType() {
        return ModelEntity.IdentifierType.PARAMETER;
    }

    private void a(List<String[]> list, boolean bl2) {
        if (!bl2 && this.getModel().isDisableUpdates()) {
            return;
        }
        ModelDb modelDb = this.getModel();
        modelDb.physics().forEach(physics -> {
            if (physics.isActive()) {
                GroupDb.a((Group)this, list, physics, physics.feature());
            }
        });
    }

    private static <T extends PhysicsFeature> void a(Group group, List<String[]> list, Physics physics, PhysicsFeatureList<T> physicsFeatureList) {
        physicsFeatureList.forEach(physicsFeature -> {
            if (physicsFeature.isActive()) {
                if (group.getType().equals("LoadGroup") && physicsFeature.getApplfeature().allowsLoadGrouping(physics.getApp())) {
                    GroupDb.addToGroup(group, list, physics, physicsFeature, "loadGroup");
                }
                if (group.getType().equals("ConstraintGroup") && physicsFeature.getApplfeature().allowsConstraintGrouping(physics.getApp())) {
                    GroupDb.addToGroup(group, list, physics, physicsFeature, "constraintGroup");
                }
                GroupDb.a(group, list, physics, physicsFeature.getFeature());
            }
        });
    }

    public static <T extends PhysicsFeature> void addToGroup(Group group, List<String[]> list, Physics physics, T t2, String string) {
        if (t2.hasParam(string)) {
            String string2 = t2.getString(string);
            if ("default".equals(string2)) {
                list.add(new String[]{"default_group.png", t2.getDisplayString(), physics.getDisplayString(), physics.model(), ModelEntityUtil.getEntityPath(t2)});
            } else if (group.tag().equals(string2)) {
                list.add(0, new String[]{Group.getIcon(group.getType()), t2.getDisplayString(), physics.getDisplayString(), physics.model(), ModelEntityUtil.getEntityPath(t2)});
            }
        }
    }

    @Override
    protected ModelEntityPropSet createEntityPropSet() {
        ModelEntityPropSet modelEntityPropSet = new ModelEntityPropSet(this, "statistics", "Group_members", true);
        modelEntityPropSet.setUnitConverter(this.getConverter());
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        this.a(arrayList, false);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[][] stringArray = (String[][])arrayList.toArray((T[])new String[0][]);
        this.setTmpProp(stringArray);
        arrayList2.add(this.a(modelEntityPropSet, stringArray));
        modelEntityPropSet.registerPropertyGroup("groupMembers", "Group_members", arrayList2.toArray(new String[0]), true);
        return modelEntityPropSet;
    }

    private String a(ModelEntityPropSet modelEntityPropSet, String[][] stringArray) {
        String string = "Group_members";
        dr dr2 = new dr("groupTable", string, stringArray);
        int[] nArray = new int[5];
        nArray[0] = 25;
        nArray[1] = 100;
        nArray[2] = 120;
        nArray[3] = 50;
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        PropAnnotationInfo.TableInfo tableInfo = new PropAnnotationInfo.TableInfo(new String[]{"", "Feature", "Interface", "Component[model]", ""}).b(150).e(nArray).d(new boolean[5]).f(blArray).h(new boolean[]{false, true, true, true, false}).e(new boolean[]{false, true, true, true, false}).bo().b("groupGoToSourceMemberAction").b("groupIncludeMemberAction").b("groupResetToDefaultAction").g(string);
        dr2.annotate().a(tableInfo);
        modelEntityPropSet.registerEntityProp((Property)dr2, (String)null, (by)new a((Property)dr2, this));
        return dr2.getName();
    }

    @Override
    public String[][] getTmpProp() {
        return (String[][])this.f.dGet("tmpProp");
    }

    @Override
    public void setTmpProp(String[][] stringArray) {
        if (!FlStringUtil.equals((String[][])this.getTmpProp(), (String[][])stringArray)) {
            this.f.dSet("tmpProp", (Object)stringArray);
        }
    }

    private static class a
    extends AbstractModelEntityGetSetHandler {
        private final Group a;
        private final Property b;

        public a(Property property, Group group) {
            super(null);
            this.b = property;
            this.a = group;
        }

        @Override
        public boolean isDataValid() {
            return true;
        }

        @Override
        public void setIndex(String string, int n2, int n3) {
            String[][] stringArray = this.a.getTmpProp();
            this.b.set(stringArray);
            this.b.setIndex(string, n2, n3);
            this.a.setTmpProp(this.b.getStringMatrix());
        }

        @Override
        public String[][] getStringMatrix() {
            return this.a.getTmpProp();
        }
    }
}

