/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbmodel;

import com.comsol.model.data.Node;
import com.comsol.model.data.events.IEventHandler;
import com.comsol.model.data.events.NODE_EVENT_TYPES;
import com.comsol.model.data.events.NodeEvent;
import com.comsol.model.dbimodel.FrameType;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.LocalSelection;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.Pair;
import com.comsol.model.dbimodel.PairList;
import com.comsol.model.dbmodel.ModelDb;
import com.comsol.model.dbmodel.ModelDbUtil;
import com.comsol.model.dbmodel.ModelEntityListDb;
import com.comsol.model.dbmodel.PairDb;
import com.comsol.model.definitions.IDefinitionsInfo;
import com.comsol.model.definitions.PairDefinitions;
import com.comsol.model.method.PairListMethod;
import com.comsol.model.method.PairMethod;
import com.comsol.model.method.internal.ISelectionInternal;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.util.ReInitInfo;
import com.comsol.util.exceptions.FlException;

public class PairListDb
extends ModelEntityListDb<PairDb>
implements IEventHandler,
PairList<PairDb> {
    protected PairListDb(Node node) {
        super(node);
    }

    @Override
    public PairListMethod<PairDb> method() {
        return (PairListMethod)this.r();
    }

    @Override
    public PairDb create(String string, String string2, String string3) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ModelDbUtil.MethodHandle methodHandle = ModelDbUtil.beginHistoryLog(this, string, string2, string3);){
            PairDb pairDb = this.a(string, string2, string3);
            return methodHandle.completeLog(pairDb);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    PairDb a(String string, String string2, String string3) {
        GeomSequence geomSequence = this.getModel().geom(string3);
        return this.a(string, string2, string3, geomSequence.getSDim() - 1);
    }

    @Override
    public PairDb create(String string, String string2, String string3, int n2) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (ModelDbUtil.MethodHandle methodHandle = ModelDbUtil.beginHistoryLog(this, string, string2, string3, n2);){
            PairDb pairDb = this.a(string, string2, string3, n2);
            return methodHandle.completeLog(pairDb);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    PairDb a(String string, String string2, String string3, int n2) {
        this.checkContains(string);
        if (!string2.equals("Identity") && !string2.equals("Contact")) {
            throw new FlException("Pair_type_must_be_Identity_or_Contact");
        }
        Node node = this.f.createChild(string, "Pair");
        PairDb pairDb = (PairDb)node.getObjectEntity();
        pairDb.tag(string);
        pairDb.setType(string2);
        pairDb.pairName(string);
        pairDb.setSrcFrame(FrameType.spatial.toString());
        pairDb.setDstFrame(FrameType.spatial.toString());
        pairDb.setMapping("deformed");
        pairDb.setSearchMethod("fast");
        pairDb.setManualDist(false);
        pairDb.setSearchDist("1e-2");
        pairDb.setSearchTol("1e-4");
        this.updateAllTags(string);
        try {
            ISelectionFilter iSelectionFilter = PairMethod.getSelectionFilter(this.getModel().geom(string3), n2);
            LocalSelection localSelection = pairDb.source();
            localSelection.setSelectionFilter(iSelectionFilter);
            ((ISelectionInternal)((Object)localSelection)).initializeSelection();
            LocalSelection localSelection2 = pairDb.destination();
            localSelection2.setSelectionFilter(iSelectionFilter);
            ((ISelectionInternal)((Object)localSelection2)).initializeSelection();
            pairDb.initialize();
        }
        catch (FlException flException) {
            this.method().remove(pairDb.tag());
            throw flException;
        }
        pairDb.getNode().sendInitializedEvent();
        return pairDb;
    }

    @Override
    public void doInitialize() {
        this.g();
    }

    @Override
    public void reInitializeThis(ReInitInfo reInitInfo) {
        if (!reInitInfo.isPasting()) {
            this.g();
        }
    }

    private void g() {
        ModelDb modelDb = this.getModel();
        this.f.getRoot().getEventManager().addEventHandler(false, modelDb.geom().getNode(), "CleanUp", (IEventHandler)this, NODE_EVENT_TYPES.REMOVE, false, false, new String[0]);
    }

    @Override
    protected void a(NodeEvent nodeEvent) {
        if ("CleanUp".equals(nodeEvent.getTag())) {
            String string = nodeEvent.getEntity().getTag();
            ((PairListMethod)this.method()).removePairs(string);
        }
    }

    @Override
    public void move(String string, int n2) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ModelDbUtil.MethodHandle methodHandle = ModelDbUtil.beginHistoryLog(this, string, n2);){
            this.a(string, n2, "pair");
            methodHandle.completeLog();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected PairDb a(String string, String string2) {
        PairDb pairDb = (PairDb)this.get(string2);
        PairDb pairDb2 = this.create(string, pairDb.getType(), pairDb.destination().geom(), pairDb.destination().getDim());
        try {
            pairDb.createDuplicate(pairDb2);
        }
        catch (RuntimeException runtimeException) {
            this.remove(string);
            throw runtimeException;
        }
        return pairDb2;
    }

    protected PairDb b(String string, String string2) {
        PairDb pairDb = this.a(string, string2);
        pairDb.getNode().sendInitializedEvent();
        return pairDb;
    }

    protected PairDb c(String string, String string2, String string3) {
        PairDb pairDb = this.a(string, string2);
        pairDb.getNode().sendInitializedEvent();
        return pairDb;
    }

    @Override
    public void createReset(PairList pairList, boolean bl2) {
        ((PairListMethod)this.method()).createReset(pairList, bl2);
    }

    @Override
    protected String c() {
        return "PairList";
    }

    @Override
    public IDefinitionsInfo<Pair> getDefinitionsInfo() {
        return new PairDefinitions();
    }

    @Override
    protected /* synthetic */ ModelEntity doDuplicate(String string, String string2) {
        return this.a(string, string2);
    }

    @Override
    protected /* synthetic */ ModelEntity b(String string, String string2, String string3) {
        return this.c(string, string2, string3);
    }

    @Override
    protected /* synthetic */ ModelEntity c(String string, String string2) {
        return this.b(string, string2);
    }
}

