/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.history;

import com.comsol.model.dbimodel.EVAL;
import com.comsol.model.history.ExportBackend;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.FlVersion;
import com.comsol.util.interfaces.m;
import com.comsol.util.methods.FlStringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatlabBackend
extends ExportBackend {
    private int h;
    private boolean i = false;
    private static String j = "out";
    private static final Pattern k = Pattern.compile("[^.]+\\.(component(\\([^)]+\\))?\\.)?([^.(]+)[.(].*", 32);

    @Override
    public void init(File file, String string) throws IOException {
        this.c = FileManagerUtil.l((String)string, (String)m.a);
        this.d = FileManagerUtil.k((String)string, (String)m.a);
        this.a = new BufferedWriter(new FileWriter(file));
    }

    @Override
    public String getLanguage() {
        return "MATLAB";
    }

    @Override
    public boolean supportsArrayInitialization() {
        return true;
    }

    @Override
    public boolean supportsVarArgsMethodCalls() {
        return false;
    }

    @Override
    public void createModel(String string) throws IOException {
        this.startLine();
        this.a.write(String.valueOf(string) + " = ModelUtil.create('Model');" + this.g);
        this.b = string;
    }

    @Override
    public void startLine() {
        this.e.setLength(0);
        this.i = false;
    }

    private static String a(String string) {
        if (string == null) {
            return "";
        }
        Matcher matcher = k.matcher(string);
        if (!matcher.matches()) {
            return "";
        }
        return matcher.group(3);
    }

    @Override
    public void endLine(boolean bl2) throws IOException {
        if (bl2) {
            this.e.append(";");
        }
        this.e.append(this.g);
        String string = this.e.toString();
        String string2 = MatlabBackend.a(string);
        String string3 = MatlabBackend.a(this.f);
        if (string2.isEmpty() || string3.isEmpty() || !string2.equals(string3)) {
            this.a.write(this.g);
        }
        this.f = string;
        this.a.write(string);
    }

    @Override
    public String getLine() {
        return this.e.toString();
    }

    @Override
    public void addComment(String string) throws IOException {
        this.a.write("% " + string + this.g);
    }

    @Override
    public void startComment() {
        String string = this.e.toString();
        this.e.setLength(0);
        this.e.append("% ");
        this.e.append(string);
        this.i = true;
    }

    @Override
    public void writeOmittedArguments() {
        this.e.append("arguments omitted");
    }

    @Override
    public void writeVar(String string) {
        this.e.append(string);
    }

    @Override
    public void writeFieldAccess() {
        this.e.append('.');
    }

    @Override
    public void writeArgumentSeparator() {
        this.e.append(", ");
    }

    @Override
    public void writeNullValue() {
        this.e.append("[]");
    }

    @Override
    public void writeNullStringValue() {
        this.writeNullValue();
    }

    @Override
    public void writeValue(boolean bl2) {
        this.e.append(Boolean.toString(bl2));
    }

    @Override
    public void writeValue(boolean[] blArray) {
        this.a(blArray, true);
    }

    private void a(boolean[] blArray, boolean bl2) {
        if (blArray == null) {
            this.writeNullValue();
        } else {
            if (bl2) {
                this.e.append('[');
            }
            boolean bl3 = true;
            boolean[] blArray2 = blArray;
            int n2 = blArray.length;
            int n3 = 0;
            while (n3 < n2) {
                boolean bl4 = blArray2[n3];
                if (!bl3) {
                    this.e.append(' ');
                }
                bl3 = false;
                this.writeValue(bl4);
                ++n3;
            }
            if (bl2) {
                this.e.append(']');
            }
        }
    }

    @Override
    public void writeValue(boolean[][] blArray) {
        if (blArray == null) {
            this.writeNullValue();
        } else {
            int n2;
            boolean bl2;
            if (blArray.length > 0) {
                bl2 = false;
                int n3 = blArray[0].length;
                int n4 = 1;
                while (n4 < blArray.length) {
                    bl2 = bl2 || blArray[n4].length != n3;
                    n3 = Math.max(blArray[n4].length, n3);
                    ++n4;
                }
                if (bl2) {
                    boolean[][] blArray2 = new boolean[blArray.length][n3];
                    n2 = 0;
                    while (n2 < blArray.length) {
                        System.arraycopy(blArray[n2], 0, blArray2[n2], 0, blArray[n2].length);
                        ++n2;
                    }
                    blArray = blArray2;
                }
            }
            this.e.append("[");
            bl2 = true;
            boolean[][] blArray3 = blArray;
            n2 = blArray.length;
            int n5 = 0;
            while (n5 < n2) {
                boolean[] blArray4 = blArray3[n5];
                if (!bl2) {
                    this.e.append("; ");
                }
                bl2 = false;
                this.a(blArray4, false);
                ++n5;
            }
            this.e.append("]");
        }
    }

    @Override
    public void writeValue(double d2) {
        int n2 = (int)d2;
        if ((double)n2 == d2) {
            this.writeValue(n2);
        } else if (Double.isNaN(d2)) {
            this.e.append("NaN");
        } else if (d2 == Double.POSITIVE_INFINITY) {
            this.e.append("Inf");
        } else if (d2 == Double.NEGATIVE_INFINITY) {
            this.e.append("-Inf");
        } else {
            this.e.append(Double.toString(d2));
        }
    }

    private void a(double[] dArray, boolean bl2) {
        if (dArray == null) {
            this.writeNullValue();
        } else {
            if (bl2) {
                this.e.append('[');
            }
            boolean bl3 = true;
            double[] dArray2 = dArray;
            int n2 = dArray.length;
            int n3 = 0;
            while (n3 < n2) {
                double d2 = dArray2[n3];
                if (!bl3) {
                    this.e.append(' ');
                }
                bl3 = false;
                this.writeValue(d2);
                ++n3;
            }
            if (bl2) {
                this.e.append(']');
            }
        }
    }

    @Override
    public void writeValue(double[] dArray) {
        if (dArray == null) {
            this.writeNullValue();
        } else if (dArray.length == 0) {
            this.e.append("''");
        } else {
            this.a(dArray, true);
        }
    }

    @Override
    public void writeValue(double[][] dArray) {
        if (dArray == null) {
            this.writeNullValue();
        } else {
            int n2;
            boolean bl2;
            if (dArray.length > 0) {
                bl2 = false;
                int n3 = dArray[0].length;
                int n4 = 1;
                while (n4 < dArray.length) {
                    bl2 = bl2 || dArray[n4].length != n3;
                    n3 = Math.max(dArray[n4].length, n3);
                    ++n4;
                }
                if (bl2) {
                    double[][] dArray2 = new double[dArray.length][n3];
                    n2 = 0;
                    while (n2 < dArray.length) {
                        System.arraycopy(dArray[n2], 0, dArray2[n2], 0, dArray[n2].length);
                        ++n2;
                    }
                    dArray = dArray2;
                }
            }
            this.e.append("[");
            bl2 = true;
            double[][] dArray3 = dArray;
            n2 = dArray.length;
            int n5 = 0;
            while (n5 < n2) {
                double[] dArray4 = dArray3[n5];
                if (!bl2) {
                    this.e.append("; ");
                }
                bl2 = false;
                this.a(dArray4, false);
                ++n5;
            }
            this.e.append("]");
        }
    }

    @Override
    public void writeValue(int n2) {
        this.e.append(Integer.toString(n2));
    }

    @Override
    public void writeValue(int[] nArray) {
        this.a(nArray, true);
    }

    private void a(int[] nArray, boolean bl2) {
        if (nArray == null) {
            this.writeNullValue();
        } else {
            if (bl2) {
                this.e.append('[');
            }
            boolean bl3 = true;
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                if (!bl3) {
                    this.e.append(' ');
                }
                bl3 = false;
                this.writeValue(n4);
                ++n3;
            }
            if (bl2) {
                this.e.append(']');
            }
        }
    }

    @Override
    public void writeValue(int[][] nArray) {
        if (nArray == null) {
            this.writeNullValue();
        } else {
            int n2;
            boolean bl2;
            if (nArray.length > 0) {
                bl2 = false;
                int n3 = nArray[0].length;
                int n4 = 1;
                while (n4 < nArray.length) {
                    bl2 = bl2 || nArray[n4].length != n3;
                    n3 = Math.max(nArray[n4].length, n3);
                    ++n4;
                }
                if (bl2) {
                    int[][] nArray2 = new int[nArray.length][n3];
                    n2 = 0;
                    while (n2 < nArray.length) {
                        System.arraycopy(nArray[n2], 0, nArray2[n2], 0, nArray[n2].length);
                        ++n2;
                    }
                    nArray = nArray2;
                }
            }
            this.e.append("[");
            bl2 = true;
            int[][] nArray3 = nArray;
            n2 = nArray.length;
            int n5 = 0;
            while (n5 < n2) {
                int[] nArray4 = nArray3[n5];
                if (!bl2) {
                    this.e.append("; ");
                }
                bl2 = false;
                this.a(nArray4, false);
                ++n5;
            }
            this.e.append("]");
        }
    }

    @Override
    public void writeValue(char c2) {
        this.writeValue(String.valueOf(c2));
    }

    @Override
    public void writeValue(String string) {
        if (string == null || string.length() == 0) {
            this.e.append("''");
        } else {
            int n2;
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < string.length()) {
                n2 = string.charAt(n3);
                if (n2 < 32 || n2 >= 128 && n2 != 10 && n2 != 13) {
                    bl2 = true;
                }
                ++n3;
            }
            if (bl2) {
                this.e.append('[');
                n3 = 0;
                n2 = 0;
                while (n2 < string.length()) {
                    char c2 = string.charAt(n2);
                    if (c2 < ' ' || c2 >= '\u0080') {
                        if (c2 == '\n' || c2 == '\r') {
                            if (n3 == 0) {
                                this.e.append('\'');
                                n3 = 1;
                            }
                            if (c2 == '\n') {
                                this.e.append("\\n");
                            } else {
                                this.e.append("\\r");
                            }
                        } else {
                            if (n3 != 0) {
                                this.e.append('\'');
                                n3 = 0;
                            }
                            if (n2 > 0) {
                                this.e.append(' ');
                            }
                            if (c2 == '\u2126' || c2 == '\u03a9') {
                                this.e.append("'ohm' ");
                            } else {
                                String string2 = FlStringUtil.padLeft((String)Integer.toHexString(c2), (char)'0', (int)4);
                                this.e.append("native2unicode(hex2dec({'").append(string2.substring(0, 2)).append("' '").append(string2.substring(2, 4)).append("'}), 'unicode') ");
                            }
                        }
                    } else {
                        if (n3 == 0) {
                            this.e.append('\'');
                            n3 = 1;
                        }
                        if (c2 == '\'') {
                            this.e.append(c2);
                        }
                        this.e.append(c2);
                    }
                    ++n2;
                }
                if (n3 != 0) {
                    this.e.append('\'');
                }
                this.e.append(']');
            } else {
                this.e.append('\'');
                n3 = 0;
                while (n3 < string.length()) {
                    n2 = string.charAt(n3);
                    if (n2 < 32 || n2 >= 128) {
                        if (n2 == 10) {
                            this.e.append("\\n");
                        } else {
                            this.e.append("\\r");
                        }
                    } else {
                        if (n2 == 39) {
                            this.e.append((char)n2);
                        }
                        this.e.append((char)n2);
                    }
                    ++n3;
                }
                this.e.append('\'');
            }
        }
    }

    private void a(String[] stringArray, boolean bl2) {
        if (stringArray == null) {
            this.writeNullValue();
        } else {
            if (bl2) {
                this.e.append("{");
            }
            boolean bl3 = true;
            int n2 = 0;
            String[] stringArray2 = stringArray;
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray2[n4];
                if (!bl3) {
                    this.e.append(" ");
                }
                if (n2 == 10) {
                    n2 = 0;
                    this.e.append(" ..." + this.g);
                    if (this.i) {
                        this.e.append("% ");
                    }
                }
                bl3 = false;
                this.writeValue(string);
                ++n2;
                ++n4;
            }
            if (bl2) {
                this.e.append("}");
            }
        }
    }

    @Override
    public void writeValue(String[] stringArray) {
        this.a(stringArray, true);
    }

    @Override
    public void writeValue(String[][] stringArray) {
        if (stringArray == null) {
            this.writeNullValue();
        } else {
            int n2;
            int n3;
            boolean bl2;
            if (stringArray.length > 0) {
                bl2 = false;
                n3 = stringArray[0].length;
                int n4 = 1;
                while (n4 < stringArray.length) {
                    bl2 = bl2 || stringArray[n4].length != n3;
                    n3 = Math.max(stringArray[n4].length, n3);
                    ++n4;
                }
                if (bl2) {
                    String[][] stringArray2 = new String[stringArray.length][n3];
                    n2 = 0;
                    while (n2 < stringArray.length) {
                        System.arraycopy(stringArray[n2], 0, stringArray2[n2], 0, stringArray[n2].length);
                        ++n2;
                    }
                    stringArray = stringArray2;
                }
            }
            this.e.append("{");
            bl2 = true;
            n3 = 0;
            String[][] stringArray3 = stringArray;
            int n5 = stringArray.length;
            n2 = 0;
            while (n2 < n5) {
                String[] stringArray4 = stringArray3[n2];
                if (stringArray4 != null) {
                    n3 += stringArray4.length;
                }
                ++n2;
            }
            stringArray3 = stringArray;
            n5 = stringArray.length;
            n2 = 0;
            while (n2 < n5) {
                String[] stringArray5 = stringArray3[n2];
                if (!bl2) {
                    this.e.append("; ");
                    if (n3 > 10) {
                        this.e.append(" ..." + this.g);
                        if (this.i) {
                            this.e.append("% ");
                        }
                    }
                }
                bl2 = false;
                this.a(stringArray5, false);
                ++n2;
            }
            this.e.append("}");
        }
    }

    @Override
    public void writeValue(EVAL[] eVALArray) {
        if (eVALArray == null) {
            this.writeNullValue();
        } else {
            this.e.append("{");
            boolean bl2 = true;
            EVAL[] eVALArray2 = eVALArray;
            int n2 = eVALArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EVAL eVAL = eVALArray2[n3];
                if (!bl2) {
                    this.e.append(", ");
                }
                bl2 = false;
                this.e.append("EVAL." + eVAL.name());
                ++n3;
            }
            this.e.append("}");
        }
    }

    @Override
    public void writeVoidCallPrefix() {
    }

    @Override
    public void declareVariable(String string, boolean[] blArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareVariable(String string, boolean[][] blArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareVariable(String string, double[] dArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareVariable(String string, double[][] dArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareVariable(String string, int[] nArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareVariable(String string, int[][] nArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareVariable(String string, String[] stringArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareVariable(String string, String[][] stringArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareVariable(String string, EVAL[] eVALArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startMethodCall(String string, int n2) {
        this.h = n2;
        this.e.append(string);
        if (n2 > 0) {
            this.e.append('(');
        }
    }

    @Override
    public void startMethodCall(Class clazz, String string, int n2) {
        this.startMethodCall(string, n2);
    }

    @Override
    public void endMethodCall() {
        if (this.h > 0) {
            this.e.append(')');
        }
    }

    @Override
    public void writeHeader(String string) throws IOException {
        String string2 = this.getFileName();
        this.a.write("function " + j + " = model" + this.g);
        this.a.write("%" + this.g);
        this.a.write("% " + string2 + this.g);
        this.a.write("%" + this.g);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d yyyy, HH:mm", Locale.US);
        this.a.write("% Model exported on " + simpleDateFormat.format(new Date()) + " by " + FlVersion.currentVersion().getFullName() + "." + this.g);
        if (string != null) {
            this.a.write("% Author: " + string + this.g);
        }
        this.a.write(this.g);
        this.a.write("import com.comsol.model.*" + this.g);
        this.a.write("import com.comsol.model.util.*" + this.g);
        this.a.write(this.g);
    }

    @Override
    public void writeFooter() throws IOException {
        if (!j.equals(this.b)) {
            this.a.write(String.valueOf(this.g) + j + " = " + this.b + ";" + this.g);
        }
    }

    @Override
    public void close() throws IOException {
        this.a.close();
    }

    @Override
    public String getParentFilePath() {
        return this.c;
    }

    @Override
    public String getFileName() {
        return this.d;
    }
}

