/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.impl.events;

import com.comsol.model.data.events.NODE_EVENT_TYPES;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropValue;
import com.comsol.model.impl.events.AbstractPropFeatureEventHandlerInitializer;
import com.comsol.model.impl.events.PropFeatureEventHandlerFactory;
import com.comsol.model.operations.ReferenceArrayPropCheck;
import com.comsol.model.util.EventManagerWrapper;
import com.comsol.model.util.MetaModelUtil;
import com.comsol.model.util.ReInitInfo;
import com.comsol.nativeutil.properties.Property;
import java.util.HashSet;

public class ReferenceArrayPropInitializer
extends AbstractPropFeatureEventHandlerInitializer {
    @Override
    public void doInitialize(PropFeature propFeature, Property property, EventManagerWrapper eventManagerWrapper) {
        this.addPropEventHandler(propFeature, property, eventManagerWrapper);
        ReferenceArrayPropCheck referenceArrayPropCheck = (ReferenceArrayPropCheck)property.getCheck();
        propFeature.set(property.getName(), referenceArrayPropCheck.getDefaultValue());
    }

    @Override
    public void reInitialize(PropFeature propFeature, PropValue propValue, Property property, EventManagerWrapper eventManagerWrapper, ReInitInfo reInitInfo) {
        if (reInitInfo.isPasting()) {
            return;
        }
        this.addPropEventHandler(propFeature, property, eventManagerWrapper);
        String string = String.valueOf(PropFeatureEventHandlerFactory.Tag.reference_array_prop_.name()) + property.getName();
        HashSet<ModelEntity> hashSet = new HashSet<ModelEntity>();
        for (ModelEntity modelEntity : propValue.getReferenceArray()) {
            if (hashSet.contains(modelEntity)) continue;
            eventManagerWrapper.addEntityEventHandler(modelEntity, string, propFeature, NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
            hashSet.add(modelEntity);
        }
    }

    private void addPropEventHandler(PropFeature propFeature, Property property, EventManagerWrapper eventManagerWrapper) {
        String string = property.getName();
        eventManagerWrapper.addPropertyEventHandler(propFeature, String.valueOf(PropFeatureEventHandlerFactory.Tag.reference_array_prop_.name()) + string, propFeature, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, string);
        ReferenceArrayPropCheck referenceArrayPropCheck = (ReferenceArrayPropCheck)property.getCheck();
        this.changeListHandlers(propFeature, property, null, referenceArrayPropCheck.resolveEntityList(), eventManagerWrapper);
    }

    @Override
    public void changeListHandlers(PropFeature propFeature, Property property, ModelEntityList<?> modelEntityList, ModelEntityList<?> modelEntityList2, EventManagerWrapper eventManagerWrapper) {
        String string = property.getName();
        if (modelEntityList != null) {
            eventManagerWrapper.removeListEventHandler(modelEntityList, String.valueOf(PropFeatureEventHandlerFactory.Tag.reference_array_prop_.name()) + string, propFeature, NODE_EVENT_TYPES.ANYCHILD, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
            eventManagerWrapper.removeEntityEventHandler(modelEntityList, String.valueOf(PropFeatureEventHandlerFactory.Tag.reference_array_prop_.name()) + string, propFeature, NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
        }
        if (modelEntityList2 != null && modelEntityList2.isInModel()) {
            eventManagerWrapper.addListEventHandler(modelEntityList2, String.valueOf(PropFeatureEventHandlerFactory.Tag.reference_array_prop_.name()) + string, propFeature, NODE_EVENT_TYPES.ANYCHILD, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
            eventManagerWrapper.addEntityEventHandler(modelEntityList2, String.valueOf(PropFeatureEventHandlerFactory.Tag.reference_array_prop_.name()) + string, propFeature, NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
        }
    }

    @Override
    public void updateSavePointModel(PropFeature propFeature, PropValue propValue, Property property) {
    }
}

