/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.dbimodel.Model;
import com.comsol.model.matlib.JahmMaterialLibrary;
import com.comsol.model.matlib.MaterialGroupNode;
import com.comsol.model.matlib.MaterialLibrary;
import com.comsol.model.matlib.MaterialLibraryManagerListener;
import com.comsol.model.matlib.MaterialNode;
import com.comsol.model.matlib.MphMaterialLibrary;
import com.comsol.model.matlib.RecentMaterialLibrary;
import com.comsol.model.matlib.XML3XMaterialLibrary;
import com.comsol.model.util.LocalModel;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.FlFileTypes;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.m;
import com.comsol.util.license.LicenseType;
import com.comsol.util.license.d;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.FlStringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class MaterialLibraryManager {
    private static MaterialLibraryManager a;
    private static Set<String> b;
    private final ExecutorService c = Executors.newSingleThreadExecutor();
    private final List<MaterialLibraryManagerListener> d = new CopyOnWriteArrayList<MaterialLibraryManagerListener>();
    private final Map<String, MaterialLibrary> e = new HashMap<String, MaterialLibrary>();
    private final Set<MaterialLibrary> f = new TreeSet<MaterialLibrary>(new a());
    private final Set<MaterialLibrary> g = new TreeSet<MaterialLibrary>(new a());
    private RecentMaterialLibrary h = null;
    private final List<Exception> i = new ArrayList<Exception>();

    static {
        b = new HashSet<String>();
        b.add("comsol_acdc_lib.mph");
        b.add("bfc_lib.mph");
        b.add("bioheat_lib.mph");
        b.add("building_lib.mph");
        b.add("eqdis_lib.mph");
        b.add("comsol_fluids_lib.mph");
        b.add("jahm.bin");
        b.add("comsol_mems_lib.mph");
        b.add("comsol_basic_material_lib.mph");
        b.add("comsol_optical_lib.mph");
        b.add("comsol_piezo_lib.mph");
        b.add("piezor_lib.mph");
        b.add("rf_lib.mph");
        b.add("semi_lib.mph");
        b.add("thermoelectric_lib.mph");
        b.add("magnetic_lib.mph");
        b.add("User_Defined_Library.mph");
    }

    public static final MaterialLibraryManager getInstance() {
        if (a == null) {
            a = new MaterialLibraryManager();
        }
        return a;
    }

    private MaterialLibraryManager() {
        String[] stringArray;
        this.h = new RecentMaterialLibrary();
        String[] stringArray2 = new String[]{"jahm.bin"};
        FlFileTypes.Type[] typeArray = new FlFileTypes.Type[]{FlFileTypes.Type.s, FlFileTypes.Type.au};
        this.a(this.getMatlibFolderName(), stringArray2, typeArray);
        this.b();
        String[] stringArray3 = stringArray = Preferences.getInstance().getStringArrayPreference("materiallibraries.libraries.userlibraries");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray3[n3];
            try {
                String string2 = FileManagerUtil.b((String)string);
                if (!FileManagerUtil.a((String)string2, (String)m.a)) {
                    throw new FlException("Material_library_was_not_found");
                }
                String string3 = FileManagerUtil.k((String)string2, (String)m.a);
                this.a(string2, this.g, b.contains(string3), false, false);
            }
            catch (Exception exception) {
                this.i.add((Exception)((Object)new FlException("Failed_to_load_library_X#" + string, (Throwable)exception)));
            }
            ++n3;
        }
        this.c();
    }

    private void a(String string, String[] stringArray, FlFileTypes.Type[] typeArray) {
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = FlFileUtil.a((String)string, (boolean)false, (boolean)true, (String[])stringArray, (FlFileTypes.Type[])typeArray);
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray3[n3];
            String string3 = FlStringUtil.getFileName((File)new File(string2), (boolean)false);
            try {
                this.a(string2, this.f, b.contains(string3), true, true);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                this.i.add((Exception)((Object)new FlException("Failed_to_load_library_X#" + string3, (Throwable)exception)));
            }
            ++n3;
        }
    }

    public String getMatlibFolderName() {
        return String.valueOf(SystemUtil.getCsRoot()) + "/data";
    }

    private void b() {
        String string = FileManagerUtil.l((String)this.getDefaultUserLib(), (String)m.a);
        String string2 = FileManagerUtil.k((String)this.getDefaultUserLib(), (String)m.a);
        try {
            if (this.e.containsKey(this.getDefaultUserLib())) {
                return;
            }
            if (!FileManagerUtil.o((String)string, (String)m.a)) {
                FlException flException = new FlException("Failed_to_create_directory");
                flException.addParameterPair("Directory", string);
                throw flException;
            }
            if (!FileManagerUtil.a((String)this.getDefaultUserLib(), (String)m.a)) {
                Throwable throwable = null;
                Object var4_7 = null;
                try (LocalModel localModel = ModelInternalUtil.createLocalModel();){
                    Model model = localModel.getModel();
                    model.tag(FlStringUtil.subStringBeforeLast((String)string2, (String)"."));
                    ModelInternalUtil.saveMatLibModel(model, this.getDefaultUserLib());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.a(this.getDefaultUserLib(), this.f, true, false, false);
        }
        catch (Exception exception) {
            this.i.add((Exception)((Object)new FlException("Failed_to_load_library_X#" + this.getDefaultUserLib(), (Throwable)exception)));
        }
    }

    public String getDefaultUserLib() {
        return String.valueOf(SystemUtil.getClientSettingsDir()) + SystemUtil.getClientFileSeparator() + "materials" + SystemUtil.getClientFileSeparator() + "User_Defined_Library.mph";
    }

    public void addMaterialLibraryListener(MaterialLibraryManagerListener materialLibraryManagerListener) {
        this.d.add(materialLibraryManagerListener);
    }

    public void removeMaterialLibraryListener(MaterialLibraryManagerListener materialLibraryManagerListener) {
        this.d.remove(materialLibraryManagerListener);
    }

    private void a(MaterialLibrary materialLibrary) {
        for (MaterialLibraryManagerListener materialLibraryManagerListener : this.d) {
            materialLibraryManagerListener.libraryAdded(materialLibrary);
        }
    }

    private void b(MaterialLibrary materialLibrary) {
        for (MaterialLibraryManagerListener materialLibraryManagerListener : this.d) {
            materialLibraryManagerListener.libraryRemoved(materialLibrary);
        }
    }

    private void c(MaterialLibrary materialLibrary) {
        for (MaterialLibraryManagerListener materialLibraryManagerListener : this.d) {
            materialLibraryManagerListener.libraryReloaded(materialLibrary);
        }
    }

    public List<Exception> getInitErrors() {
        ArrayList<Exception> arrayList = new ArrayList<Exception>(this.i);
        this.i.clear();
        return arrayList;
    }

    public void updateJahmPresence() {
        MaterialLibrary materialLibrary = this.getLibrary("comsol_material_lib");
        boolean bl2 = com.comsol.util.license.d.a((LicenseType)LicenseType.MATLIB);
        if (materialLibrary != null && !bl2) {
            this.removeDefaultLibrary(materialLibrary.getFileName());
        } else if (materialLibrary == null && bl2) {
            try {
                this.a(String.valueOf(this.getMatlibFolderName()) + "/jahm.bin", this.f, true, true, true);
            }
            catch (IOException iOException) {
                throw new FlException((Throwable)iOException);
            }
        }
    }

    public List<MaterialNode> findMaterials(Map<String, String> map) {
        Object object;
        String string = map.get("library");
        MaterialLibraryManager.fixQueryConditions(map);
        ArrayList<MaterialLibrary> arrayList = new ArrayList<MaterialLibrary>(this.f.size() + this.g.size());
        if (string != null) {
            object = this.getLibrary(string);
            if (object == null) {
                throw new IllegalArgumentException("Library search criteria does not match any known library.");
            }
            arrayList.add((MaterialLibrary)object);
        } else {
            arrayList.add(this.h);
            arrayList.addAll(this.f);
            arrayList.addAll(this.g);
        }
        object = new ArrayList();
        for (MaterialLibrary materialLibrary : arrayList) {
            object.addAll(materialLibrary.findMaterials(map));
        }
        return object;
    }

    ExecutorService a() {
        return this.c;
    }

    public MaterialLibrary getLibrary(String string) {
        if (this.h.getName().equals(string)) {
            return this.h;
        }
        if (this.e.containsKey(string)) {
            return this.e.get(string);
        }
        for (MaterialLibrary materialLibrary : this.e.values()) {
            if (!materialLibrary.getName().equals(string)) continue;
            return materialLibrary;
        }
        return null;
    }

    public MaterialNode getMaterial(String string) {
        Object object;
        MaterialLibrary materialLibrary = null;
        MaterialGroupNode materialGroupNode = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        materialLibrary = this.getLibrary(string2);
        if (materialLibrary != null) {
            object = materialLibrary.getLoadState();
            if (object == MaterialGroupNode.LoadState.FAILED) {
                return null;
            }
            try {
                Future<?> future = materialLibrary.loadLibraryBackground();
                future.get();
            }
            catch (InterruptedException interruptedException) {
                throw new FlException((Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new FlException(executionException.getCause());
            }
        } else {
            return null;
        }
        if (materialLibrary instanceof RecentMaterialLibrary && stringTokenizer.hasMoreTokens()) {
            object = new StringBuilder();
            while (stringTokenizer.hasMoreTokens()) {
                if (((StringBuilder)object).length() > 0) {
                    ((StringBuilder)object).append('.');
                }
                ((StringBuilder)object).append(stringTokenizer.nextToken());
            }
            materialGroupNode = materialLibrary.getChild(((StringBuilder)object).toString());
        } else {
            materialGroupNode = materialLibrary;
            while (stringTokenizer.hasMoreTokens() && materialGroupNode != null) {
                string2 = stringTokenizer.nextToken();
                materialGroupNode = materialGroupNode.getChild(string2);
            }
        }
        if (materialGroupNode instanceof MaterialNode) {
            return (MaterialNode)materialGroupNode;
        }
        return null;
    }

    public List<MaterialLibrary> getLibraries() {
        ArrayList<MaterialLibrary> arrayList = new ArrayList<MaterialLibrary>(this.f.size() + this.g.size() + 1);
        arrayList.add(this.h);
        arrayList.addAll(this.f);
        arrayList.addAll(this.g);
        return arrayList;
    }

    public RecentMaterialLibrary getRecentMaterials() {
        return this.h;
    }

    public List<MaterialLibrary> getDefaultLibraries() {
        ArrayList<MaterialLibrary> arrayList = new ArrayList<MaterialLibrary>(this.f.size());
        arrayList.addAll(this.f);
        return arrayList;
    }

    public List<MaterialLibrary> getUserLibraries() {
        ArrayList<MaterialLibrary> arrayList = new ArrayList<MaterialLibrary>(this.g.size());
        arrayList.addAll(this.g);
        return arrayList;
    }

    public void newLibrary(final String string) {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Throwable throwable = null;
                Object var2_3 = null;
                try (LocalModel localModel = ModelInternalUtil.createLocalModel();){
                    Model model = localModel.getModel();
                    ModelInternalUtil.saveMatLibModel(model, string);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return null;
            }
        };
        try {
            this.c.submit(callable).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            FlException flException = new FlException("Error_reading_file");
            flException.addParameterPair("File", string);
            throw flException;
        }
        try {
            if (!FileManagerUtil.a((String)string, (String)m.a)) {
                throw new FlException("Material_library_X_was_not_found#" + string);
            }
            this.a(string, this.g, false, false, false);
            this.c();
        }
        catch (IOException iOException) {
            throw new FlException("Failed_to_load_library_X#" + string, (Throwable)iOException);
        }
    }

    public void importLibrary(String string) {
        try {
            if (!FileManagerUtil.a((String)string, (String)m.a)) {
                throw new FlException("Material_library_X_was_not_found#" + string);
            }
            this.a(string, this.g, false, false, false);
            this.c();
        }
        catch (IOException iOException) {
            throw new FlException("Failed_to_load_library_X#" + string, (Throwable)iOException);
        }
    }

    public void removeUserLibrary(String string) {
        this.a(string, this.g);
        this.c();
    }

    public void reloadLibrary(String string) {
        if (!this.e.containsKey(string)) {
            throw new IllegalArgumentException("There is no material library '" + string + "'.");
        }
        MaterialLibrary materialLibrary = this.e.get(string);
        MaterialGroupNode.LoadState loadState = materialLibrary.getLoadState();
        if (!loadState.doLoad()) {
            materialLibrary.clearLibrary();
            materialLibrary.e();
        }
        this.c(materialLibrary);
    }

    public void removeDefaultLibrary(String string) {
        this.a(string, this.f);
    }

    private void a(String string, Set<MaterialLibrary> set) {
        if (!this.e.containsKey(string)) {
            throw new IllegalArgumentException("There is no material library '" + string + "'.");
        }
        MaterialLibrary materialLibrary = this.e.get(string);
        if (!set.contains(materialLibrary)) {
            throw new IllegalArgumentException("There is no material library '" + string + "'.");
        }
        this.e.remove(string);
        set.remove(materialLibrary);
        this.b(materialLibrary);
        materialLibrary.dispose();
    }

    private void a(String string, Set<MaterialLibrary> set, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        Object object;
        MaterialLibrary materialLibrary;
        String string2;
        String string3 = string2 = bl4 ? FlStringUtil.getFileName((File)new File(string), (boolean)false) : FileManagerUtil.k((String)string, (String)m.a);
        if (FlFileUtil.e((String)string2).equalsIgnoreCase(".xml")) {
            materialLibrary = new XML3XMaterialLibrary(string, bl2, bl4);
        } else if (string2.equalsIgnoreCase("jahm.bin")) {
            if (!com.comsol.util.license.d.a((LicenseType)LicenseType.MATLIB)) {
                return;
            }
            materialLibrary = new JahmMaterialLibrary(string, bl2);
        } else if (FlFileUtil.e((String)string2).equalsIgnoreCase(".mph")) {
            if (bl4) {
                object = new File(string);
                if (SystemUtil.isReadOnly((File)object)) {
                    bl3 = true;
                }
            } else {
                bl3 = FileManagerUtil.f((String)string, (String)m.a);
            }
            materialLibrary = new MphMaterialLibrary(string, bl2, bl4);
            materialLibrary.a(bl3);
        } else {
            throw new IllegalArgumentException("Unknown_material_library_type");
        }
        if (this.e.containsKey(string)) {
            if (!SystemUtil.isRunningTest()) {
                throw new FlException("Material_library_X_already_exists#" + materialLibrary.getName());
            }
            return;
        }
        object = materialLibrary.getName();
        for (MaterialLibrary materialLibrary2 : this.e.values()) {
            if (!((String)object).equals(materialLibrary2.getName())) continue;
            throw new FlException("Material_library_X_already_exists#" + (String)object);
        }
        this.e.put(string, materialLibrary);
        set.add(materialLibrary);
        this.a(materialLibrary);
    }

    private void c() {
        String string = System.getProperty("file.separator");
        String string2 = String.valueOf(SystemUtil.getClientSettingsDir()) + string + "materials";
        String string3 = FileManagerUtil.a((String)string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MaterialLibrary materialLibrary : this.g) {
            String string4 = FileManagerUtil.a((String)materialLibrary.getFileName());
            if (string4.startsWith(string3)) continue;
            arrayList.add(string4);
        }
        Preferences.getInstance().setPreference("materiallibraries.libraries.userlibraries", arrayList.toArray(new String[arrayList.size()]));
        Preferences.getInstance().savePreferences();
    }

    public void scanPreferenceDir() {
        String[] stringArray;
        String string = String.valueOf(SystemUtil.getClientSettingsDir()) + "/materials";
        String string2 = FileManagerUtil.a((String)string);
        ArrayList<MaterialLibrary> arrayList = new ArrayList<MaterialLibrary>();
        for (MaterialLibrary stringArray2 : this.g) {
            String string3 = FileManagerUtil.a((String)stringArray2.getFileName());
            if (!string3.startsWith(string2) || FileManagerUtil.a((String)stringArray2.getFileName(), (String)m.a)) continue;
            arrayList.add(stringArray2);
        }
        for (MaterialLibrary materialLibrary : arrayList) {
            this.removeUserLibrary(materialLibrary.getFileName());
        }
        String[] stringArray2 = stringArray = FileManagerUtil.a((String)string, (String)m.a, (boolean)false, (boolean)true, null, null);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string4 = stringArray2[n3];
            if (this.getLibrary(string4) == null) {
                try {
                    this.importLibrary(string4);
                }
                catch (Exception exception) {}
            }
            ++n3;
        }
    }

    public static void fixQueryConditions(Map<String, String> map) {
        String string;
        String string2;
        String string3 = map.get("name");
        if (string3 != null) {
            string3 = string3.replace("\"", "");
            string3 = string3.replace("'", "");
            string3 = string3.replace("*", "");
            string3 = string3.replace("?", "");
            map.put("name", string3);
        }
        if ((string2 = map.get("uns")) != null) {
            string2 = string2.replace("*", "");
            string2 = string2.replace("?", "");
            map.put("uns", string2);
        }
        if ((string = map.get("din")) != null) {
            string = string.replace("*", "");
            string = string.replace("?", "");
            map.put("din", string);
        }
    }

    private static class a
    implements Comparator<MaterialLibrary> {
        private static final List<String> a = new ArrayList<String>();

        static {
            a.add("comsol_material_lib");
            a.add("comsol_basic_material_lib");
            a.add("comsol_acdc_lib");
            a.add("bfc_lib");
            a.add("bioheat_lib");
            a.add("building_lib");
            a.add("eqdis_lib");
            a.add("comsol_fluids_lib");
            a.add("comsol_mems_lib");
            a.add("magnetic_lib");
            a.add("comsol_optical_lib");
            a.add("comsol_piezo_lib");
            a.add("piezor_lib");
            a.add("rf_lib");
            a.add("semi_lib");
            a.add("thermoelectric_lib");
            a.add("User_Defined_Library");
        }

        private a() {
        }

        public int a(MaterialLibrary materialLibrary, MaterialLibrary materialLibrary2) {
            int n2 = a.indexOf(materialLibrary.getName());
            int n3 = a.indexOf(materialLibrary2.getName());
            if (n2 < 0 && n3 < 0) {
                return materialLibrary.getName().compareTo(materialLibrary2.getName());
            }
            if (n2 < 0) {
                return 1;
            }
            if (n3 < 0) {
                return -1;
            }
            return n2 - n3;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((MaterialLibrary)object, (MaterialLibrary)object2);
        }
    }
}

