/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.applapi.ApplAPIUtil;
import com.comsol.model.applapi.IPhysicalQuantity;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.LayeredShellData;
import com.comsol.model.applapi.MaterialDB;
import com.comsol.model.applapi.MaterialPropSychronizationRule;
import com.comsol.model.applapi.PhysicalQuantityManager;
import com.comsol.model.applapi.SimpleSelection;
import com.comsol.model.applapi.UnitConverter;
import com.comsol.model.applapi.VariableDataBase;
import com.comsol.model.dbimodel.CopiedPrimitiveObject;
import com.comsol.model.dbimodel.CopyPasteInfo;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.Information;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.dbimodel.MaterialList;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.ParamValue;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.model.dbimodel.Unit;
import com.comsol.model.matlib.LayeredShellPropID;
import com.comsol.model.matlib.MatLibMaterialModel;
import com.comsol.model.matlib.MaterialFunction;
import com.comsol.model.matlib.MaterialNode;
import com.comsol.model.matlib.MphMaterialNode;
import com.comsol.model.matlib.RecentMaterialNode;
import com.comsol.model.method.MaterialListMethod;
import com.comsol.model.operations.IFunctionOperation;
import com.comsol.model.operations.operationID.MaterialOperationID;
import com.comsol.model.param.ParamSpec;
import com.comsol.model.properties.AbstractModelEntityGetSetHandler;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.selections.SelectionFilterAdapter;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.model.util.MultiphysicsUtil;
import com.comsol.model.util.SelectionModelUtil;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.UnitCheck;
import com.comsol.nativeutil.properties.ay;
import com.comsol.nativeutil.properties.ba;
import com.comsol.nativeutil.properties.bf;
import com.comsol.nativeutil.properties.bx;
import com.comsol.nativeutil.properties.by;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.ds;
import com.comsol.nativeutil.properties.du;
import com.comsol.util.classes.CsBitSet;
import com.comsol.util.classes.exprparser.ExprParser;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.interfaces.u;
import com.comsol.util.interfaces.w;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.o;
import com.comsol.util.methods.q;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class MaterialUtil {
    public static final int icon = 0;
    public static final int descr = 1;
    public static final int varName = 2;
    public static final int value = 3;
    public static final int unit = 4;
    public static final int modelDescr = 5;
    public static final int modelName = 6;
    public static final int pName = 7;
    public static final int size = 8;
    public static final int ncolumns = 9;
    public static final String descr_prefix = "DESCR_PREFIX:";
    public static final String info_prefix = "INFO_PREFIX:";
    private static Pattern a = Pattern.compile("\\d+x\\d+");
    private static /* synthetic */ int[] b;

    public static Material addMaterialToModel(MaterialList<? extends Material> materialList, MaterialNode materialNode, String string, String string2) {
        Material material;
        if (materialNode instanceof RecentMaterialNode) {
            materialNode = ((RecentMaterialNode)materialNode).getActualMaterial();
        }
        if (materialNode instanceof MphMaterialNode) {
            MphMaterialNode mphMaterialNode = (MphMaterialNode)materialNode;
            Material material2 = mphMaterialNode.getLibrary().b(mphMaterialNode.getName());
            material = materialList.addCopy(material2, string2);
            material.set("groups", new String[0][]);
        } else {
            material = materialList.create(string, "Common", string2);
            String string3 = materialNode.getDescription();
            material.label(material.getUniqueName(string3));
            Map<String, String> map = materialNode.getMaterialInfo();
            for (Map.Entry<String, String> object : map.entrySet()) {
                ((Information)material.info().create(object.getKey())).body(object.getValue());
            }
            for (MatLibMaterialModel matLibMaterialModel : materialNode.getMaterialModels()) {
                MaterialModel materialModel = null;
                materialModel = matLibMaterialModel.getName().equals(MaterialDB.MatRes.def.name()) ? material.propertyGroup(matLibMaterialModel.getName()) : material.propertyGroup().create(matLibMaterialModel.getName(), matLibMaterialModel.getDescription());
                for (de de2 : matLibMaterialModel.getMaterialProperties()) {
                    String[] stringArray = de2.getStringArray("expression");
                    if (stringArray.length > 1) {
                        materialModel.set(de2.getName(), stringArray);
                        continue;
                    }
                    if (stringArray.length == 1) {
                        materialModel.set(de2.getName(), stringArray[0]);
                        continue;
                    }
                    materialModel.set(de2.getName(), "");
                }
                for (MaterialFunction materialFunction : matLibMaterialModel.getModelFunctions()) {
                    materialFunction.addToModel(materialModel.func());
                }
                for (de de3 : matLibMaterialModel.getModelInputs()) {
                    materialModel.addInput(de3.getName());
                }
            }
        }
        material.getOperation().setAppearance(material, materialNode.getAppearance());
        return material;
    }

    public static String[] getTableRow(MaterialModel materialModel, String string) {
        Object[] objectArray = new String[9];
        Arrays.fill(objectArray, "");
        ParamSpec paramSpec = materialModel.getSpec(string);
        MaterialModel materialModel2 = PhysicalQuantityManager.getApplMaterialModel(materialModel.tag());
        boolean bl2 = materialModel.hasParam(string) && !materialModel.isOutput(string);
        objectArray[3] = MaterialUtil.a(materialModel, string, paramSpec);
        objectArray[5] = bl2 ? FlLocale.getString((String)"Local_properties") : (materialModel2 != null ? materialModel2.label() : materialModel.label());
        int n2 = 1;
        if (materialModel.getOperation().hasParam(materialModel, string, false)) {
            n2 = materialModel.hasParam(string) ? materialModel.getStringArray(string).length : 1;
        }
        objectArray[2] = MaterialUtil.paramToString(MaterialUtil.getVariableName(string, paramSpec), n2, paramSpec.getDims(1));
        objectArray[1] = bl2 && "".equals(materialModel.descr(string)) ? String.valueOf(FlLocale.getString((String)"Local_property")) + " " + (String)objectArray[2] : materialModel.descr(string);
        objectArray[7] = string;
        objectArray[6] = materialModel.tag();
        objectArray[4] = MaterialUtil.a((ModelEntity)materialModel, (String)objectArray[3], paramSpec);
        objectArray[8] = MaterialUtil.b(n2, paramSpec);
        return objectArray;
    }

    public static void checkAndSetValid(Material material) {
        Object object;
        Model model = material.getModel();
        if (model.isDisableUpdates()) {
            return;
        }
        if (material.hasSelection() && material.getSelectionGen() != null && (object = (GeomSequence)material.getSelectionGen().getGeomSequence()) != null && (!object.isInModel() || object.isDoingAssocUpdate())) {
            return;
        }
        object = null;
        Object var3_4 = null;
        try (MultiphysicsUtil.SelectionCacheCloseable selectionCacheCloseable = new MultiphysicsUtil.SelectionCacheCloseable(model);){
            boolean bl2 = material.getOperation().isValid(material);
            material.setValid(bl2);
            for (Material material2 : MaterialUtil.getDependentMaterials(material)) {
                if (material2 == material) continue;
                boolean bl3 = material2.getOperation().isValid(material2);
                material2.setValid(bl3);
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkValid(MaterialList<? extends Material> materialList, String string, List<String[]> list, Map<String, Selection> map) {
        Model model = materialList.getModel();
        ModelNode modelNode = model.modelNode(string);
        GeomSequence geomSequence = modelNode.getGeom();
        if (geomSequence == null || materialList.getContainer() instanceof Material) {
            return true;
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (MultiphysicsUtil.SelectionCacheCloseable selectionCacheCloseable = new MultiphysicsUtil.SelectionCacheCloseable(model);){
            String[] stringArray;
            Selection selection;
            void entry;
            HashMap<EntityBaseDimensionInfo, Selection> hashMap = new HashMap<EntityBaseDimensionInfo, Selection>();
            IVariableData iVariableData = model.physics().getVarData();
            hashMap.putAll(iVariableData.getRequestedMaterialSelection(modelNode, model));
            boolean bl2 = true;
            boolean n2 = false;
            while (entry < materialList.size()) {
                Material material = (Material)materialList.get((int)entry);
                if (material.isActive()) {
                    hashMap.remove(new MaterialShiftInfo(material.tag()));
                    if (material.hasSelection() && string.equals(material.model())) {
                        selection = new SimpleSelection(material.selection());
                        stringArray = new String[3];
                        if (!material.isValid()) {
                            stringArray[0] = "material_undefined_parameter.png";
                            bl2 = false;
                        }
                        stringArray[1] = material.getDisplayString();
                        stringArray[2] = selection.toString();
                        list.add(stringArray);
                        if (map != null) {
                            map.put(stringArray[2], selection);
                        }
                        EntityBaseDimensionInfo entityBaseDimensionInfo = new EntityBaseDimensionInfo(selection);
                        for (Map.Entry entry2 : hashMap.entrySet()) {
                            if (!entityBaseDimensionInfo.isIntersected((EntityBaseDimensionInfo)entry2.getKey())) continue;
                            entry2.setValue(((Selection)entry2.getValue()).difference(selection));
                        }
                    }
                }
                ++entry;
            }
            for (Map.Entry entry3 : hashMap.entrySet()) {
                selection = (Selection)entry3.getValue();
                if (selection == null) {
                    stringArray = new String[]{"material_undefined_parameter.png", ((Material)materialList.get(((MaterialShiftInfo)entry3.getKey()).getMaterialRequest())).getDisplayString(), FlLocale.getString((String)"Required_material_is_disabled")};
                    list.add(stringArray);
                    bl2 = false;
                    continue;
                }
                if (selection.isEmpty()) continue;
                stringArray = new String[]{"material_undefined_parameter.png", FlLocale.getString((String)"Entities_needing_a_material"), selection.toString()};
                list.add(stringArray);
                bl2 = false;
                if (map == null) continue;
                map.put(stringArray[2], selection);
            }
            return bl2;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map<String, Selection> getStringToSelection(MaterialList materialList) {
        return ((MaterialListMethod)materialList.method()).getStringToSelection();
    }

    public static boolean getValid(MaterialList<? extends Material> materialList, String string) {
        Model model = materialList.getModel();
        if (model.modelNode(string).getGeom() == null) {
            return true;
        }
        boolean bl2 = true;
        for (Material material : materialList) {
            if (bl2 && !material.isActive() || !material.hasSelection() || !string.equals(material.model()) || material.isValid()) continue;
            bl2 = false;
        }
        return bl2;
    }

    private static String a(MaterialModel materialModel, String string, ParamSpec paramSpec) {
        try {
            String[] stringArray = materialModel.getStringArray(string);
            return stringArray.length == 1 ? stringArray[0] : "{" + FlStringUtil.delimitedString((String[])stringArray, (String)", ") + "}";
        }
        catch (FlException flException) {
            return "";
        }
    }

    private static String a(ModelEntity modelEntity, String string, ParamSpec paramSpec) {
        String string2 = null;
        try {
            try {
                Material material;
                if (modelEntity.getConverter().useUnitSystems() && (string2 = paramSpec.getUnit(modelEntity)) == null && modelEntity instanceof MaterialModel && (material = ((MaterialModel)modelEntity).getMaterial()) != null) {
                    int n2 = material.hasSelection() ? material.selection().getDim() : -1;
                    string2 = modelEntity.getConverter().getUnitExpr(string, modelEntity.scopeDot(), n2);
                }
            }
            catch (FlException flException) {
                if (string2 == null) {
                    string2 = "";
                }
            }
        }
        finally {
            if (string2 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    public static String getVariableName(String string, ParamSpec paramSpec) {
        if (paramSpec.getPhysicalIdentifier() != null) {
            IPhysicalQuantity iPhysicalQuantity = paramSpec.getPhysicalIdentifier();
            if (PhysicalQuantityManager.isID(string)) {
                return iPhysicalQuantity.varName();
            }
        }
        return string;
    }

    public static ay createTreeView(ModelEntity modelEntity) {
        ds ds2;
        Object object;
        String string;
        PropAnnotationInfo.ap ap2 = new PropAnnotationInfo.ap(MaterialDB.MatRes.children.name(), MaterialDB.MatRes.menus.name(), MaterialDB.MatRes.leafMenus.name(), MaterialDB.MatRes.expanded.name());
        ap2.a((Comparator)new a());
        String[] stringArray = new String[]{MaterialDB.MatRes.children.name(), MaterialDB.MatRes.menus.name(), MaterialDB.MatRes.leafMenus.name(), MaterialDB.MatRes.expanded.name()};
        String[] stringArray2 = new String[]{MaterialDB.MatRes.children.descr(), MaterialDB.MatRes.menus.descr(), MaterialDB.MatRes.leafMenus.descr(), MaterialDB.MatRes.expanded.descr()};
        ds ds3 = new ds("add_selection", "Add_to_material", "add_row.png");
        ay ay2 = new ay("quantitytree", "Basic_properties", MaterialDB.MatRes.children.name(), stringArray, stringArray2);
        ay2.annotate().a(ap2).Z().d("");
        ay ay3 = new ay("quantitiesNode", "Basic_properties", MaterialDB.MatRes.children.name(), stringArray, stringArray2);
        ay2.registerProp(MaterialDB.MatRes.children.name(), (Property)ay3);
        ay3.registerProp(MaterialDB.MatRes.leafMenus.name(), (Property)ds3);
        String[] stringArray3 = PhysicalQuantityManager.getPQFieldNames();
        int n2 = stringArray3.length;
        int n3 = 0;
        while (n3 < n2) {
            string = stringArray3[n3];
            object = PhysicalQuantityManager.getID(string);
            if (object.isMaterialProp()) {
                ds2 = new ds(string, object.descr(), "");
                ay3.registerProp(MaterialDB.MatRes.children.name(), (Property)ds2);
            }
            ++n3;
        }
        stringArray3 = PhysicalQuantityManager.getAllMaterialModelTags();
        n2 = stringArray3.length;
        n3 = 0;
        while (n3 < n2) {
            string = stringArray3[n3];
            object = PhysicalQuantityManager.getApplMaterialModel(string);
            if (object != null && object.isActive()) {
                ParamSpec paramSpec;
                ay ay4;
                ay ay5;
                ay3 = ay2;
                ds2 = ay2;
                if (FlStringUtil.contains((String[])object.info().tags(), (String)"category")) {
                    ay ay6 = ay5 = object.info("category").body().split("/");
                    int n4 = ((String[])ay6).length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ay4 = ay6[n5];
                        if (FlStringUtil.contains((String[])ds2.getPropSet(MaterialDB.MatRes.children.name()).getNames(), (String)ay4)) {
                            ay3 = (ay)ds2.getPropSet(MaterialDB.MatRes.children.name()).getProperty((String)ay4);
                        } else {
                            ay3 = new ay((String)ay4, (String)ay4, MaterialDB.MatRes.children.name(), stringArray, stringArray2);
                            ds2.registerProp(MaterialDB.MatRes.children.name(), (Property)ay3);
                        }
                        ds2 = ay3;
                        ++n5;
                    }
                }
                ay5 = new ay(object.tag(), "#" + FlLocale.capitalize((String)object.label()), MaterialDB.MatRes.children.name(), stringArray, stringArray2);
                ay3.registerProp(MaterialDB.MatRes.children.name(), (Property)ay5);
                ay5.registerProp(MaterialDB.MatRes.menus.name(), (Property)ds3);
                ay5.registerProp(MaterialDB.MatRes.leafMenus.name(), (Property)ds3);
                ay4 = ay5;
                ArrayList<String> arrayList = new ArrayList<String>();
                Object object2 = object.param();
                int n6 = ((String[])object2).length;
                int n7 = 0;
                while (n7 < n6) {
                    String string2 = object2[n7];
                    if (object.isOutput(string2)) {
                        paramSpec = object.getSpec(string2);
                        String string3 = "#" + FlLocale.getString((String)paramSpec.getDescr());
                        string3 = PhysicalQuantityManager.isID(string2) ? String.valueOf(string3) + " (" + paramSpec.getPhysicalIdentifier().varName() + ")" : String.valueOf(string3) + " (" + string2 + ")";
                        ds ds4 = new ds(string2, string3, "");
                        ay4.registerProp(MaterialDB.MatRes.children.name(), (Property)ds4);
                    } else {
                        arrayList.add(string2);
                    }
                    ++n7;
                }
                ay ay7 = new ay("paramNode", "Local_properties", MaterialDB.MatRes.children.name(), stringArray, stringArray2);
                ay7.registerProp(MaterialDB.MatRes.menus.name(), (Property)ds3);
                ay7.registerProp(MaterialDB.MatRes.leafMenus.name(), (Property)ds3);
                for (String string4 : arrayList) {
                    object2 = object.getSpec(string4);
                    paramSpec = new ds(string4, ((ParamSpec)object2).getDescr(), "");
                    ay7.registerProp(MaterialDB.MatRes.children.name(), (Property)paramSpec);
                }
                if (ay7.getGroupProps().length > 0) {
                    ay5.registerProp(MaterialDB.MatRes.children.name(), (Property)ay7);
                }
            }
            ++n3;
        }
        return ay2;
    }

    public static String paramToString(String string, int n2, int[] nArray) {
        if (nArray[0] == 0) {
            nArray = new int[]{n2, 1};
        }
        if (Arrays.equals(nArray, VariableDataBase.SCALAR)) {
            return string;
        }
        if (nArray[1] > 1) {
            return MaterialUtil.a(string, nArray, n2);
        }
        return MaterialUtil.a(string, nArray);
    }

    private static String a(String string, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n2 = 0;
        while (n2 < nArray[0]) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string).append(String.valueOf(n2 + 1));
            ++n2;
        }
        return stringBuilder.append("}").toString();
    }

    private static String a(String string, int[] nArray, int n2) {
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = bl2 = nArray[0] == nArray[1];
        if (n2 == 1) {
            return stringBuilder.append(string).append(MaterialDB.MatRes._iso.name()).append(" ; ").append(string).append("ii = ").append(string).append(MaterialDB.MatRes._iso.name()).append(", ").append(string).append("ij = 0").toString();
        }
        if (bl2 && n2 == nArray[0]) {
            stringBuilder.append("{");
            int n3 = 0;
            while (n3 < nArray[1]) {
                if (n3 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string).append(String.valueOf(n3 + 1)).append(String.valueOf(n3 + 1));
                ++n3;
            }
            return stringBuilder.append("} ; ").append(string).append("ij = 0").toString();
        }
        if (bl2 && n2 == nArray[0] * (nArray[0] + 1) / 2) {
            stringBuilder.append("{");
            int n4 = 0;
            while (n4 < nArray[1]) {
                if (n4 > 0) {
                    stringBuilder.append(", ");
                }
                int n5 = 0;
                while (n5 < n4 + 1) {
                    if (n5 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string).append(String.valueOf(n5 + 1)).append(String.valueOf(n4 + 1));
                    ++n5;
                }
                ++n4;
            }
            return stringBuilder.append("} ; ").append(string).append("ij = ").append(string).append("ji").toString();
        }
        stringBuilder.append("{");
        int n6 = 0;
        while (n6 < nArray[1]) {
            if (n6 > 0) {
                stringBuilder.append(", ");
            }
            int n7 = 0;
            while (n7 < nArray[0]) {
                if (n7 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string).append(String.valueOf(n7 + 1)).append(String.valueOf(n6 + 1));
                ++n7;
            }
            ++n6;
        }
        return stringBuilder.append("}").toString();
    }

    public static String[][] getStringMatrix(ListType listType, MaterialModel materialModel) {
        String[] stringArray;
        Object object;
        int n2;
        Object object2;
        int n3 = 0;
        switch (MaterialUtil.a()[listType.ordinal()]) {
            case 1: {
                object2 = new ArrayList();
                String[] stringArray2 = materialModel.param();
                n2 = stringArray2.length;
                int n4 = 0;
                while (n4 < n2) {
                    object = stringArray2[n4];
                    if (materialModel.isOutput((String)object)) {
                        object2.add(object);
                    }
                    ++n4;
                }
                stringArray = object2.toArray(new String[object2.size()]);
                break;
            }
            case 3: {
                object2 = new ArrayList();
                String[] stringArray2 = materialModel.param();
                n2 = stringArray2.length;
                int n4 = 0;
                while (n4 < n2) {
                    object = stringArray2[n4];
                    if (materialModel.isLocalParameter((String)object)) {
                        object2.add(object);
                    }
                    ++n4;
                }
                stringArray = object2.toArray(new String[object2.size()]);
                break;
            }
            case 4: {
                stringArray = materialModel.input();
                break;
            }
            default: {
                throw new RuntimeException("Unknown list type");
            }
        }
        object2 = listType.getCol();
        object = new String[stringArray.length][((Object)object2).length];
        String[] stringArray3 = stringArray;
        int n5 = stringArray.length;
        n2 = 0;
        while (n2 < n5) {
            String string = stringArray3[n2];
            String[] stringArray4 = MaterialUtil.getRow(materialModel, string, listType);
            int n6 = 0;
            while (n6 < ((Object)object2).length) {
                object[n3][n6] = stringArray4[object2[n6]];
                ++n6;
            }
            ++n3;
            ++n2;
        }
        return object;
    }

    public static void collectAllVariables(Material material, HashMap<String, String> hashMap) {
        for (MaterialModel materialModel : material.propertyGroup()) {
            String string = materialModel.scope();
            String[] stringArray = materialModel.param();
            if (stringArray == null || stringArray.length <= 0) continue;
            int n2 = 0;
            while (n2 < stringArray.length) {
                ParamValue paramValue = materialModel.getParamValue(stringArray[n2]);
                ParamSpec paramSpec = materialModel.getSpec(stringArray[n2]);
                String string2 = stringArray[n2];
                if (PhysicalQuantityManager.isID(string2)) {
                    string2 = paramSpec.getPhysicalIdentifier().varName();
                }
                string2 = ParseUtil.c((String)string2, (String)string);
                int[] nArray = paramSpec.getDims(1);
                if (q.h((int[])nArray) != 0) {
                    String[][] stringArray2 = paramValue.getMatrix(nArray);
                    if (stringArray2.length > 1) {
                        int n3 = 0;
                        while (n3 < stringArray2.length) {
                            if (stringArray2[n3].length > 1) {
                                int n4 = 0;
                                while (n4 < stringArray2[n3].length) {
                                    if (stringArray2[n3][n4].length() > 0) {
                                        hashMap.put(String.valueOf(string2) + String.valueOf(n3 + 1) + String.valueOf(n4 + 1), stringArray2[n3][n4]);
                                    }
                                    ++n4;
                                }
                            } else if (stringArray2[n3][0].length() > 0) {
                                hashMap.put(String.valueOf(string2) + String.valueOf(n3 + 1), stringArray2[n3][0]);
                            }
                            ++n3;
                        }
                    } else if (stringArray2[0][0].length() > 0) {
                        hashMap.put(string2, stringArray2[0][0]);
                    }
                }
                ++n2;
            }
        }
    }

    public static void collectAllFunctions(Material material, HashMap<String, w> hashMap) {
        for (MaterialModel materialModel : material.propertyGroup()) {
            String string = materialModel.scope();
            for (PropFeature propFeature : materialModel.func()) {
                String[] stringArray;
                String[] stringArray2 = stringArray = ((IFunctionOperation)propFeature.getOperation()).getFunctionNames(propFeature);
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = stringArray2[n3];
                    hashMap.put(ParseUtil.c((String)string2, (String)string), null);
                    ++n3;
                }
            }
        }
    }

    public static String[] getRow(MaterialModel materialModel, String string, ListType listType) {
        Object[] objectArray = new String[10];
        Arrays.fill(objectArray, "");
        ParamSpec paramSpec = materialModel.getSpec(string);
        PgCol.pName.set(string, (String[])objectArray);
        PgCol.value.set(MaterialUtil.a(materialModel, string, paramSpec), (String[])objectArray);
        PgCol.unit.set(MaterialUtil.a((ModelEntity)materialModel, (String)objectArray[1], paramSpec), (String[])objectArray);
        if (listType == ListType.PARMETERS) {
            String string2 = materialModel.method().hasDescr(string) ? materialModel.descr(string) : "";
            PgCol.descr.set(string2, (String[])objectArray);
        } else {
            PgCol.descr.set(FlLocale.getString((String)paramSpec.getDescr()), (String[])objectArray);
        }
        int n2 = 1;
        if (materialModel.hasParam(string)) {
            n2 = materialModel.getStringArray(string).length;
            if (listType == ListType.OUTPUT) {
                PgCol.info.set(materialModel.getPropertyInfo(string), (String[])objectArray);
            }
        }
        PgCol.varName.set(MaterialUtil.paramToString(MaterialUtil.getVariableName(string, paramSpec), n2, paramSpec.getDims(1)), (String[])objectArray);
        PgCol.size.set(MaterialUtil.b(n2, paramSpec), (String[])objectArray);
        return objectArray;
    }

    private static String b(int n2, ParamSpec paramSpec) {
        PropAnnotationInfo.EditFieldInfo.MatrixSymmetry matrixSymmetry;
        ba ba2;
        PropAnnotationInfo.EditFieldInfo editFieldInfo;
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = paramSpec.getDims(1);
        if (nArray[0] == 0) {
            nArray = new int[]{n2, 1};
        }
        if (nArray[0] == nArray[1] && (editFieldInfo = (ba2 = paramSpec.getAnnotations()).S()) != null && (matrixSymmetry = editFieldInfo.w()) != null) {
            stringBuilder.append(matrixSymmetry.name());
        }
        return stringBuilder.append(nArray[0]).append('x').append(nArray[1]).toString();
    }

    public static int[] stringToSize(String string) {
        Matcher matcher = a.matcher(string);
        if (matcher.find()) {
            return ApplAPIUtil.parseSize(matcher.group());
        }
        return null;
    }

    public static IPhysicalQuantity findPhysicalQuantity(String string) {
        IPhysicalQuantity[] iPhysicalQuantityArray = PhysicalQuantityManager.getID(iPhysicalQuantity -> iPhysicalQuantity.isValidForModeInput() && Pattern.compile("^" + iPhysicalQuantity.varName() + "\\d{0,2}$").matcher(string).matches());
        if (iPhysicalQuantityArray.length == 1) {
            return iPhysicalQuantityArray[0];
        }
        return null;
    }

    public static void updateUsedPQ(Material material, int ... nArray) {
        material.method().updateUsedPQ(nArray);
    }

    public static Material getPropertySource(Material material) {
        return material.getOperation().getPropertySource(material, -2);
    }

    public static Collection<Material> getAllPropertySources(Material material) {
        return material.getOperation().getAllPropertySources(material);
    }

    public static List<Material> getDependentMaterials(Material material) {
        ArrayList<Material> arrayList = new ArrayList<Material>(1);
        arrayList.add(material);
        PrimitiveModelEntity primitiveModelEntity = material.getContainer().getContainer();
        if (primitiveModelEntity instanceof Material && ((Material)primitiveModelEntity).getOperationID().equals("Switch")) {
            arrayList.addAll(MaterialUtil.getDependentMaterials((Material)primitiveModelEntity));
        } else {
            for (Material material2 : material.getModel().material()) {
                if (!material2.isActive() || material2 == material || !material2.getOperation().hasLinkToMaterial(material2, LayeredShellData.getMatTag(material), false)) continue;
                arrayList.add(material2);
            }
        }
        return arrayList;
    }

    public static String[][] createTable(Material material, boolean bl2) {
        return material.getOperation().createTable(material, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public static String[][] createTableForPropertyGroupParent(Material material, Map<String, Collection<String>> map, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5;
        Object object;
        Object object2;
        int n2;
        Object object3;
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LinkedHashMap<Object, Object> linkedHashMap2 = new LinkedHashMap<Object, Object>();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (MaterialModel materialModel : material.propertyGroup()) {
            if (!materialModel.isActiveFlag()) continue;
            String string = materialModel.tag();
            if (PhysicalQuantityManager.getApplMaterialModel(string) == null) {
                String string2 = "";
            }
            object3 = materialModel.param();
            n2 = ((String[])object3).length;
            int n3 = 0;
            while (n3 < n2) {
                Object object4 = object3[n3];
                if (!((String)object4).endsWith(MaterialDB.MatRes._symmetry.name())) {
                    void var10_17;
                    object2 = String.valueOf(var10_17.length() > 0 ? String.valueOf(var10_17) + ":" : "") + (String)object4;
                    object = MaterialUtil.getTableRow(materialModel, (String)object4);
                    arrayList.add(object);
                    if (object[3].length() > 0 || materialModel.getSpec((String)object4).getDims(1)[0] == 0) {
                        object[0] = MaterialDB.definedAndUnused;
                        hashMap.put((String)object2, (String[])object);
                        if (PhysicalQuantityManager.isID((String)object4)) {
                            if (var10_17.length() > 0) {
                                hashMap.put((String)object4, (String[])object);
                                linkedHashMap2.put(object4, object2);
                            } else {
                                linkedHashMap2.remove(object2);
                            }
                        }
                    } else {
                        object[0] = "warning_problem.png";
                        linkedHashMap.put(object2, object);
                        if (var10_17.length() > 0 && !hashMap.containsKey(object4) && PhysicalQuantityManager.isID((String)object4)) {
                            linkedHashMap2.put(object4, object2);
                        }
                    }
                }
                ++n3;
            }
        }
        boolean bl6 = true;
        if (material.isActive()) {
            for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
                for (Object object4 : entry.getValue()) {
                    if (!bl3 && "shell".equals(object4)) continue;
                    if (PhysicalQuantityManager.getApplMaterialModel((String)object4) == null) {
                        object4 = "";
                    }
                    String string = entry.getKey();
                    if (((String)object4).length() > 0) {
                        string = String.valueOf(object4) + ":" + string;
                    } else if (linkedHashMap2.containsKey(string)) {
                        string = (String)((HashMap)linkedHashMap2).get(string);
                    }
                    if (!hashMap.containsKey(string)) {
                        if (!linkedHashMap.containsKey(string)) {
                            object2 = null;
                            if (((String)object4).length() == 0 || ((String)object4).equals(MaterialDB.MatRes.def.name())) {
                                object2 = material.propertyGroup(MaterialDB.MatRes.def.name());
                            } else {
                                object2 = PhysicalQuantityManager.getApplMaterialModel((String)object4);
                                if (object2 == null) {
                                    object2 = material.propertyGroup((String)object4);
                                }
                            }
                            object3 = MaterialUtil.getTableRow((MaterialModel)object2, entry.getKey());
                            linkedHashMap.put(string, object3);
                            if (object2.getSpec(entry.getKey()).getDims(1)[0] > 0) {
                                object3[0] = "material_undefined_parameter.png";
                                bl5 = false;
                            } else {
                                object3[0] = MaterialDB.definedAndUnused;
                            }
                            arrayList.add(object3);
                            continue;
                        }
                        object3 = (String[])linkedHashMap.get(string);
                        object3[0] = "material_undefined_parameter.png";
                        bl5 = false;
                        continue;
                    }
                    object3 = (String[])hashMap.get(string);
                    object3[0] = "activate.png";
                }
            }
        }
        HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
        if (material.isActive() && !bl5) {
            boolean bl7 = true;
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                String string = (String)entry.getKey();
                n2 = 6;
                object3 = ((String[])entry.getValue())[n2];
                if (PhysicalQuantityManager.getApplMaterialModel((String)object3) == null) {
                    object3 = "";
                }
                object2 = (String[])entry.getValue();
                if (((String)object3).length() == 0) {
                    object3 = MaterialDB.MatRes.def.name();
                }
                if (!map.containsKey(object = string.substring(string.indexOf(":") + 1))) continue;
                String string3 = material.getUsedRule((String)object3, (String)object);
                if (string3 != null) {
                    String[][] stringArray;
                    MaterialModel materialModel;
                    String[][] stringArray2 = null;
                    String string4 = null;
                    if (string3.startsWith(MaterialDB.MatRes.id.shortName()) && material.propertyGroup().hasTag(string3.substring(3))) {
                        materialModel = material.propertyGroup(string3.substring(3));
                        if (!materialModel.isActive()) continue;
                        string4 = materialModel.getOperation().getIdentityRule((String)object, (String)object3, materialModel);
                        if (string4 != null) {
                            hashMap2.put(string, new String[]{String.valueOf(materialModel.tag()) + ":" + string4.substring(string4.lastIndexOf(".") + 1)});
                            hashMap.put(string, (String[])object2);
                            stringArray = materialModel.getOperation().getIdentityRuleMatrix((String)object, (String)object3, materialModel);
                            object2[3] = stringArray.length == 1 ? stringArray[0][0] : "{" + FlStringUtil.delimitedString((String[])FlStringUtil.delimitedStringArrayList(Arrays.asList(stringArray), (String)", ").toArray(), (String)", ") + "}";
                        }
                    } else if (material.propertyGroup().hasTag(string3)) {
                        materialModel = material.propertyGroup(string3);
                        if (!materialModel.isActive()) continue;
                        stringArray2 = materialModel.getOperation().getSynchronizedRule((String)object, (String)object3, materialModel, true);
                        stringArray = materialModel.getSynchronizationRule((String)object3, (String)object);
                        String[] stringArray3 = stringArray.getNeededMatProps();
                        if (stringArray2 != null) {
                            hashMap2.put(string, FlStringUtil.prepend((String)(String.valueOf(materialModel.tag()) + ":"), (String[])stringArray3));
                            hashMap.put(string, (String[])object2);
                            Object object5 = object2[3] = stringArray2.length == 1 ? stringArray2[0][0] : "{" + FlStringUtil.delimitedString((String[])FlStringUtil.delimitedStringArrayList(Arrays.asList(stringArray2), (String)", ").toArray(), (String)", ") + "}";
                        }
                    }
                }
                if (hashMap.containsKey(string) || !MaterialUtil.a((String)object, (String)object3, map)) continue;
                bl4 = false;
            }
            for (String string : hashMap2.keySet()) {
                String[] stringArray = (String[])linkedHashMap.get(string);
                String string5 = string.substring(string.indexOf(":") + 1);
                if (stringArray[0] != "material_undefined_parameter.png" && stringArray[0] != "warning_problem.png" && stringArray[0] != MaterialDB.synchronizedAndUnused) continue;
                if (map.containsKey(string5)) {
                    stringArray[0] = "synch_and_used.png";
                    MaterialUtil.a(string, true, hashMap2, hashMap);
                    continue;
                }
                stringArray[0] = MaterialDB.synchronizedAndUnused;
                MaterialUtil.a(string, false, hashMap2, hashMap);
            }
        }
        material.setValid(bl4);
        Collections.sort(arrayList, new IconComparator(bl2));
        if (bl2) {
            void var10_27;
            int n4 = arrayList.size() - 1;
            while (var10_27 >= 0) {
                if (MaterialUtil.b(((String[])arrayList.get((int)var10_27))[0], bl2) <= 3) break;
                arrayList.remove((int)var10_27);
                --var10_27;
            }
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    private static boolean a(String string, String string2, Map<String, Collection<String>> map) {
        return map.containsKey(string) && (map.get(string).contains(string2) || map.get(string).contains("") && string2.equals("def"));
    }

    private static void a(String string, boolean bl2, Map<String, String[]> map, Map<String, String[]> map2) {
        if (bl2) {
            String[] stringArray;
            String[] stringArray2 = stringArray = map.get(string);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray2[n3];
                if (map.containsKey(string2)) {
                    map2.get((Object)string2)[0] = "synch_and_used.png";
                    MaterialUtil.a(string2, true, map, map2);
                } else if (map2.containsKey(string2)) {
                    map2.get((Object)string2)[0] = "activate.png";
                }
                ++n3;
            }
        } else {
            String[] stringArray;
            String[] stringArray3 = stringArray = map.get(string);
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string3 = stringArray3[n5];
                if (map.containsKey(string3)) {
                    map2.get((Object)string3)[0] = MaterialDB.synchronizedAndUnused;
                    MaterialUtil.a(string3, false, map, map2);
                }
                ++n5;
            }
        }
    }

    public static void updateUsedRule(Material material) {
        if (!material.isInModel()) {
            return;
        }
        material.clearUsedRule();
        for (MaterialModel materialModel : material.propertyGroup().getActiveList()) {
            Map<String, MaterialPropSychronizationRule> object2;
            Map<String, String> map = materialModel.getAllIdentityRules();
            if (map != null) {
                for (String string : map.keySet()) {
                    Object object;
                    int n2;
                    Object object3;
                    String string2 = string.substring(0, string.indexOf(":"));
                    String string3 = string.substring(string.indexOf(":") + 1);
                    boolean bl2 = true;
                    if (material.propertyGroup().hasTag(string2) && material.propertyGroup(string2).isActive()) {
                        object3 = material.propertyGroup(string2);
                        if (object3.getOperation().hasParam((MaterialModel)object3, string3, true)) continue;
                        String[] stringArray = object3.param();
                        int n3 = stringArray.length;
                        n2 = 0;
                        while (n2 < n3) {
                            object = stringArray[n2];
                            if (!((String)object).endsWith(MaterialDB.MatRes._symmetry.name()) && object3.getOperation().hasParam((MaterialModel)object3, (String)object, true)) {
                                bl2 = false;
                            }
                            ++n2;
                        }
                    }
                    if ((object3 = material.getUsedRule(string2, string3)) == null) {
                        material.setUsedRule(string2, string3, materialModel.tag(), true);
                        continue;
                    }
                    object = material.propertyGroup(((String)object3).substring(((String)object3).indexOf(":") + 1));
                    int n4 = n2 = materialModel.getOperation().getSynchronizedRule(string3, string2, (MaterialModel)object, false) != null ? 1 : 0;
                    if (bl2) {
                        if (n2 != 0) continue;
                        material.setUsedRule(string2, string3, materialModel.tag(), true);
                        continue;
                    }
                    material.setUsedRule(string2, string3, materialModel.tag(), true);
                }
            }
            if ((object2 = materialModel.getAllSynchronizationRules()) == null) continue;
            block3: for (String string : object2.keySet()) {
                boolean bl3 = true;
                if (material.propertyGroup().hasTag(string) && material.propertyGroup(string).isActive()) {
                    MaterialModel materialModel2 = material.propertyGroup(string);
                    boolean bl4 = false;
                    Set<String> set = object2.get(string).getDefinedMaterialProperty();
                    String[] stringArray = materialModel2.param();
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String string4 = stringArray[n6];
                        if (materialModel.getOperation().hasParam(materialModel2, string4, true)) {
                            bl3 = false;
                            if (set.contains(string4)) {
                                bl4 = true;
                                break;
                            }
                        }
                        ++n6;
                    }
                    if (bl4) continue;
                }
                for (String string5 : object2.get(string).getDefinedMaterialProperty()) {
                    boolean bl5 = true;
                    String string6 = material.getUsedRule(string, string5);
                    if (materialModel.getOperation().getSynchronizedRule(string5, string, materialModel, true) == null) continue block3;
                    if (string6 != null) {
                        boolean bl6;
                        boolean bl7 = bl6 = materialModel.getOperation().getSynchronizedRule(string5, string, materialModel, false) != null;
                        if (bl3) {
                            if (!bl6) {
                                if (string6.startsWith(MaterialDB.MatRes.id.name())) {
                                    bl5 = false;
                                } else {
                                    boolean bl8;
                                    MaterialModel materialModel3 = material.propertyGroup(string6);
                                    boolean bl9 = bl8 = materialModel.getOperation().getSynchronizedRule(string5, string, materialModel3, false) != null;
                                    if (bl8) {
                                        bl5 = false;
                                    }
                                }
                            }
                        } else if (string6.startsWith(MaterialDB.MatRes.id.name())) {
                            bl5 = false;
                        } else {
                            boolean bl10;
                            MaterialModel materialModel4 = material.propertyGroup(string6);
                            boolean bl11 = bl10 = materialModel.getOperation().getSynchronizedRule(string5, string, materialModel4, false) != null;
                            if (!bl6 && bl10) {
                                bl5 = false;
                            }
                        }
                    }
                    if (!bl5) continue;
                    for (String string7 : object2.get(string).getDefinedMaterialProperty()) {
                        material.setUsedRule(string, string7, materialModel.tag(), false);
                    }
                    continue block3;
                }
            }
        }
    }

    private static int b(String string, boolean bl2) {
        if ("warning_problem.png".equals(string)) {
            return bl2 ? 5 : 0;
        }
        if ("material_undefined_parameter.png".equals(string)) {
            return 0;
        }
        if ("activate.png".equals(string)) {
            return 1;
        }
        if ("synch_and_used.png".equals(string)) {
            return 3;
        }
        return 4;
    }

    public static int numberValidMaterials(MaterialList<? extends PropFeature> materialList) {
        int n2 = 0;
        for (PropFeature propFeature : materialList) {
            if (!propFeature.isActive()) continue;
            ++n2;
        }
        return n2;
    }

    public static String getMaterialListViewTag(MaterialList<?> materialList, String string) {
        StringBuilder stringBuilder = new StringBuilder("_").append(string);
        return stringBuilder.toString();
    }

    public static String[] getAllModelInputs(Material material) {
        HashSet hashSet = new HashSet();
        for (Material material2 : material.getOperation().getAllPropertySources(material)) {
            material2.propertyGroup().activeStream().forEach(materialModel -> hashSet.addAll(Arrays.asList(materialModel.input())));
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String[] getAllModelInputs(MaterialList<? extends Material> materialList, String string) {
        HashSet hashSet = new HashSet();
        for (Material material : materialList) {
            if (!material.isInModel() || !material.isActive() || !string.equals(material.model())) continue;
            for (Material material2 : material.getOperation().getAllPropertySources(material)) {
                material2.propertyGroup().activeStream().forEach(materialModel -> hashSet.addAll(Arrays.asList(materialModel.input())));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String getPhysicalQuantityDescr(String string) {
        return MaterialUtil.getPhysicalQuantityDescr(string, "Custom_unit");
    }

    public static String getPhysicalQuantityDescr(String string, String string2) {
        return FlLocale.getString((String)MaterialUtil.getUntranslatePhysicalQuantityDescr(string, string2));
    }

    public static String getUntranslatePhysicalQuantityDescr(String string, String string2) {
        String string3 = "";
        if (string == null || "".equals(string)) {
            string3 = "None";
        }
        if ("none".equals(string)) {
            string3 = string2;
        } else if (PhysicalQuantityManager.isID(string)) {
            IPhysicalQuantity iPhysicalQuantity = PhysicalQuantityManager.getID(string);
            string3 = iPhysicalQuantity.descr();
        }
        return string3;
    }

    public static void collectMaterialLinkToCopy(Material material, Collection<PrimitiveModelEntity> collection, CopyPasteInfo copyPasteInfo, String string) {
        Material material2;
        String string2 = material.getString(string);
        if (material.getModel().material().hasTag(string2) && (material2 = material.getModel().material(string2)).getParentModel() == null) {
            String string3 = ModelEntityUtil.getEntityPath(material2);
            ModelEntityUtil.addCopiedReference(material, collection, copyPasteInfo, material2, string3);
            material2.collectObjectsToCopy(collection, copyPasteInfo);
        }
    }

    public static void handleMaterialLinkReferenceInPaste(Material material, Material material2, CopyPasteInfo copyPasteInfo, String string4) {
        if (!copyPasteInfo.isPastingFromAnotherModel()) {
            Optional<String> optional = Optional.ofNullable(copyPasteInfo.getReferenceAsPath(material, string4));
            optional.map(string -> string.substring(string.lastIndexOf(47) + 1)).filter(string -> !string.isEmpty()).filter(string2 -> q.a((Object[])material2.getAllowedPropertyValues(string4), (Object)string2)).ifPresent(string3 -> {
                if (!string3.equals(material2.getString(string4))) {
                    material2.set(string4, (String)string3);
                }
                optional.map(string -> copyPasteInfo.getReferencedObject((String)string)).ifPresent(copiedPrimitiveObject -> {
                    CopiedPrimitiveObject copiedPrimitiveObject2 = copiedPrimitiveObject.requestRemoval();
                });
            });
        }
    }

    public static boolean canPaste(Object object, ModelEntity modelEntity) {
        if (!(modelEntity instanceof Material) && object instanceof Material) {
            return false;
        }
        if (MaterialUtil.a((Material)object, (Material)modelEntity)) {
            return false;
        }
        Material material = (Material)object;
        Material material2 = (Material)modelEntity;
        return material2.getOperation().canPaste(material2, material, material.getOperation().getAllowedSubOperations());
    }

    private static boolean a(Material material, Material material2) {
        return material2.getOperation().isSingleton() && material.feature().stream().anyMatch(propFeature -> material2.getOperationID().equals(propFeature.getOperationID()));
    }

    public static Material getMaterialSwitchParent(Material material) {
        PrimitiveModelEntity primitiveModelEntity = material.getContainer().getContainer();
        if (primitiveModelEntity instanceof Material && MaterialOperationID.SWITCH.isOfType((Material)primitiveModelEntity)) {
            return (Material)primitiveModelEntity;
        }
        return null;
    }

    static /* synthetic */ int[] a() {
        if (b != null) {
            return b;
        }
        int[] nArray = new int[ListType.values().length];
        try {
            nArray[ListType.INPUTS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ListType.OUTPUT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ListType.PARMETERS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ListType.QUANTITIES.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        b = nArray;
        return nArray;
    }

    public static class CouplingPair {
        private Set<String> a = new HashSet<String>();
        private String[] b;
        private int c;

        public CouplingPair(String string, String[] stringArray, Integer n2) {
            this.a.add(string);
            this.b = stringArray;
            this.c = n2;
        }

        public void increaseCount(String string) {
            ++this.c;
        }

        public void updateRow(String[] stringArray) {
            this.b = FlStringUtil.copy((String[])stringArray);
        }

        public String[] row() {
            return this.b;
        }

        public Integer count() {
            return this.c;
        }
    }

    public static class DynamicUnitCheck
    extends UnitCheck {
        private final String a;
        private final u b;

        public DynamicUnitCheck(u u2, IUnitConverter iUnitConverter, String string) {
            super(iUnitConverter, (w)((ModelEntity)u2));
            this.b = u2;
            this.a = string;
        }

        public boolean hasUnit() {
            return this.getBaseUnit().length() > 0;
        }

        public int[] getDim() {
            if (this.hasUnit()) {
                return this.getUnitConverter().getDimension("1[" + this.getBaseUnit() + "]", 3);
            }
            return null;
        }

        public String getBaseUnit() {
            String string = this.b.getString(this.a);
            if (PhysicalQuantityManager.isID(string)) {
                IPhysicalQuantity iPhysicalQuantity = PhysicalQuantityManager.getID(string);
                Unit unit = ((UnitConverter)this.getUnitConverter()).getFirstDerivedUnit(iPhysicalQuantity.dimension(), string);
                if (unit == null) {
                    unit = ((UnitConverter)this.getUnitConverter()).createUnit(iPhysicalQuantity.dimension(), "tmp", new String[0]);
                }
                return unit.symbol();
            }
            return "";
        }

        protected String a(String string, int n2) {
            return super.a(string, n2);
        }
    }

    public static class EntityBaseDimensionInfo {
        private Integer a = null;
        private String b = null;

        public EntityBaseDimensionInfo(Selection selection) {
            this(selection.getDim(), selection.geom());
        }

        public EntityBaseDimensionInfo(Integer n2, String string) {
            this.a = n2;
            this.b = string;
        }

        public EntityBaseDimensionInfo(EntityBaseDimensionInfo entityBaseDimensionInfo) {
            this.a = entityBaseDimensionInfo.a;
            this.b = entityBaseDimensionInfo.b;
        }

        public EntityBaseDimensionInfo useBaseDim(Integer n2) {
            this.a = n2;
            return this;
        }

        public boolean isIntersected(EntityBaseDimensionInfo entityBaseDimensionInfo) {
            return this.a == null || entityBaseDimensionInfo.a != null && this.a.intValue() == entityBaseDimensionInfo.a.intValue();
        }

        public boolean isXDIntersected(Selection selection) {
            return selection == null;
        }

        public boolean isAllowDim(int n2) {
            return n2 == -1 || n2 == -2;
        }

        public int hashCode() {
            return (this.a == null ? 0 : this.a) ^ (this.b == null ? 0 : this.b.hashCode());
        }

        public boolean equals(Object object) {
            if (!(object instanceof EntityBaseDimensionInfo)) {
                return false;
            }
            EntityBaseDimensionInfo entityBaseDimensionInfo = (EntityBaseDimensionInfo)object;
            return this.a == entityBaseDimensionInfo.a && (this.b == null || this.b.equals(entityBaseDimensionInfo.b));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("\nBase dimensions: ");
            if (this.a == null) {
                stringBuilder.append("All");
            } else if (this.a == Integer.MAX_VALUE) {
                stringBuilder.append("Empty");
            } else {
                stringBuilder.append(this.a);
            }
            stringBuilder.append(" on geometry ").append(this.b);
            return stringBuilder.toString();
        }
    }

    public static class EntityExtraDimensionInfo
    extends EntityBaseDimensionInfo {
        private List<Map<String, ValidSel>> a = new ArrayList<Map<String, ValidSel>>(2);

        public EntityExtraDimensionInfo(String string, Integer n2) {
            super(n2, null);
            this.a.add(new HashMap());
            this.a.add(new HashMap());
            this.a.get(0).put(string, new ValidSel());
            this.a.get(1).put(string, new ValidSel());
        }

        public EntityExtraDimensionInfo() {
            this("", -1);
        }

        public EntityExtraDimensionInfo useXDSel(SimpleSelection simpleSelection) {
            if (simpleSelection != null) {
                int n2 = simpleSelection.getDim();
                Map<String, ValidSel> map = this.a.get(n2);
                String string = simpleSelection.geom();
                map.put(string, map.get(string).a(simpleSelection));
                map = this.a.get(1 - n2);
                map.put(string, map.get(string).a());
            }
            return this;
        }

        @Override
        public boolean isXDIntersected(Selection selection) {
            return selection != null && Optional.ofNullable(this.a.get(selection.getDim()).get(selection.geom())).map(validSel -> validSel.a(selection)).orElse(false) != false;
        }

        @Override
        public boolean isIntersected(EntityBaseDimensionInfo entityBaseDimensionInfo) {
            if (entityBaseDimensionInfo instanceof EntityExtraDimensionInfo) {
                EntityExtraDimensionInfo entityExtraDimensionInfo = (EntityExtraDimensionInfo)entityBaseDimensionInfo;
                if (this.a(this.a.get(1), entityExtraDimensionInfo.a.get(1)) || this.a(this.a.get(0), entityExtraDimensionInfo.a.get(0))) {
                    return super.isIntersected(entityExtraDimensionInfo);
                }
                return false;
            }
            return super.isIntersected(entityBaseDimensionInfo);
        }

        private boolean a(Map<String, ValidSel> map, Map<String, ValidSel> map2) {
            for (Map.Entry<String, ValidSel> entry : map.entrySet()) {
                if (!Optional.ofNullable(map2.get(entry.getKey())).map(validSel -> ((ValidSel)entry.getValue()).a((ValidSel)validSel)).orElse(false).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isAllowDim(int n2) {
            return n2 == -1 || n2 >= 0 && Optional.ofNullable(this.a.get(n2)).map(map -> map.values().stream().allMatch(validSel -> validSel.a != ValidSel.Status.b)).orElse(false) != false;
        }

        @Override
        public int hashCode() {
            int n2 = super.hashCode();
            return n2 ^= this.a.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof EntityExtraDimensionInfo) {
                EntityExtraDimensionInfo entityExtraDimensionInfo = (EntityExtraDimensionInfo)object;
                return this.a.equals(entityExtraDimensionInfo.a) && super.equals(object);
            }
            if (object instanceof EntityBaseDimensionInfo) {
                return super.equals(object);
            }
            return false;
        }
    }

    public static class GetSetHandler
    extends AbstractModelEntityGetSetHandler {
        private final Property a;
        private final Material b;
        private final boolean d;

        public GetSetHandler(Property property, Material material, boolean bl2) {
            super(material);
            this.a = property;
            this.b = material;
            this.d = bl2;
            material.setTmpProp(property.getStringMatrix());
        }

        @Override
        public void setIndex(String string, int n2, int n3) {
            Material material = MaterialUtil.getPropertySource(this.b);
            this.a.getCheck().setCurrentParameterContainer((u)material);
            try {
                MaterialModel materialModel;
                Object object;
                String[][] stringArray = this.b.getTmpProp();
                String string2 = stringArray[n2][6];
                if (!material.propertyGroup().hasTag(string2)) {
                    object = material.getModel().physics().propertyGroup(string2);
                    materialModel = material.propertyGroup().create(object.tag(), object.label());
                } else {
                    materialModel = material.propertyGroup(string2);
                }
                object = stringArray[n2][7];
                ParamSpec paramSpec = materialModel.getSpec((String)object);
                String[] stringArray2 = ParseUtil.i((String)o.c((String)string));
                material.propertyGroup(string2).set((String)object, stringArray2);
                this.a.set(stringArray);
                this.a.setIndex(string, n2, n3);
                this.a.setIndex(MaterialUtil.paramToString((String)object, stringArray2.length, paramSpec.getDims(1)), n2, 2);
                this.a.setIndex(MaterialUtil.b(stringArray2.length, paramSpec), n2, 8);
                String string3 = stringArray[n2][0];
                boolean bl2 = this.b.getUsedPhysicalQuantityMap().containsKey(object);
                if (string.length() > 0) {
                    if (bl2) {
                        if ("material_undefined_parameter.png".equals(string3)) {
                            this.a.setIndex("activate.png", n2, 0);
                            this.a(material, this.a.getStringMatrix());
                        } else {
                            this.b(n2, material, stringArray);
                        }
                    } else {
                        this.a.setIndex(MaterialDB.definedAndUnused, n2, 0);
                        this.a(material, this.a.getStringMatrix());
                    }
                    if (stringArray[n2][n3].isEmpty()) {
                        this.a(n2, material, stringArray);
                    }
                } else {
                    if (bl2 && "activate.png".equals(string3)) {
                        this.b(n2, material, stringArray);
                    } else {
                        this.a.setIndex("warning_problem.png", n2, 0);
                        this.a(material, this.a.getStringMatrix());
                    }
                    if (stringArray[n2][n3].length() > 0) {
                        this.a(n2, material, stringArray);
                    }
                }
                this.b.setTmpProp(this.a.getStringMatrix());
            }
            finally {
                this.a.getCheck().setCurrentParameterContainer(null);
            }
        }

        private void a(Material material, String[][] stringArray) {
            boolean bl2 = true;
            String[][] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String[] stringArray3 = stringArray2[n3];
                if (bl2 && "material_undefined_parameter.png".equals(stringArray3[0])) {
                    bl2 = false;
                }
                ++n3;
            }
            if (bl2 != material.isValid()) {
                material.setValid(bl2);
            }
        }

        private void a(int n2, Material material, String[][] stringArray) {
            String[][] stringArray2 = MaterialUtil.createTableForPropertyGroupParent(material, material.getUsedPhysicalQuantityMap(), false, true);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n3 = 0;
            while (n3 < stringArray.length) {
                hashMap.put(String.valueOf(stringArray[n3][6]) + ":" + stringArray[n3][7], n3);
                ++n3;
            }
            n3 = 0;
            while (n3 < stringArray2.length) {
                Integer n4 = (Integer)hashMap.get(String.valueOf(stringArray2[n3][6]) + ":" + stringArray2[n3][7]);
                if (n4 != null && (stringArray[n4][0] == null ? stringArray2[n3][0] != null : !stringArray[n4][0].equals(stringArray2[n3][0]))) {
                    this.a.setIndex(stringArray2[n3][0], n4.intValue(), 0);
                }
                if (n4 != null && (stringArray[n4][3] == null ? stringArray2[n3][3] != null : !stringArray[n4][3].equals(stringArray2[n3][3]))) {
                    this.a.setIndex(stringArray2[n3][3], n4.intValue(), 3);
                }
                ++n3;
            }
        }

        private void b(int n2, Material material, String[][] stringArray) {
            String[][] stringArray2 = MaterialUtil.createTableForPropertyGroupParent(material, material.getUsedPhysicalQuantityMap(), false, true);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3][7].equals(stringArray[n2][7])) {
                    hashMap.put(String.valueOf(stringArray[n3][6]) + ":" + stringArray[n3][7], n3);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < stringArray2.length) {
                Integer n4 = (Integer)hashMap.get(String.valueOf(stringArray2[n3][6]) + ":" + stringArray2[n3][7]);
                if (n4 != null && (stringArray[n4][0] == null ? stringArray2[n3][0] != null : !stringArray[n4][0].equals(stringArray2[n3][0]))) {
                    this.a.setIndex(stringArray2[n3][0], n4.intValue(), 0);
                }
                ++n3;
            }
        }

        @Override
        public String[][] getStringMatrix() {
            int n2 = this.b.getEventType();
            try {
                if (n2 == MaterialDB.EventType.SELECTIONCHANGE.ordinal()) {
                    MaterialUtil.updateUsedPQ(this.b, new int[0]);
                }
                if (n2 >= MaterialDB.EventType.MODELCHANGE.ordinal()) {
                    String[][] stringArray = MaterialUtil.createTable(this.b, this.d);
                    this.b.setTmpProp(stringArray);
                }
            }
            finally {
                this.b.setEventType(MaterialDB.EventType.NOCHANGE.ordinal());
            }
            return this.b.getTmpProp();
        }
    }

    public static interface IMaterialSetGetList {
        public void move(int var1, int var2);

        public void remove(int var1);

        public void remove(String var1);

        public int size();

        public Object get(int var1);

        public String getString(int var1);

        default public int findListIndexFromTag(String string, int n2, int n3) {
            if (n2 < n3) {
                int n4 = n2;
                while (n4 < n3) {
                    if (this.getString(n4).equals(string)) {
                        return n4;
                    }
                    ++n4;
                }
            } else {
                int n5 = n2 - 1;
                while (n5 >= n3) {
                    if (this.getString(n5).equals(string)) {
                        return n5;
                    }
                    --n5;
                }
            }
            return -1;
        }
    }

    public static class IconComparator
    implements Comparator<String[]> {
        private final boolean a;

        public IconComparator(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public int compare(String[] stringArray, String[] stringArray2) {
            return MaterialUtil.b(stringArray[0], this.a) - MaterialUtil.b(stringArray2[0], this.a);
        }
    }

    public static enum ListType {
        OUTPUT(0, 3, 4, 1, 2, 5, 6),
        QUANTITIES(0, 3, 4, 1, 2, 5),
        PARMETERS(0, 1, 2, 3),
        INPUTS(0, 3, 4);

        private final int[] cols;

        private ListType(int ... nArray) {
            this.cols = nArray;
        }

        public int[] getCol() {
            return this.cols;
        }
    }

    public static enum MAT_INFO_TYPE {
        DIN,
        UNS;


        public String getDescr() {
            return "#" + this.name();
        }

        public static String[] getTypes() {
            return (String[])Stream.of(MAT_INFO_TYPE.values()).map(mAT_INFO_TYPE -> mAT_INFO_TYPE.name()).toArray(String[]::new);
        }

        public static String[] getDescriptions() {
            return (String[])Stream.of(MAT_INFO_TYPE.values()).map(mAT_INFO_TYPE -> mAT_INFO_TYPE.getDescr()).toArray(String[]::new);
        }

        public static MAT_INFO_TYPE getType(String string) {
            MAT_INFO_TYPE[] mAT_INFO_TYPEArray = MAT_INFO_TYPE.values();
            int n2 = mAT_INFO_TYPEArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MAT_INFO_TYPE mAT_INFO_TYPE = mAT_INFO_TYPEArray[n3];
                if (mAT_INFO_TYPE.name().equalsIgnoreCase(string)) {
                    return mAT_INFO_TYPE;
                }
                ++n3;
            }
            return null;
        }
    }

    private static class a
    implements Comparator<bf> {
        private final Collator a = Collator.getInstance(FlLocale.getLocale());
        private final String b = FlLocale.getString((String)"Basic_properties", (boolean)true);

        private a() {
        }

        public int a(bf bf2, bf bf3) {
            if (this.b.equals(bf2.c())) {
                return -1;
            }
            if (this.b.equals(bf3.c())) {
                return 1;
            }
            return this.a.compare(bf2.c(), bf3.c());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((bf)object, (bf)object2);
        }
    }

    public static class MaterialSelectionFilter
    extends SelectionFilterAdapter {
        protected Material a;

        public MaterialSelectionFilter(Material material) {
            this.a = material;
        }

        private String[] a() {
            ModelNode modelNode = this.a.getParentModel();
            return modelNode == null ? new String[]{} : modelNode.getAllGeom();
        }

        @Override
        public String[] getAllowedGeometries() {
            return this.a();
        }

        @Override
        public ISelectionFilter.DomainStatusInfo getDomainStatus(int n2, boolean bl2) {
            MaterialList materialList = (MaterialList)ModelEntityUtil.getContainingList(this.a);
            try {
                Object object;
                if (this.a.getParentModel() == null) {
                    return null;
                }
                if (materialList != null) {
                    this.initializeSelectionFilterCache();
                    object = materialList.getFilteredDomains(this.a.tag());
                    if (object != null && (!bl2 || ((ISelectionFilter.DomainStatusInfo)object).isOverrideInfoAdded())) {
                        Object object2 = object;
                        return object2;
                    }
                }
                object = this.a.selection().getGeomSequence();
                int n3 = object.getNEntities()[n2];
                int n4 = SelectionModelUtil.getMinEntityIndex((IGeomSequence)object, n2);
                ISelectionFilter.DomainStatusInfo domainStatusInfo = new ISelectionFilter.DomainStatusInfo(n3, n4, ISelectionFilter.DomainStatus.VALID);
                if (!this.allowVoidDomains()) {
                    domainStatusInfo.setStatusToIndex(0, ISelectionFilter.DomainStatus.NOTAPPLICABLE);
                }
                if (materialList != null) {
                    int n5;
                    int n6;
                    int n7;
                    int[] nArray;
                    int n8;
                    int n9;
                    Object object3;
                    CsBitSet csBitSet = null;
                    if (bl2) {
                        csBitSet = new CsBitSet(n4, n3 + 1);
                        object3 = this.a.selection().unfilteredEntities(n2);
                        n9 = ((int[])object3).length;
                        n8 = 0;
                        while (n8 < n9) {
                            int n10 = object3[n8];
                            csBitSet.a(n10);
                            ++n8;
                        }
                    }
                    List list = materialList.getListView();
                    n8 = materialList.index(this.a.tag());
                    n9 = list.size() - 1;
                    while (n9 > n8) {
                        object3 = (Material)list.get(n9);
                        if (this.a((Material)object3)) {
                            nArray = object3.selection().entities(n2);
                            n7 = nArray.length;
                            n6 = 0;
                            while (n6 < n7) {
                                n5 = nArray[n6];
                                domainStatusInfo.setStatus(n5, ISelectionFilter.DomainStatus.SHADOWED);
                                if (bl2 && csBitSet.b(n5)) {
                                    domainStatusInfo.addOverriddenBy((SelectionEntity)object3, null);
                                }
                                ++n6;
                            }
                        }
                        --n9;
                    }
                    if (bl2) {
                        n9 = n8 - 1;
                        while (n9 >= 0) {
                            object3 = (Material)list.get(n9);
                            if (this.a((Material)object3)) {
                                nArray = object3.selection().unfilteredEntities(n2);
                                n7 = nArray.length;
                                n6 = 0;
                                while (n6 < n7) {
                                    n5 = nArray[n6];
                                    if (csBitSet.b(n5)) {
                                        domainStatusInfo.addOverrides((SelectionEntity)object3, null);
                                        break;
                                    }
                                    ++n6;
                                }
                            }
                            --n9;
                        }
                        domainStatusInfo.setOverrideInfoAdded();
                    }
                    materialList.cacheFilteredDomains(this.a.tag(), domainStatusInfo);
                }
                ISelectionFilter.DomainStatusInfo domainStatusInfo2 = domainStatusInfo;
                return domainStatusInfo2;
            }
            finally {
                this.clearSelectionFilterCache();
            }
        }

        @Override
        public void initializeSelectionFilterCache() {
            MaterialList materialList = (MaterialList)ModelEntityUtil.getContainingList(this.a);
            if (materialList != null) {
                materialList.initializeSelectionFilterCache(this.a.tag());
            }
        }

        @Override
        public void clearSelectionFilterCache() {
            MaterialList materialList = (MaterialList)ModelEntityUtil.getContainingList(this.a);
            if (materialList != null) {
                materialList.clearSelectionFilterCache(this.a.tag());
            }
        }

        protected boolean a(Material material) {
            String string = this.a.selection().geom();
            return material.isActive() && material.hasSelection() && string.equals(material.selection().geom());
        }

        @Override
        public boolean domainFiltering() {
            return this.a.getParentModel() != null;
        }

        @Override
        public int[] getAllowedEDims() {
            ModelNode modelNode = this.a.getParentModel();
            if (modelNode != null && modelNode.getGeom() != null) {
                return this.a.getOperation().getAllowedEdims(this.a, modelNode.getGeom().getSDim());
            }
            return new int[0];
        }

        @Override
        public boolean allowVoidDomains() {
            return true;
        }

        @Override
        public ISelectionFilter.SelectionType[] getAllowedTypes() {
            if (this.a.getStoredParent() != null) {
                return new ISelectionFilter.SelectionType[]{ISelectionFilter.SelectionType.GEOMDIM};
            }
            return new ISelectionFilter.SelectionType[0];
        }
    }

    public static class MaterialShiftInfo
    extends EntityBaseDimensionInfo {
        private String a;

        public MaterialShiftInfo(String string) {
            super(null, null);
            this.a = string;
        }

        public String getMaterialRequest() {
            return this.a;
        }

        @Override
        public boolean isIntersected(EntityBaseDimensionInfo entityBaseDimensionInfo) {
            return this.equals(entityBaseDimensionInfo);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof MaterialShiftInfo && this.a.equals(((MaterialShiftInfo)object).a);
        }

        @Override
        public int hashCode() {
            return this.a == null ? super.hashCode() : this.a.hashCode();
        }

        @Override
        public String toString() {
            return "All dimensions for " + this.a;
        }
    }

    public static class MaterialTableRowUnitCheck
    extends du {
        private by a;
        private String b;
        private final int c;
        private final int i;
        private final int j;

        public MaterialTableRowUnitCheck(int n2, int n3, int n4, int n5, IUnitConverter iUnitConverter, Material material) {
            super(n2, n3, iUnitConverter, (w)material);
            this.c = n4;
            this.i = n2;
            this.j = n5;
        }

        public void setGetSetHandler(by by2) {
            this.a = by2;
        }

        protected String a() {
            if (this.c >= 0 && this.b != null) {
                return String.valueOf(this.g.scopeDot()) + this.b + ".";
            }
            return super.a();
        }

        public String[][] getUnitError(String[][] stringArray, int n2) {
            if (this.a != null) {
                stringArray = this.a.getStringMatrix();
            }
            return super.getUnitError(stringArray, n2);
        }

        public String getUnitError(String[][] stringArray, int n2, int n3, int n4) {
            if (this.a != null) {
                stringArray = this.a.getStringMatrix();
            }
            return super.getUnitError(stringArray, n2, n3, n4);
        }

        protected String[] a(String[] stringArray, int n2) {
            String[][] stringArray2;
            MaterialModel materialModel;
            MaterialModel materialModel2 = null;
            if (((Material)this.g).propertyGroup().hasTag(stringArray[this.c])) {
                materialModel2 = ((Material)this.g).propertyGroup(stringArray[this.c]);
                this.b = materialModel2.getIdentifier();
            } else {
                materialModel = PhysicalQuantityManager.getApplMaterialModel(stringArray[this.c]);
                String string = this.b = materialModel != null ? materialModel.getIdentifier() : null;
            }
            if (stringArray[3].equals(MaterialDB.MatRes.Derived.descr())) {
                return new String[stringArray.length];
            }
            if (materialModel2 != null && (materialModel = materialModel2.getSpec(stringArray[this.j]).getCheck(materialModel2)) != ParamSpec.emptyExpressionCheck && (stringArray2 = materialModel.getUnitError(stringArray[this.i], n2, materialModel2)) != null) {
                String[] stringArray3 = new String[stringArray.length];
                stringArray3[this.i] = stringArray2[0][0];
                return stringArray3;
            }
            return super.a(stringArray, n2);
        }
    }

    public static class MaterialTableValueCheck
    extends dd {
        private final int a;
        private final int b;
        private final int c;
        private final Material d;

        public MaterialTableValueCheck(int n2, int n3, int n4, Material material) {
            this.a = n3;
            this.b = n2;
            this.c = n4;
            this.d = material;
        }

        public boolean isValid(String[] stringArray) {
            dd dd2;
            MaterialModel materialModel;
            return !this.d.propertyGroup().hasTag(stringArray[this.a]) || !(materialModel = this.d.propertyGroup(stringArray[this.a])).hasParam(stringArray[this.c]) || (dd2 = materialModel.getSpec(stringArray[this.c]).getCheck(materialModel)) == null || dd2.isValid(stringArray[this.b], (u)this.d);
        }

        public boolean isValid(String[][] stringArray) {
            String[][] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String[] stringArray3 = stringArray2[n3];
                if (!this.isValid(stringArray3)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }

        public String[][] getCheckError(String[][] stringArray) {
            String[][] stringArray2 = new String[stringArray.length][];
            int n2 = 0;
            while (n2 < stringArray.length) {
                dd dd2;
                MaterialModel materialModel;
                stringArray2[n2] = new String[stringArray[n2].length];
                if (this.d.propertyGroup().hasTag(stringArray[n2][this.a]) && (materialModel = this.d.propertyGroup(stringArray[n2][this.a])).hasParam(stringArray[n2][this.c]) && (dd2 = materialModel.getSpec(stringArray[n2][this.c]).getCheck(materialModel)) != null) {
                    stringArray2[n2][this.b] = dd2.getCheckError(stringArray[n2][this.b], (u)materialModel);
                }
                ++n2;
            }
            return stringArray2;
        }

        public String[] describeValid() {
            String[] stringArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[][] stringArray2 = this.d.getTmpProp();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                dd dd2;
                MaterialModel materialModel;
                if (this.d.propertyGroup().hasTag(stringArray2[n2][this.a]) && (materialModel = this.d.propertyGroup(stringArray2[n2][this.a])).hasParam(stringArray2[n2][this.c]) && (dd2 = materialModel.getSpec(stringArray2[n2][this.c]).getCheck(materialModel)) != null && dd2.getCheckError(stringArray2[n2][this.b], (u)materialModel) != null) {
                    String[] stringArray3 = dd2.describeValid();
                    int n3 = stringArray3.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string = stringArray3[n4];
                        arrayList.add(string);
                        ++n4;
                    }
                }
                ++n2;
            }
            if (arrayList.isEmpty()) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "Invalid_parameter_value";
            } else {
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
            return stringArray;
        }
    }

    public static enum PgCol {
        pName,
        value,
        unit,
        descr,
        varName,
        size,
        info;


        public void set(String string, String[] stringArray) {
            stringArray[this.ordinal()] = string;
        }

        public String get(String[] stringArray) {
            return stringArray[this.ordinal()];
        }
    }

    public static class PhysicalSymbolProvider
    extends PropAnnotationInfo.ad {
        private final String a;
        private final u b;

        public PhysicalSymbolProvider(u u2, String string) {
            super("");
            this.b = u2;
            this.a = string;
        }

        public String getSymbol() {
            String string = this.b.getString(this.a);
            if (PhysicalQuantityManager.isID(string)) {
                IPhysicalQuantity iPhysicalQuantity = PhysicalQuantityManager.getID(string);
                return "\\[" + iPhysicalQuantity.symbol() + "\\]";
            }
            return "1";
        }
    }

    public static class ShellWrappedCheck
    extends dd {
        private final String a;
        private final MaterialModel b;
        private final Material c;

        public ShellWrappedCheck(String string, MaterialModel materialModel) {
            this.a = string;
            this.b = materialModel;
            this.c = null;
        }

        public ShellWrappedCheck(String string, Material material) {
            this.a = string;
            this.c = material;
            this.b = null;
        }

        private <T> T a(Function<dd, T> function, T t2) {
            MaterialModel materialModel = this.a();
            if (materialModel != null) {
                dd dd2 = materialModel.getSpec(this.a).getCheck(materialModel);
                return function.apply(dd2);
            }
            return t2;
        }

        private MaterialModel a() {
            if (this.b != null) {
                return this.b;
            }
            if (this.c != null) {
                if (this.c.propertyGroup().hasTag("shell")) {
                    return this.c.propertyGroup("shell");
                }
                PrimitiveModelEntity primitiveModelEntity = this.c;
                while (primitiveModelEntity != null) {
                    if (!((primitiveModelEntity = primitiveModelEntity.getContainer()) instanceof Material) || !primitiveModelEntity.propertyGroup().hasTag("shell")) continue;
                    return ((Material)primitiveModelEntity).propertyGroup("shell");
                }
            }
            return null;
        }

        public UnitCheck getUnit() {
            UnitCheck unitCheck = this.a((dd dd2) -> dd2.getUnit(), null);
            if (unitCheck != null) {
                unitCheck.setCurrentParameterContainer((u)this.a());
            }
            return unitCheck;
        }

        public boolean isValid(String string) {
            return this.a((dd dd2) -> dd2.isValid(string, (u)this.a()), true);
        }

        public String getCheckError(String string) {
            return this.a((dd dd2) -> dd2.getCheckError(string, (u)this.a()), null);
        }

        public String[][] getUnitError(String string, int n2) {
            return this.a((dd dd2) -> dd2.getUnitError(string, n2, (u)this.a()), null);
        }

        public String[] describeValid() {
            return this.a((dd dd2) -> dd2.describeValid((u)this.a()), LayeredShellData.NONE);
        }
    }

    public static class TreeGetSetHandler
    extends AbstractModelEntityGetSetHandler {
        private final Material a;

        public TreeGetSetHandler(Material material) {
            super(material);
            this.a = material;
        }

        @Override
        public void set(String[] stringArray) {
            if (stringArray.length > 2) {
                if (stringArray[1].equals("quantitiesNode")) {
                    MaterialModel materialModel = this.a.propertyGroup(MaterialDB.MatRes.def.name());
                    if (!materialModel.hasParam(stringArray[2])) {
                        PhysicalQuantityManager.getID(stringArray[2]);
                        materialModel.set(stringArray[2], "");
                        this.a.setEventType(MaterialDB.EventType.MODELCHANGE.ordinal());
                        this.a.touch();
                    }
                } else {
                    int n2 = stringArray.length - 1;
                    while (n2 > 0) {
                        if (PhysicalQuantityManager.getApplMaterialModel(stringArray[n2]) != null) {
                            MaterialModel materialModel = this.a.getModel().physics().propertyGroup(stringArray[n2]);
                            this.a.propertyGroup().create(materialModel.tag(), materialModel.label());
                            this.a.setEventType(MaterialDB.EventType.MODELCHANGE.ordinal());
                            this.a.touch();
                            break;
                        }
                        --n2;
                    }
                }
            }
            this.a.setEventType(MaterialDB.EventType.NOCHANGE.ordinal());
        }
    }

    public static class UnitAndSizePrettyfier
    extends UnitPrettyfier {
        private int a;

        public UnitAndSizePrettyfier(int n2, int n3, by by2) {
            super(n2, by2);
            this.a = n3;
        }

        @Override
        public String[][] getStringMatrix(bx bx2) {
            String[][] stringArray;
            String[][] stringArray2 = stringArray = super.getStringMatrix(bx2);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String[] stringArray3 = stringArray2[n3];
                stringArray3[this.a] = UnitAndSizePrettyfier.a(stringArray3[this.a]);
                stringArray3[PgCol.info.ordinal()] = stringArray3[PgCol.info.ordinal()].isEmpty() ? null : "about_information.png";
                ++n3;
            }
            return stringArray;
        }

        private static String a(String string) {
            Matcher matcher = Pattern.compile("\\d+").matcher(string);
            matcher.find();
            int n2 = matcher.start();
            String string2 = string.substring(n2, string.length());
            String string3 = string.substring(0, n2);
            if (string3.length() > 0) {
                if (PropAnnotationInfo.EditFieldInfo.MatrixSymmetry.a.name().equals(string3)) {
                    return FlLocale.getString((String)("Isotropic[matrix]_X#" + string2));
                }
                if (PropAnnotationInfo.EditFieldInfo.MatrixSymmetry.b.name().equals(string3)) {
                    return FlLocale.getString((String)("Diagonal[matrix]_X#" + string2));
                }
                if (PropAnnotationInfo.EditFieldInfo.MatrixSymmetry.c.name().equals(string3) || PropAnnotationInfo.EditFieldInfo.MatrixSymmetry.e.name().equals(string3)) {
                    return FlLocale.getString((String)("Symmetric[matrix]_X#" + string2));
                }
            }
            return string2;
        }
    }

    public static class UnitAndVariablePrettyfier
    extends UnitPrettyfier {
        public UnitAndVariablePrettyfier(by by2) {
            super(4, by2);
        }

        @Override
        public String[][] getStringMatrix(bx bx2) {
            String[][] stringArray;
            String[][] stringArray2 = stringArray = super.getStringMatrix(bx2);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                block7: {
                    Object object;
                    int n4;
                    String string;
                    String[] stringArray3;
                    block6: {
                        stringArray3 = stringArray2[n3];
                        string = stringArray3[7];
                        if (PhysicalQuantityManager.isID(string)) {
                            string = PhysicalQuantityManager.getID(string).varName();
                        }
                        n4 = 1;
                        try {
                            if (!stringArray3[3].contains("{") || !(object = (Object)ExprParser.a((String)stringArray3[3], (boolean)true)).c(0).z()) break block6;
                            n4 = object.c(0).k();
                        }
                        catch (FlException flException) {
                            break block7;
                        }
                    }
                    if ((object = MaterialUtil.stringToSize(stringArray3[8])) != null) {
                        stringArray3[2] = MaterialUtil.paramToString(string, n4, object);
                    }
                    if ("shell".equals(stringArray3[6]) && LayeredShellPropID.ROTATION.varName().equals(string)) {
                        stringArray3[4] = "deg";
                    }
                }
                ++n3;
            }
            return stringArray;
        }
    }

    public static class UnitPrettyfier
    implements PropAnnotationInfo.af {
        private final by a;
        private final int b;

        public UnitPrettyfier(int n2, by by2) {
            this.a = by2;
            this.b = n2;
        }

        public String[][] getStringMatrix(bx bx2) {
            String[][] stringArray;
            String[][] stringArray2 = stringArray = FlStringUtil.copy((String[][])this.a.getStringMatrix());
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String[] stringArray3 = stringArray2[n3];
                stringArray3[this.b] = FlStringUtil.convertUnitToUnicode((String)stringArray3[this.b], (FlStringUtil.DegreeFormat)FlStringUtil.DegreeFormat.c);
                ++n3;
            }
            return stringArray;
        }

        public String[] getStringArray(bx bx2) {
            throw new UnsupportedOperationException();
        }

        public int[] translateIndex(int n2, int n3) {
            return new int[]{n2, n3};
        }
    }

    private static class ValidSel {
        Status a = Status.a;
        SimpleSelection b = null;

        private ValidSel() {
        }

        public ValidSel a(SimpleSelection simpleSelection) {
            if (this.a == Status.c) {
                this.b = this.b.union(simpleSelection);
            } else {
                this.a = Status.c;
                this.b = simpleSelection;
            }
            return this;
        }

        public ValidSel a() {
            this.a = Status.b;
            this.b = null;
            return this;
        }

        boolean a(ValidSel validSel) {
            switch (this.a) {
                case a: {
                    return validSel.a != Status.b;
                }
                case b: {
                    return false;
                }
                case c: {
                    switch (validSel.a) {
                        case b: {
                            return false;
                        }
                        case a: {
                            return true;
                        }
                        case c: {
                            return !this.b.intersection(validSel.b).isEmpty();
                        }
                    }
                }
            }
            return false;
        }

        boolean a(Selection selection) {
            switch (this.a) {
                case a: {
                    return true;
                }
                case b: {
                    return false;
                }
                case c: {
                    return !this.b.intersection(selection).isEmpty();
                }
            }
            return false;
        }

        public String toString() {
            switch (this.a) {
                case b: {
                    return "Allows nothing";
                }
                case a: {
                    return "Allows all entities";
                }
                case c: {
                    return "Allows " + this.b.toString();
                }
            }
            return "";
        }

        private static enum Status {
            a,
            b,
            c;

        }
    }
}

