/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.HideGeom;
import com.comsol.model.dbimodel.HideGeomList;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.View;
import com.comsol.model.dbimodel.WorkPlaneFeature;
import com.comsol.model.method.ModelEntityListMethod;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.selections.GeometrySelectionFilter;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.util.ViewUtil;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.q;

public class HideGeomListMethod<T extends HideGeom>
extends ModelEntityListMethod<T> {
    public HideGeomListMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public HideGeomList<T> getMe() {
        return (HideGeomList)this.u();
    }

    public HideGeom create(String string) {
        this.checkContains(string);
        IGeomSequence iGeomSequence = ((View)this.getMe().getContainer()).getGeomSequence();
        if (iGeomSequence == null) {
            throw new FlException("Hide_features_can_only_be_added_to_views_associated_with_a_geometry");
        }
        if (iGeomSequence.getContainer() instanceof WorkPlaneFeature) {
            throw new FlException("Hide_feature_of_the_type_Geometry_cannot_be_added_to_work_plane_views");
        }
        HideGeom hideGeom = this.getMe().createInstance(string);
        hideGeom.tag(string);
        this.getMe().internalAdd(-1, hideGeom);
        if (this.f()) {
            for (HideGeomList hideGeomList : ViewUtil.getAllHideGeomLists(this.getModel(), iGeomSequence, ((View)this.getMe().getContainer()).tag())) {
                if (hideGeomList == this.getMe()) continue;
                if (hideGeomList.index(string) >= 0) {
                    hideGeomList.remove(string);
                }
                hideGeomList.create(string);
            }
        }
        return hideGeom;
    }

    @Override
    public void remove(String string) {
        IGeomSequence iGeomSequence = null;
        if (this.getMe().index(string) >= 0) {
            iGeomSequence = ((HideGeom)this.b(string)).getGeomSequence();
        }
        super.remove(string);
        if (this.f()) {
            for (HideGeomList hideGeomList : ViewUtil.getAllHideGeomLists(this.getModel(), iGeomSequence, ((View)this.getMe().getContainer()).tag())) {
                if (hideGeomList == this.getMe() || hideGeomList.index(string) < 0) continue;
                hideGeomList.remove(string);
            }
        }
    }

    public void clear() {
        if (this.f()) {
            for (HideGeomList hideGeomList : ViewUtil.getAllHideGeomLists(this.getModel(), ((View)this.getMe().getContainer()).tag())) {
                if (hideGeomList == this.getMe()) continue;
                hideGeomList.clear();
            }
        }
    }

    protected boolean f() {
        return true;
    }

    public ISelectionFilter getSelectionFilter(AbstractSelection abstractSelection) {
        IGeomSequence iGeomSequence = ((View)this.getMe().getContainer()).getGeomSequence();
        return new GeometrySelectionFilter(iGeomSequence, q.a((int)0, (int)1, (int)iGeomSequence.getSDim()));
    }

    public void createReset(HideGeomList<? extends HideGeom> hideGeomList, boolean bl2) {
        this.createResetCommon(hideGeomList, bl2);
        for (HideGeom hideGeom : this.getMe()) {
            HideGeom hideGeom2;
            if (hideGeom.isAutoGenerated()) continue;
            HideGeom hideGeom3 = hideGeom2 = hideGeomList.hasTag(hideGeom.tag()) ? (HideGeom)hideGeomList.get(hideGeom.tag()) : null;
            if (hideGeom2 == null) {
                hideGeom2 = hideGeomList.create(hideGeom.tag());
            }
            hideGeom.createReset(hideGeom2, bl2);
        }
    }

    @Override
    protected String a() {
        return FlLocale.getString((String)"Hidden_entities");
    }

    @Override
    public T copy(String string, String string2) {
        String[] stringArray = string2.split("/");
        if (stringArray.length != 2) {
            throw new FlException("Found_no_feature_to_copy");
        }
        HideGeom hideGeom = this.getModel().view(stringArray[0]).hideEntities(stringArray[1]);
        HideGeom hideGeom2 = this.getMe().create(string);
        hideGeom.selectionMethod().createDuplicate(hideGeom2);
        return (T)hideGeom2;
    }

    public HideGeom duplicate(String string, String string2) {
        HideGeom hideGeom = (HideGeom)this.getMe().get(string2);
        HideGeom hideGeom2 = this.getMe().create(string);
        hideGeom.selectionMethod().createDuplicate(hideGeom2);
        return hideGeom2;
    }

    public void move(String string, int n2) {
        if (this.f()) {
            for (HideGeomList hideGeomList : ViewUtil.getAllHideGeomLists(this.getModel(), ((View)this.getMe().getContainer()).tag())) {
                if (hideGeomList == this.getMe()) continue;
                hideGeomList.move(string, n2);
            }
        }
    }
}

