/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.UNIT_TYPES;
import com.comsol.model.dbimodel.Unit;
import com.comsol.model.method.ModelEntityMethod;
import com.comsol.model.method.PrimitiveModelEntityMethod;
import com.comsol.model.method.UnitSystemMethod;
import com.comsol.model.method.internal.IUnitInternal;
import com.comsol.model.method.internal.IUnitSystemInternal;
import com.comsol.model.util.UnitUtil;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlStringUtil;
import java.util.Arrays;

public class UnitMethod
extends ModelEntityMethod {
    public UnitMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public IUnitInternal getMe() {
        return (IUnitInternal)this.u();
    }

    @Override
    public String toString() {
        IUnitInternal iUnitInternal = this.getMe();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Dimension: ").append(Arrays.toString(iUnitInternal.dimension())).append("\n").append("Symbol:    ").append(iUnitInternal.symbol()).append("\n").append("Name:      ").append(iUnitInternal.tag()).append("\n");
        if (iUnitInternal.scale() != 1.0) {
            stringBuilder.append("Scale:     ").append(iUnitInternal.scale());
        }
        if (iUnitInternal.offset() != 0.0) {
            stringBuilder.append("Offset:    ").append(iUnitInternal.offset());
        }
        return stringBuilder.toString();
    }

    public void createReset(Unit unit, boolean bl2) {
        IUnitInternal iUnitInternal = (IUnitInternal)unit;
        IUnitInternal iUnitInternal2 = this.getMe();
        this.createResetCommon(iUnitInternal, bl2);
        if (!bl2) {
            Object[] objectArray;
            String string;
            int[] nArray = iUnitInternal2.dimension();
            if (!Arrays.equals(nArray, iUnitInternal.dimension())) {
                iUnitInternal.setDimension(nArray);
            }
            if ((string = iUnitInternal2.symbol()) != null && !string.equals(iUnitInternal.symbol())) {
                iUnitInternal.symbol(string);
            }
            if (iUnitInternal2.scale() != iUnitInternal.scale()) {
                iUnitInternal.scale(iUnitInternal2.scale());
            }
            if (iUnitInternal2.getSiScale() != iUnitInternal.getSiScale()) {
                iUnitInternal.setSiScale(iUnitInternal2.getSiScale());
            }
            if (iUnitInternal2.offset() != iUnitInternal.offset()) {
                iUnitInternal.offset(iUnitInternal2.offset());
            }
            if (!Arrays.equals(objectArray = iUnitInternal2.aliases(), iUnitInternal.aliases())) {
                iUnitInternal.aliases((String[])objectArray);
            }
            int[] nArray2 = iUnitInternal2.getPowers();
            Object[] objectArray2 = iUnitInternal2.getUnits();
            if (!Arrays.equals(nArray2, iUnitInternal.getPowers()) || !Arrays.equals(objectArray2, iUnitInternal.getUnits())) {
                iUnitInternal.definition((String[])objectArray2, nArray2);
            }
            if (iUnitInternal2.isPrefixAllowed() != iUnitInternal.isPrefixAllowed()) {
                iUnitInternal.setPrefixAllowed(iUnitInternal2.isPrefixAllowed());
            }
        }
    }

    public static String symbol(IUnitInternal iUnitInternal) {
        String string = iUnitInternal.getSymbol();
        if (string != null) {
            return string;
        }
        IUnitSystemInternal iUnitSystemInternal = iUnitInternal.getSystem();
        string = UnitUtil.getBaseUnitPowers(iUnitSystemInternal, iUnitInternal.dimension());
        if (iUnitSystemInternal == null) {
            return string;
        }
        String[] stringArray = iUnitInternal.getUnits();
        if (stringArray != null && stringArray.length > 0) {
            int[] nArray = iUnitInternal.getPowers();
            string = FlStringUtil.getUnitExpr((String[])stringArray, (int[])nArray);
        }
        return string;
    }

    public void symbol(String string) {
        String string2 = this.getMe().symbol();
        this.getMe().setSymbol(string);
        PrimitiveModelEntityMethod primitiveModelEntityMethod = this.getContainer().getContainer();
        ((UnitSystemMethod)primitiveModelEntityMethod).a(this.getMe(), string2);
    }

    public void aliases(String[] stringArray) {
        String[] stringArray2 = this.getMe().getAliases();
        this.getMe().setAliases(stringArray);
        PrimitiveModelEntityMethod primitiveModelEntityMethod = this.getContainer().getContainer();
        ((UnitSystemMethod)primitiveModelEntityMethod).a(this.getMe(), stringArray2);
    }

    public void definition(String[] stringArray, int[] nArray) {
        UNIT_TYPES uNIT_TYPES = this.getMe().getType();
        if (uNIT_TYPES == UNIT_TYPES.DERIVED || uNIT_TYPES == UNIT_TYPES.ADDITIONAL) {
            Unit unit;
            this.getMe().setUnits(stringArray, nArray);
            String string = "1[" + FlStringUtil.getUnitExpr((String[])stringArray, (int[])nArray) + "]";
            int[] nArray2 = this.getModel().getConverter().getDimension(string, 2);
            if (!Arrays.equals(this.getMe().dimension(), nArray2)) {
                throw new FlException("Derived_dimension_is_invalid");
            }
            if (stringArray.length > 0 && this.getMe().getSymbol() == null && this.getMe().getSystem() != null && (unit = this.getMe().getSystem().getUnit(stringArray[0], true)) != null && !unit.isPrefixAllowed()) {
                this.getMe().setPrefixAllowed(false);
            }
        } else {
            throw new FlException("Only_supported_for_derived_units");
        }
    }
}

