/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations;

import com.comsol.model.applapi.SDimType;
import com.comsol.model.dbimodel.Coordsys;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.Type;
import com.comsol.model.operations.operationID.IOperationID;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;

public enum CoordsysID implements IOperationID
{
    VectorBase("Base_vector_system", "base", SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED),
    Combined("Combined_system", "comb", SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED),
    Mapping("Mapped_system", "map", SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED),
    Scaling("Scaling_system", "scaling", SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED),
    AbsorbingLayer("Absorbing_layer", "ab", Type.b, SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED),
    InfiniteElement("Infinite_element_domain", "ie", Type.b, SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED),
    PML("Perfectly_matched_layer", "pml", Type.b, SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED),
    Boundary("Boundary_system", "bnd", SDimType.THREED, SDimType.AXI2D, SDimType.TWOD),
    Rotated("Rotated_system", "rot", SDimType.THREED, SDimType.AXI2D, SDimType.TWOD),
    Cylindrical("Cylindrical_system", "cyl", SDimType.THREED, SDimType.TWOD),
    Spherical("Spherical_system", "sph", SDimType.THREED),
    FromGeometry("System_from_geometry", "fg", SDimType.THREED),
    Composite("Composite_system", "comp", SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED),
    ReverseNormal("Reverse_normal", "rn", Type.c, SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED),
    DomainNormal("Domain_normal", "dn", Type.c, SDimType.THREED, SDimType.AXI2D, SDimType.TWOD, SDimType.AXI1D, SDimType.ONED);

    private final String descr;
    private final String shortName;
    private final HashSet<SDimType> validSDimTypes;
    private final Type type;
    public static final String[] AllCoordinateSystemIDs;
    public static final CoordsysID[] AllTopLevelIDs;
    private static /* synthetic */ int[] a;

    static {
        Predicate<CoordsysID> predicate = coordsysID -> !coordsysID.isDomainProperty() && !coordsysID.isGeometryNormal();
        AllCoordinateSystemIDs = (String[])Arrays.stream(CoordsysID.values()).filter(predicate).map(coordsysID -> coordsysID.name()).toArray(String[]::new);
        AllTopLevelIDs = (CoordsysID[])Arrays.stream(CoordsysID.values()).filter(coordsysID -> coordsysID.allowedOnTopLevel()).toArray(CoordsysID[]::new);
    }

    private CoordsysID(String string2, String string3, SDimType ... sDimTypeArray) {
        this.descr = string2;
        this.shortName = string3;
        this.type = Type.a;
        this.validSDimTypes = new HashSet<SDimType>(Arrays.asList(sDimTypeArray));
    }

    private CoordsysID(String string2, String string3, Type type, SDimType ... sDimTypeArray) {
        this.descr = string2;
        this.shortName = string3;
        this.type = type;
        this.validSDimTypes = new HashSet<SDimType>(Arrays.asList(sDimTypeArray));
    }

    public boolean appliesToSDimType(SDimType sDimType) {
        return this.validSDimTypes.contains((Object)sDimType);
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.name();
    }

    public boolean isDomainProperty() {
        return this.type == Type.b;
    }

    public boolean isGeometryNormal() {
        return this.type == Type.c;
    }

    public static CoordsysID get(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        CoordsysID[] coordsysIDArray = CoordsysID.values();
        int n2 = coordsysIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            CoordsysID coordsysID = coordsysIDArray[n3];
            if (coordsysID.id().equals(string)) {
                return coordsysID;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    public String action() {
        return "add_coordsys" + this.shortName;
    }

    @Override
    public String getIcon() {
        switch (CoordsysID.a()[this.ordinal()]) {
            case 8: {
                return "coordsys_boundary_coordinate.png";
            }
            case 10: {
                return "coordsys_cylindrical.png";
            }
            case 3: {
                return "coordsys_mapped_system.png";
            }
            case 9: {
                return "coordsys_rotated.png";
            }
            case 4: {
                return "scaling_system.png";
            }
            case 7: {
                return "pml_system.png";
            }
            case 6: {
                return "infinite_elements.png";
            }
            case 5: {
                return "absorbing_layer.png";
            }
            case 11: {
                return "coordsys_spherical.png";
            }
            case 1: {
                return "coordsys_vectorbase.png";
            }
            case 12: {
                return "coordsys_fromgeometry.png";
            }
            case 2: {
                return "coordsys_combined_system.png";
            }
            case 13: {
                return "coordsys_composite_system.png";
            }
            case 14: {
                return "reverse_normal.png";
            }
            case 15: {
                return "domain_normal.png";
            }
        }
        return "coordinate_systems.png";
    }

    public boolean isScalingSystem() {
        switch (CoordsysID.a()[this.ordinal()]) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean allowedOnTopLevel() {
        return !this.isAttribute(Boundary);
    }

    public boolean isAttribute(CoordsysID coordsysID) {
        switch (CoordsysID.a()[coordsysID.ordinal()]) {
            case 8: {
                switch (CoordsysID.a()[this.ordinal()]) {
                    case 14: 
                    case 15: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                return this.allowedInCombinedSystem();
            }
        }
        return false;
    }

    public boolean hasRelativeToGeomCoordsys() {
        switch (CoordsysID.a()[this.ordinal()]) {
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean allowedInCombinedSystem() {
        switch (CoordsysID.a()[this.ordinal()]) {
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature instanceof Coordsys && this.isOfType(propFeature.getOperationID());
    }

    @Override
    public boolean isOfType(String string) {
        return this.id().equals(string);
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[CoordsysID.values().length];
        try {
            nArray[CoordsysID.AbsorbingLayer.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.Boundary.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.Combined.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.Composite.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.Cylindrical.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.DomainNormal.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.FromGeometry.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.InfiniteElement.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.Mapping.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.PML.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.ReverseNormal.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.Rotated.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.Scaling.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.Spherical.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CoordsysID.VectorBase.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

