/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations;

import com.comsol.model.dbimodel.MeshFeature;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.operations.IPredefinedTable;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.i;
import com.comsol.util.methods.FlNumberUtil;
import com.comsol.util.methods.q;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class HAutoTable {
    private static final String[] a = new String[]{"Extremely_fine", "Extra_fine", "Finer", "Fine", "Normal[usual]", "Coarse", "Coarser", "Extra_coarse", "Extremely_coarse"};
    private static final String[] b = new String[]{"extremely_fine", "extra_fine", "finer", "fine", "normal", "coarse", "coarser", "extra_coarse", "extremely_coarse"};
    private double c = 1.0;
    private final int d;
    private final MeshSequence e;

    public static String[] getTableNames() {
        PredefinedTables[] predefinedTablesArray = PredefinedTables.values();
        String[] stringArray = new String[predefinedTablesArray.length];
        int n2 = 0;
        while (n2 < predefinedTablesArray.length) {
            stringArray[n2] = predefinedTablesArray[n2].toString();
            ++n2;
        }
        return stringArray;
    }

    public static String[] getTableDescriptions() {
        PredefinedTables[] predefinedTablesArray = PredefinedTables.values();
        String[] stringArray = new String[predefinedTablesArray.length];
        int n2 = 0;
        while (n2 < predefinedTablesArray.length) {
            stringArray[n2] = predefinedTablesArray[n2].getDescription();
            ++n2;
        }
        return stringArray;
    }

    public HAutoTable(MeshSequence meshSequence) {
        this.e = meshSequence;
        this.d = meshSequence.getGeom().getSDim();
    }

    public static HAutoCollection getDefaultTable2D() {
        HAutoCollection hAutoCollection = new HAutoCollection();
        hAutoCollection.hauto = new HAuto[]{new HAuto("FineLimit", hAutoCollection), new HAuto(0.01, 2.0E-5, 1.1, 0.2, 1.0, hAutoCollection), new HAuto(0.02, 7.5E-5, 1.2, 0.25, 1.0, hAutoCollection), new HAuto(0.037, 1.25E-4, 1.25, 0.25, 1.0, hAutoCollection), new HAuto(0.053, 3.0E-4, 1.3, 0.3, 1.0, hAutoCollection), new HAuto(0.067, 3.0E-4, 1.3, 0.3, 1.0, hAutoCollection), new HAuto(0.1, 0.002, 1.4, 0.4, 1.0, hAutoCollection), new HAuto(0.13, 0.006, 1.5, 0.6, 1.0, hAutoCollection), new HAuto(0.2, 0.016, 1.8, 0.8, 1.0, hAutoCollection), new HAuto(0.33, 0.05, 2.0, 1.0, 0.9, hAutoCollection)};
        return hAutoCollection;
    }

    private static HAutoCollection f() {
        HAutoCollection hAutoCollection = new HAutoCollection();
        hAutoCollection.hauto = new HAuto[]{new HAuto("FineLimit", hAutoCollection), new HAuto(0.02, 2.0E-4, 1.3, 0.2, 1.0, hAutoCollection), new HAuto(0.035, 0.0015, 1.35, 0.3, 0.85, hAutoCollection), new HAuto(0.055, 0.004, 1.4, 0.4, 0.7, hAutoCollection), new HAuto(0.08, 0.01, 1.45, 0.5, 0.6, hAutoCollection), new HAuto(0.1, 0.018, 1.5, 0.6, 0.5, hAutoCollection), new HAuto(0.15, 0.028, 1.6, 0.7, 0.4, hAutoCollection), new HAuto(0.19, 0.04, 1.7, 0.8, 0.3, hAutoCollection), new HAuto(0.3, 0.054, 1.85, 0.9, 0.2, hAutoCollection), new HAuto(0.5, 0.07, 2.0, 1.0, 0.1, hAutoCollection)};
        return hAutoCollection;
    }

    private static HAutoCollection b(int n2) {
        HashMap<Size, HAuto> hashMap = new HashMap<Size, HAuto>();
        HAutoCollectionMinDist hAutoCollectionMinDist = new HAutoCollectionMinDist(n2);
        if (n2 > 2) {
            hashMap.put(Size.EXTREMELYFINE, new HAuto(0.013, 2.0E-4, 1.05, 0.2, 1.0, hAutoCollectionMinDist));
            hashMap.put(Size.EXTRAFINE, new HAuto(0.023, 0.0015, 1.075, 0.3, 0.95, hAutoCollectionMinDist));
            hashMap.put(Size.FINER, new HAuto(0.037, 0.004, 1.1, 0.4, 0.9, hAutoCollectionMinDist));
            hashMap.put(Size.FINE, new HAuto(0.053, 0.01, 1.125, 0.5, 0.8, hAutoCollectionMinDist));
            hashMap.put(Size.NORMAL, new HAuto(0.067, 0.02, 1.15, 0.6, 0.7, hAutoCollectionMinDist));
            hashMap.put(Size.COARSE, new HAuto(0.1, 0.03, 1.2, 0.7, 0.6, hAutoCollectionMinDist));
            hashMap.put(Size.COARSER, new HAuto(0.13, 0.04, 1.25, 0.8, 0.5, hAutoCollectionMinDist));
            hashMap.put(Size.EXTRACOARSE, new HAuto(0.2, 0.05, 1.3, 0.9, 0.4, hAutoCollectionMinDist));
            hashMap.put(Size.EXTREMELYCOARSE, new HAuto(0.33, 0.07, 1.4, 1.0, 0.3, hAutoCollectionMinDist));
        } else {
            hashMap.put(Size.EXTREMELYFINE, new HAuto(0.0067, 2.0E-5, 1.05, 0.2, 1.0, hAutoCollectionMinDist));
            hashMap.put(Size.EXTRAFINE, new HAuto(0.013, 1.5E-4, 1.075, 0.25, 1.0, hAutoCollectionMinDist));
            hashMap.put(Size.FINER, new HAuto(0.028, 4.0E-4, 1.1, 0.25, 1.0, hAutoCollectionMinDist));
            hashMap.put(Size.FINE, new HAuto(0.035, 0.001, 1.125, 0.3, 1.0, hAutoCollectionMinDist));
            hashMap.put(Size.NORMAL, new HAuto(0.045, 0.002, 1.15, 0.3, 1.0, hAutoCollectionMinDist));
            hashMap.put(Size.COARSE, new HAuto(0.067, 0.003, 1.2, 0.4, 1.0, hAutoCollectionMinDist));
            hashMap.put(Size.COARSER, new HAuto(0.087, 0.004, 1.25, 0.6, 1.0, hAutoCollectionMinDist));
            hashMap.put(Size.EXTRACOARSE, new HAuto(0.13, 0.005, 1.3, 0.8, 1.0, hAutoCollectionMinDist));
            hashMap.put(Size.EXTREMELYCOARSE, new HAuto(0.22, 0.007, 1.4, 1.0, 0.9, hAutoCollectionMinDist));
        }
        hAutoCollectionMinDist.hauto = HAutoTable.constructHAutoTable(hashMap);
        return hAutoCollectionMinDist;
    }

    private static HAutoCollection g() {
        HashMap<Size, HAuto> hashMap = new HashMap<Size, HAuto>();
        HAutoCollection hAutoCollection = new HAutoCollection();
        hashMap.put(Size.EXTREMELYFINE, new HAuto(0.006, 5.0E-4, 1.1, 0.2, 1.0, hAutoCollection));
        hashMap.put(Size.EXTRAFINE, new HAuto(0.0075, 0.002, 1.1, 0.2, 1.0, hAutoCollection));
        hashMap.put(Size.FINER, new HAuto(0.01, 0.0025, 1.2, 0.2, 1.0, hAutoCollection));
        hashMap.put(Size.FINE, new HAuto(0.015, 0.0035, 1.25, 0.25, 1.0, hAutoCollection));
        hashMap.put(Size.NORMAL, new HAuto(0.02, 0.01, 1.3, 0.8, 1.0, hAutoCollection));
        hashMap.put(Size.COARSE, new HAuto(0.03, 0.015, 1.4, 0.8, 1.0, hAutoCollection));
        hashMap.put(Size.COARSER, new HAuto(0.04, 0.02, 1.5, 0.8, 1.0, hAutoCollection));
        hashMap.put(Size.EXTRACOARSE, new HAuto(0.05, 0.025, 1.8, 0.8, 1.0, hAutoCollection));
        hashMap.put(Size.EXTREMELYCOARSE, new HAuto(0.06, 0.03, 2.0, 1.0, 0.9, hAutoCollection));
        hAutoCollection.hauto = HAutoTable.constructHAutoTable(hashMap);
        return hAutoCollection;
    }

    private static HAutoCollection h() {
        HashMap<Size, HAuto> hashMap = new HashMap<Size, HAuto>();
        HAutoCollection hAutoCollection = new HAutoCollection();
        hashMap.put(Size.EXTREMELYFINE, new HAuto(0.04, 2.0E-4, 1.3, 0.2, 1.0, hAutoCollection));
        hashMap.put(Size.EXTRAFINE, new HAuto(0.05, 0.0015, 1.35, 0.3, 0.85, hAutoCollection));
        hashMap.put(Size.FINER, new HAuto(0.06, 0.004, 1.4, 0.4, 0.7, hAutoCollection));
        hashMap.put(Size.FINE, new HAuto(0.075, 0.01, 1.45, 0.5, 0.6, hAutoCollection));
        hashMap.put(Size.NORMAL, new HAuto(0.1, 0.02, 1.5, 0.6, 0.5, hAutoCollection));
        hashMap.put(Size.COARSE, new HAuto(0.25, 0.03, 1.6, 0.7, 0.4, hAutoCollection));
        hashMap.put(Size.COARSER, new HAuto(0.35, 0.04, 1.7, 0.8, 0.3, hAutoCollection));
        hashMap.put(Size.EXTRACOARSE, new HAuto(0.45, 0.05, 1.85, 0.9, 0.2, hAutoCollection));
        hashMap.put(Size.EXTREMELYCOARSE, new HAuto(0.55, 0.07, 2.0, 1.0, 0.1, hAutoCollection));
        hAutoCollection.hauto = HAutoTable.constructHAutoTable(hashMap);
        return hAutoCollection;
    }

    private static HAutoCollection i() {
        HashMap<Size, HAuto> hashMap = new HashMap<Size, HAuto>();
        HAutoCollection hAutoCollection = new HAutoCollection();
        hashMap.put(Size.EXTREMELYFINE, new HAuto(4.0E-4, 8.0E-5, 1.05, 0.2, 1.0, hAutoCollection));
        hashMap.put(Size.EXTRAFINE, new HAuto(0.001, 1.0E-4, 1.075, 0.25, 1.0, hAutoCollection));
        hashMap.put(Size.FINER, new HAuto(0.002, 4.0E-4, 1.1, 0.25, 1.0, hAutoCollection));
        hashMap.put(Size.FINE, new HAuto(0.0067, 0.001, 1.125, 0.3, 1.0, hAutoCollection));
        hashMap.put(Size.NORMAL, new HAuto(0.013, 0.002, 1.15, 0.3, 1.0, hAutoCollection));
        hashMap.put(Size.COARSE, new HAuto(0.028, 0.003, 1.2, 0.4, 1.0, hAutoCollection));
        hashMap.put(Size.COARSER, new HAuto(0.035, 0.004, 1.25, 0.6, 1.0, hAutoCollection));
        hashMap.put(Size.EXTRACOARSE, new HAuto(0.045, 0.005, 1.3, 0.8, 1.0, hAutoCollection));
        hashMap.put(Size.EXTREMELYCOARSE, new HAuto(0.067, 0.007, 1.4, 1.0, 0.9, hAutoCollection));
        hAutoCollection.hauto = HAutoTable.constructHAutoTable(hashMap);
        return hAutoCollection;
    }

    private static HAutoCollection j() {
        HashMap<Size, HAuto> hashMap = new HashMap<Size, HAuto>();
        HAutoCollection hAutoCollection = new HAutoCollection();
        hashMap.put(Size.EXTREMELYFINE, new HAuto(0.013, 2.0E-4, 1.05, 0.2, 1.0, hAutoCollection));
        hashMap.put(Size.EXTRAFINE, new HAuto(0.018, 0.0015, 1.075, 0.3, 0.95, hAutoCollection));
        hashMap.put(Size.FINER, new HAuto(0.023, 0.004, 1.1, 0.4, 0.9, hAutoCollection));
        hashMap.put(Size.FINE, new HAuto(0.037, 0.01, 1.125, 0.5, 0.8, hAutoCollection));
        hashMap.put(Size.NORMAL, new HAuto(0.053, 0.02, 1.15, 0.6, 0.7, hAutoCollection));
        hashMap.put(Size.COARSE, new HAuto(0.067, 0.03, 1.2, 0.7, 0.6, hAutoCollection));
        hashMap.put(Size.COARSER, new HAuto(0.1, 0.04, 1.25, 0.8, 0.5, hAutoCollection));
        hashMap.put(Size.EXTRACOARSE, new HAuto(0.13, 0.05, 1.3, 0.9, 0.4, hAutoCollection));
        hashMap.put(Size.EXTREMELYCOARSE, new HAuto(0.2, 0.07, 1.4, 1.0, 0.3, hAutoCollection));
        hAutoCollection.hauto = HAutoTable.constructHAutoTable(hashMap);
        return hAutoCollection;
    }

    public static HAuto[] constructHAutoTable(Map<Size, HAuto> map) {
        Size[] sizeArray;
        HAuto[] hAutoArray = new HAuto[10];
        HAutoCollection hAutoCollection = map.get((Object)Size.NORMAL).f;
        hAutoCollection.hashCode();
        hAutoArray[0] = new HAuto("FineLimit", hAutoCollection);
        Size[] sizeArray2 = sizeArray = Size.values();
        int n2 = sizeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Size size = sizeArray2[n3];
            if (map.get((Object)size) != null) {
                hAutoArray[size.value] = map.get((Object)size);
            }
            ++n3;
        }
        int n4 = 0;
        n3 = 0;
        n2 = 0;
        while (n2 < hAutoArray.length) {
            if (hAutoArray[n2] != null) {
                n3 = n4;
                n4 = n2;
            } else {
                int n5 = 0;
                int n6 = n2 + 1;
                while (n6 < hAutoArray.length) {
                    if (hAutoArray[n6] != null) {
                        n5 = n6;
                        break;
                    }
                    ++n6;
                }
                ConvexCombination convexCombination = n5 > 0 ? new ConvexCombination(n4, n5, (double)(n2 - n4) / (double)(n5 - n4)) : new ConvexCombination(n3, n4, 1.0 + (double)(n2 - n4) / (double)(n4 - n3));
                hAutoArray[n2] = new HAuto(HAutoTable.a(hAutoArray, convexCombination), HAutoTable.b(hAutoArray, convexCombination), HAutoTable.e(hAutoArray, convexCombination), HAutoTable.c(hAutoArray, convexCombination), HAutoTable.d(hAutoArray, convexCombination), hAutoCollection);
            }
            ++n2;
        }
        return hAutoArray;
    }

    private static ConvexCombination a(double d2) throws FlException {
        if (d2 > 1000000.0) {
            d2 = 1000000.0;
        }
        int n2 = (int)Math.floor(d2);
        int n3 = (int)Math.ceil(d2);
        if (n2 >= 0 && n3 <= 9) {
            double d3 = d2 - (double)n2;
            return new ConvexCombination(n2, n3, d3);
        }
        if (n3 > 9) {
            double d4 = d2 - 8.0;
            n3 = 9;
            n2 = 8;
            return new ConvexCombination(n2, n3, d4);
        }
        throw new FlException("Internal_error_mesh_processing");
    }

    private static double a(HAuto[] hAutoArray, ConvexCombination convexCombination) {
        return hAutoArray[convexCombination.b].getHmaxfact() * convexCombination.c + hAutoArray[convexCombination.a].getHmaxfact() * (1.0 - convexCombination.c);
    }

    public double hmax(String string, double d2) {
        HAutoCollection hAutoCollection = this.a(string);
        this.c = hAutoCollection.getGeomFactor(this.e.getGeomDimension());
        return FlNumberUtil.a((double)(HAutoTable.a(hAutoCollection.hauto, HAutoTable.a(d2)) * this.c), (int)3, (double)(1.0E-10 * this.c));
    }

    public double bndlayer(String string, double d2) {
        HAutoCollection hAutoCollection = this.a(string);
        this.c = hAutoCollection.getGeomFactor(this.e.getGeomDimension());
        return FlNumberUtil.a((double)(HAutoTable.a(hAutoCollection.hauto, HAutoTable.a(d2)) * this.c * 0.1), (int)3, (double)(1.0E-10 * this.c));
    }

    private static double b(HAuto[] hAutoArray, ConvexCombination convexCombination) {
        return hAutoArray[convexCombination.b].getHminfact() * convexCombination.c + hAutoArray[convexCombination.a].getHminfact() * (1.0 - convexCombination.c);
    }

    public double hmin(String string, double d2) {
        HAutoCollection hAutoCollection = this.a(string);
        this.c = hAutoCollection.getGeomFactor(this.e.getGeomDimension());
        return FlNumberUtil.a((double)(HAutoTable.b(hAutoCollection.hauto, HAutoTable.a(d2)) * this.c), (int)3, (double)(1.0E-10 * this.c));
    }

    private static double c(HAuto[] hAutoArray, ConvexCombination convexCombination) {
        return hAutoArray[convexCombination.b].getHcurve() * convexCombination.c + hAutoArray[convexCombination.a].getHcurve() * (1.0 - convexCombination.c);
    }

    public double hcurve(String string, double d2) {
        HAutoCollection hAutoCollection = this.a(string);
        this.c = hAutoCollection.getGeomFactor(this.e.getGeomDimension());
        return FlNumberUtil.a((double)HAutoTable.c(hAutoCollection.hauto, HAutoTable.a(d2)), (int)3, (double)(1.0E-10 * this.c));
    }

    private static double d(HAuto[] hAutoArray, ConvexCombination convexCombination) throws FlException {
        return Math.max(0.0, hAutoArray[convexCombination.b].getHnarrow() * convexCombination.c + hAutoArray[convexCombination.a].getHnarrow() * (1.0 - convexCombination.c));
    }

    public double hnarrow(String string, double d2) throws FlException {
        HAutoCollection hAutoCollection = this.a(string);
        this.c = hAutoCollection.getGeomFactor(this.e.getGeomDimension());
        return FlNumberUtil.a((double)HAutoTable.d(hAutoCollection.hauto, HAutoTable.a(d2)), (int)3, (double)(1.0E-10 * this.c));
    }

    private static double e(HAuto[] hAutoArray, ConvexCombination convexCombination) throws FlException {
        return hAutoArray[convexCombination.b].getHgrad() * convexCombination.c + hAutoArray[convexCombination.a].getHgrad() * (1.0 - convexCombination.c);
    }

    public double hgrad(String string, double d2) throws FlException {
        HAutoCollection hAutoCollection = this.a(string);
        this.c = hAutoCollection.getGeomFactor(this.e.getGeomDimension());
        return FlNumberUtil.a((double)HAutoTable.e(hAutoCollection.hauto, HAutoTable.a(d2)), (int)3, (double)(1.0E-10 * this.c));
    }

    public void setMeshParameters(double d2, MeshFeature meshFeature) {
        HAutoCollection hAutoCollection = this.a(meshFeature.getString("table"));
        this.c = hAutoCollection.getGeomFactor(this.e.getGeomDimension());
        HAutoTable.setMeshParameters(d2, meshFeature, hAutoCollection, this.c);
    }

    private HAutoCollection a(String string) {
        PredefinedTables[] predefinedTablesArray = PredefinedTables.values();
        int n2 = predefinedTablesArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PredefinedTables predefinedTables = predefinedTablesArray[n3];
            if (predefinedTables.toString().equals(string)) {
                return predefinedTables.getTable(this.d);
            }
            ++n3;
        }
        throw new FlException("Unknown_mesh_size_table_X#" + string);
    }

    public int matchHAuto(MeshFeature meshFeature) {
        double d2 = meshFeature.getDouble("hmax");
        double d3 = meshFeature.getDouble("hmin");
        double d4 = meshFeature.getDouble("hgrad");
        double d5 = meshFeature.getDouble("hcurve");
        double d6 = meshFeature.getDouble("hnarrow");
        HAutoCollection hAutoCollection = this.a(meshFeature.getString("table"));
        this.c = hAutoCollection.getGeomFactor(this.e.getGeomDimension());
        int n2 = 1;
        while (n2 < hAutoCollection.hauto.length) {
            if (hAutoCollection.hauto[n2].match(d2 * this.c, d3 * this.c, d4, d5, d6)) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public static String[] getDescriptions() {
        return a;
    }

    public static String[] getDescriptionsAction() {
        return b;
    }

    public static int[] getSpecialValuesInt() {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public static double[] getSpecialValues() {
        return new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
    }

    public static void setMeshParameters(double d2, MeshFeature meshFeature, HAutoCollection hAutoCollection, double d3) {
        ConvexCombination convexCombination = HAutoTable.a(d2);
        meshFeature.set("hmax", FlNumberUtil.a((double)(HAutoTable.a(hAutoCollection.hauto, convexCombination) * d3), (int)3, (double)(1.0E-10 * d3)));
        meshFeature.set("hmin", FlNumberUtil.a((double)(HAutoTable.b(hAutoCollection.hauto, convexCombination) * d3), (int)3, (double)(1.0E-10 * d3)));
        meshFeature.set("hgrad", FlNumberUtil.a((double)HAutoTable.e(hAutoCollection.hauto, convexCombination), (int)3, (double)1.0E-10));
        meshFeature.set("hcurve", FlNumberUtil.a((double)HAutoTable.c(hAutoCollection.hauto, convexCombination), (int)3, (double)1.0E-10));
        meshFeature.set("hnarrow", FlNumberUtil.a((double)HAutoTable.d(hAutoCollection.hauto, convexCombination), (int)3, (double)1.0E-10));
    }

    public static class ConvexCombination {
        int a;
        int b;
        double c;

        ConvexCombination(int n2, int n3, double d2) {
            this.b = n3;
            this.a = n2;
            this.c = d2;
        }
    }

    public static class HAuto
    implements i<HAuto> {
        private double a;
        private double b;
        private double c;
        private double d;
        private double e;
        private final HAutoCollection f;

        public HAuto(double d2, double d3, double d4, double d5, double d6, HAutoCollection hAutoCollection) {
            this.a = d2;
            this.b = d3;
            this.c = d4;
            this.d = d5;
            this.e = d6;
            this.f = hAutoCollection;
        }

        HAuto(String string, HAutoCollection hAutoCollection) {
            if (!string.equals("FineLimit")) {
                throw new IndexOutOfBoundsException();
            }
            this.a = 0.0;
            this.b = 0.0;
            this.c = 1.0;
            this.d = 0.0;
            this.e = 10.0;
            this.f = hAutoCollection;
        }

        HAuto(HAuto hAuto) {
            this.a = hAuto.a;
            this.b = hAuto.b;
            this.c = hAuto.c;
            this.d = hAuto.d;
            this.e = hAuto.e;
            this.f = hAuto.f;
        }

        public boolean match(double d2, double d3, double d4, double d5, double d6) {
            if (Math.abs(d4 - this.getHgrad()) > 1.0E-9) {
                return false;
            }
            if (Math.abs(d5 - this.getHcurve()) > 1.0E-9) {
                return false;
            }
            if (Math.abs(d6 - this.getHnarrow()) > 1.0E-9) {
                return false;
            }
            if (Math.abs(d2 - this.getHmaxfact()) > 1.0E-9) {
                return false;
            }
            return !(Math.abs(d3 - this.getHminfact()) > 1.0E-9);
        }

        public int compareTo(HAuto hAuto, MeshSequence meshSequence) {
            double d2;
            if (hAuto.equals(this)) {
                return 0;
            }
            double d3 = this.getHmaxfact() * this.f.getGeomFactor(meshSequence.getGeomDimension());
            if (d3 > (d2 = hAuto.getHmaxfact() * hAuto.f.getGeomFactor(meshSequence.getGeomDimension()))) {
                return -1;
            }
            if (d3 < d2) {
                return 1;
            }
            if (this.getHminfact() > hAuto.getHminfact()) {
                return -1;
            }
            if (this.getHminfact() < hAuto.getHminfact()) {
                return 1;
            }
            if (this.getHcurve() > hAuto.getHcurve()) {
                return -1;
            }
            if (this.getHcurve() < hAuto.getHcurve()) {
                return 1;
            }
            if (this.getHgrad() > hAuto.getHgrad()) {
                return -1;
            }
            if (this.getHgrad() < hAuto.getHgrad()) {
                return 1;
            }
            if (this.getHnarrow() < hAuto.getHnarrow()) {
                return -1;
            }
            if (this.getHnarrow() > hAuto.getHnarrow()) {
                return 1;
            }
            return 0;
        }

        public HAuto clone() {
            HAuto hAuto = null;
            try {
                hAuto = (HAuto)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
            return hAuto;
        }

        void a(double d2) {
            this.a = d2;
        }

        public double getHmaxfact() {
            return this.a;
        }

        void b(double d2) {
            this.b = d2;
        }

        public double getHminfact() {
            return this.b;
        }

        void c(double d2) {
            this.c = d2;
        }

        public double getHgrad() {
            return this.c;
        }

        void d(double d2) {
            this.d = d2;
        }

        public double getHcurve() {
            return this.d;
        }

        void e(double d2) {
            this.e = d2;
        }

        public double getHnarrow() {
            return this.e;
        }
    }

    public static class HAutoCollection
    implements i<HAutoCollection> {
        public HAuto[] hauto;

        public double getGeomFactor(double[] dArray) {
            return dArray[0];
        }

        public HAutoCollection clone() {
            HAutoCollection hAutoCollection = null;
            try {
                hAutoCollection = (HAutoCollection)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
            hAutoCollection.hauto = (HAuto[])q.a((i[])this.hauto);
            return hAutoCollection;
        }
    }

    public static class HAutoCollectionMinDist
    extends HAutoCollection {
        final int a;

        HAutoCollectionMinDist(int n2) {
            this.a = n2;
        }

        @Override
        public double getGeomFactor(double[] dArray) {
            if (this.a <= 2) {
                if (dArray[1] < dArray[0] * 0.001) {
                    return dArray[0];
                }
                double d2 = dArray[0] / dArray[1];
                double d3 = d2 < 0.01 ? dArray[0] * 0.01 : dArray[1];
                return Math.max(dArray[1], Math.sqrt(dArray[0] * d3) * 0.15);
            }
            double d4 = 3.0 * dArray[2] - dArray[0] - dArray[1];
            if (d4 < dArray[0] * 0.001) {
                return dArray[0];
            }
            if (dArray[1] < d4 * 0.001) {
                return d4;
            }
            double d5 = dArray[0] * d4 * dArray[1];
            double d6 = 6666.0;
            double d7 = Math.pow(d5 / d6, 0.3333333333333333);
            double d8 = dArray[1] / d4 < 0.01 ? d4 * 0.01 : dArray[1];
            return Math.max(Math.sqrt(d4 * d8), 10.0 * d7);
        }

        @Override
        public HAutoCollectionMinDist clone() {
            return (HAutoCollectionMinDist)super.clone();
        }
    }

    public static enum PredefinedTables implements IPredefinedTable
    {
        DEFAULT("General_physics"),
        CFD("Fluid_dynamics"),
        PLASMA("Plasma"),
        SEMI("Semiconductor");

        private HAutoCollection table2D;
        private HAutoCollection table3D;
        private String description;

        private PredefinedTables(String string2) {
            this.description = string2;
        }

        @Override
        public HAutoCollection getTable(int n2) {
            if (n2 >= 0 && n2 <= 2) {
                if (this.table2D == null) {
                    switch (this) {
                        case DEFAULT: {
                            this.table2D = HAutoTable.getDefaultTable2D();
                            break;
                        }
                        case CFD: {
                            this.table2D = HAutoTable.b(2);
                            break;
                        }
                        case PLASMA: {
                            this.table2D = HAutoTable.g();
                            break;
                        }
                        case SEMI: {
                            this.table2D = HAutoTable.i();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Not implemented");
                        }
                    }
                }
                return this.table2D;
            }
            if (n2 == 3) {
                if (this.table3D == null) {
                    switch (this) {
                        case DEFAULT: {
                            this.table3D = HAutoTable.f();
                            break;
                        }
                        case CFD: {
                            this.table3D = HAutoTable.b(3);
                            break;
                        }
                        case PLASMA: {
                            this.table3D = HAutoTable.h();
                            break;
                        }
                        case SEMI: {
                            this.table3D = HAutoTable.j();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Not implemented");
                        }
                    }
                }
                return this.table3D;
            }
            throw new IllegalArgumentException("Bad SDim " + n2);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public boolean useCustomSize() {
            return false;
        }
    }

    public static enum Size {
        EXTREMELYFINE(1),
        EXTRAFINE(2),
        FINER(3),
        FINE(4),
        NORMAL(5),
        COARSE(6),
        COARSER(7),
        EXTRACOARSE(8),
        EXTREMELYCOARSE(9);

        int value;

        private Size(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }
}

