/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations.operationID;

import com.comsol.model.applapi.SDimType;
import com.comsol.model.dbimodel.CommonFeature;
import com.comsol.model.dbimodel.MODEL_NODE_TYPES;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.operationID.IOperationID;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.methods.FlStringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.stream.Stream;

public enum CommonFeatureOperationID implements IOperationID
{
    ExpressionOperator("ExpressionOperator", "Expression_operator", "expression_operator.png", "exop", CommonFeatureType.CORE, RibbonGroup.MATRIX_VARIABLE, SDimType.ZEROD),
    OperatorContribution("OperatorContribution", "Operator_contribution", "operator_contribution.png", "opc", CommonFeatureType.CORE, RibbonGroup.NONE, SDimType.ZEROD, SDimType.ND),
    Matrix("Matrix", "Matrix", "matrix.png", "mat", CommonFeatureType.CORE, RibbonGroup.MATRIX_VARIABLE, SDimType.ZEROD),
    MatrixInverse("MatrixInverse", "Matrix_inverse", "matrix_inverse.png", "matinv", CommonFeatureType.CORE, RibbonGroup.MATRIX_VARIABLE, SDimType.ZEROD),
    MatrixDiagonalization("MatrixDiagonalization", "Matrix_diagonalization", "matrix_diagonalization.png", "matdiag", CommonFeatureType.CORE, RibbonGroup.MATRIX_VARIABLE, SDimType.ZEROD),
    MatrixDecomposition("MatrixDecomposition", "Matrix_decomposition_SVD", "matrix_decomposition.png", "matdec", CommonFeatureType.CORE, RibbonGroup.MATRIX_VARIABLE, SDimType.ZEROD),
    VectorTransform("VectorTransform", "Vector_transform", "vector_transform.png", "vectr", CommonFeatureType.CORE, RibbonGroup.MATRIX_VARIABLE, SDimType.ZEROD, SDimType.ND),
    MatrixTransform("MatrixTransform", "Matrix_transform", "matrix_transform.png", "mattr", CommonFeatureType.CORE, RibbonGroup.MATRIX_VARIABLE, SDimType.ZEROD, SDimType.ND),
    StateVariables("StateVariables", "State_variables[feature]", "state_variables.png", "state", CommonFeatureType.CORE, RibbonGroup.MATRIX_VARIABLE, SDimType.ZEROD),
    ParticipationFactors("ParticipationFactors", "Participation_factors", "participation_factors.png", "mpf", CommonFeatureType.CORE, RibbonGroup.NONE, SDimType.ZEROD, SDimType.ND),
    ResponseSpectrum("ResponseSpectrum", "Response_spectrum", "response_spectrum.png", "rsp", CommonFeatureType.CORE, RibbonGroup.NONE, SDimType.ZEROD, SDimType.ND),
    PrescribedDeformation("PrescribedDeformation", "Prescribed_deformation", "prescribed_deformation.png", "pres", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_DOMAIN, SDimType.getTypesByDim(-1, 0, 1)),
    RotatingDomain("RotatingDomain", "Rotating_domain", "rotating_domain.png", "rot", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_DOMAIN, SDimType.AXI2D, SDimType.ONED, SDimType.AXI1D, SDimType.ZEROD, SDimType.ND),
    SlidingDomain("SlidingDomain", "Sliding_domain", "sliding_domain.png", "slide", CommonFeatureType.PHYSICS, RibbonGroup.NONE, SDimType.getTypesByDim(-1, 0, 1)),
    DeformingDomain("DeformingDomain", "Deforming_domain", "deforming_domain.png", "free", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_DOMAIN, SDimType.getTypesByDim(-1, 0, 1)),
    RotatingAndDeformingDomain("RotatingAndDeformingDomain", "Rotating_and_deforming_domain", "rotating_and_deforming_domain.png", "frot", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_DOMAIN, SDimType.AXI2D, SDimType.ONED, SDimType.AXI1D, SDimType.ZEROD, SDimType.ND),
    FixedBoundary("FixedBoundary", "Fixed_boundary", "fixed_boundary.png", "fix", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    PrescribedMeshDisplacement("PrescribedMeshDisplacement", "Prescribed_mesh_displacement", "prescribed_mesh_displacement.png", "disp", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    PrescribedNormalMeshDisplacement("PrescribedNormalMeshDisplacement", "Prescribed_normal_mesh_displacement", "prescribed_normal_mesh_displacement.png", "pnmd", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    PrescribedNormalMeshVelocity("PrescribedNormalMeshVelocity", "Prescribed_normal_mesh_velocity", "prescribed_normal_mesh_velocity.png", "pnmv", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    RotatingBoundary("RotatingBoundary", "Rotating_boundary", "rotating_boundary.png", "rotb", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_BOUNDARY, SDimType.AXI2D, SDimType.ONED, SDimType.AXI1D, SDimType.ZEROD, SDimType.ND),
    Slip("Slip", "Mesh_slip", "mesh_slip.png", "slip", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    Symmetry("Symmetry", "Symmetry_roller", "mesh_symmetry.png", "sym", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    Slit("Slit", "Slit", "mesh_slit.png", "slit", CommonFeatureType.PHYSICS, RibbonGroup.MOVING_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    PrescribedDeformationDeformedGeometry("PrescribedDeformationDeformedGeometry", "Prescribed_deformation", "prescribed_deformation.png", "pres", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_DOMAIN, SDimType.getTypesByDim(-1, 0, 1)),
    RotatingDomainDeformedGeometry("RotatingDomainDeformedGeometry", "Rotating_domain", "rotating_domain.png", "rot", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_DOMAIN, SDimType.AXI2D, SDimType.ONED, SDimType.AXI1D, SDimType.ZEROD, SDimType.ND),
    SlidingDomainDeformedGeometry("SlidingDomainDeformedGeometry", "Sliding_domain", "sliding_domain.png", "slide", CommonFeatureType.PHYSICS, RibbonGroup.NONE, SDimType.getTypesByDim(-1, 0, 1)),
    DeformingDomainDeformedGeometry("DeformingDomainDeformedGeometry", "Deforming_domain", "deforming_domain.png", "free", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_DOMAIN, SDimType.getTypesByDim(-1, 0, 1)),
    RotatingAndDeformingDomainDeformedGeometry("RotatingAndDeformingDomainDeformedGeometry", "Rotating_and_deforming_domain", "rotating_and_deforming_domain.png", "frot", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_DOMAIN, SDimType.AXI2D, SDimType.ONED, SDimType.AXI1D, SDimType.ZEROD, SDimType.ND),
    FixedBoundaryDeformedGeometry("FixedBoundaryDeformedGeometry", "Fixed_boundary", "fixed_boundary.png", "fix", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    PrescribedMeshDisplacementDeformedGeometry("PrescribedMeshDisplacementDeformedGeometry", "Prescribed_mesh_displacement", "prescribed_mesh_displacement.png", "disp", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    PrescribedNormalMeshDisplacementDeformedGeometry("PrescribedNormalMeshDisplacementDeformedGeometry", "Prescribed_normal_mesh_displacement", "prescribed_normal_mesh_displacement.png", "pnmd", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    PrescribedNormalMeshVelocityDeformedGeometry("PrescribedNormalMeshVelocityDeformedGeometry", "Prescribed_normal_mesh_velocity", "prescribed_normal_mesh_velocity.png", "pnmv", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    RotatingBoundaryDeformedGeometry("RotatingBoundaryDeformedGeometry", "Rotating_boundary", "rotating_boundary.png", "rotb", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_BOUNDARY, SDimType.AXI2D, SDimType.ONED, SDimType.AXI1D, SDimType.ZEROD, SDimType.ND),
    SlipDeformedGeometry("SlipDeformedGeometry", "Mesh_slip", "mesh_slip.png", "slip", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    SymmetryDeformedGeometry("SymmetryDeformedGeometry", "Symmetry_roller", "mesh_symmetry.png", "sym", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    SlitDeformedGeometry("SlitDeformedGeometry", "Slit", "mesh_slit.png", "slit", CommonFeatureType.PHYSICS, RibbonGroup.DEFORMED_BOUNDARY, SDimType.getTypesByDim(-1, 0, 1)),
    ControlVariableField("ControlVariableField", "Control_variable_field", "control_variable_field.png", "cvf", CommonFeatureType.PHYSICS, RibbonGroup.NONE, SDimType.ZEROD, SDimType.ND),
    ReducedModelInputField("ReducedModelInputField", "Reduced_model_input_field", "reduced_model_input_field.png", "rmif", CommonFeatureType.PHYSICS, RibbonGroup.NONE, SDimType.ZEROD, SDimType.ND),
    RandomVariableField("RandomVariableField", "Random_variable_field", "random_variable_field.png", "rvf", CommonFeatureType.PHYSICS, RibbonGroup.NONE, SDimType.ZEROD, SDimType.ND),
    GlobalControlVariables("GlobalControlVariables", "Global_control_variables", "global_control_variables.png", "gcv", CommonFeatureType.PHYSICS, RibbonGroup.NONE, SDimType.THREED, SDimType.TWOD, SDimType.AXI2D, SDimType.ONED, SDimType.AXI1D, SDimType.ZEROD),
    GlobalReducedModelInputs("GlobalReducedModelInputs", "Global_reduced_model_inputs", "global_reduced_model_inputs.png", "grmi", CommonFeatureType.PHYSICS, RibbonGroup.REDUCED_MODELING, SDimType.THREED, SDimType.TWOD, SDimType.AXI2D, SDimType.ONED, SDimType.AXI1D, SDimType.ZEROD),
    DensityTopology("DensityTopology", "Density_model", "density_topology.png", "dtopo", CommonFeatureType.PHYSICS, RibbonGroup.TOPOLOGY_OPTIMIZATION, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D),
    FixedTopologyDomain("FixedTopologyDomain", "Prescribed_density", "topology_domain.png", "ftopo", CommonFeatureType.PHYSICS, RibbonGroup.TOPOLOGY_OPTIMIZATION, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D),
    FixedTopologyBoundary("FixedTopologyBoundary", "Fixed_topology_boundary", "topology_boundary.png", "ftopob", CommonFeatureType.PHYSICS, RibbonGroup.NONE, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D),
    FreeTopologyBoundary("FreeTopologyBoundary", "Free_topology_boundary", "topology_boundary.png", "dtopob", CommonFeatureType.PHYSICS, RibbonGroup.NONE, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D),
    FreeShapeDomain("FreeShapeDomain", "Free_shape_domain", "shape_optimization_domain.png", "fsd", CommonFeatureType.PHYSICS, RibbonGroup.SHAPE_OPTIMIZATION, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D),
    PolynomialBoundary("PolynomialBoundary", "Polynomial_boundary", "shape_optimization_boundary.png", "poly", CommonFeatureType.PHYSICS, RibbonGroup.SHAPE_OPTIMIZATION, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D, SDimType.THREED),
    FreeShapeBoundary("FreeShapeBoundary", "Free_shape_boundary", "shape_optimization_boundary.png", "fsb", CommonFeatureType.PHYSICS, RibbonGroup.SHAPE_OPTIMIZATION, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D),
    FreeShapeShell("FreeShapeShell", "Free_shape_shell", "shape_optimization_shell.png", "fss", CommonFeatureType.PHYSICS, RibbonGroup.SHAPE_OPTIMIZATION, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D, SDimType.TWOD, SDimType.AXI2D),
    FreeShapeSymmetry("FreeShapeSymmetry", "Symmetry_roller", "shape_optimization_symmetry.png", "fsr", CommonFeatureType.PHYSICS, RibbonGroup.SHAPE_OPTIMIZATION, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D),
    FixedShapeEdge("FixedShapeEdge", "Fixed_edge", "shape_optimization_edge.png", "fse", CommonFeatureType.PHYSICS, RibbonGroup.SHAPE_OPTIMIZATION, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D, SDimType.TWOD, SDimType.AXI2D),
    FixedShapePoint("FixedShapePoint", "Fixed_point", "shape_optimization_point.png", "fsp", CommonFeatureType.PHYSICS, RibbonGroup.SHAPE_OPTIMIZATION, SDimType.ZEROD, SDimType.ND, SDimType.ONED, SDimType.AXI1D, SDimType.THREED),
    CommonModelInputDefault("CommonInputDefault", "Default_model_inputs", "commonmodelinput.png", "cminpt", CommonFeatureType.MINPUT, RibbonGroup.NONE, new SDimType[0]),
    CommonModelInputDefinition("CommonInputDef", "Model_input", "modelinput.png", "minpt", CommonFeatureType.MINPUT, RibbonGroup.MULTIPHYSICS_DEFINITION, SDimType.ZEROD, SDimType.ND),
    AmbientProperties("AmbientProperties", "Ambient_properties", "ambient_properties.png", "ampr", CommonFeatureType.HEAT, RibbonGroup.MULTIPHYSICS_DEFINITION, SDimType.ZEROD, SDimType.ND);

    private String id;
    private String descr;
    private String icon;
    private String shortName;
    private CommonFeatureType type;
    private RibbonGroup ribbonGroup;
    private final HashSet<SDimType> excludedDims;
    public static final String[] MatrixVariableIDs;
    public static final String[] MovingMeshIDs;
    public static final String[] DeformedGeometryIDs;
    public static final String[] MultiphysicsIDs;
    public static final String[] OptimizationIDs;
    public static final String[] DefaultIDs;
    private static /* synthetic */ int[] a;

    static {
        MatrixVariableIDs = new String[]{CommonFeatureOperationID.Matrix.id, CommonFeatureOperationID.MatrixDecomposition.id, CommonFeatureOperationID.MatrixDiagonalization.id, CommonFeatureOperationID.MatrixInverse.id, CommonFeatureOperationID.VectorTransform.id, CommonFeatureOperationID.MatrixTransform.id, CommonFeatureOperationID.StateVariables.id};
        MovingMeshIDs = new String[]{CommonFeatureOperationID.RotatingDomain.id, CommonFeatureOperationID.SlidingDomain.id, CommonFeatureOperationID.DeformingDomain.id, CommonFeatureOperationID.RotatingAndDeformingDomain.id, CommonFeatureOperationID.PrescribedDeformation.id, CommonFeatureOperationID.FixedBoundary.id, CommonFeatureOperationID.PrescribedMeshDisplacement.id, CommonFeatureOperationID.PrescribedNormalMeshDisplacement.id, CommonFeatureOperationID.PrescribedNormalMeshVelocity.id, CommonFeatureOperationID.RotatingBoundary.id, CommonFeatureOperationID.Slip.id, CommonFeatureOperationID.Symmetry.id, CommonFeatureOperationID.Slit.id};
        DeformedGeometryIDs = new String[]{CommonFeatureOperationID.RotatingDomainDeformedGeometry.id, CommonFeatureOperationID.SlidingDomainDeformedGeometry.id, CommonFeatureOperationID.DeformingDomainDeformedGeometry.id, CommonFeatureOperationID.RotatingAndDeformingDomainDeformedGeometry.id, CommonFeatureOperationID.PrescribedDeformationDeformedGeometry.id, CommonFeatureOperationID.FixedBoundaryDeformedGeometry.id, CommonFeatureOperationID.PrescribedMeshDisplacementDeformedGeometry.id, CommonFeatureOperationID.PrescribedNormalMeshDisplacementDeformedGeometry.id, CommonFeatureOperationID.PrescribedNormalMeshVelocityDeformedGeometry.id, CommonFeatureOperationID.RotatingBoundaryDeformedGeometry.id, CommonFeatureOperationID.Slip.id, CommonFeatureOperationID.SymmetryDeformedGeometry.id, CommonFeatureOperationID.Slit.id};
        MultiphysicsIDs = new String[]{CommonFeatureOperationID.AmbientProperties.id, CommonFeatureOperationID.CommonModelInputDefinition.id};
        OptimizationIDs = new String[]{CommonFeatureOperationID.DensityTopology.id, CommonFeatureOperationID.FreeShapeDomain.id, CommonFeatureOperationID.FixedTopologyDomain.id, CommonFeatureOperationID.FixedTopologyBoundary.id, CommonFeatureOperationID.FreeTopologyBoundary.id, CommonFeatureOperationID.PolynomialBoundary.id, CommonFeatureOperationID.FreeShapeBoundary.id, CommonFeatureOperationID.FreeShapeShell.id, CommonFeatureOperationID.FixedShapeEdge.id, CommonFeatureOperationID.FixedShapePoint.id, CommonFeatureOperationID.FreeShapeSymmetry.id};
        DefaultIDs = new String[]{CommonFeatureOperationID.CommonModelInputDefault.id};
    }

    private CommonFeatureOperationID(String string2, String string3, String string4, String string5, CommonFeatureType commonFeatureType, RibbonGroup ribbonGroup, SDimType ... sDimTypeArray) {
        this.id = string2;
        this.descr = string3;
        this.icon = string4;
        this.shortName = string5;
        this.type = commonFeatureType;
        this.ribbonGroup = ribbonGroup;
        this.excludedDims = new HashSet<SDimType>(Arrays.asList(sDimTypeArray));
        this.excludedDims.add(SDimType.AXIND);
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public static CommonFeatureOperationID fromId(String string) {
        CommonFeatureOperationID[] commonFeatureOperationIDArray = CommonFeatureOperationID.values();
        int n2 = commonFeatureOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            CommonFeatureOperationID commonFeatureOperationID = commonFeatureOperationIDArray[n3];
            if (commonFeatureOperationID.id().equals(string)) {
                return commonFeatureOperationID;
            }
            ++n3;
        }
        return null;
    }

    public String getAddActionTag(AddContext addContext) {
        String string = null;
        if (addContext.accept(this)) {
            string = String.valueOf(addContext.prefix) + this.id();
            if (FlStringUtil.contains((String[])DeformedGeometryIDs, (String)this.id())) {
                string = string.replace("DeformedGeometry", "_defgeom");
            }
        }
        return string;
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature instanceof CommonFeature && this.id.equals(propFeature.getOperationID());
    }

    @Override
    public boolean isOfType(String string) {
        return this.id.equals(string);
    }

    public CommonFeatureType getType() {
        return this.type;
    }

    public static boolean isMatrixVariable(PropFeature propFeature) {
        return propFeature instanceof CommonFeature && FlStringUtil.contains((String[])MatrixVariableIDs, (String)propFeature.getOperationID());
    }

    public static boolean isMovingMesh(PropFeature propFeature) {
        return propFeature instanceof CommonFeature && FlStringUtil.contains((String[])MovingMeshIDs, (String)propFeature.getOperationID());
    }

    public static boolean isDeformedGeometry(PropFeature propFeature) {
        return propFeature instanceof CommonFeature && FlStringUtil.contains((String[])DeformedGeometryIDs, (String)propFeature.getOperationID());
    }

    public static boolean isMultiphysics(PropFeature propFeature) {
        return propFeature instanceof CommonFeature && FlStringUtil.contains((String[])MultiphysicsIDs, (String)propFeature.getOperationID());
    }

    public static boolean isOptimization(PropFeature propFeature) {
        return propFeature instanceof CommonFeature && FlStringUtil.contains((String[])OptimizationIDs, (String)propFeature.getOperationID());
    }

    public boolean appliesToSDimType(SDimType sDimType) {
        return sDimType != null && !this.excludedDims.contains((Object)sDimType);
    }

    public boolean appliesToComponentType(MODEL_NODE_TYPES mODEL_NODE_TYPES) {
        if (mODEL_NODE_TYPES == MODEL_NODE_TYPES.GLOBAL) {
            return !this.excludedDims.contains((Object)SDimType.ND);
        }
        if (this.ribbonGroup == RibbonGroup.MATRIX_VARIABLE) {
            return mODEL_NODE_TYPES != MODEL_NODE_TYPES.MESH_PART;
        }
        return mODEL_NODE_TYPES == MODEL_NODE_TYPES.STANDARD;
    }

    public static Stream<CommonFeatureOperationID> getRibbonGroup(RibbonGroup ribbonGroup) {
        return Stream.of(CommonFeatureOperationID.values()).filter(commonFeatureOperationID -> commonFeatureOperationID.ribbonGroup == ribbonGroup && !commonFeatureOperationID.isHidden(SystemUtil.isTechnologyPreview()));
    }

    public boolean requiresTechnologyPreview() {
        int cfr_ignored_0 = CommonFeatureOperationID.a()[this.ordinal()];
        return false;
    }

    public boolean isAlwaysHidden() {
        switch (CommonFeatureOperationID.a()[this.ordinal()]) {
            case 14: 
            case 16: 
            case 24: 
            case 27: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return true;
            }
        }
        return false;
    }

    public boolean isHidden(boolean bl2) {
        if (this.isAlwaysHidden()) {
            return true;
        }
        return this.requiresTechnologyPreview() && !bl2;
    }

    public boolean isSubFeature() {
        switch (CommonFeatureOperationID.a()[this.ordinal()]) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isDefault() {
        return FlStringUtil.contains((String[])DefaultIDs, (String)this.id);
    }

    public static Stream<CommonFeatureOperationID> getNonHiddenTopLevelOperations(boolean bl2) {
        return Stream.of(CommonFeatureOperationID.values()).filter(commonFeatureOperationID -> !commonFeatureOperationID.isHidden(bl2) && !commonFeatureOperationID.isSubFeature());
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[CommonFeatureOperationID.values().length];
        try {
            nArray[CommonFeatureOperationID.AmbientProperties.ordinal()] = 56;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.CommonModelInputDefault.ordinal()] = 54;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.CommonModelInputDefinition.ordinal()] = 55;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.ControlVariableField.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.DeformingDomain.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.DeformingDomainDeformedGeometry.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.DensityTopology.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.ExpressionOperator.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FixedBoundary.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FixedBoundaryDeformedGeometry.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FixedShapeEdge.ordinal()] = 52;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FixedShapePoint.ordinal()] = 53;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FixedTopologyBoundary.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FixedTopologyDomain.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FreeShapeBoundary.ordinal()] = 49;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FreeShapeDomain.ordinal()] = 47;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FreeShapeShell.ordinal()] = 50;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FreeShapeSymmetry.ordinal()] = 51;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.FreeTopologyBoundary.ordinal()] = 46;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.GlobalControlVariables.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.GlobalReducedModelInputs.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.Matrix.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.MatrixDecomposition.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.MatrixDiagonalization.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.MatrixInverse.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.MatrixTransform.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.OperatorContribution.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.ParticipationFactors.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.PolynomialBoundary.ordinal()] = 48;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.PrescribedDeformation.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.PrescribedDeformationDeformedGeometry.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.PrescribedMeshDisplacement.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.PrescribedMeshDisplacementDeformedGeometry.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.PrescribedNormalMeshDisplacement.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.PrescribedNormalMeshDisplacementDeformedGeometry.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.PrescribedNormalMeshVelocity.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.PrescribedNormalMeshVelocityDeformedGeometry.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.RandomVariableField.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.ReducedModelInputField.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.ResponseSpectrum.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.RotatingAndDeformingDomain.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.RotatingAndDeformingDomainDeformedGeometry.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.RotatingBoundary.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.RotatingBoundaryDeformedGeometry.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.RotatingDomain.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.RotatingDomainDeformedGeometry.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.SlidingDomain.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.SlidingDomainDeformedGeometry.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.Slip.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.SlipDeformedGeometry.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.Slit.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.SlitDeformedGeometry.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.StateVariables.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.Symmetry.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.SymmetryDeformedGeometry.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CommonFeatureOperationID.VectorTransform.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    public static enum AddContext {
        COMPONENT("add_common_", commonFeatureOperationID -> Stream.of(SDimType.VALUES_NONABSTRACT).anyMatch(sDimType -> commonFeatureOperationID.appliesToSDimType((SDimType)((Object)((Object)sDimType))))),
        GLOBAL("add_global_common_", commonFeatureOperationID -> Stream.of(SDimType.VALUES_ABSTRACT).anyMatch(sDimType -> commonFeatureOperationID.appliesToSDimType((SDimType)((Object)((Object)sDimType))))),
        FEATURE("add_sub_common_", commonFeatureOperationID -> true);

        public final String prefix;
        private final Predicate<CommonFeatureOperationID> predicate;

        private AddContext(String string2, Predicate<CommonFeatureOperationID> predicate) {
            this.prefix = string2;
            this.predicate = predicate;
        }

        public boolean accept(CommonFeatureOperationID commonFeatureOperationID) {
            return this.predicate.test(commonFeatureOperationID);
        }
    }

    public static enum CommonFeatureType {
        CORE,
        PHYSICS,
        HEAT,
        MINPUT;

    }

    public static enum RibbonGroup {
        MATRIX_VARIABLE,
        MOVING_DOMAIN,
        MOVING_BOUNDARY,
        DEFORMED_DOMAIN,
        DEFORMED_BOUNDARY,
        MULTIPHYSICS_DEFINITION,
        TOPOLOGY_OPTIMIZATION,
        SHAPE_OPTIMIZATION,
        REDUCED_MODELING,
        NONE;

    }
}

