/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations.operationID;

import com.comsol.model.dbimodel.ExportFeature;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.operationID.IOperationID;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.methods.q;
import java.util.ArrayList;

public enum ExportOperationID implements IOperationID
{
    ANIMATION("Animation", "anim", "Animation", "animation.png"),
    DATA("Data", "data", "Data", "export_data.png"),
    IMAGE("Image", "img", "Image", "post_image_3d.png"),
    MESH("Mesh", "mesh", "Mesh", "export_mesh.png"),
    PLOT("Plot", "plot", "Plot[noun]", "export_plot.png"),
    TABLE("Table", "tbl", "Table", "export_table.png");

    private final String idString;
    private final String shortName;
    private final String descr;
    private final String icon;
    public static final String[] NONE;

    static {
        NONE = new String[0];
    }

    private ExportOperationID(String string2, String string3, String string4, String string5) {
        this.idString = string2;
        this.shortName = string3;
        this.descr = string4;
        this.icon = string5;
    }

    public String toString() {
        return this.idString;
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature instanceof ExportFeature && this.id().equals(propFeature.getOperationID());
    }

    public static boolean isImage(PropFeature propFeature) {
        return ExportOperationID.isOfType(propFeature, IMAGE);
    }

    public static boolean isFileAnimation(PropFeature propFeature) {
        return ExportOperationID.isOfType(propFeature, ANIMATION) && "file".equals(propFeature.getString("target"));
    }

    public static boolean isPlayerAnimation(PropFeature propFeature) {
        return ExportOperationID.isOfType(propFeature, ANIMATION) && "player".equals(propFeature.getString("target"));
    }

    public static boolean isPlayerAnimation(ModelEntity modelEntity) {
        if (modelEntity instanceof PropFeature) {
            return ExportOperationID.isPlayerAnimation((PropFeature)modelEntity);
        }
        return false;
    }

    public static boolean isOfType(PropFeature propFeature, ExportOperationID ... exportOperationIDArray) {
        ExportOperationID[] exportOperationIDArray2 = exportOperationIDArray;
        int n2 = exportOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ExportOperationID exportOperationID = exportOperationIDArray2[n3];
            if (exportOperationID.isOfType(propFeature)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static final String[] ALL() {
        ExportOperationID[] exportOperationIDArray = ExportOperationID.values();
        String[] stringArray = new String[exportOperationIDArray.length];
        int n2 = 0;
        while (n2 < exportOperationIDArray.length) {
            stringArray[n2] = exportOperationIDArray[n2].toString();
            ++n2;
        }
        return stringArray;
    }

    public static final String[] ENTITY_OPERATIONS() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ExportOperationID[] exportOperationIDArray = new ExportOperationID[]{DATA, IMAGE, MESH, PLOT, TABLE};
        int n2 = exportOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ExportOperationID exportOperationID = exportOperationIDArray[n3];
            arrayList.add(exportOperationID.toString());
            ++n3;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getDataGroup() {
        return new String[]{DATA.toString(), PLOT.toString(), MESH.toString(), TABLE.toString()};
    }

    public static String[] getImageGroup() {
        return new String[]{IMAGE.toString()};
    }

    public static String[][] getGrouped() {
        FlStringList flStringList = new FlStringList();
        String[][] stringArray = new String[2][];
        flStringList.add(ExportOperationID.getDataGroup());
        stringArray[0] = flStringList.toArray();
        flStringList = new FlStringList();
        flStringList.add((String[])q.b((Object[][])new String[][]{ExportOperationID.getImageGroup(), {ANIMATION.toString()}}));
        stringArray[1] = flStringList.toArray();
        return stringArray;
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.idString;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public boolean isOfType(String string) {
        return this.id().equals(string);
    }
}

