/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.results;

import com.comsol.model.dbimodel.ExportFeature;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntityImage;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.operationID.ExportOperationID;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.de;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ImagePresets {
    public static final String[] PRESET_PROPS = new String[]{"unit", "height", "width", "lockratio", "resolution", "antialias", "zoomextents", "options3d", "options2d", "options1d", "title3d", "title2d", "title1d", "legend3d", "legend2d", "legend1d", "axes2d", "axes1d", "showgrid", "axisorientation", "grid", "logo3d", "logo2d", "logo1d", "fontsize", "customcolor", "background", "gltfincludelines", "qualitylevel", "qualityactive", "imagetype", "target", "addsuffix", "lockview"};
    private Map<String, Preset> a = new LinkedHashMap<String, Preset>();
    private static ImagePresets b;
    private static /* synthetic */ int[] c;

    private ImagePresets() {
        this.b();
    }

    private ImagePresets(ImagePresets imagePresets) {
        for (Preset preset : imagePresets.a.values()) {
            Preset preset2 = new Preset(preset.a, preset.b);
            preset2.c.putAll(preset.c);
            preset2.d.putAll(preset.d);
            this.a.put(preset2.a, preset2);
        }
    }

    public static ImagePresets getInstance() {
        if (b == null) {
            b = new ImagePresets();
            b.c();
        }
        return b;
    }

    public static ImagePresets getDefaultInstance() {
        return new ImagePresets();
    }

    public static void setInstance(ImagePresets imagePresets, Model model) {
        Objects.requireNonNull(imagePresets);
        b = imagePresets;
        if (model != null) {
            ImagePresets.ensureAllExportFeaturesAreValid(model, imagePresets);
        }
        b.saveToPrefs();
    }

    public ImagePresets getCopy() {
        return new ImagePresets(this);
    }

    private void b() {
        Preset preset = new Preset("current", "Current[present]");
        preset.a("zoomextents", "off");
        preset.a("antialias", "on");
        preset.a("options1d", "on");
        preset.a("options2d", "off");
        preset.a("options3d", "off");
        preset.a("title1d", "on");
        preset.a("title2d", "on");
        preset.a("title3d", "on");
        preset.a("legend1d", "on");
        preset.a("legend2d", "on");
        preset.a("legend3d", "on");
        preset.a("axes1d", "on");
        preset.a("axes2d", "on");
        preset.a("logo1d", "on");
        preset.a("logo2d", "on");
        preset.a("logo3d", "on");
        preset.a("showgrid", "on");
        preset.a("axisorientation", "on");
        preset.a("grid", "on");
        preset.a("fontsize", "9");
        preset.a("customcolor", new String[]{"1", "1", "1"});
        preset.a("background", "color");
        preset.a("gltfincludelines", "on");
        preset.a("qualitylevel", "92");
        preset.a("qualityactive", "off");
        preset.a("imagetype", "png");
        preset.a("target", "clipboard");
        preset.a("addsuffix", "off");
        preset.a("lockview", "off");
        this.a.put(preset.a, preset);
        Preset preset2 = new Preset("manualweb", "Manual_web");
        preset2.a("unit", "px");
        preset2.a("lockratio", "off");
        preset2.a("width", "800");
        preset2.a("height", "600");
        preset2.a("resolution", "96");
        preset2.a("zoomextents", "off");
        preset2.a("antialias", "on");
        preset2.a("options1d", "on");
        preset2.a("options2d", "off");
        preset2.a("options3d", "off");
        preset2.a("title1d", "on");
        preset2.a("title2d", "on");
        preset2.a("title3d", "on");
        preset2.a("legend1d", "on");
        preset2.a("legend2d", "on");
        preset2.a("legend3d", "on");
        preset2.a("axes1d", "on");
        preset2.a("axes2d", "on");
        preset2.a("logo1d", "on");
        preset2.a("logo2d", "on");
        preset2.a("logo3d", "on");
        preset2.a("showgrid", "on");
        preset2.a("axisorientation", "on");
        preset2.a("grid", "on");
        preset2.a("fontsize", "9");
        preset2.a("customcolor", new String[]{"1", "1", "1"});
        preset2.a("background", "color");
        preset2.a("gltfincludelines", "on");
        preset2.a("qualitylevel", "92");
        preset2.a("qualityactive", "off");
        preset2.a("imagetype", "png");
        preset2.a("target", "clipboard");
        preset2.a("addsuffix", "off");
        preset2.a("lockview", "off");
        this.a.put(preset2.a, preset2);
        Preset preset3 = new Preset("manualprint", "Manual_print");
        preset3.a("unit", "mm");
        preset3.a("lockratio", "off");
        preset3.a("width", "120");
        preset3.a("height", "90");
        preset3.a("resolution", "300");
        preset3.a("zoomextents", "off");
        preset3.a("antialias", "on");
        preset3.a("options1d", "on");
        preset3.a("options2d", "off");
        preset3.a("options3d", "off");
        preset3.a("title1d", "on");
        preset3.a("title2d", "on");
        preset3.a("title3d", "on");
        preset3.a("legend1d", "on");
        preset3.a("legend2d", "on");
        preset3.a("legend3d", "on");
        preset3.a("axes1d", "on");
        preset3.a("axes2d", "on");
        preset3.a("logo1d", "on");
        preset3.a("logo2d", "on");
        preset3.a("logo3d", "on");
        preset3.a("showgrid", "on");
        preset3.a("axisorientation", "on");
        preset3.a("grid", "on");
        preset3.a("fontsize", "9");
        preset3.a("customcolor", new String[]{"1", "1", "1"});
        preset3.a("background", "color");
        preset3.a("gltfincludelines", "on");
        preset3.a("qualitylevel", "92");
        preset3.a("qualityactive", "off");
        preset3.a("imagetype", "png");
        preset3.a("target", "clipboard");
        preset3.a("addsuffix", "off");
        preset3.a("lockview", "off");
        this.a.put(preset3.a, preset3);
        Preset preset4 = new Preset("presentation", "Presentation");
        preset4.a("unit", "px");
        preset4.a("lockratio", "off");
        preset4.a("width", "874");
        preset4.a("height", "656");
        preset4.a("resolution", "96");
        preset4.a("zoomextents", "off");
        preset4.a("antialias", "on");
        preset4.a("options1d", "on");
        preset4.a("options2d", "off");
        preset4.a("options3d", "off");
        preset4.a("title1d", "on");
        preset4.a("title2d", "on");
        preset4.a("title3d", "on");
        preset4.a("legend1d", "on");
        preset4.a("legend2d", "on");
        preset4.a("legend3d", "on");
        preset4.a("axes1d", "on");
        preset4.a("axes2d", "on");
        preset4.a("logo1d", "on");
        preset4.a("logo2d", "on");
        preset4.a("logo3d", "on");
        preset4.a("showgrid", "on");
        preset4.a("axisorientation", "on");
        preset4.a("grid", "on");
        preset4.a("fontsize", "12");
        preset4.a("customcolor", new String[]{"1", "1", "1"});
        preset4.a("background", "transparent");
        preset4.a("gltfincludelines", "on");
        preset4.a("qualitylevel", "92");
        preset4.a("qualityactive", "off");
        preset4.a("imagetype", "png");
        preset4.a("target", "linked");
        preset4.a("addsuffix", "off");
        preset4.a("lockview", "off");
        this.a.put(preset4.a, preset4);
    }

    private void c() {
        Preferences preferences = Preferences.getInstance();
        String[] stringArray = preferences.getStringArrayPreference("general.custom.image.presets");
        String[] stringArray2 = preferences.getStringArrayPreference("general.custom.image.presetdata");
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if ("|".equals(stringArray2[n2])) {
                ++n2;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (n2 + 2 < stringArray2.length && !"|".equals(stringArray2[n2])) {
                    arrayList2.add(stringArray2[n2]);
                    arrayList2.add(stringArray2[n2 + 1]);
                    arrayList2.add(stringArray2[n2 + 2]);
                    n2 += 3;
                }
                arrayList.add(arrayList2);
                continue;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray.length && n3 < arrayList.size()) {
            Preset preset;
            String string = stringArray[n3];
            boolean bl2 = this.a.containsKey(string);
            Preset preset2 = preset = bl2 ? this.a.get(string) : new Preset(string, "#" + string);
            if (!bl2) {
                this.a.put(string, preset);
            }
            List list = (List)arrayList.get(n3);
            int n4 = 0;
            while (n4 < list.size() - 2) {
                String string2 = (String)list.get(n4);
                String string3 = (String)list.get(n4 + 1);
                String string4 = (String)list.get(n4 + 2);
                switch (string2) {
                    case "a": {
                        if (bl2) {
                            preset.b(string3, string4.split(","));
                            break;
                        }
                        preset.a(string3, string4.split(","));
                        break;
                    }
                    case "s": {
                        if (bl2) {
                            preset.b(string3, string4);
                            break;
                        }
                        preset.a(string3, string4);
                    }
                }
                n4 += 3;
            }
            ++n3;
        }
    }

    public void saveToPrefs() {
        if (this.d()) {
            return;
        }
        Preferences preferences = Preferences.getInstance();
        preferences.setPreference("general.custom.image.presets", this.a.keySet().toArray(new String[this.a.size()]));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Preset preset : this.a.values()) {
            arrayList.add("|");
            for (Map.Entry entry : preset.c.entrySet()) {
                arrayList.add("s");
                arrayList.add((String)entry.getKey());
                arrayList.add((String)entry.getValue());
            }
            for (Map.Entry entry : preset.d.entrySet()) {
                arrayList.add("a");
                arrayList.add((String)entry.getKey());
                arrayList.add(String.join((CharSequence)",", (CharSequence[])entry.getValue()));
            }
        }
        preferences.setPreference("general.custom.image.presetdata", arrayList.toArray(new String[arrayList.size()]));
        preferences.savePreferences();
    }

    public void setPreset(String string, de de2) {
        ImagePresets imagePresets = ImagePresets.getDefaultInstance();
        Preset preset = imagePresets.getPreset(string);
        boolean bl2 = preset != null;
        String string2 = this.a.containsKey(string) ? this.a.get(string).b : "#" + string;
        Preset preset2 = new Preset(string, string2);
        if (bl2) {
            preset2.c.putAll(preset.c);
            preset2.d.putAll(preset.d);
        }
        boolean bl3 = de2.getFromAllProperty("allowlinked").getBoolean();
        String string3 = null;
        if (!bl3 && this.a.containsKey(string)) {
            string3 = this.a.get(string).getString("target");
        }
        String[] stringArray = PRESET_PROPS;
        int n2 = PRESET_PROPS.length;
        int n3 = 0;
        while (n3 < n2) {
            String string4 = stringArray[n3];
            Property property = de2.getFromAllProperty(string4);
            if (property != null) {
                switch (ImagePresets.a()[property.getType().ordinal()]) {
                    case 8: {
                        if (bl2) {
                            preset2.b(string4, property.getStringArray());
                            break;
                        }
                        preset2.a(string4, property.getStringArray());
                        break;
                    }
                    default: {
                        String string5 = property.getString();
                        if ("target".equals(string4) && "linked".equals(string3) && "clipboard".equals(string5)) {
                            string5 = "linked";
                        }
                        if (bl2) {
                            preset2.b(string4, string5);
                            break;
                        }
                        preset2.a(string4, string5);
                    }
                }
            }
            ++n3;
        }
        this.a.put(string, preset2);
        this.saveToPrefs();
    }

    public void removePreset(String string, Model model) {
        this.a.remove(string);
        if (model != null) {
            ImagePresets.ensureAllExportFeaturesAreValid(model, this);
        }
        this.saveToPrefs();
    }

    public Map<String, Preset> getPresets() {
        return Collections.unmodifiableMap(this.a);
    }

    public Preset getPreset(String string) {
        return this.a.get(string);
    }

    private boolean d() {
        return this != b;
    }

    public static void ensureAllExportFeaturesAreValid(Model model, ImagePresets imagePresets) {
        for (ExportFeature object2 : model.result().export()) {
            if (!ExportOperationID.isImage(object2) || imagePresets.a.containsKey(object2.getString("size"))) continue;
            ImagePresets.switchToManualWebKeepingSize(object2);
        }
        ArrayList<ModelEntityImage> arrayList = new ArrayList<ModelEntityImage>();
        ImagePresets.a(model, arrayList);
        for (Object modelEntityImage : arrayList) {
            if (imagePresets.a.containsKey(modelEntityImage.getString("size"))) continue;
            ImagePresets.switchToManualWebKeepingSize((PropFeature)modelEntityImage);
        }
    }

    private static void a(PrimitiveModelEntity primitiveModelEntity2, List<ModelEntityImage> list) {
        if (primitiveModelEntity2 instanceof ModelEntityImage) {
            list.add((ModelEntityImage)primitiveModelEntity2);
        }
        primitiveModelEntity2.allChildren(true).forEach(primitiveModelEntity -> ImagePresets.a(primitiveModelEntity, list));
    }

    public static void switchToManualWebKeepingSize(PropFeature propFeature) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String object : ImagePresets.getInstance().getPreset("manualweb").getScalars().keySet()) {
            if (!propFeature.hasProperty(object)) continue;
            linkedHashMap.put(object, propFeature.getString(object));
        }
        propFeature.setWithoutLogging("size", "manualweb");
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (((String)entry.getValue()).equals(propFeature.getString((String)entry.getKey()))) continue;
            propFeature.setWithoutLogging((String)entry.getKey(), (String)entry.getValue());
        }
    }

    static /* synthetic */ int[] a() {
        if (c != null) {
            return c;
        }
        int[] nArray = new int[Property.PropertyType.values().length];
        try {
            nArray[Property.PropertyType.s.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.k.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.r.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.q.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.m.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.c.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.f.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.g.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.l.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.b.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.h.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.i.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.j.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.o.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.p.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.n.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.a.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.d.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.t.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Property.PropertyType.e.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        c = nArray;
        return nArray;
    }

    public static class Preset {
        private final String a;
        private final String b;
        private final Map<String, String> c = new LinkedHashMap<String, String>();
        private final Map<String, String[]> d = new LinkedHashMap<String, String[]>();

        public Preset(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        public String getDescription() {
            return this.b;
        }

        private void a(String string, String string2) {
            this.c.put(string, string2);
        }

        private void b(String string, String string2) {
            if (this.c.containsKey(string)) {
                this.c.put(string, string2);
            }
        }

        private void a(String string, String[] stringArray) {
            this.d.put(string, stringArray);
        }

        private void b(String string, String[] stringArray) {
            if (this.d.containsKey(string)) {
                this.d.put(string, stringArray);
            }
        }

        public String getString(String string) {
            return this.c.get(string);
        }

        public Map<String, String> getScalars() {
            return Collections.unmodifiableMap(this.c);
        }

        public Map<String, String[]> getArrays() {
            return Collections.unmodifiableMap(this.d);
        }
    }
}

