/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.results;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public enum ReportLevel {
    BRIEF("Brief"),
    INTERMEDIATE("Intermediate[report]"),
    COMPLETE("Complete"),
    MODEL("Model", false),
    INSTALLATION("Installation", false),
    USER("User", false),
    NONE("None", false);

    private String description;
    private boolean builtIn = true;
    public static final String[] REPORT_ALL_LEVEL_IDS;
    public static String[] REPORT_ALL_LEVEL_DESCRIPTIONS;
    public static final String[] REPORT_BUILT_IN_LEVEL_IDS;
    public static String[] REPORT_BUILT_IN_LEVEL_DESCRIPTIONS;

    static {
        REPORT_ALL_LEVEL_IDS = (String[])ReportLevel.a().stream().map(reportLevel -> reportLevel.getID()).toArray(String[]::new);
        REPORT_ALL_LEVEL_DESCRIPTIONS = (String[])ReportLevel.a().stream().map(reportLevel -> reportLevel.getDescription()).toArray(String[]::new);
        REPORT_BUILT_IN_LEVEL_IDS = (String[])ReportLevel.b().stream().map(reportLevel -> reportLevel.getID()).toArray(String[]::new);
        REPORT_BUILT_IN_LEVEL_DESCRIPTIONS = (String[])ReportLevel.b().stream().map(reportLevel -> reportLevel.getDescription()).toArray(String[]::new);
    }

    private ReportLevel(String string2) {
        this.description = string2;
    }

    private ReportLevel(String string2, boolean bl2) {
        this.description = string2;
        this.builtIn = bl2;
    }

    public String getID() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public static ReportLevel getDefaultLevel() {
        return INTERMEDIATE;
    }

    private static List<ReportLevel> a() {
        return Arrays.asList(ReportLevel.values());
    }

    private static List<ReportLevel> b() {
        return Arrays.asList(ReportLevel.values()).stream().filter(reportLevel -> reportLevel.builtIn).collect(Collectors.toList());
    }

    public static String getDescription(String string) {
        Optional<ReportLevel> optional = Arrays.asList(ReportLevel.values()).stream().filter(reportLevel -> reportLevel.getID().equals(string)).findFirst();
        if (optional.isPresent()) {
            return optional.get().description;
        }
        throw new IllegalArgumentException("No report level with ID '" + string + "' exists.");
    }

    public static ReportLevel getLevel(String string) {
        Optional<ReportLevel> optional = Arrays.asList(ReportLevel.values()).stream().filter(reportLevel -> reportLevel.getID().equals(string)).findFirst();
        return optional.isPresent() ? optional.get() : NONE;
    }
}

