/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.selections;

import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.GeomObjectSelection;
import com.comsol.model.dbimodel.GeomSequenceWrapper;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SEL_TYPES;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.dbimodel.SelectionContainer;
import com.comsol.model.dbimodel.XDLocalSelection;
import com.comsol.model.method.internal.IAbstractSelectionInternal;
import com.comsol.model.method.internal.IXDLocalSelectionInternal;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.selections.GlobalOnlySelectionFilter;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.q;
import java.util.Arrays;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractSelectionMethod {
    protected final IAbstractSelectionInternal b;
    private final PrimitiveModelEntity a;

    public AbstractSelectionMethod(IAbstractSelectionInternal iAbstractSelectionInternal, PrimitiveModelEntity primitiveModelEntity) {
        this.a = primitiveModelEntity;
        this.b = iAbstractSelectionInternal;
    }

    public boolean initializeSelection() {
        return false;
    }

    public AbstractSelection getSel() {
        return this.b;
    }

    public final PrimitiveModelEntity getParent() {
        if (this.a != null) {
            return this.a;
        }
        if (this.b != null) {
            return this.b.getParentEntity();
        }
        return null;
    }

    public void checkIsLocked() {
        if (this.b.isLocked()) {
            throw new FlException("Selection_is_not_editable");
        }
    }

    public ISelectionFilter deduceSelectionFilter() {
        ISelectionFilter iSelectionFilter = null;
        Object object = this.b.getContainer();
        if (object instanceof SelectionContainer) {
            iSelectionFilter = ((SelectionContainer)object).getSelectionFilter(this.b);
        } else if (object instanceof XDLocalSelection) {
            iSelectionFilter = ((IXDLocalSelectionInternal)object).selectionMethod().deduceSelectionFilter(this.b);
        } else if (object != null && this.b.getParentEntity() instanceof SelectionContainer) {
            iSelectionFilter = ((SelectionContainer)((Object)this.b.getParentEntity())).getSelectionFilter(this.b);
        }
        if (iSelectionFilter != null) {
            iSelectionFilter.notifySelectionChanged(this.b, ISelectionFilter.Notification.FILTER);
        }
        return iSelectionFilter;
    }

    public GeomSequenceWrapper getGeomSequence(String string) {
        ISelectionFilter iSelectionFilter = this.a();
        GeomSequenceWrapper geomSequenceWrapper = null;
        if (iSelectionFilter != null) {
            geomSequenceWrapper = iSelectionFilter.resolveGeometry(string);
        }
        if (geomSequenceWrapper == null && this.b() != null) {
            geomSequenceWrapper = this.b().geom(string);
        }
        return geomSequenceWrapper;
    }

    protected ISelectionFilter a() {
        return this.b.getSelectionFilter();
    }

    protected Model b() {
        return this.b.getModel();
    }

    public final String getSelectionKey() {
        StringBuilder stringBuilder = new StringBuilder();
        SEL_TYPES sEL_TYPES = this.b.getSelType();
        stringBuilder.append(sEL_TYPES.toString());
        this.a();
        switch (sEL_TYPES) {
            case NONE: 
            case GLOBAL: 
            case MESHREMAINING: {
                break;
            }
            case GEOM: {
                stringBuilder.append(this.b.geom());
                break;
            }
            case GEOMDIM: 
            case GEOMDIMTYPE: {
                IGeomSequence iGeomSequence = ((Selection)((Object)this.b)).getGeomSequence();
                stringBuilder.append(this.b.geom());
                int[] nArray = this.b.dimension();
                stringBuilder.append(Arrays.toString(nArray));
                if (iGeomSequence == null) break;
                if (((Selection)((Object)this.b)).isAllgeom() || ((Selection)((Object)this.b)).isAllvoids()) {
                    if (((Selection)((Object)this.b)).isAllgeom()) {
                        stringBuilder.append("ALL");
                    }
                    if (!((Selection)((Object)this.b)).isAllvoids()) break;
                    stringBuilder.append("VOIDS");
                    break;
                }
                int[] nArray2 = nArray;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray2[n3];
                    try {
                        stringBuilder.append(Arrays.toString(this.a(n4)));
                    }
                    catch (RuntimeException runtimeException) {
                        stringBuilder.append("BADSEL");
                    }
                    ++n3;
                }
                break;
            }
            case OBJECT: {
                stringBuilder.append(Arrays.toString(((GeomObjectSelection)((Object)this.b)).selectionMethod().getAllObjects()));
                break;
            }
            case OBJECTDIM: {
                Object[] objectArray = ((GeomObjectSelection)((Object)this.b)).selectionMethod().getAllObjects();
                stringBuilder.append(Arrays.toString(objectArray));
                int[] nArray = this.b.dimension();
                stringBuilder.append(Arrays.toString(nArray));
                stringBuilder.append(((GeomObjectSelection)((Object)this.b)).objectEntKey(nArray));
            }
        }
        return stringBuilder.toString();
    }

    protected int[] a(int n2) {
        return this.entities(n2, false);
    }

    public String getSelectionStringKey() {
        return this.getSelectionKey();
    }

    public final String toString() {
        return this.appendStringRep(new StringBuilder(), true).toString();
    }

    public StringBuilder appendStringRep(StringBuilder stringBuilder, boolean bl2) {
        switch (this.b.getSelType()) {
            case NONE: {
                return stringBuilder.append(FlLocale.getString((String)"Undefined"));
            }
        }
        return stringBuilder;
    }

    public boolean checkTouched(String string) {
        String string2 = this.getSelectionStringKey();
        if (!string.equals(string2)) {
            this.b.touch();
            return true;
        }
        return false;
    }

    public void checkType(ISelectionFilter.SelectionType selectionType) {
        ISelectionFilter iSelectionFilter = this.a();
        if (iSelectionFilter == null) {
            return;
        }
        if (!q.a((Object[])iSelectionFilter.getAllowedTypes(), (Object)((Object)selectionType))) {
            if (selectionType == ISelectionFilter.SelectionType.OBJECTDIM && iSelectionFilter.isVirtualSelection()) {
                return;
            }
            FlException flException = new FlException("Selection_type_not_allowed");
            flException.addParameterPair("Type", selectionType.getDescr());
            flException.addParameterPair("#Allowed types", Arrays.toString((Object[])iSelectionFilter.getAllowedTypes()));
            flException.addParameterPair("Selection", this.toString());
            if (iSelectionFilter instanceof GlobalOnlySelectionFilter) {
                flException.addParameterPair("#Filter", "GlobalOnlySelectionFilter");
            } else {
                flException.addParameterPair("#Filter", "Unknown: " + iSelectionFilter.getClass().getName());
            }
            throw flException;
        }
    }

    public void checkGeometry(String string) {
        ISelectionFilter iSelectionFilter = this.a();
        if (iSelectionFilter == null) {
            return;
        }
        if (!q.a((Object[])iSelectionFilter.getAllowedGeometries(), (Object)string)) {
            FlException flException = new FlException("Unsupported_geometry");
            flException.addParameterPair("Geometry", string);
            throw flException;
        }
    }

    public void checkDomainLevel(int n2) {
        ISelectionFilter iSelectionFilter = this.a();
        if (iSelectionFilter == null) {
            return;
        }
        if (!q.c((int[])iSelectionFilter.getAllowedEDims(), (int)n2)) {
            FlException flException = new FlException("Unsupported_geometric_entity_level");
            flException.addParameterPair("Level", String.valueOf(n2));
            throw flException;
        }
    }

    public int[] entities(int n2, boolean bl2) {
        return new int[0];
    }

    public void createReset(AbstractSelection abstractSelection, boolean bl2) {
    }

    public boolean compareAttributes(AbstractSelection abstractSelection, AttributesImpl attributesImpl, AttributesImpl attributesImpl2) {
        boolean bl2 = false;
        AbstractSelection abstractSelection2 = this.getSel();
        if (abstractSelection2.getClass() != abstractSelection.getClass()) {
            attributesImpl.addAttribute("", "", "class", "CDATA", abstractSelection2.getClass().getCanonicalName());
            attributesImpl2.addAttribute("", "", "class", "CDATA", abstractSelection.getClass().getCanonicalName());
            bl2 = true;
        }
        String string = abstractSelection2.selectionMethod().appendStringRep(new StringBuilder(), false).toString();
        String string2 = abstractSelection.selectionMethod().appendStringRep(new StringBuilder(), false).toString();
        attributesImpl.addAttribute("", "", "value", "CDATA", string);
        attributesImpl.addAttribute("", "", "Description", "CDATA", "Selection");
        attributesImpl2.addAttribute("", "", "value", "CDATA", string2);
        return bl2 |= !string.equals(string2);
    }

    protected void c() {
        this.b.unlock();
    }
}

