/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.selections;

import com.comsol.model.dbimodel.DrawObject;
import com.comsol.model.dbimodel.GeomFeature;
import com.comsol.model.dbimodel.GeomObject;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.selections.GeomObjectSelectionFilter;
import com.comsol.model.selections.ISelectionFilter;

public class SphericalSurfaceSelectionFilter
extends GeomObjectSelectionFilter {
    public SphericalSurfaceSelectionFilter(GeomSequence geomSequence, GeomFeature geomFeature) {
        super(geomSequence, geomFeature, new int[]{2});
    }

    @Override
    public boolean domainFiltering() {
        return true;
    }

    @Override
    public ISelectionFilter.DomainStatus[] getDomainStatus(DrawObject drawObject, int n2) {
        boolean[] blArray;
        GeomObject geomObject = drawObject.castToGeomObject();
        int n3 = geomObject.getNEntities()[n2];
        ISelectionFilter.DomainStatus[] domainStatusArray = ISelectionFilter.DomainStatus.allNotApplicable(n3);
        boolean[] blArray2 = blArray = geomObject.exists() ? geomObject.isFaceSpherical() : null;
        if (blArray == null) {
            return domainStatusArray;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (blArray[n4]) {
                domainStatusArray[n4 + 1] = ISelectionFilter.DomainStatus.VALID;
            }
            ++n4;
        }
        return domainStatusArray;
    }
}

