/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.simple;

import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.properties.ModelEntityReferenceCheck;
import com.comsol.model.simple.SimplePropFeature;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.nativeutil.constants.XmlPropUtil;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.ba;
import com.comsol.nativeutil.properties.bi;
import com.comsol.nativeutil.properties.bs;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.df;
import com.comsol.util.classes.CsXMLWriter;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.c;
import com.comsol.util.interfaces.u;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.io.BufferedWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimplePropSet
implements c,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6583234694961284006L;
    public static final String xmlParentProperty = "#XMLparent#";
    public static final boolean VERBOSE = false;
    private final Map<String, SimpleProp> properties = new LinkedHashMap<String, SimpleProp>();

    public SimplePropSet set(String string, String string2) {
        this.properties.put(string, new SimpleProp(string, string2));
        return this;
    }

    public SimplePropSet set(String string, String[] stringArray) {
        this.properties.put(string, new SimpleProp(string, stringArray));
        return this;
    }

    public SimplePropSet set(String string, String[][] stringArray) {
        this.properties.put(string, new SimpleProp(string, stringArray));
        return this;
    }

    public SimplePropSet set(String string, double d2) {
        this.properties.put(string, new SimpleProp(string, d2));
        return this;
    }

    public SimplePropSet set(String string, double[] dArray) {
        this.properties.put(string, new SimpleProp(string, dArray));
        return this;
    }

    public SimplePropSet set(String string, double[][] dArray) {
        this.properties.put(string, new SimpleProp(string, dArray));
        return this;
    }

    public SimplePropSet set(String string, int n2) {
        this.properties.put(string, new SimpleProp(string, n2));
        return this;
    }

    public SimplePropSet set(String string, int[] nArray) {
        this.properties.put(string, new SimpleProp(string, nArray));
        return this;
    }

    public SimplePropSet set(String string, boolean bl2) {
        this.properties.put(string, new SimpleProp(string, bl2));
        return this;
    }

    public SimplePropSet set(String string, Object object) {
        this.properties.put(string, new SimpleProp(string, object));
        return this;
    }

    public SimplePropSet set(String string, List<?> list) {
        this.properties.put(string, new SimpleProp(string, list));
        return this;
    }

    public boolean hasProp(String string) {
        return this.properties.containsKey(string);
    }

    public String getString(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.getString();
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public String[] getStringArray(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.getStringArray();
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public String[][] getStringMatrix(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.getStringMatrix();
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public double getDouble(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.getDouble();
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public double[] getDoubleArray(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.getDoubleArray();
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public double[][] getDoubleMatrix(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.getDoubleMatrix();
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public int getInt(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.getInt();
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public int[] getIntArray(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.getIntArray();
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public boolean getBoolean(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.getBoolean();
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public ModelEntity getReference(Model model, String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            Object object = simpleProp.getReference();
            if (object instanceof String && ((String)object).startsWith("/")) {
                String string2 = (String)object;
                String[] stringArray = string2.split("/");
                ModelEntity modelEntity = ModelEntityUtil.findEntity(null, model, stringArray, 1);
                if (modelEntity != null) {
                    this.set(string, modelEntity);
                }
                return modelEntity;
            }
            if (object instanceof ModelEntity) {
                return (ModelEntity)object;
            }
            return null;
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public List<ModelEntity> getReferenceArray(Model model, String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            List<ModelEntity> list = simpleProp.getReferenceArray();
            if (list.size() > 0 && list.get(0) instanceof String) {
                ArrayList<ModelEntity> arrayList = new ArrayList<ModelEntity>(list.size());
                int n2 = 0;
                while (n2 < list.size()) {
                    String[] stringArray = ((String)((Object)list.get(n2))).split("/");
                    ModelEntity modelEntity = ModelEntityUtil.findEntity(null, model, stringArray, 1);
                    if (modelEntity != null) {
                        arrayList.add(n2, modelEntity);
                    }
                    ++n2;
                }
                this.set(string, arrayList);
                return arrayList;
            }
            return list;
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public Property.PropertyType getPropertyType(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp != null) {
            return simpleProp.type;
        }
        throw new RuntimeException("Property_X_does_not_exist#" + string);
    }

    public SimplePropSet clone() {
        SimplePropSet simplePropSet = null;
        try {
            simplePropSet = (SimplePropSet)super.clone();
            for (SimpleProp simpleProp : this.properties.values()) {
                simplePropSet.properties.put(simpleProp.getName(), simpleProp.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return simplePropSet;
    }

    public boolean equals(Object object) {
        if (object instanceof SimplePropSet) {
            SimplePropSet simplePropSet = (SimplePropSet)object;
            return this.properties.equals(simplePropSet.properties);
        }
        return super.equals(object);
    }

    public SimplePropSet merge(SimplePropSet simplePropSet) {
        SimplePropSet simplePropSet2 = this.clone();
        for (SimpleProp simpleProp : simplePropSet.properties.values()) {
            if (this.properties.containsKey(simpleProp.getName())) {
                if (simpleProp.equals(this.properties.get(simpleProp.getName()))) continue;
                return null;
            }
            simplePropSet2.properties.put(simpleProp.getName(), simpleProp.clone());
        }
        return simplePropSet2;
    }

    public SimplePropSet mergeIntoThis(SimplePropSet simplePropSet) {
        for (SimpleProp simpleProp : simplePropSet.properties.values()) {
            this.properties.put(simpleProp.getName(), simpleProp.clone());
        }
        return this;
    }

    public void setInFeature(PropFeature propFeature) {
        for (SimpleProp simpleProp : this.properties.values()) {
            simpleProp.setInFeature(propFeature);
        }
    }

    public boolean setInFeatureSafe(PropFeature propFeature, int n2, boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        int n3 = 0;
        boolean bl3 = true;
        while (bl3 && n3++ < n2) {
            bl3 = this.a(propFeature, n3, hashSet, bl2);
        }
        return bl3;
    }

    private boolean a(PropFeature propFeature, int n2, HashSet<String> hashSet, boolean bl2) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        boolean bl3 = propFeature instanceof SimplePropFeature;
        Object object2 = propFeature.properties();
        int n3 = ((String[])object2).length;
        int n4 = 0;
        while (n4 < n3) {
            String string = object2[n4];
            hashMap.put(string, propFeature.getStringKey(string));
            ++n4;
        }
        boolean bl4 = false;
        for (SimpleProp simpleProp : this.properties.values()) {
            try {
                ba ba2;
                Object object3;
                Object object4;
                object2 = simpleProp.getName();
                String string = (String)hashMap.get(object2);
                if (bl3) {
                    object4 = ((SimplePropFeature)propFeature).getSimplePropSet();
                    if (string == null) {
                        object3 = simpleProp.clone();
                        if (object3 == null) continue;
                        ((SimplePropSet)object4).properties.put((String)object2, (SimpleProp)object3);
                        string = propFeature.getStringKey((String)object2);
                        hashMap.put(object2, string);
                    }
                } else {
                    object4 = propFeature.getPropValueInternal((String)object2);
                    if (object4 == null || hashSet.contains(object2) || simpleProp.isEqualInFeature(propFeature) || bl2 && object4.getProperty() != null && !(ba2 = (object3 = object4.getProperty()).getAnnotations()).I() && (ba2.a(null, (u)propFeature, false, true) || (ba2.q() || ba2.s()) && !ba2.y())) continue;
                }
                switch (simpleProp.type) {
                    case o: {
                        object4 = simpleProp.getReference();
                        object3 = this.getReference(propFeature.getModel(), (String)object2);
                        if (object3 != null) {
                            propFeature.set((String)object2, object3.tag());
                            break;
                        }
                        if (object4 instanceof String) {
                            propFeature.set((String)object2, (String)object4);
                            break;
                        }
                        propFeature.set((String)object2, (String)null);
                        break;
                    }
                    case p: {
                        ba2 = simpleProp.getReferenceArray();
                        List<ModelEntity> list = this.getReferenceArray(propFeature.getModel(), (String)object2);
                        if (!list.isEmpty()) {
                            String[] stringArray = (String[])list.stream().map(modelEntity -> modelEntity.method().getReferenceTag()).toArray(String[]::new);
                            propFeature.set((String)object2, stringArray);
                            break;
                        }
                        if (!ba2.stream().allMatch(object -> object instanceof String)) break;
                        propFeature.set((String)object2, ba2.toArray(new String[ba2.size()]));
                        break;
                    }
                    default: {
                        simpleProp.setInFeature(propFeature);
                    }
                }
                bl4 |= !string.equals(propFeature.getStringKey((String)object2));
            }
            catch (FlException flException) {
                bl4 = true;
            }
        }
        return bl4;
    }

    SimplePropSet a(de de2, PropFeature propFeature) {
        Property[] propertyArray = de2.getAllProperties();
        int n2 = propertyArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Property property = propertyArray[n3];
            if (propFeature.hasPropValue(property.getName())) {
                SimpleProp simpleProp = null;
                if (property.isComposite()) {
                    int n4 = propFeature.getPropValueInternal(property.getName()).getCompositeIndex();
                    Property[] propertyArray2 = ((com.comsol.nativeutil.properties.q)property).d();
                    if (n4 >= 0 && n4 < propertyArray2.length && propertyArray2[n4].hasExternalValue()) {
                        ModelEntityReferenceCheck modelEntityReferenceCheck;
                        if (propFeature.getPropertyReference(property.getName()) != null) {
                            simpleProp = new SimpleCompositeProp(this.a(propFeature, propertyArray2[n4]), propertyArray2);
                        } else if (propertyArray2[n4].getCheck() instanceof ModelEntityReferenceCheck && (modelEntityReferenceCheck = (ModelEntityReferenceCheck)propertyArray2[n4].getCheck()).getDefaultValue() != null) {
                            simpleProp = new SimpleCompositeProp(new SimpleProp(property.getName(), modelEntityReferenceCheck.getDefaultValue()), propertyArray2);
                        }
                    }
                    int n5 = 0;
                    while (simpleProp == null && n5 < propertyArray2.length) {
                        if (propertyArray2[n5].hasExternalValue() && propFeature.getPropertyReference(property.getName()) != null) {
                            simpleProp = new SimpleCompositeProp(this.a(propFeature, propertyArray2[n5]), propertyArray2);
                        }
                        ++n5;
                    }
                    if (simpleProp == null && n4 >= 0 && n4 < propertyArray2.length) {
                        simpleProp = new SimpleCompositeProp(this.a(propFeature, propertyArray2[n4]), propertyArray2);
                    } else if (simpleProp == null) {
                        FlLogger.c((String)String.format("Ignored composite prop '%s' because the stored index %d is not applicable for %d members (reference: %s)", property.getName(), n4, propertyArray2.length, ModelEntityUtil.getShortEntityPath(propFeature, true)));
                    }
                } else {
                    simpleProp = this.a(propFeature, property);
                }
                if (simpleProp != null) {
                    this.properties.put(property.getName(), simpleProp);
                }
            }
            ++n3;
        }
        return this;
    }

    public boolean remove(String string) {
        return this.properties.remove(string) != null;
    }

    public void removeAll() {
        this.properties.clear();
    }

    protected SimpleProp a(PropFeature propFeature, Property property) {
        switch (property.getType()) {
            case a: 
            case m: 
            case q: {
                return new SimpleProp(property.getName(), property.getString());
            }
            case d: {
                return new SimpleProp(property.getName(), property.getStringArray());
            }
            case e: 
            case j: {
                return new SimpleProp(property.getName(), property.getStringMatrix());
            }
            case b: {
                return new SimpleProp(property.getName(), property.getDouble());
            }
            case h: {
                String string = propFeature.getPropValueInternal(property.getName()).getValue();
                if (string != null) {
                    return new SimpleProp(property.getName(), string);
                }
                return new SimpleProp(property.getName(), property.getDoubleArray());
            }
            case i: {
                return new SimpleProp(property.getName(), property.getDoubleMatrix());
            }
            case c: {
                return new SimpleProp(property.getName(), property.getInt());
            }
            case f: {
                return new SimpleProp(property.getName(), property.getIntArray());
            }
            case k: {
                return new SimpleProp(property.getName(), property.getBoolean());
            }
            case o: {
                ModelEntity modelEntity = propFeature.getPropertyReference(property.getName());
                if (modelEntity instanceof ModelEntity) {
                    return new SimpleProp(property.getName(), Property.PropertyType.o, ModelEntityUtil.getEntityPath(modelEntity, "/", true));
                }
                if (modelEntity == null) {
                    return new SimpleProp(property.getName(), Property.PropertyType.o, null);
                }
                FlLogger.a((String)("WARNING: Skipped the reference property '" + property.getName() + "' since it did not refer to a ModelEntity."));
                break;
            }
            case p: {
                List<? extends ModelEntity> list = propFeature.getReferenceArray(property.getName());
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ModelEntity modelEntity : list) {
                    if (modelEntity instanceof ModelEntity) {
                        arrayList.add(ModelEntityUtil.getEntityPath(modelEntity, "/", true));
                        continue;
                    }
                    FlLogger.a((String)("WARNING: Skipped an element of the reference array property '" + property.getName() + "' since it did not refer to a ModelEntity."));
                }
                return new SimpleProp(property.getName(), Property.PropertyType.p, arrayList);
            }
        }
        return null;
    }

    public void registerProp(SimpleProp simpleProp) {
        this.properties.put(simpleProp.getName(), simpleProp);
    }

    SimpleProp a(String string) {
        SimpleProp simpleProp = this.properties.get(string);
        if (simpleProp == null) {
            throw new RuntimeException("Property_X_does_not_exist#" + string);
        }
        return simpleProp;
    }

    public bs getPropValue(String string) {
        return this.a(string);
    }

    public String[] getAllProperties() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    void a(CsXMLWriter csXMLWriter) {
        csXMLWriter.startSection("PropSet", new String[0]);
        for (SimpleProp simpleProp : this.properties.values()) {
            simpleProp.toXML(csXMLWriter);
        }
        csXMLWriter.endSection();
    }

    boolean a(de de2, PropFeature propFeature, CsXMLWriter csXMLWriter) {
        SimplePropSet simplePropSet = new SimplePropSet().a(de2, propFeature);
        return this.a(simplePropSet, csXMLWriter, de2);
    }

    boolean a(SimplePropSet simplePropSet, CsXMLWriter csXMLWriter, de de2) {
        Object object;
        Object object2;
        Object[] objectArray;
        Object[] objectArray2;
        boolean bl2 = false;
        Object[] objectArray3 = this.getAllProperties();
        if (de2 != null) {
            objectArray2 = de2.getAllProperties();
            objectArray = new String[objectArray2.length];
            int n2 = 0;
            while (n2 < objectArray2.length) {
                objectArray[n2] = objectArray2[n2].getName();
                ++n2;
            }
        } else {
            objectArray = simplePropSet.getAllProperties();
        }
        objectArray2 = (String[])q.d((Object[])objectArray, (Object[])objectArray3);
        String[] stringArray = (String[])q.b((Object[])objectArray3, (Object[])objectArray2);
        String[] stringArray2 = (String[])q.b((Object[])objectArray, (Object[])objectArray2);
        StringWriter stringWriter = new StringWriter();
        CsXMLWriter csXMLWriter2 = new CsXMLWriter(new BufferedWriter(stringWriter), 2);
        Object[] objectArray4 = objectArray2;
        int n3 = objectArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            SimpleProp simpleProp;
            object2 = objectArray4[n4];
            object = this.properties.get(object2);
            if (!((SimpleProp)object).equals(simpleProp = simplePropSet.properties.get(object2))) {
                AttributesImpl attributesImpl = new AttributesImpl();
                csXMLWriter2.startSection("Property", new String[]{"name", object2, "type", ((SimpleProp)object).type.name(), "value", ((SimpleProp)object).convertToString()});
                attributesImpl.addAttribute("", "", "type", "CDATA", simpleProp.type.name());
                attributesImpl.addAttribute("", "", "value", "CDATA", simpleProp.convertToString());
                attributesImpl.addAttribute("", "", "Description", "CDATA", FlLocale.getString((String)"Attributes_differ"));
                attributesImpl.addAttribute("", "", "icon", "CDATA", "$icon_conflict$");
                csXMLWriter2.startSection("Difference", (Attributes)attributesImpl, true, false);
                csXMLWriter2.endSection();
                bl2 = true;
            }
            ++n4;
        }
        if (bl2) {
            csXMLWriter.startSection("Difference", new String[]{"Description", FlLocale.getString((String)"Properties_differ"), "icon", "$icon_conflict$"});
            csXMLWriter2.flush();
            object2 = stringWriter.toString();
            if (((String)object2).trim().length() > 0) {
                csXMLWriter.writeRawData((String)object2);
            }
            csXMLWriter.endSection();
        }
        if (stringArray.length > 0) {
            csXMLWriter.startSection("Difference", new String[]{"Description", FlLocale.getString((String)"Properties_that_only_exist_in_local_file"), "icon", "$icon_outgoing$"});
            objectArray4 = stringArray;
            n3 = stringArray.length;
            n4 = 0;
            while (n4 < n3) {
                object2 = objectArray4[n4];
                this.properties.get(object2).toXML(csXMLWriter);
                ++n4;
            }
            csXMLWriter.endSection();
            bl2 = true;
        }
        if (stringArray2.length > 0) {
            csXMLWriter.startSection("Difference", new String[]{"Description", FlLocale.getString((String)"Properties_that_only_exist_in_remote_file"), "icon", "$icon_incoming$"});
            objectArray4 = stringArray2;
            n3 = stringArray2.length;
            n4 = 0;
            while (n4 < n3) {
                object2 = objectArray4[n4];
                if (simplePropSet.properties.containsKey(object2)) {
                    simplePropSet.properties.get(object2).toXML(csXMLWriter);
                    bl2 = true;
                } else if (de2 != null) {
                    object = new AttributesImpl();
                    ((AttributesImpl)object).addAttribute("", "", "name", "CDATA", (String)object2);
                    ((AttributesImpl)object).addAttribute("", "", "type", "CDATA", de2.getFromAllProperty((String)object2).getType().name());
                    try {
                        ((AttributesImpl)object).addAttribute("", "", "value", "CDATA", de2.getString((String)object2));
                    }
                    catch (FlException flException) {
                        ((AttributesImpl)object).addAttribute("", "", "value", "CDATA", "-");
                    }
                    csXMLWriter.startSection("UnsupportedProperty", (Attributes)object, true, true);
                }
                ++n4;
            }
            csXMLWriter.endSection();
        }
        return bl2;
    }

    protected int c() {
        return this.properties.size();
    }

    public c startElement(String string, Map<String, String> map) {
        Property.PropertyType[] propertyTypeArray;
        String[] stringArray;
        String string2 = map.get("name");
        SimpleProp simpleProp = null;
        String string3 = map.get("value");
        switch (Property.PropertyType.valueOf((String)map.get("type"))) {
            case a: {
                simpleProp = new SimpleProp(string2, string3);
                break;
            }
            case m: {
                simpleProp = new SimpleProp(string2, Property.PropertyType.m, string3);
                break;
            }
            case b: {
                simpleProp = new SimpleProp(string2, ParseUtil.c((String)string3));
                break;
            }
            case c: {
                simpleProp = new SimpleProp(string2, ParseUtil.a((String)string3));
                break;
            }
            case k: {
                simpleProp = new SimpleProp(string2, Boolean.parseBoolean(string3));
                break;
            }
            case d: {
                simpleProp = new SimpleProp(string2, XmlPropUtil.b((String[])q.b((String)string3)));
                break;
            }
            case e: {
                simpleProp = new SimpleProp(string2, XmlPropUtil.b((String[][])q.c((String)string3)));
                break;
            }
            case h: {
                simpleProp = new SimpleProp(string2, ParseUtil.b((String[])q.b((String)string3)));
                break;
            }
            case i: {
                simpleProp = new SimpleProp(string2, ParseUtil.a((String[][])q.c((String)string3)));
                break;
            }
            case f: {
                simpleProp = new SimpleProp(string2, ParseUtil.a((String[])q.b((String)string3)));
                break;
            }
            case o: {
                if (XmlPropUtil.XmlEscape.d.a().equals(string3)) {
                    simpleProp = new SimpleProp(string2, (Object)null);
                    break;
                }
                if ("&null;".equals(string3)) {
                    simpleProp = new SimpleProp(string2, (Object)null);
                    break;
                }
                simpleProp = new SimpleProp(string2, (Object)string3);
                break;
            }
            case p: {
                stringArray = q.b((String)string3);
                propertyTypeArray = new ArrayList(stringArray.length);
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string4 = stringArray2[n3];
                    if (XmlPropUtil.XmlEscape.d.a().equals(string4)) {
                        propertyTypeArray.add(null);
                    } else if ("&null;".equals(string4)) {
                        simpleProp = new SimpleProp(string2, (Object)null);
                    } else {
                        propertyTypeArray.add(string4);
                    }
                    ++n3;
                }
                simpleProp = new SimpleProp(string2, (List<?>)propertyTypeArray);
                break;
            }
        }
        if (simpleProp != null) {
            if (map.containsKey("otherTypes")) {
                stringArray = q.b((String)map.get("otherTypes"));
                propertyTypeArray = new Property.PropertyType[stringArray.length];
                int n4 = 0;
                while (n4 < stringArray.length) {
                    propertyTypeArray[n4] = Property.PropertyType.valueOf((String)stringArray[n4]);
                    ++n4;
                }
                simpleProp = new SimpleCompositeProp(simpleProp, propertyTypeArray);
            }
            this.properties.put(string2, simpleProp);
        }
        return this;
    }

    public c endElement(String string) {
        if ("PropSet".equals(string)) {
            return (c)this.properties.remove(xmlParentProperty).getReference();
        }
        return this;
    }

    public void addChild(String string, c c2) {
    }

    private static class SimpleCompositeProp
    extends SimpleProp {
        private static final long serialVersionUID = 1829862510483353127L;
        private final Property.PropertyType[] otherTypes;

        public SimpleCompositeProp(SimpleProp simpleProp, Property[] propertyArray) {
            super(simpleProp.name, simpleProp.type, simpleProp.value);
            ArrayList<Property.PropertyType> arrayList = new ArrayList<Property.PropertyType>(propertyArray.length);
            Property[] propertyArray2 = propertyArray;
            int n2 = propertyArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Property property = propertyArray2[n3];
                if (property.getType() != simpleProp.type) {
                    arrayList.add(property.getType());
                }
                ++n3;
            }
            this.otherTypes = arrayList.toArray(new Property.PropertyType[arrayList.size()]);
        }

        public SimpleCompositeProp(SimpleProp simpleProp, Property.PropertyType[] propertyTypeArray) {
            super(simpleProp.name, simpleProp.type, simpleProp.value);
            this.otherTypes = propertyTypeArray;
        }

        @Override
        public boolean isComposite() {
            return true;
        }

        @Override
        public String getString() {
            if (q.a((Object[])this.otherTypes, (Object)Property.PropertyType.a)) {
                return this.convertToString();
            }
            return super.getString();
        }

        @Override
        public Object getReference() {
            if (q.a((Object[])this.otherTypes, (Object)Property.PropertyType.o)) {
                return null;
            }
            return super.getReference();
        }

        @Override
        protected AttributesImpl a() {
            AttributesImpl attributesImpl = super.a();
            StringBuilder stringBuilder = new StringBuilder("[");
            Property.PropertyType[] propertyTypeArray = this.otherTypes;
            int n2 = this.otherTypes.length;
            int n3 = 0;
            while (n3 < n2) {
                Property.PropertyType propertyType = propertyTypeArray[n3];
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(propertyType.name());
                ++n3;
            }
            stringBuilder.append("]");
            attributesImpl.addAttribute("", "", "otherTypes", "CDATA", stringBuilder.toString());
            return attributesImpl;
        }
    }

    public static class SimpleProp
    implements bs,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7172317415883237189L;
        private final String name;
        protected Property.PropertyType type;
        protected Object value;

        protected SimpleProp(String string, Property.PropertyType propertyType, Object object) {
            this.name = string;
            this.type = propertyType;
            this.value = object;
        }

        public SimpleProp(String string, String string2) {
            this(string, Property.PropertyType.a, string2);
        }

        public SimpleProp(String string, String[] stringArray) {
            this(string, Property.PropertyType.d, null);
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            this.value = stringArray2;
        }

        public SimpleProp(String string, String[][] stringArray) {
            this(string, Property.PropertyType.e, null);
            String[][] stringArrayArray = new String[stringArray.length][];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArrayArray[n2] = new String[stringArray[n2].length];
                System.arraycopy(stringArray[n2], 0, stringArrayArray[n2], 0, stringArray[n2].length);
                ++n2;
            }
            this.value = stringArrayArray;
        }

        public SimpleProp(String string, double d2) {
            this(string, Property.PropertyType.b, d2);
        }

        public SimpleProp(String string, double[] dArray) {
            this(string, Property.PropertyType.h, null);
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            this.value = dArray2;
        }

        public SimpleProp(String string, double[][] dArray) {
            this(string, Property.PropertyType.i, null);
            double[][] dArrayArray = new double[dArray.length][];
            int n2 = 0;
            while (n2 < dArray.length) {
                dArrayArray[n2] = new double[dArray[n2].length];
                System.arraycopy(dArray[n2], 0, dArrayArray[n2], 0, dArray[n2].length);
                ++n2;
            }
            this.value = dArrayArray;
        }

        public SimpleProp(String string, int n2) {
            this(string, Property.PropertyType.c, n2);
        }

        public SimpleProp(String string, int[] nArray) {
            this(string, Property.PropertyType.f, null);
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            this.value = nArray2;
        }

        public SimpleProp(String string, boolean bl2) {
            this(string, Property.PropertyType.k, bl2);
        }

        public SimpleProp(String string, Object object) {
            this(string, Property.PropertyType.o, object);
        }

        public SimpleProp(String string, List<?> list) {
            this(string, Property.PropertyType.p, list);
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            if (this.type.equals((Object)Property.PropertyType.a) || this.type.equals((Object)Property.PropertyType.m)) {
                return (String)this.value;
            }
            throw new RuntimeException("Property_X_is_not_a_string#" + this.name);
        }

        public String[] getStringArray() {
            if (this.type.equals((Object)Property.PropertyType.d)) {
                return (String[])((String[])this.value).clone();
            }
            throw new RuntimeException("Property_X_is_not_a_string_array#" + this.name);
        }

        public String[][] getStringMatrix() {
            if (this.type.equals((Object)Property.PropertyType.e)) {
                return FlStringUtil.copy((String[][])((String[][])this.value));
            }
            throw new RuntimeException("Property_X_is_not_a_string_matrix#" + this.name);
        }

        public double getDouble() {
            if (this.type.equals((Object)Property.PropertyType.b)) {
                return (Double)this.value;
            }
            throw new RuntimeException("Property_X_is_not_a_double#" + this.name);
        }

        public double[] getDoubleArray() {
            if (this.type.equals((Object)Property.PropertyType.h)) {
                return (double[])((double[])this.value).clone();
            }
            throw new RuntimeException("Property_X_is_not_a_double_array#" + this.name);
        }

        public double[][] getDoubleMatrix() {
            if (this.type.equals((Object)Property.PropertyType.i)) {
                return q.e((double[][])((double[][])this.value));
            }
            throw new RuntimeException("Property_X_is_not_a_double_matrix#" + this.name);
        }

        public int getInt() {
            if (this.type.equals((Object)Property.PropertyType.c)) {
                return (Integer)this.value;
            }
            throw new RuntimeException("Property_X_is_not_an_integer#" + this.name);
        }

        public int[] getIntArray() {
            if (this.type.equals((Object)Property.PropertyType.f)) {
                return (int[])((int[])this.value).clone();
            }
            throw new RuntimeException("Property_X_is_not_an_integer_array#" + this.name);
        }

        public boolean getBoolean() {
            if (this.type.equals((Object)Property.PropertyType.k)) {
                return (Boolean)this.value;
            }
            throw new RuntimeException("Property_X_is_not_a_boolean#" + this.name);
        }

        public Object getReference() {
            if (this.type.equals((Object)Property.PropertyType.o)) {
                return this.value;
            }
            throw new RuntimeException("Property_X_is_not_a_reference#" + this.name);
        }

        public List<?> getReferenceArray() {
            if (this.type.equals((Object)Property.PropertyType.p)) {
                return (List)this.value;
            }
            throw new RuntimeException("Property_X_is_not_a_reference_array#" + this.name);
        }

        public boolean isComposite() {
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof SimpleProp) {
                SimpleProp simpleProp = (SimpleProp)object;
                if (this == simpleProp) {
                    return true;
                }
                if (!this.name.equals(simpleProp.name) || !this.type.equals((Object)simpleProp.type)) {
                    return false;
                }
                switch (this.type) {
                    case a: {
                        return this.getString().equals(simpleProp.getString());
                    }
                    case d: {
                        return FlStringUtil.equals((String[])this.getStringArray(), (String[])simpleProp.getStringArray());
                    }
                    case e: {
                        return FlStringUtil.equals((String[][])this.getStringMatrix(), (String[][])simpleProp.getStringMatrix());
                    }
                    case b: {
                        return this.getDouble() == simpleProp.getDouble();
                    }
                    case h: {
                        return q.b((double[])this.getDoubleArray(), (double[])simpleProp.getDoubleArray(), (double)0.0, (boolean)false);
                    }
                    case i: {
                        double[][] dArray = this.getDoubleMatrix();
                        double[][] dArray2 = simpleProp.getDoubleMatrix();
                        if (dArray.length != dArray2.length) {
                            return false;
                        }
                        int n2 = 0;
                        while (n2 < dArray.length) {
                            if (!q.b((double[])dArray[n2], (double[])dArray2[n2], (double)0.0, (boolean)false)) {
                                return false;
                            }
                            ++n2;
                        }
                        return true;
                    }
                    case c: {
                        return this.getInt() == simpleProp.getInt();
                    }
                    case f: {
                        return Arrays.equals(this.getIntArray(), simpleProp.getIntArray());
                    }
                    case k: {
                        return this.getBoolean() == simpleProp.getBoolean();
                    }
                    case o: {
                        return this.getReference() == null ? simpleProp.getReference() == null : this.getReference().equals(simpleProp.getReference());
                    }
                    case p: {
                        return this.getReferenceArray().equals(simpleProp.getReferenceArray());
                    }
                }
                return false;
            }
            return super.equals(object);
        }

        public SimpleProp clone() {
            switch (this.type) {
                case a: {
                    return new SimpleProp(this.name, this.getString());
                }
                case d: {
                    return new SimpleProp(this.name, this.getStringArray());
                }
                case e: {
                    return new SimpleProp(this.name, this.getStringMatrix());
                }
                case b: {
                    return new SimpleProp(this.name, this.getDouble());
                }
                case h: {
                    return new SimpleProp(this.name, this.getDoubleArray());
                }
                case i: {
                    return new SimpleProp(this.name, this.getDoubleMatrix());
                }
                case c: {
                    return new SimpleProp(this.name, this.getInt());
                }
                case f: {
                    return new SimpleProp(this.name, this.getIntArray());
                }
                case k: {
                    return new SimpleProp(this.name, this.getBoolean());
                }
                case o: {
                    if (this.value instanceof String) {
                        return new SimpleProp(this.name, this.type, this.value);
                    }
                    return new SimpleProp(this.name, this.type, null);
                }
                case p: {
                    if (this.value instanceof List && (((List)this.value).isEmpty() || ((List)this.value).get(0) instanceof String)) {
                        return new SimpleProp(this.name, this.type, this.value);
                    }
                    return new SimpleProp(this.name, this.type, null);
                }
            }
            return null;
        }

        public boolean setInFeature(PropFeature propFeature) {
            switch (this.type) {
                case a: 
                case m: {
                    if (propFeature.getString(this.name).equals(this.getString())) break;
                    propFeature.set(this.name, this.getString());
                    return true;
                }
                case d: {
                    if (Arrays.equals(propFeature.getStringArray(this.name), this.getStringArray())) break;
                    propFeature.set(this.name, this.getStringArray());
                    return true;
                }
                case e: {
                    if (Arrays.deepEquals((Object[])propFeature.getStringMatrix(this.name), (Object[])this.getStringMatrix())) break;
                    propFeature.set(this.name, this.getStringMatrix());
                    return true;
                }
                case b: {
                    if (propFeature.getDouble(this.name) == this.getDouble()) break;
                    propFeature.set(this.name, this.getDouble());
                    return true;
                }
                case h: {
                    if (Arrays.equals(propFeature.getDoubleArray(this.name), this.getDoubleArray())) break;
                    propFeature.set(this.name, this.getDoubleArray());
                    return true;
                }
                case i: {
                    if (Arrays.deepEquals((Object[])propFeature.getDoubleMatrix(this.name), (Object[])this.getDoubleMatrix())) break;
                    propFeature.set(this.name, this.getDoubleMatrix());
                    return true;
                }
                case c: {
                    if (propFeature.getInt(this.name) == this.getInt()) break;
                    propFeature.set(this.name, this.getInt());
                    return true;
                }
                case f: {
                    if (Arrays.equals(propFeature.getIntArray(this.name), this.getIntArray())) break;
                    propFeature.set(this.name, this.getIntArray());
                    return true;
                }
                case k: {
                    if (propFeature.getBoolean(this.name) == this.getBoolean()) break;
                    propFeature.set(this.name, this.getBoolean());
                    return true;
                }
                case o: {
                    Object object = this.getReference();
                    if (!(object instanceof ModelEntity) || propFeature.getPropertyReference(this.name) == object) break;
                    propFeature.set(this.name, ((ModelEntity)object).tag());
                    return true;
                }
            }
            return false;
        }

        public boolean isEqualInFeature(PropFeature propFeature) {
            switch (this.type) {
                case a: 
                case m: {
                    return propFeature.getString(this.name).equals(this.getString());
                }
                case d: {
                    return Arrays.equals(propFeature.getStringArray(this.name), this.getStringArray());
                }
                case e: {
                    return Arrays.deepEquals((Object[])propFeature.getStringMatrix(this.name), (Object[])this.getStringMatrix());
                }
                case b: {
                    return propFeature.getDouble(this.name) == this.getDouble();
                }
                case h: {
                    return Arrays.equals(propFeature.getDoubleArray(this.name), this.getDoubleArray());
                }
                case i: {
                    return Arrays.deepEquals((Object[])propFeature.getDoubleMatrix(this.name), (Object[])this.getDoubleMatrix());
                }
                case c: {
                    return propFeature.getInt(this.name) == this.getInt();
                }
                case f: {
                    return Arrays.equals(propFeature.getIntArray(this.name), this.getIntArray());
                }
                case k: {
                    return propFeature.getBoolean(this.name) == this.getBoolean();
                }
                case o: {
                    Object object = this.getReference();
                    return propFeature.getPropertyReference(this.name) == object;
                }
            }
            return false;
        }

        public void toXML(CsXMLWriter csXMLWriter) {
            csXMLWriter.startSection("Property", (Attributes)this.a(), true, true);
        }

        protected AttributesImpl a() {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "", "name", "CDATA", this.name);
            attributesImpl.addAttribute("", "", "type", "CDATA", this.type.name());
            attributesImpl.addAttribute("", "", "value", "CDATA", this.convertToString());
            return attributesImpl;
        }

        public String convertToString() {
            switch (this.type) {
                case a: 
                case b: 
                case c: 
                case k: 
                case m: {
                    return String.valueOf(this.value);
                }
                case h: {
                    return Arrays.toString((double[])this.value);
                }
                case f: {
                    return Arrays.toString((int[])this.value);
                }
                case d: {
                    return Arrays.deepToString(XmlPropUtil.a((String[])((String[])this.value)));
                }
                case e: {
                    return Arrays.deepToString((Object[])XmlPropUtil.a((String[][])((String[][])this.value)));
                }
                case i: {
                    return Arrays.deepToString((Object[])this.value);
                }
                case o: {
                    String string = XmlPropUtil.XmlEscape.d.a();
                    Object object = this.getReference();
                    if (object instanceof ModelEntity) {
                        string = ModelEntityUtil.getEntityPath((ModelEntity)object, "/", true);
                    } else if (object instanceof String) {
                        string = (String)object;
                    }
                    return string;
                }
                case p: {
                    List<?> list = this.getReferenceArray();
                    Object[] objectArray = new String[list.size()];
                    int n2 = 0;
                    while (n2 < list.size()) {
                        objectArray[n2] = list.get(n2) instanceof ModelEntity ? ModelEntityUtil.getEntityPath((ModelEntity)list.get(n2), "/", true) : (list.get(n2) instanceof String ? (String)list.get(n2) : XmlPropUtil.XmlEscape.d.a());
                        ++n2;
                    }
                    return Arrays.toString(objectArray);
                }
            }
            FlLogger.a((String)("WARNING: Skipped the property '" + this.name + "' since it is of the unsupported type '" + this.type.name() + "'."));
            return null;
        }

        public void internalReEvaluate() {
        }

        public bi.a getContainer() {
            return null;
        }

        public String getValue() {
            switch (this.type) {
                case k: {
                    return this.getBoolean() ? "on" : "off";
                }
                case m: {
                    return this.convertToString();
                }
            }
            return this.getString();
        }

        public String[][] getValueArray() {
            if (this.type == Property.PropertyType.d) {
                return new String[][]{this.getStringArray()};
            }
            return this.getStringMatrix();
        }

        public void setValueArray(String[][] stringArray) {
            throw new UnsupportedOperationException();
        }

        public String[] getValueRows() {
            throw new UnsupportedOperationException();
        }

        public void setValueRows(String[] stringArray) {
            throw new UnsupportedOperationException();
        }

        public void setRowMatrixValue(String[] stringArray, String[][] stringArray2) {
            throw new UnsupportedOperationException();
        }

        public int getIntValue() {
            return this.getInt();
        }

        public void setIntValue(int n2) {
            throw new UnsupportedOperationException();
        }

        public double getDoubleValue() {
            return this.getDouble();
        }

        public void setDoubleValue(double d2) {
            throw new UnsupportedOperationException();
        }

        public double[] getDoubleArrayValue() {
            return this.getDoubleArray();
        }

        public void setDoubleArrayValue(double[] dArray) {
            throw new UnsupportedOperationException();
        }

        public int[] getIntArrayValue() {
            return this.getIntArray();
        }

        public void setIntArrayValue(int[] nArray) {
            throw new UnsupportedOperationException();
        }

        public double[][] getDoubleMatrixValue() {
            return this.getDoubleMatrix();
        }

        public void setDoubleMatrixValue(double[][] dArray) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String string) {
            throw new UnsupportedOperationException();
        }

        public int getCompositeIndex() {
            return 0;
        }

        public void setCompositeIndex(int n2) {
            throw new UnsupportedOperationException();
        }

        public String[] getArrayErrorValue() {
            return null;
        }

        public void setArrayErrorValue(String[] stringArray) {
            throw new UnsupportedOperationException();
        }

        public String[][] getMatrixErrorValue() {
            return null;
        }

        public void setMatrixErrorValue(String[][] stringArray) {
            throw new UnsupportedOperationException();
        }

        public String[][] getUnitErrorValue() {
            return null;
        }

        public void setUnitErrorValue(String[][] stringArray) {
            throw new UnsupportedOperationException();
        }

        public void commit(df df2) {
            throw new UnsupportedOperationException();
        }

        public void fireSideEffectsRun() {
            throw new UnsupportedOperationException();
        }

        public String getEntityPath() {
            throw new UnsupportedOperationException();
        }

        public String scopeDot() {
            return "root.";
        }

        public void setSynchronized() {
        }
    }
}

