/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.applapi.SDimType;
import com.comsol.model.dbimodel.Frame;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.MODEL_NODE_TYPES;
import com.comsol.model.dbimodel.ModelNode;

public class ComponentUtil {
    public static SDimType getSDimType(ModelNode modelNode) {
        SDimType sDimType = SDimType.ND;
        if (modelNode != null) {
            if (modelNode.getGeom() != null) {
                GeomSequence geomSequence = modelNode.getGeom();
                sDimType = SDimType.getType(geomSequence.getSDim(), geomSequence.isAxisymmetric());
            } else {
                sDimType = SDimType.ZEROD;
            }
        }
        return sDimType;
    }

    public static MODEL_NODE_TYPES getModelNodeType(ModelNode modelNode) {
        MODEL_NODE_TYPES mODEL_NODE_TYPES = MODEL_NODE_TYPES.GLOBAL;
        if (modelNode != null) {
            mODEL_NODE_TYPES = modelNode.getModelType();
        }
        return mODEL_NODE_TYPES;
    }

    public static Frame getSpatialFrame(ModelNode modelNode) {
        if (modelNode == null) {
            return null;
        }
        for (Frame frame : modelNode.getModel().frame()) {
            if (!frame.getParentModel().equals(modelNode) || !frame.getGeom().isMainGeometry(false) || !frame.isSpatialFrame()) continue;
            return frame;
        }
        return null;
    }

    public static Frame getMaterialFrame(ModelNode modelNode) {
        if (modelNode == null) {
            return null;
        }
        for (Frame frame : modelNode.getModel().frame()) {
            if (!frame.getParentModel().equals(modelNode) || !frame.getGeom().isMainGeometry(false) || !frame.isMaterialFrame()) continue;
            return frame;
        }
        return null;
    }

    public static Frame getGeometryFrame(ModelNode modelNode) {
        if (modelNode == null) {
            return null;
        }
        for (Frame frame : modelNode.getModel().frame()) {
            if (!frame.getParentModel().equals(modelNode) || !frame.getGeom().isMainGeometry(false) || !frame.isGeometryFrame()) continue;
            return frame;
        }
        return null;
    }

    public static Frame getMeshFrame(ModelNode modelNode) {
        if (modelNode == null) {
            return null;
        }
        for (Frame frame : modelNode.getModel().frame()) {
            if (!frame.getParentModel().equals(modelNode) || !frame.getGeom().isMainGeometry(false) || !frame.isMeshFrame()) continue;
            return frame;
        }
        return null;
    }
}

