/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.dbmigration.framework.ModelTypes;
import com.comsol.dbmigration.framework.a;
import com.comsol.model.data.AttributeUtil;
import com.comsol.model.dbimodel.FileResource;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.Study;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.StudyList;
import com.comsol.model.operations.operationID.AppOperationID;
import com.comsol.model.util.ApplicationUtil;
import com.comsol.model.util.ModelLoadUtil;
import com.comsol.nativeutil.data.IModelAttributeUtil;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.p;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.Consumer;

public class ExecutableUtil {
    public static String validateNoClusterBatch(Model model, boolean bl2) throws FlException {
        StudyList<? extends Study> studyList = model.study();
        for (Study study : studyList) {
            for (StudyFeature studyFeature : study.feature()) {
                String string = studyFeature.getOperationID();
                String string2 = ExecutableUtil.validateNoClusterOrBatch(string, bl2);
                if (string2 == null) continue;
                return string2;
            }
        }
        return "";
    }

    public static String validateNoClusterOrBatch(String string, boolean bl2) {
        switch (string) {
            case "Batch": {
                if (bl2) {
                    throw new FlException("Batch_jobs_is_not_supported_in_standalone_application");
                }
                return string;
            }
            case "BatchSweep": {
                if (bl2) {
                    throw new FlException("Batch_sweep_is_not_supported_in_standalone_application");
                }
                return string;
            }
            case "BatchDesignofExperiments": {
                if (bl2) {
                    throw new FlException("Batch_design_of_experiments_is_not_supported_in_standalone_application");
                }
                return string;
            }
            case "ClusterComputing": {
                if (bl2) {
                    throw new FlException("Cluster_computing_is_not_supported_in_standalone_application");
                }
                return string;
            }
            case "ClusterSweep": {
                if (bl2) {
                    throw new FlException("Cluster_sweep_is_not_supported_in_standalone_application");
                }
                return string;
            }
        }
        return null;
    }

    public static String getFileNameAndUpdatesSplash(PropFeature propFeature, Consumer<FileResource> consumer, boolean bl2) {
        String string = propFeature.getString("splash_preview");
        if (string.isEmpty()) {
            consumer.accept(null);
            return "";
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Model model = propFeature.getModel();
        ApplicationUtil.collectAllFileTags(model.appBuilderFeature(), linkedHashMap, false);
        String string2 = (String)((HashMap)linkedHashMap).get(string);
        if (model.file().hasTag(string2)) {
            FileResource fileResource = model.file(string2);
            consumer.accept(fileResource);
            return bl2 ? fileResource.archive() : fileResource.getClientPath();
        }
        return "";
    }

    public static String getAppIconPathByFilename(Model model, String string, boolean bl2) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        ApplicationUtil.collectAllFileTags(model.appBuilderFeature(), linkedHashMap, false);
        String string2 = (String)((HashMap)linkedHashMap).get(string);
        for (FileResource fileResource : model.file()) {
            if (!fileResource.getTag().equals(string2)) continue;
            return bl2 ? fileResource.archive() : fileResource.resource();
        }
        return "";
    }

    public static String getAppIconPath(Model model, boolean bl2) {
        PropFeature propFeature2 = model.appBuilderFeature().stream().filter(propFeature -> AppOperationID.isOfType(propFeature, AppOperationID.SINGLE_WINDOW)).findFirst().orElse(null);
        if (propFeature2 == null) {
            return "";
        }
        String string = propFeature2.getString("icon");
        return ExecutableUtil.getAppIconPathByFilename(model, string, bl2);
    }

    public static void checkAppVersion(String string) {
        String string2;
        int n2 = a.a((IModelAttributeUtil)new AttributeUtil()).a(ModelTypes.a);
        File file = p.a((String)string, (String)"fileversion");
        if (file == null) {
            return;
        }
        try {
            string2 = FlFileUtil.p((File)file);
        }
        catch (IOException iOException) {
            throw new FlException((Throwable)iOException);
        }
        ModelLoadUtil.FileVersion fileVersion = ModelLoadUtil.extractFileVersion(string2);
        ModelLoadUtil.checkFileVersion(fileVersion, n2);
    }
}

