/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.applapi.PhysicalQuantityManager;
import com.comsol.model.applapi.SimpleSelection;
import com.comsol.model.data.EventManager;
import com.comsol.model.data.Node;
import com.comsol.model.data.Root;
import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.CopiedPrimitiveObject;
import com.comsol.model.dbimodel.CopyPasteInfo;
import com.comsol.model.dbimodel.Expression;
import com.comsol.model.dbimodel.FileResource;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.LocalSelection;
import com.comsol.model.dbimodel.MODEL_NODE_TYPES;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.ModelParam;
import com.comsol.model.dbimodel.ModelParamGroup;
import com.comsol.model.dbimodel.NodeGroup;
import com.comsol.model.dbimodel.OptFeatureList;
import com.comsol.model.dbimodel.ParameterContainer;
import com.comsol.model.dbimodel.ParameterEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.ProbeFeatureList;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropFeatureList;
import com.comsol.model.dbimodel.PropValue;
import com.comsol.model.dbimodel.Results;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.model.dbimodel.SelectionFeature;
import com.comsol.model.dbimodel.View;
import com.comsol.model.dbimodel.physics.FeatureInfo;
import com.comsol.model.dbimodel.physics.FeatureInfoList;
import com.comsol.model.dbmodel.ResultsDb;
import com.comsol.model.external.ExternalPrimitiveModelEntity;
import com.comsol.model.method.PrimitiveModelEntityMethod;
import com.comsol.model.operations.IFunctionOperation;
import com.comsol.model.operations.ReferenceArrayPropCheck;
import com.comsol.model.operations.ReferencePropCheck;
import com.comsol.model.param.ParamSpec;
import com.comsol.model.properties.DynamicStringCheck;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.savepoint.interfaces.IModelEntity;
import com.comsol.model.savepoint.interfaces.IModelEntityList;
import com.comsol.model.savepoint.interfaces.IPostInfoProvider;
import com.comsol.model.savepoint.interfaces.IPrimitiveModelEntity;
import com.comsol.model.util.GeomSequenceUtil;
import com.comsol.model.util.IModelManager;
import com.comsol.model.util.IParamDatabase;
import com.comsol.model.util.LoadedModel;
import com.comsol.model.util.LocalModel;
import com.comsol.model.util.ModelEntityCopyTask;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ModelPath;
import com.comsol.model.util.ModelType;
import com.comsol.model.util.NodeGroupUtil;
import com.comsol.model.util.QuickReadUtil;
import com.comsol.model.util.ReInitInfo;
import com.comsol.nativeutil.ComparisonResult;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.ba;
import com.comsol.nativeutil.properties.bi;
import com.comsol.nativeutil.runnable.f;
import com.comsol.nativeutil.runnable.k;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsXMLWriter;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.af;
import com.comsol.util.classes.an;
import com.comsol.util.classes.exprparser.BuiltInFunctions;
import com.comsol.util.classes.exprparser.BuiltInVariables;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.m;
import com.comsol.util.interfaces.u;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.ae;
import com.comsol.util.methods.q;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.xml.sax.helpers.AttributesImpl;

public class ModelEntityUtil {
    public static final String REFERENCE_ENTITY_SEPARATOR = "@##@";
    public static final String REFERENCE_ENTITY_PREFIX = "__REFERENCE_ENTITY";
    private static final Map<Class<? extends PrimitiveModelEntity>, String> a = new HashMap<Class<? extends PrimitiveModelEntity>, String>();
    public static final Pattern warningPattern = Pattern.compile("warning\\d*");
    public static final Pattern errorPattern = Pattern.compile("error\\d*");

    public static ModelEntity findEntity(ModelEntity modelEntity, String string) {
        if (string.indexOf(47) == 0 && !(modelEntity instanceof Model)) {
            modelEntity = modelEntity.getModel();
        }
        return ModelEntityUtil.findEntity(null, modelEntity, FlStringUtil.split((CharSequence)string, (char)'/', (boolean)false), 0);
    }

    public static ModelEntity findEntity(StringBuilder stringBuilder, ModelEntity modelEntity, String[] stringArray, int n2) {
        if (stringBuilder != null && n2 > 1 && !(modelEntity instanceof ModelEntityList)) {
            stringBuilder.append("/").append(modelEntity.getDisplayString());
        }
        if (n2 == stringArray.length) {
            return modelEntity;
        }
        String string = stringArray[n2];
        if (modelEntity instanceof ModelEntityList) {
            ModelEntityList modelEntityList = (ModelEntityList)modelEntity;
            if (modelEntityList.hasTag(string)) {
                return ModelEntityUtil.findEntity(stringBuilder, modelEntityList.get(string), stringArray, n2 + 1);
            }
        } else {
            List<PrimitiveModelEntity> list = modelEntity.allChildren(true);
            for (PrimitiveModelEntity primitiveModelEntity : list) {
                String string2 = null;
                if (primitiveModelEntity instanceof ModelEntity && !string.equals(string2 = ((ModelEntity)primitiveModelEntity).tag()) && (string2 == null || primitiveModelEntity instanceof ModelEntityList || primitiveModelEntity instanceof ResultsDb)) {
                    string2 = ModelEntityUtil.getInterfaceClassName(primitiveModelEntity);
                }
                if (!string.equals(string2)) continue;
                return ModelEntityUtil.findEntity(stringBuilder, (ModelEntity)primitiveModelEntity, stringArray, n2 + 1);
            }
        }
        return null;
    }

    public static ModelEntity findEntityShort(ModelEntity modelEntity, String[] stringArray, int n2) {
        if (n2 == stringArray.length) {
            return modelEntity;
        }
        String string = stringArray[n2];
        if (modelEntity instanceof ModelEntityList) {
            ModelEntityList modelEntityList = (ModelEntityList)modelEntity;
            if (modelEntityList.hasTag(string)) {
                return ModelEntityUtil.findEntityShort(modelEntityList.get(string), stringArray, n2 + 1);
            }
        } else {
            List<PrimitiveModelEntity> list = modelEntity.allChildren(true);
            for (PrimitiveModelEntity primitiveModelEntity : list) {
                if (primitiveModelEntity instanceof ModelEntityList) {
                    ModelEntityList modelEntityList = (ModelEntityList)primitiveModelEntity;
                    if (!modelEntityList.hasTag(string)) continue;
                    return ModelEntityUtil.findEntityShort(modelEntityList.get(string), stringArray, n2 + 1);
                }
                if (!(primitiveModelEntity instanceof ModelEntity) || !string.equals(((ModelEntity)primitiveModelEntity).tag())) continue;
                return ModelEntityUtil.findEntityShort((ModelEntity)primitiveModelEntity, stringArray, n2 + 1);
            }
        }
        return null;
    }

    public static ModelEntity findEntityInModelOrMatchingNonLocalModel(StringBuilder stringBuilder, ModelEntity modelEntity, String[] stringArray, int n2) {
        ModelEntity modelEntity2 = ModelEntityUtil.findEntity(stringBuilder, modelEntity, stringArray, n2);
        if (modelEntity2 == null && (modelEntity = ModelEntityUtil.getMatchingNonLocalModelEntity(modelEntity)) != null) {
            modelEntity2 = ModelEntityUtil.findEntity(stringBuilder, modelEntity, stringArray, n2);
        }
        return modelEntity2;
    }

    public static String getInterfaceClassName(PrimitiveModelEntity primitiveModelEntity) {
        Class<?> clazz = primitiveModelEntity.getClass();
        String string = a.get(clazz);
        if (string == null) {
            string = clazz.getSimpleName();
            if (primitiveModelEntity instanceof ExternalPrimitiveModelEntity && string.startsWith("Simple")) {
                string = string.substring("Simple".length());
            }
            ArrayList arrayList = new ArrayList();
            boolean bl2 = false;
            Class<?>[] classArray = clazz.getInterfaces();
            int n2 = classArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Class clazz2 = classArray[n3];
                String string2 = clazz2.getSimpleName();
                if (string.startsWith(string2)) {
                    string = string2;
                    bl2 = true;
                } else if (string2.startsWith("I") && string2.endsWith("Internal")) {
                    Collections.addAll(arrayList, clazz2.getInterfaces());
                }
                ++n3;
            }
            if (!bl2) {
                for (Class clazz2 : arrayList) {
                    if (!string.startsWith(clazz2.getSimpleName())) continue;
                    string = clazz2.getSimpleName();
                }
            }
            a.put(clazz, string);
        }
        return string;
    }

    public static <T extends PrimitiveModelEntity> String getEntityPath(T t2) {
        return ModelEntityUtil.getEntityPath(t2, "/", false);
    }

    public static <T extends PrimitiveModelEntity> String getEntityPath(T t2, String string, boolean bl2) {
        CharSequence charSequence;
        if (t2 == null) {
            throw new IllegalArgumentException();
        }
        Object object = t2;
        boolean bl3 = false;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        while (object != null) {
            bl3 = object instanceof Model;
            charSequence = object.getTag();
            if (charSequence == null || !bl2 && !ModelEntityUtil.a(object)) {
                stack.push(ModelEntityUtil.getInterfaceClassName(object));
            } else {
                stack.push(charSequence);
            }
            object = object.getContainer();
        }
        charSequence = new StringBuilder();
        if (bl3) {
            stack.pop();
        } else {
            ((StringBuilder)charSequence).append((String)stack.pop());
        }
        while (!stack.isEmpty()) {
            ((StringBuilder)charSequence).append(string).append((String)stack.pop());
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static boolean a(PrimitiveModelEntity primitiveModelEntity) {
        if (primitiveModelEntity instanceof Results) {
            return false;
        }
        if (primitiveModelEntity instanceof OptFeatureList) {
            return true;
        }
        if (primitiveModelEntity instanceof ProbeFeatureList) {
            return "massProp".equals(primitiveModelEntity.getTag());
        }
        return !(primitiveModelEntity instanceof ModelEntityList);
    }

    public static <T extends ModelEntity> String getEntityModelNodePath(T t2) {
        CharSequence charSequence;
        if (t2 == null) {
            throw new IllegalArgumentException();
        }
        ModelNode modelNode = t2.getParentModel();
        if (t2 == modelNode) {
            modelNode = null;
        }
        Object object = t2;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        while (object != null) {
            charSequence = object.getTag();
            if (charSequence == null || object instanceof ModelEntityList) {
                stack.push(ModelEntityUtil.getInterfaceClassName(object));
            } else {
                stack.push(charSequence);
            }
            object = object.getContainer();
        }
        charSequence = new StringBuilder();
        stack.pop();
        if (modelNode != null) {
            ((StringBuilder)charSequence).append("/ModelNodeList/").append(modelNode.tag());
        }
        while (!stack.isEmpty()) {
            ((StringBuilder)charSequence).append("/").append((String)stack.pop());
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String getEntityDisplayPath(ModelEntity modelEntity) {
        CharSequence charSequence;
        PrimitiveModelEntity primitiveModelEntity = modelEntity;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        while (primitiveModelEntity != null) {
            charSequence = null;
            if (!(primitiveModelEntity instanceof ModelEntityList)) {
                charSequence = primitiveModelEntity.label();
            }
            if (charSequence != null) {
                stack.push(charSequence);
            }
            primitiveModelEntity = primitiveModelEntity.getContainer();
        }
        charSequence = new StringBuilder();
        stack.pop();
        while (!stack.isEmpty()) {
            ((StringBuilder)charSequence).append("/").append((String)stack.pop());
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String getEntityStyledDisplayPath(ModelEntity modelEntity) {
        CharSequence charSequence;
        PrimitiveModelEntity primitiveModelEntity = modelEntity;
        Stack<StringBuilder> stack = new Stack<StringBuilder>();
        while (primitiveModelEntity != null) {
            charSequence = null;
            if (!(primitiveModelEntity instanceof ModelEntityList)) {
                charSequence = primitiveModelEntity.getStyledDisplayString().a();
            }
            if (charSequence != null) {
                stack.push((StringBuilder)charSequence);
            }
            primitiveModelEntity = primitiveModelEntity.getContainer();
        }
        charSequence = new StringBuilder();
        if (!stack.isEmpty()) {
            stack.pop();
        }
        while (!stack.isEmpty()) {
            ((StringBuilder)charSequence).append("/").append((String)stack.pop());
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static boolean isRunnable(ModelEntity modelEntity) {
        if (modelEntity != null) {
            Method[] methodArray = modelEntity.getClass().getMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Method method = methodArray[n3];
                if ("run".equals(method.getName())) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public static boolean hasWarning(FeatureInfoList<? extends FeatureInfo> featureInfoList) {
        return ModelEntityUtil.getWarningNode(featureInfoList) != null;
    }

    public static String getWarningNode(FeatureInfoList<? extends FeatureInfo> featureInfoList) {
        for (FeatureInfo featureInfo : featureInfoList) {
            if (!warningPattern.matcher(featureInfo.tag()).matches()) continue;
            return featureInfo.tag();
        }
        return null;
    }

    public static boolean hasError(FeatureInfoList<? extends FeatureInfo> featureInfoList) {
        return ModelEntityUtil.getErrorNode(featureInfoList) != null;
    }

    public static String getErrorNode(FeatureInfoList<? extends FeatureInfo> featureInfoList) {
        for (FeatureInfo featureInfo : featureInfoList) {
            if (!errorPattern.matcher(featureInfo.tag()).matches()) continue;
            return featureInfo.tag();
        }
        return null;
    }

    public static Method getExternalMethod(PrimitiveModelEntity primitiveModelEntity, String string, Class<?> clazz, Class<?> ... classArray) {
        Object object;
        Class<?> clazz2;
        String string2 = primitiveModelEntity.getClass().getSimpleName();
        String string3 = null;
        Class<?>[] classArray2 = primitiveModelEntity.getClass().getInterfaces();
        int n2 = classArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            clazz2 = classArray2[n3];
            if (string2.startsWith(clazz2.getSimpleName())) {
                string3 = clazz2.getCanonicalName();
            }
            ++n3;
        }
        if (string3 == null) {
            classArray2 = primitiveModelEntity.getClass().getInterfaces();
            n2 = classArray2.length;
            n3 = 0;
            while (n3 < n2) {
                clazz2 = classArray2[n3];
                Class<?>[] classArray3 = clazz2.getInterfaces();
                int n4 = classArray3.length;
                int n5 = 0;
                while (n5 < n4) {
                    object = classArray3[n5];
                    if (string2.startsWith(((Class)object).getSimpleName())) {
                        string3 = ((Class)object).getCanonicalName();
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        string3 = string3.replace(".internal.", ".").replace(".dbimodel.", ".");
        try {
            clazz2 = primitiveModelEntity.getClass().getClassLoader().loadClass(string3);
            object = clazz2.getMethods();
            int n6 = ((Method[])object).length;
            n2 = 0;
            while (n2 < n6) {
                Method method = object[n2];
                if (method.getName().equals(string) && method.getReturnType() == clazz) {
                    return primitiveModelEntity.getClass().getMethod(string, classArray);
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    public static <T extends ModelEntity> String getShortEntityPath(T t2, boolean bl2) {
        return ModelEntityUtil.getShortEntityPath(t2, bl2, false);
    }

    public static <T extends ModelEntity> String getShortEntityPath(T t2, boolean bl2, boolean bl3) {
        CharSequence charSequence;
        if (t2 == null) {
            return "";
        }
        Object object = t2;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        CharSequence charSequence2 = null;
        while (object != null) {
            charSequence = object.getTag();
            if (object instanceof Model) {
                if (bl3 && charSequence2 != null) {
                    stack.push(charSequence2);
                }
                if (bl2) {
                    stack.push(((Model)object).label());
                }
            } else if (object instanceof ModelEntityList) {
                charSequence2 = charSequence != null ? charSequence : ModelEntityUtil.getInterfaceClassName(object);
            } else if (charSequence != null) {
                stack.push(charSequence);
            }
            object = object.getContainer();
        }
        charSequence = new StringBuilder();
        while (!stack.isEmpty()) {
            ((StringBuilder)charSequence).append("/").append((String)stack.pop());
        }
        return ((StringBuilder)charSequence).length() > 0 ? ((StringBuilder)charSequence).substring(1) : "";
    }

    public static void initializeDefaultName(ModelEntity modelEntity, String string, boolean bl2) {
        String string2;
        int n2 = ModelEntityUtil.getFeatureNumber(modelEntity);
        boolean bl3 = !modelEntity.method().isInvisibleInGui();
        String string3 = string2 = bl3 ? FlLocale.getString((String)string, (boolean)true) : string;
        if (bl2) {
            string2 = "Derived " + string2;
        }
        if (n2 > 0) {
            string2 = String.valueOf(string2) + " " + n2;
        }
        if (!string2.equals(modelEntity.getEntityName())) {
            if (bl3) {
                string2 = ModelEntityUtil.uniqueNameWithinList(modelEntity, string2, n2);
            }
            modelEntity.setEntityName(string2);
        }
    }

    public static String getNewDefaultName(ModelEntity modelEntity, String string, boolean bl2) {
        String string2;
        if (modelEntity == null) {
            return string;
        }
        int n2 = ModelEntityUtil.getFeatureNumber(modelEntity);
        boolean bl3 = !modelEntity.method().isInvisibleInGui();
        String string3 = string2 = bl3 ? FlLocale.getString((String)string, (boolean)bl2) : string;
        if (n2 > 0) {
            string2 = String.valueOf(string2) + " " + n2;
        }
        if (!string2.equals(modelEntity.getEntityName()) && bl3) {
            string2 = ModelEntityUtil.uniqueNameWithinList(modelEntity, string2, n2);
        }
        return string2;
    }

    public static final int getFeatureNumber(ModelEntity modelEntity) {
        String string = modelEntity.getTag();
        return ModelEntityUtil.getFeatureNumber(string);
    }

    public static final int getFeatureNumber(String string) {
        if (string == null) {
            return 0;
        }
        int n2 = string.length();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (!Character.isDigit(string.charAt(n3)) || n3 < n2 - 9) {
                if (n3 < n2 - 1) {
                    return Integer.parseInt(string.substring(n3 + 1));
                }
                return 0;
            }
            --n3;
        }
        return 0;
    }

    public static final String uniqueNameWithinList(ModelEntity modelEntity, String string, int n2) {
        ModelEntityList modelEntityList = null;
        PrimitiveModelEntityMethod primitiveModelEntityMethod = modelEntity.method().getContainer();
        if (primitiveModelEntityMethod != null && primitiveModelEntityMethod.getMe() instanceof ModelEntityList) {
            modelEntityList = (ModelEntityList)primitiveModelEntityMethod.getMe();
        }
        return ModelEntityUtil.uniqueNameWithinList(modelEntityList, string, n2);
    }

    public static String uniqueNameWithinList(ModelEntityList<? extends ModelEntity> modelEntityList, String string, int n2) {
        if (modelEntityList != null) {
            ModelEntityList modelEntityList2 = (ModelEntityList)ModelEntityUtil.getMatchingNonLocalModelEntity(modelEntityList);
            if (modelEntityList.containsName(string) || modelEntityList2 != null && modelEntityList2.containsName(string)) {
                String string2;
                int n3 = 0;
                do {
                    if (n2 > 0) {
                        if (n3 < 24) {
                            string2 = String.valueOf(string) + (char)(97 + n3++);
                            continue;
                        }
                        string2 = String.valueOf(string) + "." + n3++;
                        continue;
                    }
                    string2 = String.valueOf(string) + " " + String.valueOf(++n3 + 1);
                } while (modelEntityList.containsName(string2) || modelEntityList2 != null && modelEntityList2.containsName(string2));
                string = string2;
            }
        }
        return string;
    }

    public static ModelEntity getMatchingNonLocalModelEntity(ModelEntity modelEntity) {
        ModelEntity modelEntity2 = null;
        if (modelEntity != null && modelEntity.isInModel()) {
            Model model = ModelInternalUtil.getMatchingNonLocalModel(modelEntity.getModel());
            modelEntity2 = ModelEntityUtil.getMatchingModelEntityInOtherModel(modelEntity, model);
        }
        return modelEntity2;
    }

    public static ModelEntity getMatchingModelEntityInOtherModel(ModelEntity modelEntity, Model model) {
        Node node;
        ModelEntity modelEntity2 = null;
        if (model != null && (node = model.getNode().getRoot().parseRef(modelEntity.getNode().getModelPath())) != null) {
            modelEntity2 = (ModelEntity)((Object)node.getObjectEntity());
        }
        return modelEntity2;
    }

    public static String uniqueLabelWithinList(ModelEntityList<? extends ModelEntity> modelEntityList, String string, int n2) {
        if (modelEntityList != null && modelEntityList.containsLabel(string)) {
            String string2;
            int n3 = 0;
            do {
                if (n2 > 0) {
                    if (n3 < 24) {
                        string2 = String.valueOf(string) + (char)(97 + n3++);
                        continue;
                    }
                    string2 = String.valueOf(string) + "." + n3++;
                    continue;
                }
                string2 = String.valueOf(string) + " " + String.valueOf(++n3 + 1);
            } while (modelEntityList.containsLabel(string2));
            string = string2;
        }
        return string;
    }

    public static final String uniqueNameWithinList(ModelEntity modelEntity, String string) {
        String string2;
        ModelEntityList modelEntityList = null;
        PrimitiveModelEntityMethod primitiveModelEntityMethod = modelEntity.method().getContainer();
        if (primitiveModelEntityMethod != null && primitiveModelEntityMethod.getMe() instanceof ModelEntityList) {
            modelEntityList = (ModelEntityList)primitiveModelEntityMethod.getMe();
        }
        int n2 = 1;
        do {
            string2 = String.valueOf(string) + " " + String.valueOf(n2++);
        } while (modelEntityList != null && modelEntityList.containsName(string2) && !string2.equals(modelEntity.label()));
        return string2;
    }

    public static final String uniqueNameWithinListParentheses(ModelEntity modelEntity, String string) {
        ModelEntityList modelEntityList = null;
        PrimitiveModelEntityMethod primitiveModelEntityMethod = modelEntity.method().getContainer();
        if (primitiveModelEntityMethod != null && primitiveModelEntityMethod.getMe() instanceof ModelEntityList) {
            modelEntityList = (ModelEntityList)primitiveModelEntityMethod.getMe();
        }
        if (modelEntityList != null && modelEntityList.containsName(string)) {
            String string2;
            int n2 = 1;
            while (modelEntityList.containsName(string2 = String.valueOf(string) + " (" + String.valueOf(++n2) + ")")) {
            }
            string = string2;
        }
        return string;
    }

    public static String getModelTag(PrimitiveModelEntity primitiveModelEntity) {
        if (primitiveModelEntity != null && primitiveModelEntity.isInModel()) {
            return primitiveModelEntity.getModel().tag();
        }
        return m.a;
    }

    public static <T extends PrimitiveModelEntity> String getPrimitiveEntityPath(T t2) {
        if (t2 == null) {
            return "";
        }
        if (t2 instanceof ModelEntity) {
            return ModelEntityUtil.getEntityPath((ModelEntity)t2);
        }
        if (t2.getContainer() instanceof ModelEntity) {
            return String.valueOf(ModelEntityUtil.getEntityPath((ModelEntity)t2.getContainer())) + ":" + t2.getTag();
        }
        return t2.getTag();
    }

    public static <T extends PrimitiveModelEntity> String serializeToStringForCopy(Collection<T> collection, CopyPasteInfo copyPasteInfo, boolean bl2, String ... stringArray) {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        try {
            try {
                CsXMLWriter csXMLWriter = new CsXMLWriter(bufferedWriter);
                if (bl2) {
                    csXMLWriter.startDocument();
                }
                csXMLWriter.startSection("CopiedObjects", stringArray);
                copyPasteInfo.getNode().toXML(csXMLWriter);
                for (T t2 : collection) {
                    if (t2 instanceof PrimitiveModelEntity) {
                        PrimitiveModelEntity primitiveModelEntity = (PrimitiveModelEntity)t2;
                        primitiveModelEntity.getNode().toXML(csXMLWriter);
                        continue;
                    }
                    FlLogger.c((String)"Skipped invalid object in serialization for copy");
                }
                csXMLWriter.endSection();
                if (bl2) {
                    csXMLWriter.endDocument();
                }
            }
            catch (Throwable throwable) {
                FlLogger.b((Throwable)throwable);
                throw throwable;
            }
        }
        finally {
            try {
                bufferedWriter.close();
                return stringWriter.toString();
            }
            catch (IOException iOException) {
                FlLogger.b((Throwable)iOException);
            }
        }
        return null;
    }

    public static CopyPasteInfo deserializeFromPastedString(String string, ModelType modelType, long l2) {
        ModelType modelType2;
        if (string == null || modelType == null) {
            return null;
        }
        final CopyPasteInfo[] copyPasteInfoArray = new CopyPasteInfo[1];
        QuickReadUtil.MaxDepthFilter maxDepthFilter = new QuickReadUtil.MaxDepthFilter("CopiedObjects", "modelType", 0);
        List<String> list = QuickReadUtil.quickReadAttribute(string, (QuickReadUtil.QuickReadFilter)maxDepthFilter);
        if (list.isEmpty()) {
            modelType2 = modelType;
        } else {
            modelType2 = ModelType.valueOf(list.get(0));
            if (modelType2 != modelType) {
                return null;
            }
        }
        LocalModel localModel = ModelInternalUtil.createLocalModel(modelType2, true, false);
        localModel.getModel().setBlockClusterOperations(true);
        localModel.getModel().getNode().getRoot().getFileResourceManager().a(true);
        final Root root = localModel.getModel().getNode().getRoot();
        root.markAsClipboardCopy();
        try {
            try {
                root.getReferenceDatabase().prepareDatabasePreCopy();
                StringReader stringReader = new StringReader(string);
                com.comsol.util.interfaces.c c2 = new com.comsol.util.interfaces.c(){

                    public com.comsol.util.interfaces.c startElement(String string, Map<String, String> map) {
                        if (string.equals("CopiedObjects")) {
                            return new a(this){
                                private int c;
                                {
                                    super(c2);
                                    this.c = -1;
                                }

                                public com.comsol.util.interfaces.c startElement(String string, Map<String, String> map) {
                                    if (string.equals("CopyPasteInfo")) {
                                        return root.addChildFromXmlElement(this, string, map, node -> {
                                            CopyPasteInfo copyPasteInfo = (CopyPasteInfo)((Object)node.getObjectEntity());
                                        });
                                    }
                                    if (copyPasteInfoArray[0] == null) {
                                        return new Node.IgnoreElementReader(this);
                                    }
                                    if (copyPasteInfoArray[0].getCopiedObject(++this.c) != null) {
                                        throw new IllegalArgumentException("Cannot add a copied object to a occupied index");
                                    }
                                    String string2 = String.valueOf(this.c);
                                    CopiedPrimitiveObject copiedPrimitiveObject = copyPasteInfoArray[0].addReference(string2);
                                    copiedPrimitiveObject.set("path", copyPasteInfoArray[0].getCopiedPath(this.c));
                                    return copiedPrimitiveObject.getNode().addChildFromXmlElement(this, string, map, null);
                                }

                                public com.comsol.util.interfaces.c endElement(String string) {
                                    return this.b;
                                }

                                public void addChild(String string, com.comsol.util.interfaces.c c2) {
                                }
                            };
                        }
                        return new Node.IgnoreElementReader(this);
                    }

                    public com.comsol.util.interfaces.c endElement(String string) {
                        return null;
                    }

                    public void addChild(String string, com.comsol.util.interfaces.c c2) {
                    }
                };
                ae.a((Reader)stringReader, (com.comsol.util.interfaces.c)c2);
            }
            catch (RuntimeException runtimeException) {
                FlLogger.b((String)("Illegal XML content:\n%" + string));
                FlLogger.b((Throwable)runtimeException);
                if (copyPasteInfoArray[0] != null) {
                    copyPasteInfoArray[0].postPasteSerialization();
                    copyPasteInfoArray[0].setLocalModel(localModel);
                    boolean bl2 = copyPasteInfoArray[0].getTimeStamp() != l2;
                    copyPasteInfoArray[0].setPastingFromAnotherModel(bl2);
                    copyPasteInfoArray[0].setKeepReferencesWhenPasting(modelType2 == ModelType.DESIGN || !bl2);
                } else {
                    localModel.dispose();
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (copyPasteInfoArray[0] != null) {
                copyPasteInfoArray[0].postPasteSerialization();
                copyPasteInfoArray[0].setLocalModel(localModel);
                boolean bl3 = copyPasteInfoArray[0].getTimeStamp() != l2;
                copyPasteInfoArray[0].setPastingFromAnotherModel(bl3);
                copyPasteInfoArray[0].setKeepReferencesWhenPasting(modelType2 == ModelType.DESIGN || !bl3);
            } else {
                localModel.dispose();
            }
            throw throwable;
        }
        if (copyPasteInfoArray[0] != null) {
            copyPasteInfoArray[0].postPasteSerialization();
            copyPasteInfoArray[0].setLocalModel(localModel);
            boolean bl4 = copyPasteInfoArray[0].getTimeStamp() != l2;
            copyPasteInfoArray[0].setPastingFromAnotherModel(bl4);
            copyPasteInfoArray[0].setKeepReferencesWhenPasting(modelType2 == ModelType.DESIGN || !bl4);
        } else {
            localModel.dispose();
        }
        return copyPasteInfoArray[0];
    }

    public static void reInitializeForPaste(ModelEntity modelEntity, ModelType modelType) {
        try {
            modelEntity.reInitialize(ReInitInfo.allChildrenPaste);
        }
        catch (RuntimeException runtimeException) {
            FlLogger.b((Throwable)runtimeException);
        }
    }

    public static boolean containedInLists(List<ModelEntity> list, ModelEntity modelEntity) {
        for (ModelEntity modelEntity2 : list) {
            if (!ModelInternalUtil.containedBy(modelEntity2, modelEntity)) continue;
            return true;
        }
        return false;
    }

    public static ModelEntity findPastedObjectUsedInLink(String string, List<ModelEntity> list, PropFeature propFeature2, CopyPasteInfo copyPasteInfo) {
        String string2 = ModelEntityUtil.getCopiedPath(propFeature2, copyPasteInfo);
        String string3 = copyPasteInfo.getReferenceFromSetting(String.valueOf(string2) + ":" + string);
        ModelEntity modelEntity3 = propFeature2.getPropertyReference(string);
        Optional<ModelEntity> optional = ModelEntityUtil.findPastedObjectUsedInLink(string3, propFeature2.getModel(), copyPasteInfo);
        if (!optional.isPresent()) {
            optional = Optional.ofNullable(ModelEntityUtil.findChildOfPastedObjectUsedInLink(string3, propFeature2.getModel(), copyPasteInfo));
        }
        BiFunction<PropFeature, ModelEntity, Boolean> biFunction = (propFeature, modelEntity) -> {
            if (propFeature.getPropertyReference(string) != modelEntity) {
                return true;
            }
            return false;
        };
        if (optional.isPresent()) {
            copyPasteInfo.removeMessages(ModelEntityUtil.getSettingObject(propFeature2, string));
            return optional.filter(modelEntity2 -> modelEntity2 != modelEntity3).orElse(null);
        }
        if (string3 == null) {
            Property property = propFeature2.getPropValueInternal(string).getProperty();
            if (modelEntity3 != null && !property.isComposite()) {
                copyPasteInfo.addMessage("Pasted_object_refers_to_an_entity_that_was_not_present_in_the_original_XYZ#" + propFeature2.tag() + "#" + modelEntity3.getDisplayString() + "#" + ModelEntityUtil.getDescription(propFeature2, string, true), ModelEntityUtil.getSettingObject(propFeature2, string));
            }
            return null;
        }
        if (ModelEntityUtil.containedInLists(list, modelEntity3)) {
            copyPasteInfo.addMessage("Pasted_object_refers_to_an_entity_that_already_existed_in_application_XYZ#" + propFeature2.tag() + "#" + modelEntity3.getDisplayString() + "#" + ModelEntityUtil.getDescription(propFeature2, string, true), ModelEntityUtil.getSettingObject(propFeature2, string));
            return null;
        }
        Property property = propFeature2.getPropValueInternal(string).getProperty();
        ReferencePropCheck referencePropCheck = (ReferencePropCheck)property.getExternalCheck();
        String string4 = ModelEntityUtil.getReferenceTag(property, string3);
        ModelEntity modelEntity4 = null;
        Object[] objectArray = new String[]{};
        try {
            objectArray = referencePropCheck.getAllowedValues();
            if (q.a((Object[])objectArray, (Object)string4)) {
                modelEntity4 = referencePropCheck.resolveEntity(string4);
            }
        }
        catch (FlException flException) {}
        ba ba2 = property.getAnnotations();
        if (modelEntity4 != null && modelEntity4 == modelEntity3) {
            ModelEntityUtil.a(string, propFeature2, copyPasteInfo, string2, modelEntity3, biFunction);
            return null;
        }
        if (modelEntity4 != null && (copyPasteInfo.keepReferencesWhenPasting() || ba2.bP())) {
            if (!ModelEntityUtil.containedInLists(list, modelEntity4)) {
                ModelEntityUtil.a(string, propFeature2, copyPasteInfo, string2, modelEntity4, biFunction);
            }
            return modelEntity4;
        }
        if (modelEntity3 != null) {
            ModelEntityUtil.a(string, propFeature2, copyPasteInfo, string2, modelEntity3, biFunction);
            return null;
        }
        if (objectArray.length > 0 && propFeature2.getString(string) == null) {
            referencePropCheck.resetToDefault(propFeature2, string);
            modelEntity4 = propFeature2.getPropertyReference(string);
        }
        if (modelEntity4 != null) {
            copyPasteInfo.addMessage("Pasted_object_refers_to_an_entity_that_was_not_present_in_the_original_XYZ#" + propFeature2.tag() + "#" + modelEntity4.getDisplayString() + "#" + ModelEntityUtil.getDescription(propFeature2, string, true), ModelEntityUtil.getSettingObject(propFeature2, string));
        } else {
            copyPasteInfo.addMessage("Cleared_reference_in_pasted_object_because_it_contains_an_invalid_reference_XYZ#" + string3 + "#" + propFeature2.tag() + "#" + ModelEntityUtil.getDescription(propFeature2, string, true), ModelEntityUtil.getSettingObject(propFeature2, string));
        }
        return null;
    }

    public static List<ModelEntity> findPastedObjectArrayUsedInLink(String string, List<ModelEntity> list, PropFeature propFeature2, CopyPasteInfo copyPasteInfo) {
        List<? extends ModelEntity> list2 = propFeature2.getReferenceArray(string);
        String string2 = ModelEntityUtil.getCopiedPath(propFeature2, copyPasteInfo);
        Property property = propFeature2.getPropValueInternal(string).getProperty();
        ReferenceArrayPropCheck referenceArrayPropCheck = (ReferenceArrayPropCheck)property.getExternalCheck();
        ArrayList<ModelEntity> arrayList = new ArrayList<ModelEntity>();
        int n2 = 0;
        Model model = propFeature2.getModel();
        String string3 = ":" + n2;
        String string4 = String.valueOf(string) + string3;
        String string5 = copyPasteInfo.getReferenceFromSetting(String.valueOf(string2) + ":" + string4);
        while (string5 != null) {
            ModelEntity modelEntity2 = list2.size() > n2 ? list2.get(n2) : null;
            Optional<ModelEntity> optional = ModelEntityUtil.findPastedObjectUsedInLink(string5, model, copyPasteInfo);
            if (!optional.isPresent()) {
                optional = ModelEntityUtil.a(copyPasteInfo, string5, model);
            }
            if (optional.isPresent()) {
                arrayList.add(optional.get());
            } else if (ModelEntityUtil.containedInLists(list, modelEntity2)) {
                copyPasteInfo.addMessage("Pasted_object_refers_to_an_entity_that_already_existed_in_application_XYZ#" + propFeature2.tag() + "#" + modelEntity2.getDisplayString() + "#" + ModelEntityUtil.getDescription(propFeature2, string, true) + string3, ModelEntityUtil.getSettingObject(propFeature2, string4));
                arrayList.add(modelEntity2);
            } else {
                ba ba2;
                Object object;
                ModelEntity modelEntity3 = null;
                try {
                    List<ModelEntity> list3;
                    object = ModelEntityUtil.getReferenceTag(property, string5);
                    ba2 = referenceArrayPropCheck.getAllowedValues();
                    if (q.a((Object[])ba2, (Object)object) && !(list3 = referenceArrayPropCheck.resolveEntities(new String[]{object})).isEmpty()) {
                        modelEntity3 = list3.get(0);
                    }
                }
                catch (FlException flException) {}
                object = (propFeature, modelEntity) -> !propFeature.getReferenceArray(string).contains(modelEntity);
                ba2 = propFeature2.getPropValueInternal(string).getProperty().getAnnotations();
                if (modelEntity3 != null && modelEntity3 == modelEntity2) {
                    ModelEntityUtil.a(string4, propFeature2, copyPasteInfo, string2, modelEntity2, (BiFunction<PropFeature, ModelEntity, Boolean>)object);
                    arrayList.add(modelEntity2);
                } else if (modelEntity3 != null && (copyPasteInfo.keepReferencesWhenPasting() || ba2.bP())) {
                    if (!ModelEntityUtil.containedInLists(list, modelEntity3)) {
                        ModelEntityUtil.a(string4, propFeature2, copyPasteInfo, string2, modelEntity3, (BiFunction<PropFeature, ModelEntity, Boolean>)object);
                    }
                    arrayList.add(modelEntity3);
                } else {
                    copyPasteInfo.addMessage("Removed_reference_in_pasted_object_because_it_contains_an_invalid_reference_XYZ#" + string5 + "#" + propFeature2.tag() + "#" + ModelEntityUtil.getDescription(propFeature2, string, true) + string3, ModelEntityUtil.getSettingObject(propFeature2, string4));
                    arrayList.add(null);
                }
            }
            string3 = ":" + ++n2;
            string4 = String.valueOf(string) + string3;
            string5 = copyPasteInfo.getReferenceFromSetting(String.valueOf(string2) + ":" + string4);
        }
        return arrayList;
    }

    public static String[] findPastedObjectsUsedInLinkArray(String string2, DynamicStringCheck dynamicStringCheck, List<ModelEntity> list, ModelEntity modelEntity2, CopyPasteInfo copyPasteInfo) {
        String string3 = ModelEntityUtil.getCopiedPath(modelEntity2, copyPasteInfo);
        ArrayList arrayList = new ArrayList();
        u u2 = (u)modelEntity2;
        String[] stringArray = u2.getStringArray(string2);
        int n2 = 0;
        String string4 = copyPasteInfo.getReferenceFromSetting(String.valueOf(string3) + ":" + string2 + ":" + n2);
        while (string4 != null) {
            String string5 = stringArray.length > n2 ? stringArray[n2] : null;
            ModelEntity modelEntity3 = dynamicStringCheck.getEntityOrNull(string5);
            ModelEntityUtil.a(string2, dynamicStringCheck, copyPasteInfo, modelEntity2, string4, modelEntity3, n2).map(modelEntity -> dynamicStringCheck.getValueOrNull(u2, string2, (ModelEntity)modelEntity)).ifPresent(string -> {
                boolean bl2 = arrayList.add(string);
            });
            string4 = copyPasteInfo.getReferenceFromSetting(String.valueOf(string3) + ":" + string2 + ":" + ++n2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Optional<String> findPastedObjectUsedInLink(String string, DynamicStringCheck dynamicStringCheck, List<ModelEntity> list, ModelEntity modelEntity3, CopyPasteInfo copyPasteInfo) {
        String string2 = ModelEntityUtil.getCopiedPath(modelEntity3, copyPasteInfo);
        String string3 = copyPasteInfo.getReferenceFromSetting(String.valueOf(string2) + ":" + string);
        u u2 = (u)modelEntity3;
        String string4 = u2.getString(string);
        ModelEntity modelEntity4 = dynamicStringCheck.getEntityOrNull(string4);
        return ModelEntityUtil.a(string, dynamicStringCheck, copyPasteInfo, modelEntity3, string3, modelEntity4, -1).filter(modelEntity2 -> modelEntity2 != modelEntity4).map(modelEntity -> dynamicStringCheck.getValueOrNull(u2, string, (ModelEntity)modelEntity));
    }

    private static Optional<ModelEntity> a(String string, DynamicStringCheck dynamicStringCheck, CopyPasteInfo copyPasteInfo, ModelEntity modelEntity, String string2, ModelEntity modelEntity2, int n2) {
        Optional<ModelEntity> optional = ModelEntityUtil.findPastedObjectUsedInLink(string2, modelEntity.getModel(), copyPasteInfo);
        if (!optional.isPresent()) {
            optional = Optional.ofNullable(ModelEntityUtil.findChildOfPastedObjectUsedInLink(string2, modelEntity.getModel(), copyPasteInfo));
        }
        String string3 = n2 < 0 ? "" : ":" + n2;
        String string4 = String.valueOf(string) + string3;
        if (optional.isPresent()) {
            copyPasteInfo.removeMessages(ModelEntityUtil.getSettingObject(modelEntity, string4));
            return optional;
        }
        if (modelEntity2 != null) {
            if (copyPasteInfo.isPastingFromAnotherModel()) {
                copyPasteInfo.addMessage("Pasted_object_refers_to_an_entity_that_already_existed_in_application_XYZ#" + modelEntity.getDisplayString() + "#" + modelEntity2.getDisplayString() + "#" + ModelEntityUtil.getDescription(modelEntity, string, true) + string3, ModelEntityUtil.getSettingObject(modelEntity, string4));
            }
            return Optional.of(modelEntity2);
        }
        if (string2 != null) {
            String string5 = string2.substring(string2.lastIndexOf(47) + 1);
            copyPasteInfo.addMessage("Cleared_reference_in_pasted_object_because_it_contains_an_invalid_reference_XYZ#" + string5 + "#" + modelEntity.getDisplayString() + "#" + ModelEntityUtil.getDescription(modelEntity, string, true) + string3, ModelEntityUtil.getSettingObject(modelEntity, string4));
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static void collectDynamicStringCheckReferences(CopyPasteInfo copyPasteInfo, String string, String string3, boolean bl2, u u2, DynamicStringCheck dynamicStringCheck) {
        if (bl2) {
            String[] stringArray = u2.getStringArray(string);
            HashSet hashSet = new HashSet();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string4 = stringArray2[n3];
                Optional.ofNullable(dynamicStringCheck.getEntityOrNull(string4)).map(modelEntity -> ModelEntityUtil.getEntityPath(modelEntity)).filter(string2 -> hashSet.add(string4)).ifPresent(string2 -> {
                    CopyPasteInfo copyPasteInfo2 = copyPasteInfo.addReferenceSetting(String.valueOf(string3) + ":" + (hashSet.size() - 1), (String)string2);
                });
                ++n3;
            }
        } else {
            Optional.ofNullable(dynamicStringCheck.getEntityOrNull(u2.getString(string))).map(modelEntity -> ModelEntityUtil.getEntityPath(modelEntity)).ifPresent(string2 -> {
                CopyPasteInfo copyPasteInfo2 = copyPasteInfo.addReferenceSetting(string3, (String)string2);
            });
        }
    }

    private static void a(String string, PropFeature propFeature, CopyPasteInfo copyPasteInfo, String string2, ModelEntity modelEntity, BiFunction<PropFeature, ModelEntity, Boolean> biFunction) {
        ModelEntity modelEntity2 = ModelEntityUtil.findEntity(null, propFeature.getModel(), string2.split("/"), 1);
        if (copyPasteInfo.isPastingFromAnotherModel() || modelEntity2 != propFeature && (!(modelEntity2 instanceof PropFeature) || !propFeature.getOperationID().equals(((PropFeature)modelEntity2).getOperationID()) || biFunction.apply((PropFeature)modelEntity2, modelEntity).booleanValue())) {
            int n2 = string.lastIndexOf(58);
            String string3 = n2 > 0 ? string.substring(0, n2) : string;
            String string4 = n2 > 0 ? string.substring(n2) : "";
            copyPasteInfo.addMessage("Pasted_object_refers_to_an_entity_that_already_existed_in_application_XYZ#" + propFeature.tag() + "#" + modelEntity.getDisplayString() + "#" + ModelEntityUtil.getDescription(propFeature, string3, true) + string4, ModelEntityUtil.getSettingObject(propFeature, string));
        }
    }

    public static String getDescription(ModelEntity modelEntity, String string, boolean bl2) {
        ParameterContainer parameterContainer;
        ParamSpec paramSpec;
        String string2 = null;
        if (modelEntity instanceof PropFeature) {
            PropFeature propFeature = (PropFeature)modelEntity;
            PropValue propValue = propFeature.getPropValueInternal(string);
            if (propValue != null) {
                string2 = propValue.getProperty().getDescription();
            }
        } else if (modelEntity instanceof ParameterContainer && (paramSpec = (parameterContainer = (ParameterContainer)((Object)modelEntity)).getSpec(string)) != null) {
            string2 = paramSpec.getDescr();
        }
        if (string2 == null) {
            return string;
        }
        if (bl2) {
            return FlLocale.getString(string2);
        }
        return string2;
    }

    public static Object getSettingObject(ModelEntity modelEntity, String string) {
        return new ModelEntitySetting(modelEntity, string);
    }

    public static void collectNamedSelection(SelectionEntity selectionEntity, String string, AbstractSelection abstractSelection, CopyPasteInfo copyPasteInfo) {
        LocalSelection localSelection;
        if (abstractSelection instanceof LocalSelection && !(localSelection = (LocalSelection)abstractSelection).named().isEmpty()) {
            SelectionFeature selectionFeature = localSelection.getNamedSelection();
            String string2 = ModelEntityUtil.getEntityPath(selectionFeature);
            String string3 = ModelEntityUtil.getEntityPath(selectionEntity);
            CopiedPrimitiveObject copiedPrimitiveObject = copyPasteInfo.addReference(string2);
            copiedPrimitiveObject.set("dim", String.valueOf(selectionFeature.getDim()));
            copyPasteInfo.addReferenceSetting(String.valueOf(string3) + ":" + string, string2);
        }
    }

    public static void fixPastedSelection(SelectionEntity selectionEntity, String string, CopyPasteInfo copyPasteInfo) {
        Optional<ModelEntity> optional;
        Object object;
        Object object2;
        String string2 = ModelEntityUtil.getCopiedPath(selectionEntity, copyPasteInfo);
        String string3 = copyPasteInfo.getReferenceFromSetting(String.valueOf(string2) + ":" + string);
        if (string3 == null) {
            return;
        }
        LocalSelection localSelection = null;
        if ("selection".equals(string)) {
            localSelection = selectionEntity.selection();
        } else if (selectionEntity instanceof PropFeature) {
            object2 = ((PropFeature)selectionEntity).getPropValueInternal(string);
            Property property = object = object2 != null ? object2.getProperty() : null;
            if (object != null && object.getType() == Property.PropertyType.n && object2.getSelection() instanceof LocalSelection) {
                localSelection = (LocalSelection)object2.getSelection();
            }
        } else if (selectionEntity instanceof ParameterEntity && q.a((Object[])(object2 = ((ParameterEntity)selectionEntity).getExtraSelectionNames()), (Object)string)) {
            localSelection = ((ParameterEntity)selectionEntity).selection(string);
        }
        if (localSelection == null) {
            return;
        }
        object2 = selectionEntity.getModel();
        object = null;
        if (localSelection != null && !localSelection.named().isEmpty() && string3.equals(ModelEntityUtil.getEntityPath(object = localSelection.getNamedSelection()))) {
            return;
        }
        if (!copyPasteInfo.isPastingFromAnotherModel()) {
            String string4 = localSelection.model();
            optional = Optional.ofNullable(ModelEntityUtil.findEntity(null, (ModelEntity)object2, string3.split("/"), 1)).filter(modelEntity -> modelEntity.model().equals(string4));
        } else {
            optional = ModelEntityUtil.findPastedObjectUsedInLink(string3, (Model)object2, copyPasteInfo);
        }
        if (!optional.isPresent()) {
            optional = ModelEntityUtil.a(copyPasteInfo, string3, (Model)object2);
        }
        if (optional.isPresent()) {
            localSelection.named(optional.get().tag());
        }
    }

    private static Optional<ModelEntity> a(CopyPasteInfo copyPasteInfo, String string, Model model) {
        if (string.startsWith("/SelectionList/")) {
            String string2;
            String string3 = string.substring(string.lastIndexOf(47) + 1);
            int n2 = string3.indexOf(95);
            if (n2 < 0) {
                return Optional.empty();
            }
            String string4 = string3.substring(0, n2);
            Optional<GeomSequence> optional = ModelEntityUtil.findPastedObjectUsedInLink("/GeomList/" + string4, model, copyPasteInfo).map(modelEntity -> (GeomSequence)modelEntity);
            if (!optional.isPresent()) {
                return Optional.empty();
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = string3.lastIndexOf(95);
            if (n3 > n2 + 1) {
                string2 = string3.substring(n3 + 1);
                int n4 = optional.get().getSDim();
                int n5 = -1;
                while (n5 <= n4) {
                    if (string2.equals(GeomSequenceUtil.getLevelLabel(n4, n5))) {
                        stringBuilder.append(string3.subSequence(n2 + 1, n3)).append('.').append(string2);
                        break;
                    }
                    ++n5;
                }
            }
            if (stringBuilder.length() == 0) {
                stringBuilder.append(string3.substring(n2 + 1));
            }
            string2 = stringBuilder.toString();
            return optional.filter(geomSequence -> geomSequence.selection().hasTag(string2)).map(geomSequence -> geomSequence.selection(string2).getSelectionFeature());
        }
        return Optional.empty();
    }

    public static List<CopiedPrimitiveObject> findCopiedShortcut(String string, PropFeature propFeature, CopyPasteInfo copyPasteInfo) {
        String string2 = ModelEntityUtil.getCopiedPath(propFeature, copyPasteInfo);
        String string3 = copyPasteInfo.getReferenceFromSetting(String.valueOf(string2) + ":" + string);
        ArrayList<CopiedPrimitiveObject> arrayList = new ArrayList<CopiedPrimitiveObject>();
        if (string3 != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = FlStringUtil.strSplit((String)string3, (String)",", (boolean)true);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string4 = stringArray2[n3];
                arrayList.add(copyPasteInfo.getReferencedObject("/AppBuilderFeatureList/" + string + ":" + string4.trim()));
                ++n3;
            }
        }
        return arrayList;
    }

    public static String getCopiedPath(ModelEntity modelEntity, CopyPasteInfo copyPasteInfo) {
        String string = null;
        Model model = modelEntity.getModel();
        List<PrimitiveModelEntity> list = copyPasteInfo.getCopiedObjects();
        int n2 = 0;
        while (n2 < list.size()) {
            String string2 = copyPasteInfo.getCopiedPath(n2);
            String string3 = copyPasteInfo.getPastedPath(string2);
            if (string3 != null) {
                ModelEntity modelEntity2 = ModelEntityUtil.findEntity(null, model, string3.split("/"), 1);
                if (modelEntity2 == modelEntity) {
                    string = copyPasteInfo.getCopiedPath(n2);
                    break;
                }
                if (ModelInternalUtil.containedBy(modelEntity2, modelEntity) && (string = copyPasteInfo.getCopiedPath(n2)) != null) {
                    StringBuilder stringBuilder = new StringBuilder(string);
                    stringBuilder.append(ModelEntityUtil.getEntityPath(modelEntity).substring(string3.length()));
                    string = stringBuilder.toString();
                }
            }
            ++n2;
        }
        return string;
    }

    public static ModelEntity findChildOfPastedObjectUsedInLink(String string, Model model, CopyPasteInfo copyPasteInfo) {
        ModelEntity modelEntity;
        String[] stringArray = ModelEntityUtil.findPastedPathInHierarchy(string, copyPasteInfo);
        if (stringArray != null && (modelEntity = ModelEntityUtil.findEntity(model, stringArray[0])) != null) {
            return ModelEntityUtil.findEntity(modelEntity, stringArray[1]);
        }
        return null;
    }

    public static String[] findPastedPathInHierarchy(String string, CopyPasteInfo copyPasteInfo) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        String string3 = "";
        String string4 = copyPasteInfo.getPastedPath(string2);
        if (string4 != null) {
            return new String[]{string4, string3};
        }
        int n2 = -1;
        while ((n2 = string2.lastIndexOf(47)) != -1) {
            string3 = String.valueOf(string2.substring(n2 + 1)) + (string3.isEmpty() ? "" : "/" + string3);
            string4 = copyPasteInfo.getPastedPath(string2 = string2.substring(0, n2));
            if (string4 == null) continue;
            return new String[]{string4, string3};
        }
        return null;
    }

    public static ModelEntity findPastedObjectUsedInLink(String string, ModelEntity modelEntity, Model model, CopyPasteInfo copyPasteInfo) {
        return ModelEntityUtil.findPastedObjectUsedInLink(string, model, copyPasteInfo).filter(modelEntity2 -> modelEntity2 != modelEntity).orElse(null);
    }

    public static Optional<ModelEntity> findPastedObjectUsedInLink(String string2, Model model, CopyPasteInfo copyPasteInfo) {
        return Optional.ofNullable(copyPasteInfo.getPastedPath(string2)).map(string -> ModelEntityUtil.findEntity(null, model, string.split("/"), 1));
    }

    public static IGeomSequence getGeometry(IModelEntity iModelEntity) {
        if (iModelEntity instanceof IPostInfoProvider) {
            return ((IPostInfoProvider)((Object)iModelEntity)).getGeom();
        }
        if (iModelEntity instanceof ModelEntity) {
            ModelNode modelNode = ((ModelEntity)iModelEntity).getParentModel();
            return modelNode != null ? modelNode.getGeom() : null;
        }
        return null;
    }

    public static <T extends ModelEntityList> T getContainingList(ModelEntity modelEntity) {
        PrimitiveModelEntity primitiveModelEntity;
        if (modelEntity == null || (primitiveModelEntity = modelEntity.getContainer()) == null) {
            return null;
        }
        if (ModelEntityList.class.isAssignableFrom(primitiveModelEntity.getClass())) {
            try {
                return (T)((ModelEntityList)primitiveModelEntity);
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return null;
    }

    public static List<Stream<? extends ModelEntity>> getCopiedComponentLists(ModelNode modelNode, boolean bl2) {
        MODEL_NODE_TYPES mODEL_NODE_TYPES;
        ArrayList<Stream<? extends ModelEntity>> arrayList = new ArrayList<Stream<? extends ModelEntity>>();
        if (bl2) {
            arrayList.add(Stream.of(modelNode));
        }
        boolean bl3 = (mODEL_NODE_TYPES = modelNode.getModelType()) == MODEL_NODE_TYPES.MESH_PART;
        boolean bl4 = mODEL_NODE_TYPES == MODEL_NODE_TYPES.EXTRA_DIMENSION;
        Predicate<ModelEntity> predicate = modelEntity -> !modelEntity.isAutoGenerated();
        arrayList.add(modelNode.geom().stream().filter(geomSequence -> predicate.test((ModelEntity)geomSequence) && !geomSequence.isParticle() && !geomSequence.isRay() && !geomSequence.isDeformed()));
        arrayList.add(modelNode.mesh().stream().filter(meshSequence -> predicate.test((ModelEntity)meshSequence) && !meshSequence.getGeom().isDeformed()));
        if (!bl3) {
            arrayList.add(modelNode.variable().stream().filter(predicate));
            arrayList.add(modelNode.func().stream().filter(predicate));
            arrayList.add(modelNode.cpl().stream().filter(predicate));
            arrayList.add(modelNode.probe().stream().filter(predicate));
            arrayList.add(modelNode.selection().stream().filter(selectionFeature -> predicate.test((ModelEntity)selectionFeature) && !selectionFeature.isFromGeom()));
            arrayList.add(modelNode.pair().stream().filter(pair -> predicate.test((ModelEntity)pair) && !pair.hasAutoSelection()));
            arrayList.add(modelNode.coordSystem().stream().filter(predicate));
            arrayList.add(modelNode.view().stream().filter(predicate));
            arrayList.add(modelNode.extraDim().stream().filter(predicate));
            arrayList.add(modelNode.common().stream().filter(predicate));
            if (!bl4) {
                arrayList.add(modelNode.massProp().stream().filter(predicate));
                arrayList.add(modelNode.material().stream().filter(predicate));
                arrayList.add(modelNode.physics().stream().filter(predicate));
                arrayList.add(modelNode.multiphysics().stream().filter(predicate));
            }
            arrayList.add(modelNode.getModel().nodeGroup().stream().filter(nodeGroup -> nodeGroup.getContext() == modelNode && predicate.test((ModelEntity)nodeGroup)));
        }
        return arrayList;
    }

    public static void collectGlobalParameters(ModelEntity modelEntity, Collection<PrimitiveModelEntity> collection, CopyPasteInfo copyPasteInfo) {
        Model model = modelEntity.getModel();
        IParamDatabase iParamDatabase = modelEntity.paramDatabase();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Predicate<bi> predicate = bi2 -> bi2.getContainer() instanceof ModelEntity && ModelInternalUtil.containedBy(modelEntity, (ModelEntity)bi2.getContainer());
        iParamDatabase.a(hashMap, predicate);
        if (model.getParamDatabase() != iParamDatabase) {
            model.getParamDatabase().a(hashMap, predicate);
        }
        PhysicalQuantityManager.getPhysConstants().forEach(physicalConstant -> {
            Object v2 = hashMap.remove(physicalConstant.getVarName());
        });
        Stream.of(BuiltInVariables.c()).forEach(string -> {
            Object v2 = hashMap.remove(string);
        });
        Stream.of(BuiltInFunctions.g()).forEach(string -> {
            Object v2 = hashMap.remove("." + string);
        });
        ModelParam modelParam = model.param();
        String string4 = String.valueOf(ModelEntityUtil.getEntityPath(modelParam.group())) + "/";
        hashMap.forEach((string2, string3) -> {
            if (modelParam.hasVariable((String)string2)) {
                Expression expression = modelParam.getExpression((String)string2);
                String string4 = expression.getGroupTag();
                String string5 = String.valueOf(string4) + string4 + ":" + string2;
                CopiedPrimitiveObject copiedPrimitiveObject = copyPasteInfo.addReference(string5);
                String string6 = copyPasteInfo.getReferenceFromSetting((String)string3);
                if (string6 != null && !string6.isEmpty()) {
                    copyPasteInfo.addReferenceSetting((String)string3, String.valueOf(string6) + "," + string5);
                } else {
                    copyPasteInfo.addReferenceSetting((String)string3, string5);
                }
                copiedPrimitiveObject.setType("ModelParam");
                copiedPrimitiveObject.set("name", expression.getTag());
                copiedPrimitiveObject.set("expression", expression.getExpression(false));
                copiedPrimitiveObject.set("description", expression.getDescription());
                if (!"default".equals(string4)) {
                    ModelParamGroup modelParamGroup = modelParam.group(string4);
                    ModelEntityUtil.addCopiedReference(modelEntity, collection, copyPasteInfo, modelParamGroup, ModelEntityUtil.getEntityPath(modelParamGroup));
                }
            }
        });
        Set set = hashMap.keySet();
        model.func().stream().filter(functionFeature -> functionFeature.isActive() && !functionFeature.isAutoGenerated() && functionFeature != modelEntity).forEach(functionFeature -> ModelEntityUtil.a(modelEntity, collection, copyPasteInfo, (Collection<String>)set, (PropFeature)functionFeature));
    }

    private static void a(ModelEntity modelEntity, Collection<PrimitiveModelEntity> collection, CopyPasteInfo copyPasteInfo, Collection<String> collection2, PropFeature propFeature) {
        String[] stringArray = ((IFunctionOperation)propFeature.getOperation()).getFunctionNames(propFeature);
        String string = propFeature.scopeDot().substring("root.".length() - 1);
        stringArray = FlStringUtil.prepend((String)string, (String[])stringArray);
        if (collection2.removeAll(Arrays.asList(stringArray))) {
            String string2 = ModelEntityUtil.getEntityPath(propFeature);
            ModelEntityUtil.addCopiedReference(modelEntity, collection, copyPasteInfo, propFeature, string2);
        }
    }

    public static boolean addCopiedReference(ModelEntity modelEntity, Collection<PrimitiveModelEntity> collection, CopyPasteInfo copyPasteInfo, ModelEntity modelEntity2, String string) {
        int n2;
        CopiedPrimitiveObject copiedPrimitiveObject = copyPasteInfo.addReference(string);
        String string2 = ModelEntityUtil.getEntityPath(modelEntity);
        int[] nArray = FlStringUtil.find((String)string2, (char)'/');
        int n3 = n2 = string2.startsWith("/Results/") ? 3 : 2;
        if (nArray.length > n2) {
            string2 = string2.substring(0, nArray[n2]);
        }
        int n4 = copyPasteInfo.getCopiedIndex(string2);
        int n5 = copiedPrimitiveObject.getPasteBeforeIndex();
        if (n5 < 0) {
            copiedPrimitiveObject.setPasteBeforeIndex(n4);
        } else if (n4 >= 0) {
            int n6 = ModelEntityUtil.a(copyPasteInfo, n5);
            int n7 = n4;
            if (n6 < n4) {
                n7 = ModelEntityUtil.a(copyPasteInfo, n4);
            }
            if (n6 > n7) {
                copiedPrimitiveObject.setPasteBeforeIndex(n4);
            }
        }
        return copyPasteInfo.addCopiedObject(collection, modelEntity2, copiedPrimitiveObject, false);
    }

    private static int a(CopyPasteInfo copyPasteInfo, int n2) {
        String string = copyPasteInfo.getCopiedPath(n2);
        CopiedPrimitiveObject copiedPrimitiveObject = copyPasteInfo.getReferencedObject(string);
        while (copiedPrimitiveObject != null && copiedPrimitiveObject.getPasteBeforeIndex() >= 0) {
            n2 = copiedPrimitiveObject.getPasteBeforeIndex();
            string = copyPasteInfo.getCopiedPath(n2);
            copiedPrimitiveObject = copyPasteInfo.getReferencedObject(string);
        }
        return n2;
    }

    public static void pasteGlobalParameters(ModelParam modelParam, CopyPasteInfo copyPasteInfo) {
        String string = String.valueOf(ModelEntityUtil.getEntityPath(modelParam.group())) + "/";
        copyPasteInfo.getReferenceSettingData().stream().forEach(stringStringPair -> {
            String[] stringArray;
            String[] stringArray2 = stringArray = FlStringUtil.strSplit((String)stringStringPair.second, (int)44);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray2[n3];
                ModelPath modelPath = new ModelPath(string2);
                if (modelPath.hasAttribute() && modelPath.toString().startsWith(string)) {
                    String string3 = "default";
                    String string4 = modelPath.getString();
                    int n4 = string4.indexOf(58);
                    String string5 = string4.substring(n4 + 1);
                    CopiedPrimitiveObject copiedPrimitiveObject = copyPasteInfo.getReferencedObject(string4);
                    if (!modelParam.hasVariable(modelPath.getAttribute())) {
                        copiedPrimitiveObject.setPasted(String.valueOf(string) + string3 + ":" + string5);
                        modelParam.group(string3).set(modelPath.getAttribute(), copiedPrimitiveObject.getString("expression"), copiedPrimitiveObject.getString("description"));
                    } else if (!copiedPrimitiveObject.isPasted() && copyPasteInfo.isPastingFromAnotherModel()) {
                        ModelPath modelPath2 = new ModelPath(stringStringPair.first);
                        copyPasteInfo.addMessage("Pasted_object_refers_to_a_parameter_that_already_existed_in_application_XY#" + modelPath2.getEntityString() + "#" + modelPath.getAttribute(), null);
                    }
                }
                ++n3;
            }
        });
    }

    public static boolean checkReference(ModelEntity modelEntity, String string, PrimitiveModelEntity primitiveModelEntity) {
        Node node = modelEntity.getNode().getReference(string);
        if (node != primitiveModelEntity.getNode()) {
            if (node != null) {
                FlLogger.a((String)String.format("%s: Replace existing reference '%s' with '%s' as it is incorrectly referenced", modelEntity.tag(), primitiveModelEntity.getTag(), node.getObjectEntity().getTag()));
            } else {
                FlLogger.b((String)String.format("%s: Set reference to '%s' as it was not referenced", modelEntity.tag(), primitiveModelEntity.getTag()));
            }
            return true;
        }
        FlLogger.b((String)String.format("%s: Keep existing reference '%s' as it is correctly referenced", modelEntity.tag(), primitiveModelEntity.getTag()));
        return false;
    }

    public static Selection getSelection(IModelEntity iModelEntity) {
        IPrimitiveModelEntity iPrimitiveModelEntity = iModelEntity;
        while (iPrimitiveModelEntity != null) {
            if (iPrimitiveModelEntity instanceof SelectionEntity && ((SelectionEntity)iPrimitiveModelEntity).hasSelection()) {
                return ((SelectionEntity)iPrimitiveModelEntity).selection();
            }
            iPrimitiveModelEntity = iPrimitiveModelEntity.getContainer();
        }
        return new SimpleSelection(iModelEntity.getModel());
    }

    public static String[][] quickReadNodes(String string, String[] stringArray, String string2, String ... stringArray2) {
        try {
            File file = FileManagerUtil.a((String)string, (String)m.a, (boolean)false);
            if (file == null) {
                throw new FlException("File_not_found");
            }
            try {
                return ModelEntityUtil.quickReadNodes(file, false, stringArray, string2, stringArray2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return ModelEntityUtil.quickReadNodes(file, true, stringArray, string2, stringArray2);
            }
        }
        catch (IOException iOException) {
            throw new FlException("Failed_to_load_application", (Throwable)iOException);
        }
    }

    public static String[][] quickReadNodes(File file, boolean bl2, String[] stringArray, String string, String ... stringArray2) throws IOException {
        QuickReadUtil.AttributesFilter attributesFilter;
        if (bl2) {
            int n2 = QuickReadUtil.quickReadSavedInVersion(file, bl2, stringArray);
            attributesFilter = new QuickReadUtil.ModelEntityFilterEmf(string, n2, stringArray2);
        } else {
            attributesFilter = new QuickReadUtil.ModelEntityFilterDb(string, stringArray2);
        }
        return ModelEntityUtil.quickReadNodes(file, bl2, stringArray, attributesFilter, stringArray2);
    }

    public static String[][] quickReadNodes(File file, boolean bl2, String[] stringArray, QuickReadUtil.QuickReadFilter quickReadFilter, String ... stringArray2) throws IOException {
        int n2;
        List<String> list = QuickReadUtil.quickReadAttribute(file, quickReadFilter, bl2, stringArray);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = bl2 ? "entityName" : "name";
        String string2 = null;
        String[] stringArray3 = null;
        int n3 = 0;
        while (n3 < list.size()) {
            String[] stringArray4 = new String[2];
            n2 = list.get(n3).indexOf(61);
            if (n2 >= 0) {
                stringArray4[0] = list.get(n3).substring(0, n2);
                stringArray4[1] = list.get(n3).substring(n2 + 1);
                if (string2 == null || string2.equals(stringArray4[0])) {
                    string2 = stringArray4[0];
                    stringArray3 = new String[2 + stringArray2.length];
                    arrayList.add(stringArray3);
                }
                if ("tag".equals(stringArray4[0])) {
                    stringArray3[0] = stringArray4[1];
                } else if (string.equals(stringArray4[0])) {
                    stringArray3[1] = stringArray4[1];
                } else {
                    int n4 = q.c((Object[])stringArray2, (Object)stringArray4[0]);
                    if (n4 >= 0) {
                        stringArray3[2 + n4] = stringArray4[1];
                    }
                }
            }
            ++n3;
        }
        String[][] stringArray5 = new String[2 + stringArray2.length][arrayList.size()];
        int n5 = 0;
        while (n5 < arrayList.size()) {
            stringArray3 = (String[])arrayList.get(n5);
            n2 = 0;
            while (n2 < stringArray3.length) {
                stringArray5[n2][n5] = stringArray3[n2];
                ++n2;
            }
            ++n5;
        }
        return stringArray5;
    }

    public static boolean supportClipboardCopy(Object object, Collection<PrimitiveModelEntity> collection, CopyPasteInfo copyPasteInfo) {
        ModelEntity modelEntity;
        if (object instanceof ModelEntity && (modelEntity = (ModelEntity)object).supportClipBoardCopy()) {
            ModelEntityUtil.addCopiedObject(modelEntity, collection, copyPasteInfo);
            return true;
        }
        return false;
    }

    public static boolean addCopiedObject(ModelEntity modelEntity, Collection<PrimitiveModelEntity> collection, CopyPasteInfo copyPasteInfo) {
        if (copyPasteInfo.addCopiedObject(collection, modelEntity, null, true)) {
            modelEntity.collectObjectsToCopy(collection, copyPasteInfo);
            return true;
        }
        return false;
    }

    public static void handlePastedReferences(CopyPasteInfo copyPasteInfo, List<ModelEntity> list, Map<ModelEntity, ModelEntity> map) {
        boolean bl2 = map.isEmpty();
        for (Map.Entry<ModelEntity, ModelEntity> entry : map.entrySet()) {
            ModelEntity modelEntity = entry.getKey();
            ModelEntity modelEntity2 = entry.getValue();
            modelEntity2.handleReferencesInPaste(modelEntity, list, copyPasteInfo);
            bl2 |= modelEntity2.allowPasteConflictMessages(copyPasteInfo);
        }
        if (!bl2) {
            copyPasteInfo.getMessages().clear();
        }
    }

    private static LoadedModel a(af.a a2, k k2, String ... stringArray) {
        LoadedModel loadedModel = new LoadedModel(null);
        IModelManager iModelManager = ModelInternalUtil.getModelManager();
        try {
            try {
                iModelManager.setAllowUnavailableLicensesOnLoad(true);
                String string = ModelInternalUtil.uniquetag("insertcomp");
                loadedModel.model = ModelInternalUtil.load(string, a2.b, k2, stringArray);
            }
            catch (IOException iOException) {
                throw new FlException("Failed_to_load_model", (Throwable)iOException);
            }
        }
        finally {
            iModelManager.setAllowUnavailableLicensesOnLoad(false);
        }
        return loadedModel;
    }

    public static ModelEntity[] deletePastedEntities(ModelEntity[] modelEntityArray, Map<ModelEntity, ModelEntity> map, CopyPasteInfo copyPasteInfo) {
        CopiedPrimitiveObject[] copiedPrimitiveObjectArray = new CopiedPrimitiveObject[modelEntityArray.length];
        if (copyPasteInfo != null) {
            for (CopiedPrimitiveObject object2 : copyPasteInfo.getReferences(false)) {
                if (!object2.hasIndex() || !object2.removeObject()) continue;
                copiedPrimitiveObjectArray[object2.getIndex()] = object2;
            }
        }
        ModelEntity[] modelEntityArray2 = (ModelEntity[])modelEntityArray.clone();
        int n2 = 0;
        while (n2 < modelEntityArray.length) {
            if (modelEntityArray[n2] != null && copiedPrimitiveObjectArray[n2] != null) {
                PrimitiveModelEntity primitiveModelEntity = modelEntityArray[n2].getContainer();
                if (primitiveModelEntity instanceof ModelEntityList) {
                    ((ModelEntityList)primitiveModelEntity).remove(modelEntityArray[n2].tag());
                    copyPasteInfo.removeMessages(modelEntityArray[n2]);
                    copiedPrimitiveObjectArray[n2].setPasted("");
                }
                Iterator<Map.Entry<ModelEntity, ModelEntity>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<ModelEntity, ModelEntity> entry = iterator.next();
                    if (entry.getValue() != modelEntityArray[n2]) continue;
                    iterator.remove();
                }
            }
            ++n2;
        }
        return (ModelEntity[])Arrays.stream(modelEntityArray2).filter(modelEntity -> modelEntity != null && modelEntity.isInModel()).toArray(ModelEntity[]::new);
    }

    public static ModelEntity[] pasteObjects(ModelEntity modelEntity, CopyPasteInfo copyPasteInfo, IPasteController iPasteController) {
        Object object;
        Model model = modelEntity.getModel();
        ModelEntityList modelEntityList = null;
        if (modelEntity instanceof ModelEntityList) {
            modelEntityList = (ModelEntityList)modelEntity;
        } else if (modelEntity != model && ((Optional)(object = modelEntity.allChildren(true).stream().filter(primitiveModelEntity -> primitiveModelEntity instanceof ModelEntityList).findFirst())).isPresent()) {
            modelEntityList = (ModelEntityList)((Optional)object).get();
        }
        object = copyPasteInfo.getCopiedObjects();
        int[] nArray = iPasteController.reorderEntities((List<? extends PrimitiveModelEntity>)object, copyPasteInfo);
        ModelEntity[] modelEntityArray = new ModelEntity[object.size()];
        ModelEntityUtil.pasteGlobalParameters(model.param(), copyPasteInfo);
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            Object e2 = object.get(n4);
            if (e2 instanceof ModelEntity) {
                modelEntityArray[n4] = ModelEntityUtil.pasteModelEntity(copyPasteInfo, iPasteController, modelEntityList, model, n4, (ModelEntity)e2);
            }
            ++n3;
        }
        copyPasteInfo.resolveReferencesAfterPaste(modelEntityArray);
        Map<ModelEntity, ModelEntity> map = iPasteController.getMap();
        ModelEntityUtil.handlePastedReferences(copyPasteInfo, Arrays.asList(modelEntityArray), map);
        modelEntityArray = ModelEntityUtil.deletePastedEntities(modelEntityArray, map, copyPasteInfo);
        if (iPasteController.getPasteContext() instanceof NodeGroup) {
            NodeGroup nodeGroup = (NodeGroup)iPasteController.getPasteContext();
            ModelEntity[] modelEntityArray2 = modelEntityArray;
            int n5 = modelEntityArray.length;
            int n6 = 0;
            while (n6 < n5) {
                ModelEntity modelEntity2 = modelEntityArray2[n6];
                if (modelEntity2 != null && modelEntity2.isInModel() && nodeGroup.accept(modelEntity2)) {
                    NodeGroupUtil.addToGroup(nodeGroup, modelEntity2);
                }
                ++n6;
            }
        }
        iPasteController.finalize(copyPasteInfo, modelEntityArray);
        return modelEntityArray;
    }

    public static <T extends ModelEntity> T pasteModelEntity(CopyPasteInfo copyPasteInfo, IPasteController iPasteController, ModelEntityList<? extends ModelEntity> modelEntityList, Model model, int n2, T t2) {
        ModelEntity modelEntity = null;
        try {
            if (modelEntityList == null && (modelEntityList = iPasteController.getListToPasteTo(model, n2, copyPasteInfo)) == null) {
                throw new FlException("Cannot_find_list_to_paste_to_for_object_X#" + copyPasteInfo.getCopiedPath(n2));
            }
            String string2 = Optional.of(modelEntityList.model()).filter(string -> !string.isEmpty()).orElse(iPasteController.getComponentContext(n2, copyPasteInfo));
            ModelEntityUtil.reInitializeForPaste(t2, model.getModelType());
            iPasteController.preDuplicate(t2);
            modelEntity = modelEntityList.insertNewEntity(t2, string2, copyPasteInfo);
            if (modelEntity != null) {
                iPasteController.postDuplicate(t2, modelEntity);
            }
            return (T)modelEntity;
        }
        catch (FlException flException) {
            copyPasteInfo.addErrorMessage(flException, null);
            return (T)modelEntity;
        }
    }

    public static void moveSaved(int[] nArray, int n2, an an2, an an3, List<Boolean> list, List<Boolean> list2) {
        int n3;
        int n4;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int[] nArray2 = nArray;
        int n5 = nArray.length;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = nArray2[n6];
            n4 = n7 + n2;
            if (n4 < 0 || n4 >= list.size()) {
                throw new FlException("Cannot_move_outside_of_list");
            }
            hashMap.put(n4, n7);
            hashSet.add(n7);
            ++n6;
        }
        an an4 = new an();
        an an5 = new an();
        n5 = 0;
        int n8 = 0;
        while (n8 < list.size()) {
            Boolean bl2 = list.get(n8);
            if (!hashSet.contains(n8)) {
                an4.add(n8);
            } else if (bl2.booleanValue()) {
                an5.add(n8);
                an2.add(n5);
            }
            if (bl2.booleanValue()) {
                ++n5;
            }
            ++n8;
        }
        n8 = 0;
        n5 = 0;
        n4 = 0;
        while (n4 < list.size()) {
            n3 = hashMap.containsKey(n4) ? list.get((Integer)hashMap.get(n4)).booleanValue() : list.get(an4.get(n8++)).booleanValue();
            if (n3 != 0) {
                ++n5;
            }
            list2.add(n3 != 0);
            ++n4;
        }
        int[] nArray3 = new int[list2.size()];
        n3 = 0;
        int n9 = 0;
        while (n9 < list2.size()) {
            if (list2.get(n9).booleanValue()) {
                // empty if block
            }
            nArray3[n9] = ++n3;
            ++n9;
        }
        int[] nArray4 = an5.toArray();
        int n10 = nArray4.length;
        int n11 = 0;
        while (n11 < n10) {
            n9 = nArray4[n11];
            an3.add(nArray3[n9 + n2] - 1);
            ++n11;
        }
    }

    public static <T extends ModelEntity> T insertWithinList(String string, String string2, ModelEntityList<T> modelEntityList) {
        modelEntityList.checkContains(string);
        ModelEntity modelEntity = null;
        try {
            String[][] stringArray = ModelEntityUtil.insertFeatures(null, modelEntityList.getModel(), modelEntityList, new String[]{string2}, new String[0]);
            if (stringArray[1].length > 0) {
                String string3 = stringArray[1][0].substring(stringArray[1][0].lastIndexOf(47) + 1);
                modelEntity = modelEntityList.get(string3);
            }
        }
        catch (FlException flException) {}
        if (modelEntity != null && !modelEntity.tag().equals(string)) {
            modelEntity.tag(string);
        }
        return (T)modelEntity;
    }

    public static String[][] insertFeatures(String string, Model model, ModelEntityList modelEntityList, String[] stringArray, String ... stringArray2) {
        Model model2 = null;
        try {
            if (string != null) {
                af.a a2 = af.g().e(string);
                model2 = ModelEntityUtil.a((af.a)a2, (k)new f(), (String[])stringArray2).model;
            } else {
                model2 = model;
            }
            ModelEntityCopyTask modelEntityCopyTask = new ModelEntityCopyTask(model2, model);
            String[][] stringArray3 = modelEntityCopyTask.insertFeatures(modelEntityList, stringArray, stringArray2.length > 0);
            return stringArray3;
        }
        finally {
            if (string != null && model2 != null) {
                ModelInternalUtil.remove(model2.tag());
            }
        }
    }

    public static SelectionEntity getSelectionEntity(PrimitiveModelEntity primitiveModelEntity) {
        while (!(primitiveModelEntity == null || primitiveModelEntity instanceof SelectionEntity && ((SelectionEntity)primitiveModelEntity).hasSelection())) {
            primitiveModelEntity = primitiveModelEntity.getContainer();
        }
        return primitiveModelEntity != null ? (SelectionEntity)primitiveModelEntity : null;
    }

    public static String getCopyUniqueTag(ModelEntityList<?> modelEntityList, ModelEntity modelEntity) {
        if (modelEntityList instanceof PropFeatureList) {
            return modelEntityList.uniquetag(FlStringUtil.stripNumberSuffix((String)modelEntity.tag()), ((PropFeature)modelEntity).getOperationID());
        }
        return modelEntityList.uniquetag(FlStringUtil.stripNumberSuffix((String)modelEntity.tag()));
    }

    public static void addResourceToCopyPaste(String string, PropFeature propFeature, CopyPasteInfo copyPasteInfo) {
        Model model = propFeature.getModel();
        try {
            String string2 = propFeature.getString(string);
            if (model.file().hasTag(string2)) {
                FileResource fileResource = model.file(string2);
                String string3 = fileResource.resource();
                if (FlStringUtil.isNullOrEmpty((String)string3)) {
                    return;
                }
                String string4 = ModelEntityUtil.getEntityPath(fileResource);
                if (!copyPasteInfo.containsReference(string4)) {
                    Object object;
                    CopiedPrimitiveObject copiedPrimitiveObject = copyPasteInfo.addReference(string4);
                    copiedPrimitiveObject.set("isExternal", String.valueOf(fileResource.isExternal()));
                    if (!fileResource.isExternal()) {
                        copiedPrimitiveObject.set("extension", FlFileUtil.e((String)string3));
                        object = new File(string3);
                        byte[] byArray = FlFileUtil.i((File)object);
                        copiedPrimitiveObject.setRawData(byArray);
                    } else {
                        copiedPrimitiveObject.set("path", string3);
                    }
                    copiedPrimitiveObject.set("noremove", String.valueOf(fileResource.hasFlag(ModelEntity.Flags.NOREMOVE)));
                    copiedPrimitiveObject.set("noretag", String.valueOf(fileResource.hasFlag(ModelEntity.Flags.NORETAG)));
                    object = String.valueOf(ModelEntityUtil.getEntityPath(propFeature)) + ":" + string;
                    copyPasteInfo.addReferenceSetting((String)object, string4);
                }
            }
        }
        catch (IOException iOException) {
            FlLogger.a((Throwable)iOException);
        }
        catch (FlException flException) {
            FlLogger.a((Throwable)flException);
        }
    }

    public static String pasteResourceReferenceFromClipBoard(String string, PropFeature propFeature, PropFeature propFeature2, CopyPasteInfo copyPasteInfo) {
        CopiedPrimitiveObject copiedPrimitiveObject;
        String string2 = propFeature.getString(string);
        Model model = propFeature2.getModel();
        IModelEntityList iModelEntityList = model.file();
        if (string2.isEmpty()) {
            if (!propFeature2.getString(string).isEmpty()) {
                propFeature2.set(string, "");
            }
            return null;
        }
        String string3 = copyPasteInfo.getReferenceAsPath(propFeature, string);
        CopiedPrimitiveObject copiedPrimitiveObject2 = copiedPrimitiveObject = string3 != null ? copyPasteInfo.getReferencedObject(string3) : null;
        if (copiedPrimitiveObject == null) {
            return null;
        }
        if (copiedPrimitiveObject.isPasted()) {
            String string4 = copiedPrimitiveObject.getPasted();
            if (!(string4 = string4.substring(string4.lastIndexOf(47) + 1)).equals(propFeature2.getString(string))) {
                propFeature2.set(string, string4);
            }
            return string4;
        }
        FilterOutputStream filterOutputStream = null;
        try {
            model.hist().disable();
            String string5 = FlStringUtil.stripNumberSuffix((String)string2);
            String string6 = iModelEntityList.uniquetag(string5);
            FileResource fileResource = (FileResource)iModelEntityList.create(string6);
            fileResource.setIgnoreWhenResettingHistory(true);
            if ("true".equals(copiedPrimitiveObject.getString("noremove"))) {
                fileResource.addFlag(ModelEntity.Flags.NOREMOVE);
            }
            if ("true".equals(copiedPrimitiveObject.getString("noretag"))) {
                fileResource.addFlag(ModelEntity.Flags.NORETAG);
            }
            if ("true".equals(copiedPrimitiveObject.getString("isExternal"))) {
                fileResource.resource(copiedPrimitiveObject.getString("path"), true);
            } else {
                byte[] byArray = copiedPrimitiveObject.getRawData();
                File file = new File(SystemUtil.getTempFilePathForModel((String)model.tag(), (String)copiedPrimitiveObject.getString("extension")));
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                filterOutputStream.write(byArray);
                ((BufferedOutputStream)filterOutputStream).flush();
                filterOutputStream.close();
                filterOutputStream = null;
                fileResource.resource(file.getAbsolutePath(), false);
            }
            copiedPrimitiveObject.setPasted(ModelEntityUtil.getEntityPath(fileResource));
            propFeature2.set(string, string6);
            String string7 = string6;
            return string7;
        }
        catch (IOException iOException) {
            copyPasteInfo.addErrorMessage(new FlException("#" + iOException.getMessage()), propFeature);
            if (!propFeature2.getString(string).isEmpty()) {
                copyPasteInfo.addMessage("An_unresolved_reference_was_cleared_in_a_pasted_object_XY#" + string2 + "#" + ModelEntityUtil.getShortEntityPath(propFeature2, false), ModelEntityUtil.getSettingObject(propFeature2, string));
                propFeature2.set(string, "");
            }
            return null;
        }
        finally {
            model.hist().enable();
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    FlLogger.a((Throwable)iOException);
                }
            }
            filterOutputStream = null;
        }
    }

    public static String getReferenceTag(Property property, String string) {
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        if (property.includeSequenceInTag()) {
            int n2 = string.indexOf(47, 1) + 1;
            int n3 = string.indexOf(47, n2);
            if (n3 < 0) {
                return string2;
            }
            return String.valueOf(string.substring(n2, n3 + 1)) + string2;
        }
        return string2;
    }

    public static String getReferenceTag(ModelEntity modelEntity) {
        return modelEntity.method().getReferenceTag();
    }

    private static abstract class a
    implements com.comsol.util.interfaces.c {
        protected final com.comsol.util.interfaces.c b;

        private a(com.comsol.util.interfaces.c c2) {
            this.b = c2;
        }
    }

    public static class EventHandlerExceptionCloseable
    implements AutoCloseable {
        private final Optional<EventManager> a;
        private final EventManager.EventHandlerExceptionHandler b;

        public EventHandlerExceptionCloseable(ModelEntity modelEntity2) {
            this.a = Optional.ofNullable(modelEntity2).map(modelEntity -> modelEntity.getNode()).map(node -> node.getRoot().getEventManager());
            this.b = this.a.map(eventManager -> eventManager.setEventHandlerExceptionHandler(runtimeException -> runtimeException instanceof FlException)).orElse(null);
        }

        @Override
        public void close() {
            this.a.ifPresent(eventManager -> {
                EventManager.EventHandlerExceptionHandler eventHandlerExceptionHandler = eventManager.setEventHandlerExceptionHandler(this.b);
            });
        }
    }

    public static interface IPasteController
    extends AutoCloseable {
        default public ModelEntityList<? extends ModelEntity> getListToPasteTo(ModelEntity modelEntity, int n2, CopyPasteInfo copyPasteInfo) {
            return copyPasteInfo.getTopListToPasteTo(n2, modelEntity.getModel());
        }

        default public Object getPasteContext() {
            return null;
        }

        public String getComponentContext(int var1, CopyPasteInfo var2);

        public Map<ModelEntity, ModelEntity> getMap();

        default public int[] reorderEntities(List<? extends PrimitiveModelEntity> list, CopyPasteInfo copyPasteInfo) {
            int[] nArray = q.a((int)0, (int)1, (int)(list.size() - 1));
            return copyPasteInfo.reorder(nArray);
        }

        default public void preDuplicate(ModelEntity modelEntity) {
        }

        default public void postDuplicate(ModelEntity modelEntity, ModelEntity modelEntity2) {
            this.getMap().put(modelEntity, modelEntity2);
        }

        default public void finalize(CopyPasteInfo copyPasteInfo, ModelEntity[] modelEntityArray) {
        }

        @Override
        default public void close() {
            this.getMap().values().stream().filter(modelEntity -> modelEntity instanceof View).map(modelEntity -> (View)modelEntity).filter(view -> view.isTempLocked()).forEach(view -> {
                view.setWithoutLogging("locked", false);
                view.setTempLocked(false);
            });
        }
    }

    static class b
    implements ComparisonResult.a {
        private final CopyPasteInfo a;
        private final CopyPasteInfo b;
        private final Collection<PrimitiveModelEntity> c = new LinkedHashSet<PrimitiveModelEntity>();
        private final Collection<PrimitiveModelEntity> d = new LinkedHashSet<PrimitiveModelEntity>();
        private final Function<ModelEntity, String> e;
        private ComparisonResult.MergeTarget f = ComparisonResult.MergeTarget.a;

        public b(CopyPasteInfo copyPasteInfo, CopyPasteInfo copyPasteInfo2, Function<ModelEntity, String> function) {
            this.a = copyPasteInfo;
            if (this.a != null) {
                copyPasteInfo.setTimeStamp(System.currentTimeMillis());
            }
            if ((this.b = copyPasteInfo2) != null) {
                copyPasteInfo2.setTimeStamp(System.currentTimeMillis());
            }
            this.e = function;
        }

        public int a(Object object) {
            CopyPasteInfo copyPasteInfo;
            if (!(object instanceof ModelEntity)) {
                return -1;
            }
            boolean bl2 = this.f == ComparisonResult.MergeTarget.b;
            CopyPasteInfo copyPasteInfo2 = copyPasteInfo = bl2 ? this.b : this.a;
            if (copyPasteInfo == null) {
                return -1;
            }
            Collection<PrimitiveModelEntity> collection = bl2 ? this.d : this.c;
            int n2 = collection.size();
            if (ModelEntityUtil.addCopiedObject((ModelEntity)object, collection, copyPasteInfo)) {
                return n2;
            }
            return copyPasteInfo.getCopiedIndex(ModelEntityUtil.getEntityPath((ModelEntity)object));
        }

        public ComparisonResult.MergeTarget a(ComparisonResult.MergeTarget mergeTarget) {
            ComparisonResult.MergeTarget mergeTarget2 = this.f;
            this.f = mergeTarget;
            return mergeTarget2;
        }

        public void a(ComparisonResult comparisonResult) {
            comparisonResult.startSection("xml_compare", new String[]{"version", String.valueOf(1)});
        }

        public void b(ComparisonResult comparisonResult) {
            if (this.a != null) {
                comparisonResult.writeRawData(ModelEntityUtil.serializeToStringForCopy(this.c, this.a, false, "modelType", this.a.getModel().getModelType().name(), "target", ComparisonResult.MergeTarget.a.name()));
            }
            if (this.b != null) {
                comparisonResult.writeRawData(ModelEntityUtil.serializeToStringForCopy(this.d, this.b, false, "modelType", this.b.getModel().getModelType().name(), "target", ComparisonResult.MergeTarget.b.name()));
            }
            comparisonResult.endSection("xml_compare");
        }

        public void a(Object object2, AttributesImpl attributesImpl) {
            Optional.ofNullable(object2).filter(object -> object instanceof ModelEntity).map(object -> this.e.apply((ModelEntity)object)).ifPresent(string -> attributesImpl.addAttribute("", "", "icon", "CDATA", (String)string));
        }
    }

    public static class ModelEntitySetting {
        public final ModelEntity entity;
        public final String setting;

        public ModelEntitySetting(ModelEntity modelEntity, String string) {
            this.entity = modelEntity;
            this.setting = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ModelEntitySetting) {
                ModelEntitySetting modelEntitySetting = (ModelEntitySetting)object;
                return this.entity.equals(modelEntitySetting.entity) && this.setting.equals(modelEntitySetting.setting);
            }
            return false;
        }

        public int hashCode() {
            return this.setting.hashCode() * 17 + this.entity.hashCode();
        }

        public String toString() {
            return String.valueOf(ModelEntityUtil.getEntityPath(this.entity)) + ":" + this.setting;
        }
    }

    static class c
    implements IPasteController {
        private final Map<ModelEntity, ModelEntity> a = new LinkedHashMap<ModelEntity, ModelEntity>();
        private final String b;

        public c(String string) {
            this.b = string;
        }

        @Override
        public String getComponentContext(int n2, CopyPasteInfo copyPasteInfo) {
            String string;
            if (!FlStringUtil.isNullOrEmpty((String)this.b) && (string = copyPasteInfo.getCopiedPath(n2)) != null && copyPasteInfo.getReferenceFromSetting(String.valueOf(string) + ":storedParent") != null) {
                return this.b;
            }
            return copyPasteInfo.getComponentRef(n2);
        }

        @Override
        public Map<ModelEntity, ModelEntity> getMap() {
            return this.a;
        }
    }

    public static class PropComparerExcludeInactive
    implements PropAnnotationInfo.t {
        private final PropFeature a;
        private final Function<PropFeature, Boolean> b;

        public PropComparerExcludeInactive(PropFeature propFeature, Function<PropFeature, Boolean> function) {
            this.a = propFeature;
            this.b = function;
        }

        public String getStringValue() {
            if (this.a()) {
                return "";
            }
            return null;
        }

        public int getTolerance() {
            if (this.a()) {
                return Integer.MAX_VALUE;
            }
            return 0;
        }

        private boolean a() {
            return this.b.apply(this.a);
        }
    }

    public static class PropComparerExcludeInactiveByGroupValue
    extends PropComparerExcludeInactive {
        public PropComparerExcludeInactiveByGroupValue(PropFeature propFeature2, String string, String string2) {
            super(propFeature2, propFeature -> propFeature.hasProperty(string) && !propFeature.getString(string).equals(string2));
        }
    }
}

