/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.applapi.IParamSpecContainer;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.data.Node;
import com.comsol.model.dbimodel.CopyPasteInfo;
import com.comsol.model.dbimodel.DEPVAR_TYPE;
import com.comsol.model.dbimodel.Field;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.dbimodel.MaterialList;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.MultiphysicsContributor;
import com.comsol.model.dbimodel.NodeGroup;
import com.comsol.model.dbimodel.Ode;
import com.comsol.model.dbimodel.ParamValue;
import com.comsol.model.dbimodel.ParameterContainer;
import com.comsol.model.dbimodel.ParameterEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.physics.EquationViewParent;
import com.comsol.model.dbimodel.physics.MultiphysicsCoupling;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.dbimodel.physics.PhysicsFeatureList;
import com.comsol.model.dbimodel.physics.PhysicsField;
import com.comsol.model.dbimodel.physics.PhysicsProp;
import com.comsol.model.events.MultiphysicsEvent;
import com.comsol.model.method.internal.IMultiphysicsContributorSetter;
import com.comsol.model.method.internal.MultiphysicsContributorInternal;
import com.comsol.model.savepoint.interfaces.IModelEntity;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MultiphysicsUtil {
    private static final String[] a = new String[]{"mat", "sys", "pml", "ie"};
    private static final String[] b = new String[]{"material", "minput"};
    public static final boolean DO_ASSOC_UPDATE_ON_CONTRIBUTIONS = true;
    public static final Predicate<ModelEntity> anyEntities = modelEntity -> true;
    public static final Predicate<ModelEntity> anyPairFeature = modelEntity -> modelEntity.isActive() && modelEntity instanceof PhysicsFeature && ((PhysicsFeature)modelEntity).getApplfeature().isPairFeature();
    public static final Predicate<ModelEntity> anyPairCoupling = modelEntity -> modelEntity.isActive() && modelEntity instanceof MultiphysicsCoupling && ((MultiphysicsCoupling)modelEntity).getMultiphysicsCoupling().isPairFeature();
    public static final Function<MultiphysicsContributor, MultiphysicsContributor> normalUpdate = multiphysicsContributor -> multiphysicsContributor;
    public static final Function<MultiphysicsContributor, MultiphysicsContributor> selectionUpdate = multiphysicsContributor -> Optional.ofNullable(MultiphysicsUtil.getContainingPhysics(multiphysicsContributor)).orElse((Physics)multiphysicsContributor);
    private static final Function<ModelEntity, Stream<IMultiphysicsContributorSetter>> g = modelEntity -> MultiphysicsUtil.b(modelEntity, true).stream();
    private static final Function<ModelEntity, Stream<ModelEntity>> h = modelEntity -> modelEntity instanceof NodeGroup ? ((NodeGroup)modelEntity).stream() : Stream.of(modelEntity);
    private static final Predicate<IMultiphysicsContributorSetter> i = iMultiphysicsContributorSetter -> !iMultiphysicsContributorSetter.muteMultiphysics(true);
    private static final boolean c = false;
    private static final boolean d = false;
    private static final Predicate<PrimitiveModelEntity> e = primitiveModelEntity -> primitiveModelEntity instanceof ModelNode;
    private static final Predicate<PrimitiveModelEntity> f = primitiveModelEntity -> primitiveModelEntity instanceof Physics || primitiveModelEntity instanceof MultiphysicsCoupling;

    public static String getUniqueName(String string, Set<String> set, boolean bl2) {
        int n2 = 1;
        String string2 = bl2 ? string : String.valueOf(string) + n2;
        while (set.contains(string2)) {
            string2 = String.valueOf(string) + ++n2;
        }
        set.add(string2);
        return string2;
    }

    public static HashSet<String> getAllFieldNames(Model model, PhysicsField physicsField) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Physics physics : model.physics()) {
            for (PhysicsField physicsField2 : physics.field()) {
                if (physicsField2 == physicsField) continue;
                hashSet.add(physicsField2.field());
            }
        }
        for (Field field : model.field()) {
            if (field.getType() != DEPVAR_TYPE.CONTROL) continue;
            hashSet.add(field.field());
        }
        String string = physicsField != null ? physicsField.scopeDot() : "";
        for (Ode ode : model.ode()) {
            String[] stringArray = ode.state();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                if (string2.startsWith(string)) {
                    hashSet.add(string2.substring(string.length()));
                }
                ++n3;
            }
        }
        return hashSet;
    }

    public static HashSet<String> getAllCompNames(Model model, PhysicsField physicsField) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Physics physics : model.physics()) {
            for (PhysicsField physicsField2 : physics.field()) {
                if (physicsField2 == physicsField) continue;
                String[] stringArray = physicsField2.component();
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string = stringArray[n3];
                    hashSet.add(string);
                    ++n3;
                }
            }
        }
        return hashSet;
    }

    public static Physics getContainingPhysics(IModelEntity iModelEntity) {
        if (iModelEntity instanceof PrimitiveModelEntity) {
            PrimitiveModelEntity primitiveModelEntity = (PrimitiveModelEntity)((Object)iModelEntity);
            while (primitiveModelEntity != null) {
                if (primitiveModelEntity instanceof Physics) {
                    return (Physics)primitiveModelEntity;
                }
                primitiveModelEntity = primitiveModelEntity.getContainer();
            }
        }
        return null;
    }

    public static IParamSpecContainer getParamSpecContainer(PrimitiveModelEntity primitiveModelEntity) {
        if (primitiveModelEntity instanceof PhysicsFeature) {
            return ((PhysicsFeature)primitiveModelEntity).getApplfeature();
        }
        if (primitiveModelEntity instanceof PhysicsProp) {
            return ((PhysicsProp)primitiveModelEntity).getProp();
        }
        if (primitiveModelEntity instanceof MultiphysicsCoupling) {
            return ((MultiphysicsCoupling)primitiveModelEntity).getMultiphysicsCoupling();
        }
        return null;
    }

    private static List<IMultiphysicsContributorSetter> b(PrimitiveModelEntity primitiveModelEntity, boolean bl2) {
        ArrayList<IMultiphysicsContributorSetter> arrayList = new ArrayList<IMultiphysicsContributorSetter>();
        PrimitiveModelEntity primitiveModelEntity2 = primitiveModelEntity;
        while (primitiveModelEntity2 != null) {
            if (primitiveModelEntity2 instanceof IMultiphysicsContributorSetter) {
                arrayList.add((IMultiphysicsContributorSetter)primitiveModelEntity2);
                if (bl2) {
                    return arrayList;
                }
            }
            primitiveModelEntity2 = primitiveModelEntity2.getContainer();
        }
        return arrayList;
    }

    public static boolean isPhysicsContext(ModelEntity modelEntity) {
        PrimitiveModelEntity primitiveModelEntity = modelEntity;
        while (primitiveModelEntity != null) {
            if (primitiveModelEntity instanceof Physics || primitiveModelEntity instanceof MultiphysicsCoupling) {
                return true;
            }
            primitiveModelEntity = primitiveModelEntity.getContainer();
        }
        return false;
    }

    public static boolean isReservedFirstScope(String string) {
        return q.a((Object[])b, (Object)string);
    }

    public static boolean checkIdentifier(String string, ModelEntity modelEntity, String string2, String ... stringArray) {
        String string3 = FlStringUtil.stripNumberSuffix((String)string);
        if (q.a((Object[])a, (Object)string3) && !q.a((Object[])stringArray, (Object)string3)) {
            throw new FlException("Identifier_X_is_not_allowed_for_a_Y#" + string + "#" + FlLocale.getString((String)string2).toLowerCase(Locale.ENGLISH));
        }
        if (!modelEntity.isInModel()) {
            return true;
        }
        Collection<String> collection = MultiphysicsUtil.a(modelEntity, modelEntity.getModel(), false);
        String string4 = modelEntity.scope();
        int n2 = string4.lastIndexOf(46);
        if (n2 > 0) {
            string4 = String.valueOf(string4.substring(0, n2 + 1)) + string;
        }
        return !collection.contains(string4);
    }

    private static Collection<String> a(ModelEntity modelEntity, Model model, boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        MultiphysicsUtil.a(modelEntity, model.physics(), hashSet, bl2);
        MultiphysicsUtil.a(modelEntity, model.multiphysics(), hashSet, bl2);
        MultiphysicsUtil.a(modelEntity, model.coordSystem(), hashSet, bl2);
        MultiphysicsUtil.a(modelEntity, model.material(), hashSet, bl2);
        MultiphysicsUtil.a(modelEntity, model.pair(), hashSet, bl2);
        return hashSet;
    }

    private static void a(ModelEntity modelEntity, ModelEntityList<? extends ModelEntity> modelEntityList, HashSet<String> hashSet, boolean bl2) {
        for (ModelEntity modelEntity2 : modelEntityList) {
            if (modelEntity == modelEntity2) continue;
            String string = modelEntity2.scope();
            if (bl2) {
                string = FlStringUtil.getUnscopedName((String)string);
            }
            hashSet.add(string);
        }
    }

    public static String getUniqueIdentifier(String string, ModelEntity modelEntity, ModelEntityList modelEntityList) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(MultiphysicsUtil.a(modelEntity, modelEntityList.getModel(), true));
        if (hashSet.contains(string)) {
            String string2 = FlStringUtil.stripNumberSuffix((String)string);
            int n2 = 1;
            while (hashSet.contains(String.valueOf(string2) + ++n2) && n2 <= hashSet.size()) {
            }
            return String.valueOf(string2) + n2;
        }
        return string;
    }

    private static void b(Model model, Physics physics, boolean bl2) {
        if (physics != null) {
            physics.useSelectionEntityCache(bl2);
            MultiphysicsUtil.b(physics.feature(), bl2);
        } else {
            for (Physics matchTagContainer : model.physics()) {
                matchTagContainer.useSelectionEntityCache(bl2);
                MultiphysicsUtil.b(matchTagContainer.feature(), bl2);
            }
            for (MultiphysicsCoupling multiphysicsCoupling : model.multiphysics()) {
                multiphysicsCoupling.useSelectionEntityCache(bl2);
            }
        }
    }

    private static void b(Model model, boolean bl2) {
        MultiphysicsUtil.b(model, null, bl2);
        MultiphysicsUtil.b(model, null, bl2);
    }

    private static void b(PhysicsFeatureList<? extends PhysicsFeature> physicsFeatureList, boolean bl2) {
        for (PhysicsFeature physicsFeature : physicsFeatureList) {
            physicsFeature.useSelectionEntityCache(bl2);
            MultiphysicsUtil.b(physicsFeature.feature(), bl2);
        }
    }

    private static void b(Model model, Material material, boolean bl2) {
        if (material != null) {
            material.useSelectionEntityCache(bl2);
        } else {
            for (Material material2 : model.material()) {
                material2.useSelectionEntityCache(bl2);
            }
        }
    }

    public static void updateAllPhysics(Model model) {
        IVariableData iVariableData = model.physics().getVarData();
        model.physics().activeStream().forEach(physics -> iVariableData.updateVariables(null, (ModelEntity)physics, null, false, true));
        model.multiphysics().activeStream().forEach(multiphysicsCoupling -> iVariableData.updateVariables(null, (ModelEntity)multiphysicsCoupling, null, false, true));
    }

    public static void updatePhysicsPairFeatures(Model model) {
        IVariableData iVariableData = model.physics().getVarData();
        ArrayList<MultiphysicsContributor> arrayList = new ArrayList<MultiphysicsContributor>();
        MultiphysicsUtil.collectMultiphysicsContributors(model.physics(), arrayList, anyPairFeature);
        MultiphysicsUtil.collectMultiphysicsContributors(model.multiphysics(), arrayList, anyPairCoupling);
        arrayList.stream().forEach(multiphysicsContributor -> iVariableData.updateVariables(null, (ModelEntity)multiphysicsContributor, null, false, true));
    }

    public static void collectMultiphysicsContributors(ModelEntity modelEntity, Collection<MultiphysicsContributor> collection, Predicate<ModelEntity> predicate) {
        if (modelEntity instanceof MultiphysicsContributor && predicate.test(modelEntity)) {
            collection.add((MultiphysicsContributor)modelEntity);
        }
        if (modelEntity instanceof ModelEntityList) {
            for (ModelEntity modelEntity2 : (ModelEntityList)modelEntity) {
                MultiphysicsUtil.collectMultiphysicsContributors(modelEntity2, collection, predicate);
            }
        } else {
            List<PrimitiveModelEntity> list = modelEntity.allChildren(true);
            for (PrimitiveModelEntity primitiveModelEntity : list) {
                if (!(primitiveModelEntity instanceof ModelEntity)) continue;
                MultiphysicsUtil.collectMultiphysicsContributors((ModelEntity)primitiveModelEntity, collection, predicate);
            }
        }
    }

    public static String getFeaturePath(ModelEntity modelEntity) {
        Stack<String> stack = new Stack<String>();
        StringBuffer stringBuffer = new StringBuffer();
        while (modelEntity instanceof PhysicsFeature) {
            String string = ((PhysicsFeature)modelEntity).getApplfeatureID();
            stack.push(String.valueOf(string) + "/");
            modelEntity = (ModelEntity)modelEntity.getContainer().getContainer();
        }
        while (!stack.isEmpty()) {
            stringBuffer.append((String)stack.pop());
        }
        return stringBuffer.toString();
    }

    public static boolean disabledBySelection(PrimitiveModelEntity primitiveModelEntity) {
        boolean bl2;
        block5: {
            SelectionEntity selectionEntity;
            block6: {
                if (primitiveModelEntity == null || !(primitiveModelEntity instanceof SelectionEntity)) {
                    return false;
                }
                selectionEntity = (SelectionEntity)primitiveModelEntity;
                if (!selectionEntity.hasSelection()) {
                    return false;
                }
                bl2 = selectionEntity.selection().isEmpty();
                if (!bl2) break block5;
                if (!(selectionEntity instanceof ParameterEntity)) break block6;
                ParameterEntity parameterEntity = (ParameterEntity)selectionEntity;
                String[] stringArray = parameterEntity.getExtraSelectionNames();
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string = stringArray[n3];
                    if (parameterEntity.isActive(string) && !parameterEntity.selection(string).isEmpty()) {
                        return false;
                    }
                    ++n3;
                }
                break block5;
            }
            if (!(selectionEntity instanceof Physics)) break block5;
            for (PhysicsFeature physicsFeature : ((Physics)selectionEntity).feature().getActiveList()) {
                if (MultiphysicsUtil.disabledBySelection(physicsFeature)) continue;
                return false;
            }
        }
        return bl2;
    }

    public static String getWarningOrErrorTooltip(EquationViewParent equationViewParent, Function<Object, String> function) {
        String[] stringArray;
        String string = ModelEntityUtil.getErrorNode(equationViewParent.featureInfo());
        if (string == null) {
            string = ModelEntityUtil.getWarningNode(equationViewParent.featureInfo());
        }
        if (string != null && (stringArray = equationViewParent.featureInfo(string).getStringArray("$message")) != null && stringArray.length > 0) {
            return FlLocale.getString((String)stringArray[0]);
        }
        return function.apply(equationViewParent);
    }

    private static Optional<ModelEntity> a(Model model, String string2, CopyPasteInfo copyPasteInfo, Predicate<PrimitiveModelEntity> predicate) {
        List<PrimitiveModelEntity> list = copyPasteInfo.getCopiedObjects();
        int n2 = 0;
        while (n2 < list.size()) {
            PrimitiveModelEntity primitiveModelEntity = list.get(n2);
            if (predicate.test(primitiveModelEntity) && ((ModelEntity)primitiveModelEntity).getIdentifierName().equals(string2)) {
                return Optional.ofNullable(copyPasteInfo.getPastedPath(copyPasteInfo.getCopiedPath(n2))).map(string -> ModelEntityUtil.findEntity(model, string));
            }
            ++n2;
        }
        return Optional.empty();
    }

    public static Optional<String> findScopedVariableWhenPasting(Model model, String string, CopyPasteInfo copyPasteInfo) {
        if (!string.startsWith("root.")) {
            return Optional.empty();
        }
        String[] stringArray = FlStringUtil.split((CharSequence)string, (char)'.', (boolean)true);
        String string2 = null;
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            switch (n2) {
                case 0: {
                    stringBuilder.append(stringArray[n2]).append('.');
                    break;
                }
                case 1: {
                    String[] stringArray2 = MultiphysicsUtil.a(model, stringArray[n2], copyPasteInfo, e).map(modelEntity -> modelEntity.getIdentifierName()).orElse("");
                    if (stringArray2.isEmpty()) {
                        return Optional.empty();
                    }
                    stringBuilder.append((String)stringArray2).append('.');
                    break;
                }
                case 2: {
                    String[] stringArray2 = MultiphysicsUtil.a(model, stringArray[n2], copyPasteInfo, f).orElse(null);
                    if (stringArray2 == null) {
                        return Optional.empty();
                    }
                    stringBuilder.append(stringArray2.getIdentifierName()).append('.');
                    string2 = ModelEntityUtil.getCopiedPath((ModelEntity)stringArray2, copyPasteInfo);
                    if (!(stringArray2 instanceof Physics)) break;
                    string3 = "/PhysicsFeatureList/";
                    break;
                }
                default: {
                    if (string2 == null || string3 == null) {
                        return Optional.empty();
                    }
                    String[] stringArray2 = ModelEntityUtil.findPastedPathInHierarchy(string2 = String.valueOf(string2) + string3 + stringArray[n2], copyPasteInfo);
                    if (stringArray2 == null) {
                        return Optional.empty();
                    }
                    if (stringArray2[1].isEmpty()) {
                        stringBuilder.append(stringArray2[0].substring(stringArray2[0].lastIndexOf(47) + 1)).append('.');
                        break;
                    }
                    stringBuilder.append(stringArray2[1].substring(stringArray2[1].lastIndexOf(47) + 1)).append('.');
                }
            }
            ++n2;
        }
        return Optional.of(stringBuilder.append(stringArray[stringArray.length - 1]).toString());
    }

    public static void clearAllContributions(Model model, ModelEntity modelEntity) {
        Iterator<Node> iterator = model.getNode().allContents(true);
        boolean bl2 = modelEntity == null || modelEntity == model;
        while (iterator.hasNext()) {
            MultiphysicsContributorInternal multiphysicsContributorInternal;
            Node node = iterator.next();
            if (!(node.getObjectEntity() instanceof MultiphysicsContributorInternal) || !(multiphysicsContributorInternal = (MultiphysicsContributorInternal)((Object)node.getObjectEntity())).hasContribution() || !bl2 && !ModelInternalUtil.containedBy(modelEntity, multiphysicsContributorInternal)) continue;
            multiphysicsContributorInternal.setContribution(null);
        }
    }

    public static class CallContributorsCloseable
    extends SelectionCacheCloseable {
        public final IVariableData varData;
        private final List<IMultiphysicsContributorSetter> a = new ArrayList<IMultiphysicsContributorSetter>();
        private final boolean c;
        private final boolean d;

        public CallContributorsCloseable(Model model, String string, boolean bl2) {
            super(model);
            this.varData = model.physics().getVarData();
            this.varData.setStudyStepPath(string);
            this.c = bl2;
            this.d = this.varData.isFullMultiphysics();
            this.a();
        }

        @Override
        public void close() {
            try {
                this.b();
                this.varData.setStudyStepPath(null);
                this.varData.setFullMultiphysics(this.d);
                if (!this.c) {
                    this.b.fireMultiphysicsEvent(new MultiphysicsEvent(MultiphysicsEvent.EventType.POSTMULTIPHYSICS));
                }
            }
            finally {
                super.close();
            }
        }

        private void a() {
            if (this.b != null) {
                this.b.physics().stream().map(physics -> (IMultiphysicsContributorSetter)((Object)physics)).filter(iMultiphysicsContributorSetter -> !iMultiphysicsContributorSetter.muteMultiphysics(true)).forEach(iMultiphysicsContributorSetter -> {
                    boolean bl2 = this.a.add((IMultiphysicsContributorSetter)iMultiphysicsContributorSetter);
                });
                this.b.multiphysics().stream().map(multiphysicsCoupling -> (IMultiphysicsContributorSetter)((Object)multiphysicsCoupling)).filter(iMultiphysicsContributorSetter -> !iMultiphysicsContributorSetter.muteMultiphysics(true)).forEach(iMultiphysicsContributorSetter -> {
                    boolean bl2 = this.a.add((IMultiphysicsContributorSetter)iMultiphysicsContributorSetter);
                });
            }
        }

        private void b() {
            if (!this.a.isEmpty()) {
                this.a.forEach(iMultiphysicsContributorSetter -> {
                    boolean bl2 = iMultiphysicsContributorSetter.muteMultiphysics(false);
                });
                this.a.clear();
            }
        }
    }

    public static class DeleteMultipleMuteMultiphysicsCloseable
    extends SelectionCacheCloseable {
        private final List<IMultiphysicsContributorSetter> a = new ArrayList<IMultiphysicsContributorSetter>();

        public DeleteMultipleMuteMultiphysicsCloseable(Model model, Collection<?> collection, boolean bl2) {
            super(model);
            this.a(collection, bl2);
        }

        @Override
        public void close() {
            try {
                this.a();
            }
            finally {
                super.close();
            }
        }

        private void a(Collection<?> collection, boolean bl2) {
            if (!collection.isEmpty()) {
                collection.stream().filter(object -> object instanceof ModelEntity).map(object -> (ModelEntity)object).flatMap(h).flatMap(g).filter(i).forEach(iMultiphysicsContributorSetter -> {
                    boolean bl2 = this.a.add((IMultiphysicsContributorSetter)iMultiphysicsContributorSetter);
                });
                if (bl2) {
                    this.b.physics().stream().map(physics -> (IMultiphysicsContributorSetter)((Object)physics)).filter(i).forEach(iMultiphysicsContributorSetter -> {
                        boolean bl2 = this.a.add((IMultiphysicsContributorSetter)iMultiphysicsContributorSetter);
                    });
                    this.b.multiphysics().stream().map(multiphysicsCoupling -> (IMultiphysicsContributorSetter)((Object)multiphysicsCoupling)).filter(i).forEach(iMultiphysicsContributorSetter -> {
                        boolean bl2 = this.a.add((IMultiphysicsContributorSetter)iMultiphysicsContributorSetter);
                    });
                }
            }
        }

        private void a() {
            if (!this.a.isEmpty()) {
                this.a.forEach(iMultiphysicsContributorSetter -> {
                    boolean bl2 = iMultiphysicsContributorSetter.muteMultiphysics(false);
                });
                this.a.clear();
            }
        }
    }

    public static class MuteMultiphysicsCloseable
    implements AutoCloseable {
        private final boolean a;
        protected final List<IMultiphysicsContributorSetter> c = new ArrayList<IMultiphysicsContributorSetter>();

        public MuteMultiphysicsCloseable(PrimitiveModelEntity primitiveModelEntity, boolean bl2) {
            this(primitiveModelEntity, true, bl2);
        }

        public MuteMultiphysicsCloseable(PrimitiveModelEntity primitiveModelEntity, boolean bl2, boolean bl3) {
            this.a = !bl3;
            List list = MultiphysicsUtil.b(primitiveModelEntity, !bl2);
            list.stream().filter(iMultiphysicsContributorSetter -> iMultiphysicsContributorSetter.muteMultiphysics(bl3) ^ bl3).forEach(iMultiphysicsContributorSetter -> {
                boolean bl2 = this.c.add((IMultiphysicsContributorSetter)iMultiphysicsContributorSetter);
            });
            if (list.isEmpty() && primitiveModelEntity != null) {
                throw new IllegalArgumentException("The multiphysics contributor '" + primitiveModelEntity.getDisplayString() + "' do not support muting of multiphysics calls");
            }
        }

        @Override
        public void close() {
            if (!this.c.isEmpty()) {
                this.c.forEach(iMultiphysicsContributorSetter -> {
                    boolean bl2 = iMultiphysicsContributorSetter.muteMultiphysics(this.a);
                });
                this.c.clear();
            }
        }
    }

    public static class MutePostMultiphysicsEvents
    extends SelectionCacheCloseable {
        private final StudyFeature a;
        private final boolean c;
        private final ModelEntityList<Field> d;
        private final ModelEntityList<Ode> e;

        public MutePostMultiphysicsEvents(StudyFeature studyFeature, Model model, boolean bl2) {
            super(model);
            this.a = studyFeature;
            this.c = bl2;
            this.d = (ModelEntityList)model.field().copy(model);
            this.e = (ModelEntityList)model.ode().copy(model);
        }

        @Override
        public void close() {
            this.b.physics().getVarData().updateInputListeners(this.b, false, true, null);
            if (!this.c) {
                this.b.fireMultiphysicsEvent(new MultiphysicsEvent(this.a, this.d, this.e, this.b.field(), this.b.ode()));
                this.b.fireMultiphysicsEvent(new MultiphysicsEvent(MultiphysicsEvent.EventType.POSTMULTIPHYSICS));
            }
            super.close();
        }
    }

    public static class SelectionCacheCloseable
    implements AutoCloseable {
        private ModelEntity a = null;
        protected Model b = null;
        private final Collection<SelectionEntity> c;

        public SelectionCacheCloseable(IModelEntity iModelEntity) {
            this(iModelEntity, Collections.emptyList());
        }

        public SelectionCacheCloseable(IModelEntity iModelEntity, Collection<SelectionEntity> collection) {
            this.c = collection;
            if (iModelEntity instanceof ModelEntity && !(this.b = ((ModelEntity)iModelEntity).getModel()).selectionCacheEnabled()) {
                this.b.enableSelectionCache(true);
                this.a = (ModelEntity)iModelEntity;
                if (this.b == this.a) {
                    MultiphysicsUtil.b(this.b, true);
                } else if (this.a instanceof PhysicsFeatureList) {
                    MultiphysicsUtil.b((PhysicsFeatureList)this.a, true);
                } else if (this.a instanceof Physics) {
                    MultiphysicsUtil.b(this.b, (Physics)this.a, true);
                } else if (this.a instanceof MaterialList) {
                    MultiphysicsUtil.b(this.b, null, true);
                }
            }
            for (SelectionEntity selectionEntity : collection) {
                ISelectionFilter iSelectionFilter;
                if (!selectionEntity.hasSelection() || (iSelectionFilter = selectionEntity.selection().getSelectionFilter()) == null) continue;
                iSelectionFilter.initializeSelectionFilterCache();
            }
        }

        @Override
        public void close() {
            for (SelectionEntity selectionEntity : this.c) {
                ISelectionFilter iSelectionFilter;
                if (!selectionEntity.hasSelection() || (iSelectionFilter = selectionEntity.selection().getSelectionFilter()) == null) continue;
                iSelectionFilter.clearSelectionFilterCache();
            }
            if (this.a != null) {
                if (this.b == this.a) {
                    MultiphysicsUtil.b(this.b, false);
                } else if (this.a instanceof PhysicsFeatureList) {
                    MultiphysicsUtil.b((PhysicsFeatureList)this.a, false);
                } else if (this.a instanceof Physics) {
                    MultiphysicsUtil.b(this.b, (Physics)this.a, false);
                } else if (this.a instanceof MaterialList) {
                    MultiphysicsUtil.b(this.b, null, false);
                }
                this.b.enableSelectionCache(false);
                this.a = null;
                this.b = null;
            }
        }
    }

    public static class SetParamValueCloseable
    extends MuteMultiphysicsCloseable {
        private final ParamValue a;
        private final boolean b;

        public SetParamValueCloseable(ParamValue paramValue, boolean bl2, boolean bl3) {
            super(paramValue.getContainer(), bl3);
            this.a = paramValue;
            this.b = bl2;
            if (paramValue.getContainer() instanceof PhysicsProp) {
                PhysicsProp physicsProp = (PhysicsProp)paramValue.getContainer();
                String string = Optional.ofNullable(physicsProp.getApplmode()).map(physics -> physics.tag()).orElse(null);
                physicsProp.getModel().multiphysics().stream().filter(multiphysicsCoupling -> multiphysicsCoupling.getPhysicsTags().contains(string)).map(multiphysicsCoupling -> (IMultiphysicsContributorSetter)((Object)multiphysicsCoupling)).filter(iMultiphysicsContributorSetter -> iMultiphysicsContributorSetter.muteMultiphysics(bl3) ^ bl3).forEach(iMultiphysicsContributorSetter -> {
                    boolean bl2 = this.c.add(iMultiphysicsContributorSetter);
                });
            }
        }

        @Override
        public void close() {
            super.close();
            if (this.b) {
                MultiphysicsContributor multiphysicsContributor = (MultiphysicsContributor)this.a.getContainer();
                IParamSpecContainer iParamSpecContainer = MultiphysicsUtil.getParamSpecContainer(multiphysicsContributor);
                iParamSpecContainer.updateVariables((ParameterContainer)((Object)multiphysicsContributor), this.a.getTag());
            }
        }
    }
}

