/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.util.INodeTextListener;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.nativeutil.preferences.e;
import com.comsol.nativeutil.preferences.j;
import com.comsol.nativeutil.properties.BooleanProp;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.methods.FlStringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public enum NodeTextType implements e
{
    LABEL("Label", "Label", null, null),
    NAME("Name", "Name", null, "nodetextname"),
    TAG("Tag", "Tag", null, "nodetexttag"),
    TYPE("Type", "Type", null, "nodetexttype");

    private String ID = "node_text_";
    private final String text;
    private final String toolTip;
    private final String icon;
    private final String preferenceName;
    private final j preferenceChangeManager = Preferences.getInstance().getPreferenceChangeManager();
    private boolean settingValue = false;
    private List<INodeTextListener> listeners = new ArrayList<INodeTextListener>();

    private NodeTextType(String string2, String string3, String string4, String string5) {
        this.text = string2;
        this.toolTip = string3;
        this.icon = string4;
        this.preferenceName = string5;
    }

    public String getTag() {
        return String.valueOf(this.ID) + this.name().toLowerCase(Locale.ENGLISH);
    }

    public String getText() {
        return this.text;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public String getIcon() {
        return this.icon;
    }

    public void addPreferenceListeners() {
        this.removePreferenceListeners();
        String string = this.getPreferenceName();
        this.preferenceChangeManager.a(string, (e)this);
    }

    public void removePreferenceListeners() {
        String string = "modelbuilder.buildertree.";
        this.preferenceChangeManager.b(String.valueOf(string) + this.preferenceName, (e)this);
    }

    public void preferenceChanged(String string, String string2) {
        if (!this.settingValue) {
            this.setValue(BooleanProp.OnOff.a.toString().equals(string2));
        }
    }

    public String getPreferenceName() {
        String string = "modelbuilder.buildertree.";
        return String.valueOf(string) + this.preferenceName;
    }

    public String[] getPreferenceNames() {
        if (this.preferenceName == null) {
            return new String[0];
        }
        return new String[]{"modelbuilder.buildertree." + this.preferenceName};
    }

    private Boolean a() {
        String string = this.getPreferenceName();
        return Preferences.getInstance().getBooleanPreference(string);
    }

    private void a(boolean bl2) {
        String string = this.getPreferenceName();
        if (string != null) {
            this.settingValue = true;
            try {
                Preferences.getInstance().setBooleanPreference(this.getPreferenceName(), bl2);
            }
            finally {
                this.settingValue = false;
            }
        }
    }

    public boolean isOptional() {
        return this != LABEL;
    }

    public boolean getValueToUse() {
        String string = SystemUtil.getTreeLabelMode();
        if (string != null) {
            return string.toLowerCase(Locale.ENGLISH).contains(this.text.toLowerCase(Locale.ENGLISH));
        }
        return this.getValue();
    }

    public boolean getValue() {
        return this.a();
    }

    public void setValue(boolean bl2) {
        this.a(bl2);
        ArrayList<INodeTextListener> arrayList = new ArrayList<INodeTextListener>();
        arrayList.addAll(this.listeners);
        for (INodeTextListener iNodeTextListener : arrayList) {
            iNodeTextListener.onNodeTypeChanged(this, bl2);
        }
    }

    public static NodeTextType[] getOptionalTypes() {
        return new NodeTextType[]{NAME, TAG, TYPE};
    }

    public static NodeTextType[] getTypesDisplayOrder() {
        return new NodeTextType[]{TYPE, LABEL, NAME, TAG};
    }

    public static NodeTextType[] getApplicationTreeTypes() {
        return new NodeTextType[]{LABEL, TAG};
    }

    public void setFromPreferences() {
        this.setValue(Preferences.getInstance().getBooleanPreference(this.getPreferenceName()));
    }

    public void addEventHandler(INodeTextListener iNodeTextListener) {
        if (!this.listeners.contains(iNodeTextListener)) {
            this.listeners.add(iNodeTextListener);
        }
    }

    public void removeEventHandler(INodeTextListener iNodeTextListener) {
        this.listeners.remove(iNodeTextListener);
    }

    public static void addEventHandlers(INodeTextListener iNodeTextListener, NodeTextType[] nodeTextTypeArray) {
        NodeTextType[] nodeTextTypeArray2 = nodeTextTypeArray;
        int n2 = nodeTextTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            NodeTextType nodeTextType = nodeTextTypeArray2[n3];
            nodeTextType.addEventHandler(iNodeTextListener);
            ++n3;
        }
    }

    public static void removeEventHandlers(INodeTextListener iNodeTextListener, NodeTextType[] nodeTextTypeArray) {
        NodeTextType[] nodeTextTypeArray2 = nodeTextTypeArray;
        int n2 = nodeTextTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            NodeTextType nodeTextType = nodeTextTypeArray2[n3];
            nodeTextType.removeEventHandler(iNodeTextListener);
            ++n3;
        }
    }

    public static void set(String[] stringArray) {
        NodeTextType[] nodeTextTypeArray = NodeTextType.getOptionalTypes();
        int n2 = nodeTextTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            NodeTextType nodeTextType = nodeTextTypeArray[n3];
            nodeTextType.setValue(FlStringUtil.contains((String[])stringArray, (String)nodeTextType.getText()));
            ++n3;
        }
    }
}

