/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.analysis.StudyFeatureID;
import com.comsol.model.analysis.StudyReferenceAnalysisID;
import com.comsol.model.applapi.ISharedQuantity;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.SharedQuantityContainer;
import com.comsol.model.applapi.UnitConverter;
import com.comsol.model.dbimodel.BatchFeature;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.OptFeatureList;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropFeatureList;
import com.comsol.model.dbimodel.SolverSequence;
import com.comsol.model.dbimodel.Study;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.StudyFeatureList;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.opt.OptOperationID;
import com.comsol.model.util.MultiphysicsException;
import com.comsol.model.util.OptimizationSharedQtyContainer;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.di;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.List;

public class OptUtil {
    public static String[] getOptObjectiveExpressionNames() {
        String[] stringArray = new String[]{"all_obj_contrib", "all_obj_contrib_nolsq", "all_obj_sum", "all_obj_min", "all_obj_max", "all_obj_scaled_contrib", "all_obj_scaled_contrib_nolsq", "all_obj_scaled_sum", "all_obj_scaled_min", "all_obj_scaled_max"};
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getOptObjectiveExpressionVals(List<? extends PropFeature> list) {
        void var7_11;
        String string;
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (PropFeature object2 : list) {
            if (!object2.isActive() || (string2 = FlStringUtil.getXmeshVarName((String)object2.getString("varname"))).length() <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("+");
            }
            stringBuilder.append(string2);
            arrayList.add(string2);
            if (!OptOperationID.LEASTSQUARES.toString().equals(object2.getOperationID())) {
                string = "(" + UnitConverter.getXMeshExpr(object2.getString("expr"), object2, false, false) + ")";
                arrayList2.add(string);
                if (stringBuilder3.length() > 0) {
                    stringBuilder3.append("+");
                    stringBuilder2.append("+");
                    stringBuilder4.append("+");
                }
                stringBuilder3.append(string2);
                stringBuilder2.append(string);
                stringBuilder4.append(string);
                continue;
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("+");
            }
            stringBuilder2.append(string2);
            arrayList2.add(string2);
        }
        String string3 = "inf";
        Object object3 = "inf";
        string2 = "-inf";
        string = "-inf";
        if (stringBuilder.length() == 0) {
            stringBuilder.append("0");
            stringBuilder2.append("0");
        }
        if (stringBuilder3.length() == 0) {
            stringBuilder3.append("0");
            stringBuilder4.append("0");
        }
        if (arrayList.size() > 0) {
            String string4 = OptUtil.a(arrayList, "min");
            string2 = OptUtil.a(arrayList, "max");
        }
        if (arrayList2.size() > 0) {
            object3 = OptUtil.a(arrayList2, "min");
            string = OptUtil.a(arrayList2, "max");
        }
        String[] stringArray = new String[]{stringBuilder.toString(), stringBuilder3.toString(), stringBuilder.toString(), var7_11.toString(), string2.toString(), stringBuilder2.toString(), stringBuilder4.toString(), stringBuilder2.toString(), ((String)object3).toString(), string.toString()};
        return stringArray;
    }

    public static void getOptObjectiveVarNamesOchScaledExpressions(List<? extends PropFeature> list, FlStringList flStringList, FlStringList flStringList2) {
        for (PropFeature propFeature : list) {
            if (!propFeature.isActive()) continue;
            String string = FlStringUtil.getXmeshVarName((String)propFeature.getString("varname"));
            flStringList.add(string);
            if (!OptOperationID.LEASTSQUARES.toString().equals(propFeature.getOperationID())) {
                String string2 = "(" + UnitConverter.getXMeshExpr(propFeature.getString("expr"), propFeature, false, false) + ")";
                flStringList2.add(string2);
                continue;
            }
            flStringList2.add(string);
        }
    }

    private static String a(List<String> list, String string) {
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 2) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append("(").append(list.get(0)).append(",").append(list.get(1)).append(")");
            return stringBuilder.toString();
        }
        int n2 = list.size() / 2;
        String string2 = OptUtil.a(list.subList(0, n2 + 1), string);
        String string3 = OptUtil.a(list.subList(n2 + 1, list.size()), string);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("(").append(string2).append(",").append(string3).append(")");
        return stringBuilder.toString();
    }

    public static Study getParametricStudy(BatchFeature batchFeature) {
        Study study = null;
        for (PropFeature propFeature : batchFeature.feature().getActiveList()) {
            ModelEntity modelEntity;
            if (propFeature.getOperationID().equals("Solutionseq")) {
                if (propFeature.getString("seq").equals("all")) continue;
                modelEntity = (SolverSequence)propFeature.getPropertyReference("seq");
                study = modelEntity.getStudyFeature();
                continue;
            }
            if (!propFeature.getOperationID().equals("Jobseq")) continue;
            modelEntity = (BatchFeature)propFeature.getPropertyReference("seq");
            study = modelEntity.getStudyFeature();
        }
        return study;
    }

    public static void pushExternalStudyTag(Study study, String string) {
        if (!study.getExternalStudyTag().isEmpty()) {
            study.setExternalStudyTag("");
            throw new FlException("Recursive_batch_sequence_detected");
        }
        study.setExternalStudyTag(string);
    }

    public static void popExternalStudyTag(Study study) {
        if (study.getExternalStudyTag().isEmpty()) {
            throw new FlException("Internal_solver_error");
        }
        study.setExternalStudyTag("");
    }

    public static Study getEvaluateForStudy(StudyFeature studyFeature, String string) {
        Study study = (Study)studyFeature.getContainer().getContainer();
        for (PropFeature propFeature : study.feature()) {
            if (!propFeature.tag().equals(string)) continue;
            if (propFeature.getOperationID().equals(StudyReferenceAnalysisID.StudyReference.id())) {
                return (Study)propFeature.getPropertyReference("studyref");
            }
            return study;
        }
        return null;
    }

    public static String getEntityTag(ISharedQuantity iSharedQuantity, String string, Model model) {
        IVariableData iVariableData = model.physics().getVarData();
        SharedQuantityContainer sharedQuantityContainer = iVariableData.findSharedQuantityContainer(iSharedQuantity, "root." + string, model);
        if (sharedQuantityContainer != null && ((OptimizationSharedQtyContainer)sharedQuantityContainer).getProperties().hasProp("entityTag")) {
            return ((OptimizationSharedQtyContainer)sharedQuantityContainer).getProperties().getString("entityTag");
        }
        if (FlStringUtil.checkValidTag((String)string)) {
            return string;
        }
        throw new MultiphysicsException("Illegal_X_name_Y#" + FlLocale.getString((String)iSharedQuantity.getDescription()) + "#" + string);
    }

    public static boolean hasLsqData(PropFeature propFeature) {
        if (propFeature != null) {
            if (propFeature instanceof StudyFeature && propFeature.getOperationID().equals("ParameterEstimation")) {
                return true;
            }
            OptFeatureList<? extends PropFeature> optFeatureList = propFeature.getModel().opt().objective();
            if ((optFeatureList == null || optFeatureList.size() == 0) && propFeature instanceof StudyFeature) {
                StudyFeature studyFeature = OptUtil.a((StudyFeature)propFeature);
                return studyFeature != null;
            }
            for (PropFeature propFeature2 : optFeatureList) {
                if (!propFeature2.getOperationID().equals(OptOperationID.LEASTSQUARES.toString())) continue;
                if (propFeature2.tag().startsWith("parestobj")) {
                    if (!(propFeature instanceof StudyFeature)) continue;
                    StudyFeature studyFeature = OptUtil.a((StudyFeature)propFeature);
                    if (propFeature2.getDerivedFrom() != studyFeature) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private static StudyFeature a(StudyFeature studyFeature) {
        StudyFeatureList studyFeatureList;
        StudyFeature studyFeature2 = null;
        if (studyFeature != null && (studyFeatureList = (StudyFeatureList)studyFeature.getContainer()) != null) {
            for (Object e2 : studyFeatureList) {
                if (!((StudyFeature)e2).getOperationID().equals("ParameterEstimation") || !((StudyFeature)e2).isActive()) continue;
                return (StudyFeature)e2;
            }
        }
        return studyFeature2;
    }

    public static boolean hasActiveLsqData(PropFeature propFeature) {
        if (propFeature != null) {
            OptFeatureList<? extends PropFeature> optFeatureList = propFeature.getModel().opt().objective();
            boolean bl2 = false;
            for (PropFeature propFeature2 : optFeatureList) {
                if (!propFeature2.isActive() || !propFeature2.getOperationID().equals(OptOperationID.LEASTSQUARES.toString())) continue;
                bl2 = true;
                break;
            }
            return bl2;
        }
        return false;
    }

    public static boolean hasOpt(StudyFeature studyFeature) {
        if (studyFeature != null) {
            StudyFeatureList studyFeatureList = (StudyFeatureList)studyFeature.getContainer();
            StudyFeature studyFeature2 = OptUtil.getOpt(studyFeatureList);
            return studyFeature2 != null && studyFeature2.isActive();
        }
        return false;
    }

    public static StudyFeature getOpt(PropFeatureList<? extends PropFeature> propFeatureList) {
        if (propFeatureList != null) {
            for (PropFeature propFeature : propFeatureList) {
                if (!(propFeature instanceof StudyFeature) || !StudyFeatureID.isOptimizationID(((StudyFeature)propFeature).getOperationID())) continue;
                return (StudyFeature)propFeature;
            }
        }
        return null;
    }

    public static dd getUseLsqDataCheck(final PropFeature propFeature) {
        di di2 = new di(new String[0], new String[0]){

            public String[] describeValid() {
                if (OptUtil.hasLsqData(propFeature) || propFeature != null && propFeature.getModel().isReinitializing()) {
                    return new String[]{"Manual", "From_lsq_objective"};
                }
                return new String[]{"Manual"};
            }

            public String[] getDescriptions() {
                return this.describeValid();
            }

            public String[] getAllowedValues() {
                if (OptUtil.hasLsqData(propFeature) || propFeature != null && propFeature.getModel().isReinitializing()) {
                    return new String[]{"manual", "lsq"};
                }
                return new String[]{"manual"};
            }
        };
        return di2;
    }

    public static void expParamsExpressionCheck(PropFeature propFeature, List<String[][]> list) {
        if (propFeature != null && propFeature.hasProperty("pname")) {
            String[] stringArray = propFeature.getStringArray("pname");
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3 = 0;
                while (n3 < list.size()) {
                    int n4 = 0;
                    while (n4 < list.get(n3).length) {
                        int n5 = 0;
                        while (n5 < list.get(n3)[n4].length) {
                            String[][] stringArray2 = ParseUtil.m((String)list.get(n3)[n4][n5]);
                            if (q.a((Object[])stringArray2[0], (Object)stringArray[n2])) {
                                throw new FlException("Control_variables_are_not_supported_as_experimental_parameters_expressions");
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    public static dd getKeepSolsInMemoryCheck(final PropFeature propFeature) {
        di di2 = new di(new String[0], new String[0]){

            public String[] describeValid() {
                if (OptUtil.hasOptStudy(propFeature) != null) {
                    return new String[]{"Only_last", "All", "Opt"};
                }
                return new String[]{"Only_last", "All"};
            }

            public String[] getDescriptions() {
                return this.describeValid();
            }

            public String[] getAllowedValues() {
                if (OptUtil.hasOptStudy(propFeature) != null) {
                    return new String[]{"last", "all", "opt"};
                }
                return new String[]{"last", "all"};
            }
        };
        return di2;
    }

    public static StudyFeature hasOptStudy(PropFeature propFeature) {
        StudyFeatureList studyFeatureList;
        if (propFeature != null && propFeature instanceof StudyFeature && (studyFeatureList = (StudyFeatureList)propFeature.getContainer()) != null) {
            for (Object e2 : studyFeatureList) {
                if (!StudyFeatureID.isOptimizationID(((StudyFeature)e2).getOperationID()) || !((StudyFeature)e2).isActive()) continue;
                return (StudyFeature)e2;
            }
        }
        return null;
    }

    public static dd getKeepsolCheck(PropFeature propFeature) {
        di di2 = new di(new String[0], new String[0]){

            public String[] describeValid() {
                return new String[]{"Automatic", "Only_last", "All"};
            }

            public String[] getDescriptions() {
                return this.describeValid();
            }

            public String[] getAllowedValues() {
                return new String[]{"auto", "last", "all"};
            }
        };
        return di2;
    }

    public static String getSharedQuantityName(PhysicsFeature physicsFeature, String string, String string2) {
        String string3 = physicsFeature.getString(string2);
        if (string3.isEmpty()) {
            string3 = physicsFeature.tag();
            while (physicsFeature.getContainer().getContainer() instanceof PhysicsFeature) {
                physicsFeature = (PhysicsFeature)physicsFeature.getContainer().getContainer();
                string3 = String.valueOf(physicsFeature.tag()) + "." + string3;
            }
            string3 = String.valueOf(physicsFeature.scopeDot()) + string3;
            physicsFeature.set(string2, string3);
        } else if (string3.equals("$pre52")) {
            string3 = string;
            physicsFeature.set(string2, string3);
        }
        return string3;
    }
}

