/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.geommesh.mesh;

import com.comsol.geommesh.mesh.MeshOperation;
import com.comsol.geommesh.mesh.MeshOperationID;
import com.comsol.geommesh.mesh.f;
import com.comsol.geommesh.mesh.h;
import com.comsol.model.dbimodel.MeshFeature;
import com.comsol.model.dbimodel.MeshFeatureList;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.IOperation;
import com.comsol.model.operations.IOperationProvider;
import com.comsol.model.operations.OperationType;

public class MeshOperationProvider
implements IOperationProvider {
    public String[] getAllowedSequenceOperations(OperationType operationType, ModelEntityList<?> modelEntityList) {
        if (operationType == OperationType.MESHDATA) {
            return new String[]{"Enrich"};
        }
        if (operationType != OperationType.MESH) {
            return null;
        }
        if (modelEntityList == null) {
            throw new RuntimeException("Bad parameters for getting allowed operations");
        }
        int n2 = ((MeshSequence)modelEntityList.getContainer()).getSDim();
        boolean bl2 = ((MeshSequence)modelEntityList.getContainer()).isGeneratingSequence();
        return MeshOperationID.a(n2, bl2);
    }

    public static String[] getGUIOperations(MeshSequence meshSequence, MeshFeature meshFeature) {
        if (meshSequence.isLockedMesh()) {
            return new String[0];
        }
        int n2 = meshSequence.getSDim();
        boolean bl2 = meshSequence.isGeneratingSequence();
        boolean bl3 = MeshOperationProvider.hasImportFeature(meshSequence, meshFeature == null ? "" : meshFeature.tag());
        return MeshOperationID.a(n2, bl2, bl3);
    }

    public static MeshOperationID.ID getOperationID(String string) {
        MeshOperationID.ID[] iDArray = MeshOperationID.ID.values();
        int n2 = iDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MeshOperationID.ID iD = iDArray[n3];
            if (iD.a(string)) {
                return iD;
            }
            ++n3;
        }
        return null;
    }

    public IOperation create(OperationType operationType, String string) {
        if (operationType.equals((Object)OperationType.MESHDATA)) {
            return new f(string);
        }
        if (operationType.equals((Object)OperationType.MESHEXPORT)) {
            return new h(string);
        }
        if (!operationType.equals((Object)OperationType.MESH)) {
            return null;
        }
        return MeshOperationID.a(string);
    }

    public static boolean hasImportFeature(MeshSequence meshSequence, String string) {
        MeshFeatureList meshFeatureList = meshSequence.feature();
        if (meshFeatureList.size() == 0 && !meshSequence.getGeom().allowsMeshImportSequence()) {
            return false;
        }
        for (PropFeature propFeature : meshFeatureList) {
            MeshOperation meshOperation = (MeshOperation)propFeature.getOperation();
            String string2 = meshOperation.getID();
            if (!MeshOperationID.ID.a.a(string2) && !MeshOperationID.ID.h.a(string2)) continue;
            return true;
        }
        return false;
    }
}

