/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.nativejni.util;

import com.comsol.nativejni.CPointer;
import com.comsol.nativejni.FlNativeException;
import com.comsol.nativejni.FlNativeObject;
import com.comsol.nativejni.util.MatrixExch;
import com.comsol.nativejni.util.Prop;
import com.comsol.util.exceptions.FlException;

public class VMatrixExch
extends FlNativeObject {
    public VMatrixExch(int n, int n2) throws FlNativeException {
        this.initWSLen(this.getCPointer(), n, n2);
    }

    public VMatrixExch(Prop prop, String string) throws FlNativeException {
        CPointer cPointer = prop.getCPointer();
        this.initWSProp(this.getCPointer(), cPointer, string);
    }

    public void toProp(Prop prop, String string) throws FlNativeException {
        this.toProp(this.getCPointer(), prop.getCPointer(), string);
    }

    public int getLen() throws FlNativeException {
        return this.getLen(this.getCPointer());
    }

    public boolean isReal(int n) throws FlNativeException {
        return this.isReal(this.getCPointer(), n);
    }

    public int[] getDim(int n) throws FlNativeException {
        return this.getDim(this.getCPointer(), n);
    }

    public double[] getVal(int n) throws FlNativeException {
        int n2 = this.a(n);
        double[] dArray = new double[n2];
        this.getVal(this.getCPointer(), dArray, n);
        return dArray;
    }

    public double[] getValBlock(int n, int n2, int n3) throws FlNativeException {
        if (n2 < 1) {
            throw new FlException("Start_index_must_be_greater_than_0");
        }
        if (n3 < 1) {
            throw new FlException("Stop_index_must_be_greater_than_0");
        }
        if (n3 < n2) {
            throw new FlException("Stop_index_must_be_greater_than_or_equal_to_start_index");
        }
        int n4 = this.a(n, n2, n3);
        double[] dArray = new double[n4];
        if (!this.isReal(n)) {
            n2 = n2 * 2 - 1;
        }
        this.getValBlock(this.getCPointer(), dArray, n, n2);
        return dArray;
    }

    public void setDim(int[] nArray, boolean bl, int n) throws FlNativeException {
        this.setDim(this.getCPointer(), nArray, bl, n);
    }

    public void setVal(double[] dArray, int n) throws FlNativeException {
        this.setVal(this.getCPointer(), dArray, n);
    }

    public void setVal(MatrixExch matrixExch, int n) {
        int[] nArray = matrixExch.getDim();
        int n2 = 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            n2 *= nArray[n3];
            ++n3;
        }
        if (!matrixExch.isReal()) {
            n2 *= 2;
        }
        this.setVal(this.getCPointer(), matrixExch.getCPointer(), n, n2);
    }

    public double getAdr(int n) throws FlNativeException {
        return this.getAdr(this.getCPointer(), n);
    }

    private int a(int n) throws FlNativeException {
        int[] nArray = this.getDim(n);
        int n2 = 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            n2 *= nArray[n3];
            ++n3;
        }
        if (!this.isReal(n)) {
            n2 *= 2;
        }
        return n2;
    }

    private int a(int n, int n2, int n3) throws FlNativeException {
        int[] nArray = this.getDim(n);
        int n4 = 1;
        if (nArray.length > 0) {
            int n5 = nArray[0] >= n3 ? n3 : nArray[0];
            int n6 = nArray[0] >= n2 ? n2 : nArray[0] + 1;
            n4 = n5 - n6 + 1;
            int n7 = 1;
            while (n7 < nArray.length) {
                n4 *= nArray[n7];
                ++n7;
            }
            if (!this.isReal(n)) {
                n4 *= 2;
            }
        }
        return n4;
    }

    public double[][][] getVMatrix() throws FlNativeException {
        int n = this.getLen();
        double[][][] dArrayArray = new double[n][][];
        int n2 = 0;
        while (n2 < n) {
            double[] dArray = this.getVal(n2);
            int n3 = dArray.length;
            if (this.isReal(n2)) {
                dArrayArray[n2] = new double[1][n3];
                dArrayArray[n2][0] = dArray;
            } else {
                dArrayArray[n2] = new double[2][n3 / 2];
                int n4 = 0;
                int n5 = 0;
                while (n5 < n3 / 2) {
                    dArrayArray[n2][0][n5] = dArray[n4];
                    dArrayArray[n2][1][n5] = dArray[n4 + 1];
                    ++n5;
                    n4 += 2;
                }
            }
            ++n2;
        }
        return dArrayArray;
    }

    @Override
    protected void doCleanup(CPointer cPointer) throws FlNativeException {
        this.cleanupWS(cPointer);
    }

    private native void initWSLen(CPointer var1, int var2, int var3) throws FlNativeException;

    private native void initWSProp(CPointer var1, CPointer var2, String var3) throws FlNativeException;

    private native void toProp(CPointer var1, CPointer var2, String var3) throws FlNativeException;

    private native int getLen(CPointer var1) throws FlNativeException;

    private native boolean isReal(CPointer var1, int var2) throws FlNativeException;

    private native int[] getDim(CPointer var1, int var2) throws FlNativeException;

    private native void getVal(CPointer var1, double[] var2, int var3) throws FlNativeException;

    private native void getValBlock(CPointer var1, double[] var2, int var3, int var4) throws FlNativeException;

    private native void setDim(CPointer var1, int[] var2, boolean var3, int var4) throws FlNativeException;

    private native void setVal(CPointer var1, double[] var2, int var3) throws FlNativeException;

    private native void setVal(CPointer var1, CPointer var2, int var3, int var4);

    private native double getAdr(CPointer var1, int var2) throws FlNativeException;

    private native void cleanupWS(CPointer var1) throws FlNativeException;
}

