/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.geommesh.geom;

import com.comsol.geommesh.geom.GeomConstraint;
import com.comsol.geommesh.geom.d;
import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.dbimodel.SketchSnapshotData;
import com.comsol.model.operations.FeatureGroupInfo;
import com.comsol.model.operations.IGeomOperation;
import com.comsol.model.operations.SelectionProperty;
import com.comsol.model.selections.GeomObjectSelectionFilter;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.nativemph.geom.CGHandler;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.nativeutil.properties.BooleanProp;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.UnitCheck;
import com.comsol.nativeutil.properties.ag;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.util.interfaces.w;
import com.comsol.util.methods.FlNumberUtil;
import java.util.ArrayList;
import java.util.List;

public class CGAngle
extends GeomConstraint {
    public CGAngle(String string) {
        super(string);
    }

    @Override
    public de createPropSet(IGeomOperation.SequenceInfo sequenceInfo) {
        de de2 = super.createPropSet(sequenceInfo);
        GeomObjectSelectionFilter geomObjectSelectionFilter = new GeomObjectSelectionFilter(this.d, new int[]{1}, false);
        geomObjectSelectionFilter.setSingleSelection(true);
        SelectionProperty selectionProperty = new SelectionProperty("edge1", "First_edge", (ISelectionFilter)geomObjectSelectionFilter);
        selectionProperty.annotate().ad().bc();
        de2.registerProp((Property)selectionProperty);
        BooleanProp booleanProp = new BooleanProp("reverse1", "Reverse_direction", false);
        de2.registerProp((Property)booleanProp);
        geomObjectSelectionFilter = new GeomObjectSelectionFilter(this.d, new int[]{1}, false);
        geomObjectSelectionFilter.setSingleSelection(true);
        selectionProperty = new SelectionProperty("edge2", "Second_edge", (ISelectionFilter)geomObjectSelectionFilter);
        selectionProperty.annotate().bc();
        de2.registerProp((Property)selectionProperty);
        BooleanProp booleanProp2 = new BooleanProp("reverse2", "Reverse_direction", false);
        de2.registerProp((Property)booleanProp2);
        UnitCheck unitCheck = new UnitCheck(PhysicalQuantityID.PLANEANGLE.dimension(), PhysicalQuantityID.PLANEANGLE.fieldName(), sequenceInfo.uAngleConv, (w)this.e);
        selectionProperty = new ag("angle", "Angle", 0.0, (dd)unitCheck);
        selectionProperty.annotate().bc();
        de2.registerProp((Property)selectionProperty);
        selectionProperty = this.a(sequenceInfo, "helppoint1", "First_help_point");
        de2.registerProp((Property)selectionProperty);
        selectionProperty = this.a(sequenceInfo, "helppoint2", "Second_help_point");
        de2.registerProp((Property)selectionProperty);
        selectionProperty = new ag("arrowradius", "Arrow radius", Double.NaN);
        selectionProperty.annotate().r().at();
        de2.registerProp((Property)selectionProperty);
        selectionProperty = new ag("labelpos", "Relative label position", 0.5);
        selectionProperty.annotate().r().at();
        de2.registerProp((Property)selectionProperty);
        selectionProperty = new BooleanProp("arrowint", "Internal or external arrow", true);
        selectionProperty.annotate().r().at();
        de2.registerProp((Property)selectionProperty);
        return de2;
    }

    @Override
    public List<FeatureGroupInfo> getGUIGroupInfoList() {
        ArrayList<FeatureGroupInfo> arrayList = new ArrayList<FeatureGroupInfo>(1);
        arrayList.add(new FeatureGroupInfo("First_ray", true, true, new String[]{"edge1", "reverse1"}));
        arrayList.add(new FeatureGroupInfo("Second_ray", true, true, new String[]{"edge2", "reverse2"}));
        arrayList.add(new FeatureGroupInfo("Dimension_value", true, true, new String[]{"angle"}));
        arrayList.add(new FeatureGroupInfo("Help_points", false, true, new String[]{"helppoint1", "helppoint2"}));
        return arrayList;
    }

    @Override
    protected boolean U_() {
        return true;
    }

    @Override
    public String[] getInputPropNames() {
        return new String[]{"edge1", "edge2"};
    }

    @Override
    public void prepareSetCGHandlerProperties(CGHandler cGHandler) {
        this.e.selection("edge1");
        this.e.selection("edge2");
    }

    @Override
    public void collectSnapshotData(SketchSnapshotData sketchSnapshotData) {
        sketchSnapshotData.set("edge1", this.b("edge1"));
        sketchSnapshotData.set("edge2", this.b("edge2"));
        sketchSnapshotData.set("reverse1", this.e.getBoolean("reverse1") ? 1 : 0);
        sketchSnapshotData.set("reverse2", this.e.getBoolean("reverse2") ? 1 : 0);
        sketchSnapshotData.set("angle", this.d.getRadians(this.e.getDouble("angle")));
        sketchSnapshotData.set("helppoint", this.a(new String[]{"helppoint1", "helppoint2"}));
        sketchSnapshotData.set("arrowradius", this.e.getDouble("arrowradius"));
        sketchSnapshotData.set("labelpos", this.e.getDouble("labelpos"));
        sketchSnapshotData.set("arrowint", this.e.getBoolean("arrowint") ? 1 : 0);
        sketchSnapshotData.set("text", this.g());
    }

    public static void setCGHandlerProperties(CGHandler cGHandler, SketchSnapshotData sketchSnapshotData, boolean bl2) {
        com.comsol.nativeutil.w w2 = new com.comsol.nativeutil.w();
        w2.c("edge1", sketchSnapshotData.getIntMatrix("edge1"));
        w2.c("edge2", sketchSnapshotData.getIntMatrix("edge2"));
        w2.e("reverse1", sketchSnapshotData.getInt("reverse1"));
        w2.e("reverse2", sketchSnapshotData.getInt("reverse2"));
        w2.c("angle", sketchSnapshotData.getDouble("angle"));
        w2.c("helppoint", sketchSnapshotData.getDoubleMatrix("helppoint"));
        cGHandler.a(sketchSnapshotData.getId(), w2, sketchSnapshotData.getParentId());
    }

    @Override
    public void updateFromCGHandler(CGHandler cGHandler, boolean bl2, boolean bl3, SketchSnapshotData sketchSnapshotData) {
        com.comsol.nativeutil.w w2 = new com.comsol.nativeutil.w();
        cGHandler.b(this.e.getId(), w2, this.getCGHParent());
        this.a(w2, "edge1", bl3, sketchSnapshotData);
        this.a(w2, "edge2", bl3, sketchSnapshotData);
        if (bl2) {
            if (bl3) {
                com.comsol.geommesh.geom.d.a(this.e, "reverse1", w2.x("reverse1") != 0, sketchSnapshotData);
                com.comsol.geommesh.geom.d.a(this.e, "reverse2", w2.x("reverse2") != 0, sketchSnapshotData);
                double d2 = this.d.getRadians(1.0);
                com.comsol.geommesh.geom.d.b(this.e, "angle", w2.y("angle") / d2, sketchSnapshotData, 1.0);
            } else {
                this.a(w2);
            }
            this.a(w2, sketchSnapshotData, "helppoint1", "helppoint2");
        }
    }

    @Override
    public void updateSnapshotSelectionsFromCGHandler(CGHandler cGHandler, SketchSnapshotData sketchSnapshotData) {
        com.comsol.nativeutil.w w2 = new com.comsol.nativeutil.w();
        cGHandler.b(this.e.getId(), w2, this.getCGHParent());
        CGAngle.updateSnapshotSelection(w2, "edge1", sketchSnapshotData);
        CGAngle.updateSnapshotSelection(w2, "edge2", sketchSnapshotData);
    }

    private String g() {
        int n2 = Preferences.getInstance().getIntegerPreference("general.precision.output");
        String string = this.e.getString("angle");
        try {
            double d2 = Double.parseDouble(string);
            string = FlNumberUtil.b((double)d2, (int)n2, (double)1.0E-50);
            if (this.d.getAngularUnit().equals("deg")) {
                string = String.valueOf(string) + "[deg]";
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return string;
    }

    public static void setCGHandlerSymbolProperties(CGHandler cGHandler, SketchSnapshotData sketchSnapshotData, boolean bl2) {
        com.comsol.nativeutil.w w2 = new com.comsol.nativeutil.w();
        w2.c("arrowradius", sketchSnapshotData.getDouble("arrowradius"));
        w2.c("labelpos", sketchSnapshotData.getDouble("labelpos"));
        w2.d("arrowint", sketchSnapshotData.getInt("arrowint"));
        w2.d("text", sketchSnapshotData.getString("text"));
        cGHandler.a(sketchSnapshotData.getId(), w2, bl2);
    }

    @Override
    public void updateSymbolPropertiesFromCGHandler(CGHandler cGHandler, SketchSnapshotData sketchSnapshotData) {
        com.comsol.nativeutil.w w2 = new com.comsol.nativeutil.w();
        if (cGHandler.a(this.e.getId(), w2)) {
            double d2 = w2.y("arrowradius");
            com.comsol.geommesh.geom.d.b(this.e, "arrowradius", d2, sketchSnapshotData, d2);
            com.comsol.geommesh.geom.d.b(this.e, "labelpos", w2.y("labelpos"), sketchSnapshotData, 1.0);
            com.comsol.geommesh.geom.d.a(this.e, "arrowint", w2.x("arrowint") != 0, sketchSnapshotData);
        }
    }

    @Override
    public boolean hasEditableDimensionSymbol() {
        return true;
    }

    @Override
    public String getEditableDimensionInputPropName() {
        return "angle";
    }

    @Override
    public void adjustAfterEdgeReversal(String string) {
        if ("edge1".equals(string)) {
            this.e.set("reverse1", !this.e.getBoolean("reverse1"));
        } else if ("edge2".equals(string)) {
            this.e.set("reverse2", !this.e.getBoolean("reverse2"));
        } else assert (false);
    }
}

