/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.geommesh.geom;

import com.comsol.geommesh.geom.GeomPrimFeature;
import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.dbimodel.GeomFeatureList;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.IGeomOperation;
import com.comsol.nativemph.geom.Geom;
import com.comsol.nativemph.geom.Geom3;
import com.comsol.nativeutil.properties.BooleanProp;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.UnitCheck;
import com.comsol.nativeutil.properties.ab;
import com.comsol.nativeutil.properties.ag;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.di;
import com.comsol.nativeutil.properties.ds;
import com.comsol.nativeutil.properties.p;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.w;
import java.util.List;

public class PrimHelix
extends GeomPrimFeature {
    public PrimHelix(String string) {
        super(string);
    }

    @Override
    public void postCreateInit() {
        super.postCreateInit();
        this.d.geomManagerNative().getNewID();
    }

    @Override
    public de createPropSet(IGeomOperation.SequenceInfo sequenceInfo) {
        de de2 = super.createPropSet(sequenceInfo);
        de2.setCurrentGroupDescription("Size_and_shape");
        ab ab2 = new ab(0.0, true, Double.POSITIVE_INFINITY, true);
        ab ab3 = new ab(0.0, false, Double.POSITIVE_INFINITY, true);
        UnitCheck unitCheck = new UnitCheck(PhysicalQuantityID.LENGTH.dimension(), sequenceInfo.uConv, (w)this.e);
        p p2 = new p();
        p2.add((dd)ab2);
        p2.add((dd)unitCheck);
        p p3 = new p();
        p3.add((dd)ab3);
        p3.add((dd)unitCheck);
        ab ab4 = new ab(Double.NEGATIVE_INFINITY, true, Double.POSITIVE_INFINITY, true);
        p p4 = new p();
        p4.add((dd)ab4);
        p4.add((dd)unitCheck);
        p p5 = new p();
        p5.add((dd)ab2);
        p5.add((dd)new UnitCheck(sequenceInfo.uConv, (w)this.e));
        ag ag2 = new ag("turns", "Number_of_turns", 3.0, (dd)p5);
        ag2.annotate().bc();
        de2.registerProp((Property)ag2);
        ag2 = new ag("rmaj", "Major_radius", 1.0, (dd)p2);
        ag2.annotate().bc();
        de2.registerProp((Property)ag2);
        ag2 = new ag("rmin", "Minor_radius", 0.1, (dd)p3);
        ag2.annotate().bc();
        de2.registerProp((Property)ag2);
        ag2 = new ag("axialpitch", "Axial_pitch", 0.3, (dd)p3);
        ag2.annotate().bc();
        de2.registerProp((Property)ag2);
        ag2 = new ag("radialpitch", "Radial_pitch", 0.0, (dd)p4);
        ag2.annotate().bc();
        de2.registerProp((Property)ag2);
        ag2 = new ds("chirality", "Chirality", "right", (dd)new di(new String[]{"right", "left"}, new String[]{"Right_handed", "Left_handed"}));
        ag2.annotate().bc();
        de2.registerProp((Property)ag2);
        de2.registerProp((Property)new ds("endcaps", "End_caps", "paraaxis", (dd)new di(new String[]{"paraaxis", "perpaxis", "perpspine"}, new String[]{"Parallel_to_axis", "Perpendicular_to_axis", "Perpendicular_to_spine"})));
        de2.registerProp((Property)new BooleanProp("twistcomp", "Twist_compensation", true));
        de2.registerProp((Property)new ds("grep", "Geometry_representation", "spline", (dd)new di(new String[]{"bezier", "spline"}, new String[]{"Bezier", "Spline[curve]"})));
        de2.registerProp((Property)new ag("rtol", "Relative_tolerance", 1.0E-4, (dd)p5));
        return de2;
    }

    @Override
    public Geom doExecutePrimitive() {
        if (this.e.getDouble("axialpitch") == 0.0 && this.e.getDouble("radialpitch") == 0.0 && this.e.getDouble("turns") > 0.99999999999999) {
            throw new FlException("Self-intersecting_object");
        }
        com.comsol.nativeutil.w w2 = new com.comsol.nativeutil.w();
        w2.a("pos", this.e.getDoubleArray("pos"));
        w2.a("axis", PrimHelix.a(this.e));
        w2.a("rot", PrimHelix.b(this.e));
        w2.c("coordsys", PrimHelix.getInputWorkPlaneTransformation((PropFeature)this.e, "workplanesrc", "workplane"));
        w2.c("turns", this.e.getDouble("turns"));
        w2.c("rmaj", this.e.getDouble("rmaj"));
        w2.c("rmin", this.e.getDouble("rmin"));
        w2.c("axialpitch", this.e.getDouble("axialpitch"));
        w2.c("radialpitch", this.e.getDouble("radialpitch"));
        w2.f("chirality", this.e.getString("chirality"));
        w2.f("endcaps", this.e.getString("endcaps"));
        w2.f("twistcomp", this.e.getString("twistcomp"));
        w2.f("grep", this.e.getString("grep"));
        w2.c("rtol", this.e.getDouble("rtol"));
        int n2 = GeomPrimFeature.TYPE.a(this.e.getString("type"), this.d.getSDim());
        return Geom3.d((int)n2, (com.comsol.nativeutil.w)w2);
    }

    @Override
    public int[][] createOutputAssoc(Geom[] geomArray, int[][] nArray, List<GeomFeatureList> list) {
        Geom[] geomArray2 = new Geom[]{Geom3.a((double)this.e.getDouble("rmin"))};
        int n2 = this.e.getId();
        int[] nArray2 = geomArray2[0].x();
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray2.length) {
            n3 = 100 * n3 + nArray2[n4];
            ++n4;
        }
        int[][] nArrayArray = new int[][]{{n2 + 1, n3}};
        this.a(geomArray2, nArrayArray, new int[0][], 0, list);
        int[][] nArray3 = this.a(geomArray, (int[][])nArrayArray, list, false);
        return nArray3;
    }
}

