/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.geommesh.geom;

import com.comsol.geommesh.geom.GeomPrimAnalytic;
import com.comsol.geommesh.geom.GeomPrimFeature;
import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.dbimodel.FEATURE_STATUS;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.IGeomOperation;
import com.comsol.model.util.DoublePropExpressionInfo;
import com.comsol.nativemph.geom.Geom;
import com.comsol.nativemph.geom.Geom2;
import com.comsol.nativemph.geom.Geom3;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.nativeutil.properties.BooleanProp;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.UnitCheck;
import com.comsol.nativeutil.properties.ac;
import com.comsol.nativeutil.properties.ag;
import com.comsol.nativeutil.properties.ao;
import com.comsol.nativeutil.properties.aw;
import com.comsol.nativeutil.properties.bs;
import com.comsol.nativeutil.properties.ch;
import com.comsol.nativeutil.properties.cj;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.ds;
import com.comsol.nativeutil.properties.p;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.interfaces.w;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;

public class PrimParametricCurve
extends GeomPrimAnalytic {
    public PrimParametricCurve(String string) {
        super(string);
    }

    @Override
    protected GeomPrimFeature.TYPE a(int n2) {
        return GeomPrimFeature.TYPE.c;
    }

    @Override
    public de createPropSet(IGeomOperation.SequenceInfo sequenceInfo) {
        String[] stringArray;
        de de2 = super.createPropSet(sequenceInfo);
        de2.setCurrentGroupDescription("Parameter");
        ac ac2 = new ac(0.0);
        Object object = new ds("parname", "Name", "s");
        object.addSideEffect(property -> this.e.getPropValueInternal("coord").internalReEvaluate());
        object.annotate().bc();
        de2.registerProp((Property)object);
        object = new ag("parmin", "Minimum", 0.0);
        object.annotate().bc();
        de2.registerProp((Property)object);
        object = new ag("parmax", "Maximum", 1.0);
        object.annotate().bc();
        de2.registerProp((Property)object);
        ao ao2 = new ao(sequenceInfo.sdim, (PropAnnotationInfo.af)this.getDynamicCoordNames());
        ao2.setAllowedValuesDependProps(new String[]{"workplanesrc", "workplane"});
        UnitCheck unitCheck = new UnitCheck(PhysicalQuantityID.LENGTH.dimension(), sequenceInfo.uConv, (w)this.e);
        p p2 = new p();
        p2.add((dd)ao2);
        p2.add((dd)unitCheck);
        if (sequenceInfo.sdim == 3) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "";
            stringArray2[1] = "";
            stringArray = stringArray2;
            stringArray2[2] = "";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "";
            stringArray = stringArray3;
            stringArray3[1] = "";
        }
        String[] stringArray4 = stringArray;
        object = new aw("coord", "Expressions", stringArray4, (dd)p2){

            protected String[] c() {
                return new String[]{PrimParametricCurve.this.e.getString("parname")};
            }

            public void evaluate(bs bs2) {
                super.evaluate(bs2);
                if (PrimParametricCurve.this.e.isBuilt() && !PrimParametricCurve.this.e.isInitializing() && !PrimParametricCurve.this.e.getModel().isReinitializing() && !PrimParametricCurve.this.e.getModel().isClusterReinitializing()) {
                    PrimParametricCurve.this.e.setBuildStatusGen(FEATURE_STATUS.EDITED);
                    PrimParametricCurve.this.e.notifyPropertyChanged(null);
                }
            }
        };
        object.annotate().a((PropAnnotationInfo.p)new DoublePropExpressionInfo());
        de2.registerProp((Property)object);
        p2 = new p();
        p2.add((dd)ac2);
        p2.add((dd)new UnitCheck(sequenceInfo.uConv, (w)this.e));
        de2.registerProp((Property)new ag("rtol", "Relative_tolerance", 1.0E-6, (dd)p2));
        de2.registerProp((Property)new cj("maxknots", "Maximum_number_of_knots", 1000, (dd)new ch(2)));
        de2.registerProp((Property)new BooleanProp("reparameterize", "Reparameterize_using_arc_length", false));
        return de2;
    }

    @Override
    protected boolean g() {
        return false;
    }

    @Override
    public Geom doExecutePrimitive() {
        String string;
        int n2 = this.d.getSDim();
        String string2 = this.e.getString("parname");
        double d2 = this.e.getDouble("parmin");
        double d3 = this.e.getDouble("parmax");
        if (d3 <= d2) {
            FlException flException = new FlException("Parameter_minimum_must_be_less_than_parameter_maximum");
            throw flException;
        }
        String[] stringArray = this.e.getStringArray("coord");
        double d4 = this.e.getDouble("rtol");
        int n3 = this.e.getInt("maxknots");
        boolean bl2 = this.e.getBoolean("reparameterize");
        int n4 = 3;
        GeomSequence geomSequence = this.d.getMainGeometryOrSubsequence();
        double[][][] dArray = geomSequence.createSplineApproximation(string2, d2, d3, stringArray, n4, d4, n3, this.C());
        double[] dArray2 = dArray[0][0];
        double[][] dArray3 = dArray[1];
        double d5 = dArray[0][1][0];
        if (d5 > d4) {
            string = "Maximum_relative_error_of_parametric_curve_representation_is_X#" + FlStringUtil.valueOf((double)d5);
            this.e.problem().create("warning1", "GeomWarning").set("message", string);
        }
        if (n2 == 3) {
            double[] dArray4 = this.e.getDoubleArray("pos");
            double[] dArray5 = PrimParametricCurve.a(this.e);
            double d6 = PrimParametricCurve.b(this.e);
            double[][] dArray6 = PrimParametricCurve.getInputWorkPlaneTransformation((PropFeature)this.e, "workplanesrc", "workplane");
            string = Geom3.a((int)n4, (double[])dArray2, (double[][])dArray3, (double[])dArray4, (double[])dArray5, (double)d6, (double[][])dArray6, (boolean)bl2);
        } else {
            double[] dArray7 = this.e.getDoubleArray("pos");
            double d7 = PrimParametricCurve.b(this.e);
            string = Geom2.a((int)n4, (double[])dArray2, (double[][])dArray3, (double[])dArray7, (double)d7, (boolean)bl2);
        }
        this.a((Geom)string);
        return string;
    }

    private void a(Geom geom) {
        double[] dArray = geom.b(false);
        double d2 = q.h((double[])dArray);
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < dArray.length - 1) {
            d3 = Math.max(d3, dArray[n2 + 1] - dArray[n2]);
            n2 += 2;
        }
        if (100.0 * Math.ulp(d2) > d3) {
            throw new FlException("Singular_edge_detected");
        }
    }

    @Override
    public int maxEDimFeatureSelections(IGeomOperation.SequenceInfo sequenceInfo) {
        return 1;
    }

    @Override
    public boolean scaleObjectsByTransformingProps(double[] dArray, boolean bl2, double[] dArray2, boolean bl3) {
        if (!bl2) {
            double d2 = PrimParametricCurve.b(this.e);
            double d3 = 1.0E-11;
            if (Math.abs(d2 - (double)Math.round(d2 / (Math.PI * 2)) * (Math.PI * 2)) > d3) {
                return false;
            }
        }
        if (!bl3) {
            int n2 = this.d.getSDim();
            String[] stringArray = this.e.getStringArray("coord");
            double[] dArray3 = new double[stringArray.length];
            int n3 = 0;
            while (n3 < stringArray.length) {
                dArray3[n3] = PrimParametricCurve.f(stringArray[n3]) ? ParseUtil.a((String)stringArray[n3], (IUnitConverter)this.g.getUnitConverter()) : Double.NaN;
                ++n3;
            }
            String[] stringArray2 = this.e.getStringArray("pos");
            double[] dArray4 = this.e.getDoubleArray("pos");
            int n4 = 0;
            while (n4 < n2) {
                stringArray[n4] = PrimParametricCurve.a(stringArray[n4], dArray3[n4], dArray[n4], 0.0);
                stringArray2[n4] = PrimParametricCurve.a(stringArray2[n4], dArray4[n4], dArray[n4], dArray2[n4] * (1.0 - dArray[n4]));
                ++n4;
            }
            this.e.set("coord", stringArray);
            this.e.set("pos", stringArray2);
        }
        return true;
    }

    @Override
    protected boolean e_(String string) {
        return true;
    }
}

