/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.analysis;

import com.comsol.model.analysis.AnalysisID;
import com.comsol.model.analysis.EquationForm;
import com.comsol.model.analysis.GeneralAnalysisID;
import com.comsol.model.analysis.SolverType;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.util.license.LicenseType;
import java.util.Locale;

public enum ComAnalysisID implements GeneralAnalysisID
{
    Stationary("Stationary", "stat"),
    Transient("Time_dependent", "time"),
    Eigenfrequency("Eigenfrequency", "eig"),
    Eigenvalue("Eigenvalue", "eigv"),
    Frequency("Frequency_domain", "freq");

    private String descr;
    private String shortName;

    static {
        ComAnalysisID[] comAnalysisIDArray = ComAnalysisID.values();
        int n2 = comAnalysisIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ComAnalysisID comAnalysisID = comAnalysisIDArray[n3];
            AnalysisID.idToOperationID.put(comAnalysisID.id(), comAnalysisID);
            ++n3;
        }
    }

    private ComAnalysisID(String string2, String string3) {
        this.descr = string2;
        this.shortName = string3;
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.name();
    }

    @Override
    public boolean isEquationForm() {
        return EquationForm.contains(this);
    }

    @Override
    public AnalysisID getStudyStep() {
        return this;
    }

    @Override
    public boolean isSpecialCaseOf(String string) {
        boolean bl2 = this.id().equals(string);
        if (bl2) {
            return true;
        }
        switch (this) {
            case Eigenfrequency: {
                return Eigenvalue.id().equals(string);
            }
            case Eigenvalue: {
                return Eigenfrequency.id().equals(string);
            }
        }
        return false;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String getIcon() {
        return "study_" + this.descr().toLowerCase(Locale.ENGLISH) + ".png";
    }

    @Override
    public LicenseType[][] getLicenseRequirements() {
        return new LicenseType[][]{new LicenseType[0]};
    }

    @Override
    public SolverType getSolverType() {
        switch (this) {
            case Eigenfrequency: {
                return SolverType.Eigenvalue;
            }
        }
        return SolverType.valueOf(this.id());
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature != null && this.id().equals(propFeature.getOperationID());
    }

    @Override
    public boolean isOfType(String string) {
        return this.id().equals(string);
    }
}

