/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.analysis;

import com.comsol.model.analysis.AnalysisID;
import com.comsol.model.analysis.ComAnalysisID;
import com.comsol.model.analysis.GeneralAnalysisID;
import com.comsol.model.analysis.SolverType;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.util.license.LicenseType;
import java.util.Locale;

public enum SpecialAnalysisID implements GeneralAnalysisID
{
    TimeDiscrete("Time_discrete", "discr"),
    Transientmodal("Time_dependent_modal", "timod"),
    Transientmodalreduction("Modal_reduced_model", "timodred"),
    Frequencymodal("Frequency_domain_modal", "frmod"),
    Frequencylinearized("Frequency_domain,_linearized", "frlin"),
    StationaryPlugflow("Stationary_plugflow", "spf"),
    RayTracing("Ray_tracing", "rtrac"),
    BidirectionallyCoupledParticleTracing("Bidirectionally_coupled_particle_tracing", "bcpt"),
    BidirectionallyCoupledRayTracing("Bidirectionally_coupled_ray_tracing", "bcrt"),
    SchrodingerPoisson("Schrodinger_poisson", "sdpo"),
    TimeDependentFixedGeometry("Time_dependent,_Fixed_geometry", "tdfg"),
    MeanEnergies("Mean_energies", "ebar"),
    ReducedElectricFields("Reduced_electric_fields", "ref"),
    EEDFInitialization("EEDF_initialization", "edfi"),
    TimePeriodic("Time_periodic", "tper"),
    TimePeriodicToTimeDependent("Time_periodic_to_time_dependent", "tptd"),
    CyclicVoltammetry("Cyclic_voltammetry", "cyclv"),
    Fatigue("Fatigue", "ftge"),
    TimeToFreqFFT("Time_to_frequency_FFT", "tffft"),
    FreqToTimeFFT("Frequency_to_time_FFT", "ftfft"),
    Wavelength("Wavelength_domain", "wave"),
    FrequencyAdaptive("Adaptive_frequency_sweep", "frawe"),
    TEMBoundaryModeAnalysis("TEM_boundary_mode_analysis", "tbma");

    private static final String[] a;
    private String descr;
    private String shortName;

    static {
        a = new String[]{BidirectionallyCoupledParticleTracing.id(), BidirectionallyCoupledRayTracing.id()};
        SpecialAnalysisID[] specialAnalysisIDArray = SpecialAnalysisID.values();
        int n2 = specialAnalysisIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            SpecialAnalysisID specialAnalysisID = specialAnalysisIDArray[n3];
            AnalysisID.idToOperationID.put(specialAnalysisID.id(), specialAnalysisID);
            ++n3;
        }
    }

    private SpecialAnalysisID(String string2, String string3) {
        this.descr = string2;
        this.shortName = string3;
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.name();
    }

    @Override
    public boolean isEquationForm() {
        return false;
    }

    @Override
    public AnalysisID getStudyStep() {
        return this;
    }

    @Override
    public boolean isSpecialCaseOf(String string) {
        boolean bl2 = this.id().equals(string);
        if (bl2) {
            return true;
        }
        switch (this) {
            case TimeDiscrete: 
            case Transientmodal: 
            case Transientmodalreduction: 
            case StationaryPlugflow: 
            case RayTracing: 
            case TimeDependentFixedGeometry: 
            case TimePeriodicToTimeDependent: 
            case CyclicVoltammetry: {
                return ComAnalysisID.Transient.id().equals(string);
            }
            case Frequencymodal: 
            case Frequencylinearized: 
            case MeanEnergies: 
            case ReducedElectricFields: 
            case Wavelength: 
            case FrequencyAdaptive: 
            case TEMBoundaryModeAnalysis: {
                return ComAnalysisID.Frequency.id().equals(string);
            }
            case BidirectionallyCoupledParticleTracing: 
            case BidirectionallyCoupledRayTracing: 
            case EEDFInitialization: 
            case TimePeriodic: 
            case Fatigue: {
                return ComAnalysisID.Stationary.id().equals(string);
            }
            case TimeToFreqFFT: {
                return ComAnalysisID.Frequency.id().equals(string);
            }
            case FreqToTimeFFT: {
                return ComAnalysisID.Transient.id().equals(string);
            }
            case SchrodingerPoisson: {
                return ComAnalysisID.Eigenfrequency.id().equals(string);
            }
        }
        return false;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String getIcon() {
        return "study_" + this.descr().toLowerCase(Locale.ENGLISH) + ".png";
    }

    @Override
    public LicenseType[][] getLicenseRequirements() {
        switch (this) {
            case Transientmodal: 
            case Transientmodalreduction: 
            case Frequencymodal: {
                return new LicenseType[][]{{LicenseType.MEMS, LicenseType.STRUCTURALMECHANICS, LicenseType.ACOUSTICS, LicenseType.MULTIBODYDYNAMICS, LicenseType.RF, LicenseType.WAVEOPTICS}};
            }
            case StationaryPlugflow: {
                return new LicenseType[][]{{LicenseType.CHEM}};
            }
            case RayTracing: {
                return new LicenseType[][]{{LicenseType.RAYOPTICS, LicenseType.ACOUSTICS}};
            }
            case BidirectionallyCoupledParticleTracing: {
                return new LicenseType[][]{{LicenseType.PARTICLETRACING}};
            }
            case SchrodingerPoisson: {
                return new LicenseType[][]{{LicenseType.SEMICONDUCTOR}};
            }
            case BidirectionallyCoupledRayTracing: {
                return new LicenseType[][]{{LicenseType.RAYOPTICS}};
            }
            case TimeDependentFixedGeometry: {
                return new LicenseType[][]{{LicenseType.BATTERIESANDFUELCELLS, LicenseType.ELECTRODEPOSITION, LicenseType.CORROSION}};
            }
            case CyclicVoltammetry: {
                return new LicenseType[][]{{LicenseType.BATTERIESANDFUELCELLS, LicenseType.ELECTRODEPOSITION, LicenseType.CORROSION, LicenseType.ELECTROCHEMISTRY}};
            }
            case MeanEnergies: 
            case ReducedElectricFields: 
            case EEDFInitialization: 
            case TimePeriodic: 
            case TimePeriodicToTimeDependent: {
                return new LicenseType[][]{{LicenseType.PLASMA}};
            }
            case Wavelength: {
                return new LicenseType[][]{{LicenseType.WAVEOPTICS}};
            }
            case FrequencyAdaptive: {
                return new LicenseType[][]{{LicenseType.MEMS, LicenseType.RF, LicenseType.WAVEOPTICS}};
            }
            case TEMBoundaryModeAnalysis: {
                return new LicenseType[][]{{LicenseType.RF}};
            }
            case Fatigue: {
                return new LicenseType[][]{{LicenseType.FATIGUE}};
            }
        }
        return new LicenseType[][]{new LicenseType[0]};
    }

    @Override
    public SolverType getSolverType() {
        switch (this) {
            case Transientmodal: 
            case Transientmodalreduction: 
            case Frequencymodal: {
                return SolverType.Modal;
            }
            case TimeToFreqFFT: 
            case FreqToTimeFFT: {
                return SolverType.FFT;
            }
            case Frequencylinearized: 
            case Wavelength: 
            case FrequencyAdaptive: 
            case TEMBoundaryModeAnalysis: {
                return SolverType.Frequency;
            }
            case TimeDiscrete: {
                return SolverType.Transient;
            }
            case StationaryPlugflow: {
                return SolverType.Transient;
            }
            case RayTracing: {
                return SolverType.Transient;
            }
            case BidirectionallyCoupledParticleTracing: {
                return SolverType.Transient;
            }
            case BidirectionallyCoupledRayTracing: {
                return SolverType.Transient;
            }
            case TimeDependentFixedGeometry: {
                return SolverType.Transient;
            }
            case CyclicVoltammetry: {
                return SolverType.Transient;
            }
            case MeanEnergies: {
                return SolverType.Frequency;
            }
            case ReducedElectricFields: {
                return SolverType.Frequency;
            }
            case EEDFInitialization: {
                return SolverType.Stationary;
            }
            case TimePeriodic: {
                return SolverType.Stationary;
            }
            case TimePeriodicToTimeDependent: {
                return SolverType.Transient;
            }
            case Fatigue: {
                return SolverType.Stationary;
            }
            case SchrodingerPoisson: {
                return SolverType.Eigenvalue;
            }
        }
        return SolverType.valueOf(this.id());
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature != null && this.id().equals(propFeature.getOperationID());
    }

    @Override
    public boolean isOfType(String string) {
        return this.id().equals(string);
    }

    public static boolean isBidirectionallyCoupledID(String string) {
        String[] stringArray = a;
        int n2 = a.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (string2.equals(string)) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

