/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.analysis;

import com.comsol.model.analysis.AnalysisID;
import com.comsol.model.analysis.ComAnalysisID;
import com.comsol.model.analysis.GeneralAnalysisID;
import com.comsol.model.analysis.SolverType;
import com.comsol.model.analysis.StudyReferenceAnalysisID;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.util.license.LicenseType;
import com.comsol.util.license.d;
import com.comsol.util.methods.q;
import java.util.Arrays;
import java.util.LinkedList;

public enum StudyFeatureID implements GeneralAnalysisID
{
    MultigridLevel("Multigrid_level", "mgl", "solver_multigrid.png"),
    Parametric("Parametric_sweep", "param", "study_parametric_sweep.png"),
    DesignofExperiments("Design_of_experiments", "designe", "study_design_of_experiments.png"),
    FunctionSweep("Function_sweep", "funsw", "definitions_function.png"),
    MaterialSweep("Material_sweep", "matsw", "material.png"),
    StudyReference("Study_reference", "ref", "study_studyreference.png"),
    CombineSolution("Combine_solutions", "cmbsol", "study_combinesolution.png"),
    Batch("Batch", "batch", "study_batch.png"),
    BatchSweep("Batch_sweep", "batsw", "study_batch_sweep.png"),
    BatchDesignofExperiments("Batch_design_of_experiments", "batde", "study_batch_design_of_experiments.png"),
    ClusterComputing("Cluster_computing", "cluco", "study_cluster_computing.png"),
    ClusterSweep("Cluster_sweep", "clusw", "study_cluster_sweep.png"),
    Optimization("Optimization", "opt", "study_optimization.png"),
    Sensitivity("Sensitivity", "sens", "study_sensitivity.png"),
    ParameterEstimation("Parameter_estimation", "est", "study_parameter_estimation.png"),
    ModelReduction("Model_reduction", "mr", "study_model_reduction.png");

    private String descr;
    private String shortName;
    private String icon;
    public static StudyFeatureID[] OPTIMIZATION_OPERATIONS_IDS;
    public static String[] SENSITIVITY_OPERATION_NAMES;
    public static String[] OPTIMIZATION_OPERATION_NAMES;
    public static StudyFeatureID[] SPECIAL_CONTROL_OPERATION_IDS;
    public static StudyFeatureID[] CONTROL_OPERATION_IDS;
    public static StudyFeatureID[] PARAMETRIC_OPERATION_IDS;
    public static AnalysisID[] NON_PHYSICS_OPERATION_IDS;
    public static StudyFeatureID[] STEP_TOOLBAR_OPERATIONS;
    public static StudyFeatureID[] BATCH_TOOLBAR_OPERATIONS;
    public static StudyFeatureID[] CLUSTER_TOOLBAR_OPERATIONS;
    private static /* synthetic */ int[] a;

    static {
        OPTIMIZATION_OPERATIONS_IDS = new StudyFeatureID[]{Optimization, ParameterEstimation};
        SENSITIVITY_OPERATION_NAMES = new String[]{Sensitivity.id()};
        OPTIMIZATION_OPERATION_NAMES = new String[]{Optimization.id(), ParameterEstimation.id()};
        SPECIAL_CONTROL_OPERATION_IDS = new StudyFeatureID[]{Batch, BatchSweep, BatchDesignofExperiments, ClusterComputing, ClusterSweep, ModelReduction, Sensitivity};
        CONTROL_OPERATION_IDS = new StudyFeatureID[]{Batch, BatchSweep, BatchDesignofExperiments, ClusterComputing, ClusterSweep, Parametric, DesignofExperiments, FunctionSweep, MaterialSweep, ModelReduction, Optimization, ParameterEstimation, Sensitivity};
        PARAMETRIC_OPERATION_IDS = new StudyFeatureID[]{Parametric, DesignofExperiments, FunctionSweep, MaterialSweep};
        NON_PHYSICS_OPERATION_IDS = new AnalysisID[]{Batch, BatchSweep, BatchDesignofExperiments, ClusterComputing, ClusterSweep, Parametric, DesignofExperiments, FunctionSweep, MaterialSweep, ModelReduction, Optimization, ParameterEstimation, Sensitivity, StudyReferenceAnalysisID.StudyReference};
        STEP_TOOLBAR_OPERATIONS = new StudyFeatureID[]{Parametric, FunctionSweep, MaterialSweep, CombineSolution, StudyReference, Optimization, ParameterEstimation, Sensitivity, ModelReduction};
        BATCH_TOOLBAR_OPERATIONS = new StudyFeatureID[]{Batch, BatchSweep};
        CLUSTER_TOOLBAR_OPERATIONS = new StudyFeatureID[]{ClusterComputing, ClusterSweep};
        StudyFeatureID[] studyFeatureIDArray = StudyFeatureID.values();
        int n2 = studyFeatureIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            StudyFeatureID studyFeatureID = studyFeatureIDArray[n3];
            AnalysisID.idToOperationID.put(studyFeatureID.id(), studyFeatureID);
            ++n3;
        }
    }

    private StudyFeatureID(String string2, String string3, String string4) {
        this.descr = string2;
        this.shortName = string3;
        this.icon = string4;
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.name();
    }

    @Override
    public boolean isEquationForm() {
        return false;
    }

    @Override
    public AnalysisID getStudyStep() {
        return this;
    }

    @Override
    public boolean isSpecialCaseOf(String string) {
        if (this.id().equals(string)) {
            return true;
        }
        switch (StudyFeatureID.a()[this.ordinal()]) {
            case 16: {
                return ComAnalysisID.Transient.id().equals(string) || ComAnalysisID.Frequency.id().equals(string);
            }
            case 15: {
                return Optimization.id().equals(string);
            }
        }
        return false;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public LicenseType[][] getLicenseRequirements() {
        switch (StudyFeatureID.a()[this.ordinal()]) {
            case 13: 
            case 15: {
                return new LicenseType[][]{{LicenseType.OPTIMIZATION}};
            }
        }
        return new LicenseType[][]{new LicenseType[0]};
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature != null && this.id().equals(propFeature.getOperationID());
    }

    @Override
    public boolean isOfType(String string) {
        return this.id().equals(string);
    }

    public static boolean isOptimizationID(String string) {
        String[] stringArray = OPTIMIZATION_OPERATION_NAMES;
        int n2 = OPTIMIZATION_OPERATION_NAMES.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (string2.equals(string)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean isSensitivityID(String string) {
        String[] stringArray = SENSITIVITY_OPERATION_NAMES;
        int n2 = SENSITIVITY_OPERATION_NAMES.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (string2.equals(string)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean isSensOrOptID(String string) {
        return StudyFeatureID.isSensitivityID(string) || StudyFeatureID.isOptimizationID(string);
    }

    public static String[] getAllToolBarOperationsIDs() {
        return (String[])Arrays.stream((StudyFeatureID[])q.b((Object[][])new StudyFeatureID[][]{STEP_TOOLBAR_OPERATIONS, BATCH_TOOLBAR_OPERATIONS, CLUSTER_TOOLBAR_OPERATIONS})).map(StudyFeatureID::id).toArray(String[]::new);
    }

    public static StudyFeatureID[] getLicensedStepToolBarOperations() {
        return StudyFeatureID.a(STEP_TOOLBAR_OPERATIONS);
    }

    private static StudyFeatureID[] a(StudyFeatureID[] studyFeatureIDArray) {
        LinkedList<StudyFeatureID> linkedList = new LinkedList<StudyFeatureID>();
        StudyFeatureID[] studyFeatureIDArray2 = studyFeatureIDArray;
        int n2 = studyFeatureIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            StudyFeatureID studyFeatureID = studyFeatureIDArray2[n3];
            LicenseType[][] licenseTypeArray = studyFeatureID.getLicenseRequirements();
            boolean bl2 = true;
            if (licenseTypeArray.length > 0) {
                LicenseType[] licenseTypeArray2 = licenseTypeArray[0];
                int n4 = licenseTypeArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    LicenseType licenseType = licenseTypeArray2[n5];
                    bl2 &= d.c((LicenseType)licenseType);
                    ++n5;
                }
            }
            if (bl2) {
                linkedList.add(studyFeatureID);
            }
            ++n3;
        }
        return linkedList.toArray(new StudyFeatureID[0]);
    }

    @Override
    public SolverType getSolverType() {
        switch (StudyFeatureID.a()[this.ordinal()]) {
            case 13: 
            case 15: {
                return SolverType.Optimization;
            }
        }
        return SolverType.valueOf(this.id());
    }

    public static boolean isParametricSynch(PropFeature propFeature) {
        return propFeature.getOperationID().equals(Parametric.id()) || propFeature.getOperationID().equals(FunctionSweep.id()) || propFeature.getOperationID().equals(DesignofExperiments.id()) || propFeature.getOperationID().equals(MaterialSweep.id()) || propFeature.getOperationID().equals(BatchSweep.id()) || propFeature.getOperationID().equals(BatchDesignofExperiments.id()) || propFeature.getOperationID().equals(ClusterSweep.id());
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[StudyFeatureID.values().length];
        try {
            nArray[StudyFeatureID.Batch.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.BatchDesignofExperiments.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.BatchSweep.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.ClusterComputing.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.ClusterSweep.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.CombineSolution.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.DesignofExperiments.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.FunctionSweep.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.MaterialSweep.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.ModelReduction.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.MultigridLevel.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.Optimization.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.ParameterEstimation.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.Parametric.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.Sensitivity.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StudyFeatureID.StudyReference.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

