/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.applapi;

import com.comsol.model.analysis.AnalysisID;
import com.comsol.model.analysis.ComAnalysisID;
import com.comsol.model.analysis.IAnalysisOperation;
import com.comsol.model.analysis.SpecialAnalysisID;
import com.comsol.model.applapi.ApplFeatureID;
import com.comsol.model.applapi.ApplModeCreatorManager;
import com.comsol.model.applapi.IApplField;
import com.comsol.model.applapi.IApplMode;
import com.comsol.model.applapi.IFeatureContainer;
import com.comsol.model.applapi.IParamSpecContainer;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.SDimType;
import com.comsol.model.applapi.VariableInfo;
import com.comsol.model.dbimodel.DEPVAR_TYPE;
import com.comsol.model.dbimodel.EVAL;
import com.comsol.model.dbimodel.Frame;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.Ode;
import com.comsol.model.dbimodel.OdeList;
import com.comsol.model.dbimodel.ParameterContainer;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.StudyFeatureList;
import com.comsol.model.dbimodel.physics.MultiphysicsCoupling;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.dbimodel.physics.PhysicsField;
import com.comsol.model.dbimodel.physics.PhysicsProp;
import com.comsol.model.operations.OperationManager;
import com.comsol.model.operations.OperationType;
import com.comsol.model.savepoint.interfaces.IModelEntity;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.model.util.MultiphysicsUtil;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.nativeutil.properties.ba;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsAbstractPlugin;
import com.comsol.util.classes.FlVersion;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.exceptions.PhysicsAPIException;
import com.comsol.util.license.LicenseType;
import com.comsol.util.license.d;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.j;
import com.comsol.util.methods.q;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ApplAPIUtil {
    public static boolean SANITY_CHECK = "true".equals(System.getProperty("cs.applutil.sanitycheck", "false"));
    public static final String logCallID = "multiphysics-calls";
    public static String OUTPUT_FILE;
    public static final Predicate<String> inValidPlotGroup;

    static {
        if (SANITY_CHECK) {
            try {
                String string2 = SystemUtil.getArchName();
                String string3 = SystemUtil.getClientType();
                StringBuilder stringBuilder = new StringBuilder(SystemUtil.getOutputRootDir((String)"api")).append(File.separator).append("physics-api-logging").append("_").append(string2.toLowerCase(Locale.ENGLISH)).append("_");
                if (string3 != null) {
                    stringBuilder.append(string3.toLowerCase(Locale.ENGLISH));
                } else {
                    stringBuilder.append("api");
                }
                stringBuilder.append("_").append(FlVersion.currentVersionString().replace(".", "_"));
                OUTPUT_FILE = stringBuilder.append(".log").toString();
                String string4 = String.valueOf(j.b()) + " - " + j.a();
                FlFileUtil.e((File)new File(OUTPUT_FILE), (String[])new String[]{"-------------------- New session (" + string4 + ")-------------------------"});
            }
            catch (Exception exception) {
                FlLogger.b((Throwable)exception);
                OUTPUT_FILE = null;
            }
        }
        inValidPlotGroup = string -> string.startsWith("#") || string.contains(" ") || string.contains(",");
    }

    public static boolean isHidden(ba ba2) {
        if (ba2.q()) {
            return true;
        }
        PropAnnotationInfo.EditFieldInfo editFieldInfo = ba2.S();
        if (editFieldInfo == null) {
            return false;
        }
        LicenseType[] licenseTypeArray = editFieldInfo.z();
        if (licenseTypeArray == null) {
            return false;
        }
        boolean bl2 = editFieldInfo.A();
        return !d.a((LicenseType[])licenseTypeArray) ^ bl2;
    }

    public static boolean useAnalysis(IApplMode iApplMode, StudyFeature studyFeature, ModelEntity modelEntity, AnalysisID ... analysisIDArray) {
        IAnalysisOperation iAnalysisOperation = null;
        String string = "";
        if (iApplMode != null) {
            string = ApplAPIUtil.getDefaultStudyType(iApplMode);
        } else if (modelEntity instanceof MultiphysicsCoupling) {
            string = ApplAPIUtil.getDefaultStudyType((MultiphysicsCoupling)modelEntity);
        } else {
            if (modelEntity instanceof Frame) {
                IAnalysisOperation iAnalysisOperation2 = (IAnalysisOperation)studyFeature.getOperation();
                return iAnalysisOperation2.isValidType(analysisIDArray, modelEntity);
            }
            return false;
        }
        if (studyFeature != null) {
            iAnalysisOperation = (IAnalysisOperation)studyFeature.getOperation();
            List list = ((StudyFeatureList)studyFeature.getContainer()).getActiveList();
            int n2 = list.indexOf(studyFeature) - 1;
            AnalysisID[] analysisIDArray2 = modelEntity instanceof MultiphysicsCoupling ? ((MultiphysicsCoupling)modelEntity).getMultiphysicsCoupling().getValidAnalysisTypes() : iApplMode.getValidAnalysisTypes();
            while (n2 >= 0) {
                PropFeature propFeature = (PropFeature)list.get(n2);
                IAnalysisOperation iAnalysisOperation3 = (IAnalysisOperation)propFeature.getOperation();
                if (iAnalysisOperation3.contributesPhysics() && iAnalysisOperation3.isValid(analysisIDArray2, modelEntity)) {
                    string = iAnalysisOperation3.getID();
                    break;
                }
                --n2;
            }
        }
        return ApplAPIUtil.a(iApplMode, modelEntity, iAnalysisOperation, string, analysisIDArray);
    }

    public static boolean useAnalysis(IApplMode iApplMode, ModelEntity modelEntity, IAnalysisOperation iAnalysisOperation, AnalysisID ... analysisIDArray) {
        return ApplAPIUtil.a(iApplMode, modelEntity, iAnalysisOperation, ApplAPIUtil.getDefaultStudyType(iApplMode), analysisIDArray);
    }

    public static boolean useAnalysis(MultiphysicsCoupling multiphysicsCoupling, ModelEntity modelEntity, IAnalysisOperation iAnalysisOperation, AnalysisID ... analysisIDArray) {
        return ApplAPIUtil.a(null, modelEntity, iAnalysisOperation, ApplAPIUtil.getDefaultStudyType(multiphysicsCoupling), analysisIDArray);
    }

    private static boolean a(IApplMode iApplMode, ModelEntity modelEntity, IAnalysisOperation iAnalysisOperation, String string, AnalysisID ... analysisIDArray) {
        Object[] objectArray;
        Object[] objectArray2 = null;
        if (iApplMode != null) {
            objectArray2 = iApplMode.getValidAnalysisTypes();
        }
        if (modelEntity instanceof MultiphysicsCoupling) {
            objectArray = ((MultiphysicsCoupling)modelEntity).getMultiphysicsCoupling().getValidAnalysisTypes();
            objectArray2 = iApplMode == null ? objectArray : (AnalysisID[])q.d((Object[])objectArray2, (Object[])objectArray);
        }
        Object[] objectArray3 = objectArray = iApplMode != null ? iApplMode.getEquationFormOperation() : null;
        if (objectArray != null) {
            return objectArray.isValidType(analysisIDArray, modelEntity);
        }
        if (iAnalysisOperation == null || !iAnalysisOperation.isValid((AnalysisID[])objectArray2, modelEntity)) {
            iAnalysisOperation = (IAnalysisOperation)OperationManager.create(OperationType.ANALYSIS, string);
            return iAnalysisOperation.isValidType(analysisIDArray, modelEntity);
        }
        return iAnalysisOperation.isValid(analysisIDArray, modelEntity);
    }

    public static String getDefaultStudyType(IApplMode iApplMode) {
        AnalysisID[] analysisIDArray = iApplMode.getValidAnalysisTypes();
        if (analysisIDArray.length == 0) {
            throw new PhysicsAPIException("The_interface_X_does_not_support_any_study_types#" + FlLocale.getString((String)iApplMode.getDescr()));
        }
        AnalysisID[] analysisIDArray2 = analysisIDArray;
        int n2 = analysisIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            AnalysisID analysisID = analysisIDArray2[n3];
            boolean bl2 = true;
            LicenseType[][] licenseTypeArray = iApplMode.getLicenseRequirements(analysisID, SDimType.settingsToType(iApplMode.getNSDims(), iApplMode.isAxisymmetric()));
            int n4 = licenseTypeArray.length;
            int n5 = 0;
            while (n5 < n4) {
                LicenseType[] licenseTypeArray2 = licenseTypeArray[n5];
                bl2 &= d.a((LicenseType[])licenseTypeArray2);
                ++n5;
            }
            if (bl2) {
                return analysisID.id();
            }
            ++n3;
        }
        return analysisIDArray[0].id();
    }

    public static String getDefaultStudyType(MultiphysicsCoupling multiphysicsCoupling) {
        AnalysisID[] analysisIDArray = multiphysicsCoupling.getMultiphysicsCoupling().getValidAnalysisTypes();
        if (analysisIDArray.length == 0) {
            throw new PhysicsAPIException("The_multiphysics_coupling_X_does_not_support_any_study_types#" + FlLocale.getString((String)multiphysicsCoupling.getMultiphysicsCoupling().getDescr(multiphysicsCoupling.getEdim())));
        }
        return analysisIDArray[0].id();
    }

    /*
     * WARNING - void declaration
     */
    public static Ode findBestOde(String string, String string2, VariableInfo variableInfo, StudyFeature studyFeature, ModelEntity modelEntity) {
        void var9_13;
        Object object;
        Physics physics = MultiphysicsUtil.getContainingPhysics(modelEntity);
        String string3 = variableInfo.realValueType() ? "real" : "complex";
        IApplField iApplField = null;
        IApplMode iApplMode = null;
        if (physics != null) {
            for (PhysicsField object22 : physics.field()) {
                if (!object22.getField().isOdeCollection() || object22.getField().checkCompNames(new String[]{string}, null, physics.getApp()) != null) continue;
                string2 = object22.field();
                object = ApplAPIUtil.getRealValueType(studyFeature, object22, VariableInfo.xmesh(modelEntity));
                if (object != null) {
                    string3 = ((Boolean)object).booleanValue() ? "real" : "complex";
                }
                modelEntity = physics;
                iApplField = object22.getField();
                break;
            }
            iApplMode = physics.getApp();
        }
        String string4 = "";
        if (variableInfo.useIOmega() && ApplAPIUtil.useAnalysis(iApplMode, studyFeature, modelEntity, ComAnalysisID.Frequency, ComAnalysisID.Eigenfrequency, ComAnalysisID.Eigenvalue)) {
            String string5 = ParseUtil.c((String)variableInfo.timeDerivativeMultiplier(), (String)modelEntity.scopeDot());
        }
        DEPVAR_TYPE dEPVAR_TYPE = variableInfo.depVarType();
        object = null;
        Model model = modelEntity.getModel();
        IVariableData iVariableData = model.physics().getVarData();
        for (Ode ode : model.ode()) {
            if (modelEntity != ode.getDerivedFrom() || !ode.tag().startsWith(string2) || iApplField == null && (!string3.equals(ode.valueType()) || ode.getType() != dEPVAR_TYPE || !var9_13.equals(ode.timeDerivativeMultiplier()))) continue;
            object = ode;
            break;
        }
        if (object == null) {
            if (iApplField == null && model.ode().hasTag(string2)) {
                string2 = model.ode().uniquetag(string2);
            }
            object = (Ode)model.ode().create(string2);
            object.setDerivedFrom(modelEntity);
            if (ApplAPIUtil.usingTimeDiscreteSolver(studyFeature)) {
                object.setCreateTimeVars(false);
            }
            if (variableInfo.useIOmega()) {
                object.timeDerivativeMultiplier((String)var9_13);
            }
            object.valueType(string3);
            object.setType(dEPVAR_TYPE);
            iVariableData.clearFieldNames();
        }
        if (!object.valueType().equals(string3) || object.getType() != dEPVAR_TYPE) {
            PhysicsAPIException physicsAPIException = new PhysicsAPIException("The_settings_for_the_states_are_incompatible_with_the_ODE_entity");
            physicsAPIException.addParameterPair("Field_name", string);
            if (iApplField != null) {
                physicsAPIException.addParameterPair("Ode_states_collection", iApplField.getApplFieldID());
            }
            if (!object.valueType().equals(string3)) {
                physicsAPIException.addParameterPair("Value_type", string3);
                physicsAPIException.addParameterPair("Value_type_x#ODE", object.valueType());
            }
            if (object.getType() != dEPVAR_TYPE) {
                physicsAPIException.addParameterPair("Type", dEPVAR_TYPE.toString());
                physicsAPIException.addParameterPair("Type_x#ODE", object.getType().toString());
            }
            throw physicsAPIException;
        }
        return object;
    }

    public static Boolean getRealValueType(StudyFeature studyFeature, PhysicsField physicsField, VariableInfo variableInfo) {
        if (physicsField.getApplmode().prop().hasTag("ShapeProperty")) {
            String[] stringArray = physicsField.getApplmode().prop("ShapeProperty").getStringArray("valueType");
            int n2 = physicsField.getApplmode().field().index(physicsField.tag());
            if (n2 >= 0 && n2 < stringArray.length) {
                if ("automatic".equals(stringArray[n2])) {
                    return physicsField.getField().ignoreImaginaryPart(studyFeature, physicsField);
                }
                return "real".equals(stringArray[n2]);
            }
        }
        return null;
    }

    public static boolean usingTimeDiscreteSolver(StudyFeature studyFeature) {
        IAnalysisOperation iAnalysisOperation;
        return studyFeature != null && (iAnalysisOperation = (IAnalysisOperation)studyFeature.getOperation()).getAnalysisID().isSpecialCaseOf(SpecialAnalysisID.TimeDiscrete.id());
    }

    public static Ode getNewODE(String string, ModelEntity modelEntity, boolean bl2) {
        OdeList<? extends Ode> odeList = modelEntity.getModel().ode();
        String string2 = bl2 ? odeList.uniquetag(string) : string;
        Ode ode = (Ode)odeList.create(string2);
        ode.setDerivedFrom(modelEntity);
        modelEntity.getModel().physics().getVarData().clearFieldNames();
        return ode;
    }

    public static IApplMode getApplModeInstance(Model model, GeomSequence geomSequence, String string) {
        IApplMode iApplMode = ApplModeCreatorManager.create(string);
        iApplMode.initialize(model, geomSequence, null);
        iApplMode.initFields();
        iApplMode.initProps();
        return iApplMode;
    }

    public static Stack<IFeatureContainer> getInitializedApplFeature(ModelEntity modelEntity, String string) {
        ApplFeatureID applFeatureID;
        IApplMode iApplMode;
        ArrayList<String> arrayList = new ArrayList<String>();
        PrimitiveModelEntity primitiveModelEntity = modelEntity.getContainer();
        while (primitiveModelEntity != null && !(primitiveModelEntity instanceof Physics)) {
            if (primitiveModelEntity instanceof PhysicsFeature) {
                arrayList.add(((PhysicsFeature)primitiveModelEntity).getApplfeatureID());
            }
            primitiveModelEntity = primitiveModelEntity.getContainer();
        }
        Physics physics = (Physics)primitiveModelEntity;
        Stack<IFeatureContainer> stack = new Stack<IFeatureContainer>();
        StringBuilder stringBuilder = new StringBuilder();
        if (physics != null && physics.isAppInitialized()) {
            iApplMode = physics.getApp();
            String string2 = physics.model();
            stringBuilder.append(string2).append("/").append(physics.getApplmodeID());
            stack.push(iApplMode);
            IFeatureContainer iFeatureContainer = iApplMode;
            int n2 = arrayList.size() - 1;
            while (n2 >= 0) {
                iFeatureContainer = iFeatureContainer.getFeatureID((String)arrayList.get(n2));
                stack.push(iFeatureContainer);
                stringBuilder.append("/").append(iFeatureContainer.getName());
                --n2;
            }
            applFeatureID = iFeatureContainer.getFeatureID(string);
            stack.push(applFeatureID);
            if (!applFeatureID.isInitialized()) {
                stack.pop();
                applFeatureID.initFeature(iApplMode, iFeatureContainer, iApplMode.getSDimType(), stringBuilder.toString());
                applFeatureID = iFeatureContainer.getFeatureID(string);
                stack.push(applFeatureID);
            }
        } else {
            throw new IllegalStateException(String.format("Cannot initialize a physics feature not contained in an initialized physics hierarchy\n  Physics: %s (%s)\n  Feature ID: %s", physics != null ? physics.tag() : "null", physics != null ? physics.getApplmodeID() : "null", string));
        }
        applFeatureID.getFeature().ensureSpecInitialized(iApplMode, stringBuilder.toString());
        return stack;
    }

    public static IParamSpecContainer getSpecContainer(ParameterContainer parameterContainer) {
        if (parameterContainer instanceof MultiphysicsCoupling) {
            return ((MultiphysicsCoupling)parameterContainer).getMultiphysicsCoupling();
        }
        if (parameterContainer instanceof PhysicsProp) {
            return ((PhysicsProp)parameterContainer).getProp();
        }
        if (parameterContainer instanceof PhysicsFeature) {
            return ((PhysicsFeature)parameterContainer).getApplfeature();
        }
        if (parameterContainer instanceof MaterialModel) {
            return null;
        }
        throw new IllegalArgumentException("No parameter spec container can be found for '" + parameterContainer.toString() + "'");
    }

    public static Model getModel(ParameterContainer parameterContainer) {
        if (parameterContainer instanceof ModelEntity) {
            return ((ModelEntity)((Object)parameterContainer)).getModel();
        }
        throw new IllegalArgumentException("No model can be found for '" + parameterContainer.toString() + "'");
    }

    public static void getUniqueCoordNames(SelectionEntity selectionEntity, String[] stringArray) {
        Model model = selectionEntity.getModel();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Frame frame : model.frame()) {
            String[] stringArray2 = frame.coord();
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray2[n3];
                hashSet.add(string);
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < 3) {
            Object object = stringArray[n4];
            int n5 = 1;
            while (hashSet.contains(object)) {
                object = String.valueOf(stringArray[n4]) + n5;
                ++n5;
            }
            if (n5 > 1) {
                stringArray[n4] = object;
            }
            hashSet.add(object);
            ++n4;
        }
    }

    public static String getFullFeatureScope(IModelEntity iModelEntity, boolean bl2) {
        String string = iModelEntity.scopeDot();
        if (!bl2 && string.startsWith("root.")) {
            string = string.substring("root.".length());
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (iModelEntity instanceof PhysicsFeature) {
            Stack<String> stack = new Stack<String>();
            while (iModelEntity instanceof PhysicsFeature) {
                stack.push(iModelEntity.tag());
                iModelEntity = (ModelEntity)iModelEntity.getContainer();
                if (iModelEntity == null) continue;
                iModelEntity = (ModelEntity)iModelEntity.getContainer();
            }
            while (stack.size() > 0) {
                stringBuilder.append((String)stack.pop()).append('.');
            }
        }
        return stringBuilder.toString();
    }

    public static int[] parseSize(String string) {
        String[] stringArray = string.split("x");
        int[] nArray = new int[stringArray.length];
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                nArray[n2] = Integer.parseInt(stringArray[n2].trim());
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PhysicsAPIException("Syntax_error_in_size_specification", (Throwable)numberFormatException);
        }
        return nArray;
    }

    public static String isCompatibleFields(PhysicsField physicsField, PhysicsField physicsField2) {
        IApplField iApplField = physicsField.getField();
        IApplField iApplField2 = physicsField2.getField();
        if (iApplField.isVarDim() == iApplField2.isVarDim()) {
            if (!Arrays.equals(iApplField.getAllowedDim(), iApplField2.getAllowedDim())) {
                return "Incompatible_dimensions";
            }
            if (!ApplAPIUtil.a(physicsField, iApplField, physicsField2, iApplField2)) {
                return "Incompatible_units";
            }
            String[] stringArray = physicsField.getComponents();
            String[] stringArray2 = physicsField2.getComponents();
            if (stringArray != null && stringArray2 != null && stringArray.length != stringArray2.length) {
                return "Incompatible_components";
            }
        }
        if (ApplAPIUtil.isScalarFieldOrSizeOne(physicsField) && ApplAPIUtil.isScalarFieldOrSizeOne(physicsField2) && !ApplAPIUtil.a(physicsField, iApplField, physicsField2, iApplField2)) {
            return "Incompatible_units";
        }
        return null;
    }

    private static boolean a(PhysicsField physicsField, IApplField iApplField, PhysicsField physicsField2, IApplField iApplField2) {
        String[] stringArray;
        String[] stringArray2 = iApplField.getUnitString(physicsField.getApplmode());
        return FlStringUtil.equals((String)stringArray2[0], (String)(stringArray = iApplField2.getUnitString(physicsField2.getApplmode()))[0]) && (stringArray2.length == 1 || stringArray.length == 1 || FlStringUtil.equals((String)stringArray2[1], (String)stringArray[1]));
    }

    public static boolean isScalarFieldOrSizeOne(PhysicsField physicsField) {
        IApplField iApplField = physicsField.getField();
        if (!iApplField.isVarDim() && iApplField.getAllowedDim().length == 1 && iApplField.getAllowedDim()[0] == 1) {
            return true;
        }
        return physicsField.getComponents() != null && physicsField.getComponents().length == 1;
    }

    public static String getModelInputScope(String string) {
        return "root.minput.";
    }

    public static void addGeneralExceptionInfo(FlException flException, ModelEntity modelEntity2, PropFeature propFeature2) {
        Optional.ofNullable(modelEntity2).ifPresent(modelEntity -> {
            FlException flException2 = flException.addParameterPair("Entity", modelEntity.getDisplayString());
        });
        Optional.ofNullable(propFeature2).ifPresent(propFeature -> {
            FlException flException2 = flException.addParameterPair("Node", propFeature.label()).addParameterPair("Path", ModelEntityUtil.getShortEntityPath(propFeature, true));
        });
    }

    public static PhysicsField getPhysicsFieldFromID(Physics physics, String string) {
        if (physics == null) {
            return null;
        }
        for (PhysicsField physicsField : physics.field()) {
            if (!physicsField.getApplfieldID().equals(string)) continue;
            return physicsField;
        }
        return null;
    }

    public static String getPhysicsVarDimSuffix(Physics physics) {
        return physics.getField().activeStream().filter(physicsField -> physicsField.getField().isVarDim()).flatMap(physicsField -> Arrays.stream(physicsField.component())).collect(Collectors.joining("_"));
    }

    public static IAnalysisOperation getAnalysisOperationSafe(PropFeature propFeature) {
        return (IAnalysisOperation)Optional.ofNullable(propFeature.getOperationNoCreate()).orElse(OperationManager.create(OperationType.ANALYSIS, propFeature.getOperationID()));
    }

    public static boolean hasPhysicsPropertyParameter(Physics physics, String string, String string2) {
        return physics.prop().hasTag(string) && physics.prop(string).hasParam(string2);
    }

    public static void logMultiphysicsWarnings(ModelEntity modelEntity, EVAL eVAL) {
        if (modelEntity.getModel().doingMultiphysics()) {
            if (FlLogger.n((String)"Multiphysics")) {
                FlLogger.a((String)"Multiphysics", (String)"Pass", (String)eVAL.getDisplayName());
                FlLogger.a((String)"Multiphysics", (String)"Provider", (String)ModelEntityUtil.getEntityPath(modelEntity));
                FlLogger.q((String)"Multiphysics");
            }
            if (SANITY_CHECK) {
                if (FlLogger.o((String)logCallID)) {
                    FlLogger.c((String)logCallID, (String)OUTPUT_FILE);
                } else {
                    FlLogger.a((String)logCallID, null, (CsAbstractPlugin.LogLevel)CsAbstractPlugin.LogLevel.DEBUG);
                }
            }
        } else {
            ApplAPIUtil.clearMultiphysicsWarnings(modelEntity, eVAL);
        }
    }

    public static void clearMultiphysicsWarnings(ModelEntity modelEntity, EVAL eVAL) {
        FlLogger.b((String)"Multiphysics", null);
        if (SANITY_CHECK) {
            FlLogger.a((String)logCallID, null, (CsAbstractPlugin.LogLevel)CsAbstractPlugin.LogLevel.DEBUG);
            FlLogger.a((String)logCallID, (String)String.format("%s: %s", eVAL, modelEntity.getDisplayString()), (CsAbstractPlugin.LogLevel)CsAbstractPlugin.LogLevel.DEBUG);
        }
    }
}

