/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.applapi;

import com.comsol.model.applapi.IPhysicalQuantity;
import com.comsol.model.applapi.ISDim;
import com.comsol.model.applapi.VariableInfo;
import com.comsol.model.dbimodel.MatchTagContainer;
import com.comsol.model.dbimodel.ParameterContainer;
import com.comsol.model.dbimodel.physics.MultiphysicsCoupling;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.dbimodel.physics.PhysicsProp;
import com.comsol.model.savepoint.interfaces.IModelEntity;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FeatureInputEvent
extends EventObject {
    public static final int setEmpty = 64;
    VariableInfo info;
    int edim;
    ISDim sDim;

    public FeatureInputEvent(Object object, VariableInfo variableInfo, int n2, boolean bl2) {
        this(object, variableInfo, n2, null, bl2);
    }

    public FeatureInputEvent(Object object, VariableInfo variableInfo, int n2, ISDim iSDim, boolean bl2) {
        super(object);
        this.edim = n2 == -1 ? 4 : n2;
        if (bl2) {
            this.edim |= 0x40;
        }
        this.info = variableInfo.clone();
        this.sDim = iSDim;
    }

    public boolean equals(Object object) {
        if (object instanceof FeatureInputEvent) {
            FeatureInputEvent featureInputEvent = (FeatureInputEvent)object;
            Physics physics = this.info.getModelApplMode();
            Physics physics2 = featureInputEvent.info.getModelApplMode();
            return this.getSource().equals(featureInputEvent.getSource()) && this.id().hasSameID(featureInputEvent.id()) && this.tagEquals(featureInputEvent.tag()) && (physics == null ? physics2 == null : physics.equals(physics2)) && this.getDomainLevel() == featureInputEvent.getDomainLevel();
        }
        return false;
    }

    public IPhysicalQuantity id() {
        return this.info.id();
    }

    public String tag() {
        return this.info.announceTag();
    }

    public int getDomainLevel() {
        return this.isGlobal() ? 4 : this.edim & 0x80000003;
    }

    public String getScope() {
        Physics physics = this.info.getModelApplMode();
        if (physics != null) {
            return physics.shortScopeDot();
        }
        if (this.info.getProvider() != null && this.info.getProvider().isInModel()) {
            if (this.info.getProvider() instanceof MultiphysicsCoupling) {
                return ((MultiphysicsCoupling)this.info.getProvider()).shortScopeDot();
            }
            return this.info.getProvider().scopeDot();
        }
        return "root.";
    }

    public boolean isGlobal() {
        return (this.edim & 4) > 0;
    }

    public boolean isEmpty() {
        return (this.edim & 0x40) > 0;
    }

    public boolean tagEquals(String string) {
        return FeatureInputEvent.tagMatches(string, this.tag());
    }

    public static boolean tagMatches(String string, String ... stringArray) {
        if (q.a((Object[])stringArray, (Object)string)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        Pattern pattern = null;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[n3];
            if (string2 == null) {
                string2 = "";
            }
            if (pattern == null) {
                try {
                    pattern = Pattern.compile(string);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            if (pattern.matcher(string2).matches()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean betterMatch(FeatureInputEvent featureInputEvent, ParameterContainer parameterContainer, ISDim iSDim, Match match) {
        Object object;
        MatchTagContainer matchTagContainer;
        if (match.equals((Object)Match.Synchronized)) {
            return false;
        }
        Physics physics = null;
        ArrayList<Physics> arrayList = null;
        int n2 = -1;
        if (parameterContainer instanceof PhysicsFeature) {
            physics = ((PhysicsFeature)parameterContainer).getApplmode();
            matchTagContainer = (PhysicsFeature)parameterContainer;
            n2 = matchTagContainer.getEdim();
            iSDim = iSDim != null ? iSDim : matchTagContainer.getApplfeature().getPhysicsSDims((PhysicsFeature)matchTagContainer, null)[0];
        } else if (parameterContainer instanceof PhysicsProp) {
            physics = ((PhysicsProp)parameterContainer).getApplmode();
            n2 = physics.getApp().getSDimMax();
            iSDim = iSDim != null ? iSDim : physics.getApp().getSDim(physics.getApp().getSelectedFrameType());
        } else if (parameterContainer instanceof MultiphysicsCoupling) {
            matchTagContainer = (MultiphysicsCoupling)parameterContainer;
            physics = null;
            if ((match == Match.PhysicsMatch || match == Match.ModelInputMatch) && (object = matchTagContainer.getPhysicsTags()).size() > 0) {
                arrayList = new ArrayList<Physics>();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    arrayList.add(matchTagContainer.getModel().physics(string));
                }
            }
            n2 = matchTagContainer.getEdim();
            iSDim = iSDim != null ? iSDim : matchTagContainer.getMultiphysicsCoupling().getPhysicsSDims((MultiphysicsCoupling)matchTagContainer, null)[0];
        }
        matchTagContainer = this.info.getModelApplMode();
        object = this.info.getProvider();
        if ((match.equals((Object)Match.AlwaysMatch) || physics != null && this.a(physics.tag()) || arrayList != null && arrayList.contains(matchTagContainer) || matchTagContainer != null && matchTagContainer == physics || object != null && object == parameterContainer) && this.getDomainLevel() >= n2) {
            if (this.betterSDimMatch(featureInputEvent, iSDim)) {
                return true;
            }
            return this.getDomainLevel() < featureInputEvent.getDomainLevel();
        }
        return false;
    }

    private boolean a(String string) {
        if (this.info.getProvider() instanceof MultiphysicsCoupling) {
            MultiphysicsCoupling multiphysicsCoupling = (MultiphysicsCoupling)this.info.getProvider();
            return multiphysicsCoupling.getPhysicsTags().contains(string);
        }
        return false;
    }

    public boolean betterSDimMatch(FeatureInputEvent featureInputEvent, ISDim iSDim) {
        if (featureInputEvent == null) {
            return true;
        }
        if (this.sDim != null && iSDim != null) {
            if (!featureInputEvent.sDim.getMatchTag().equals(iSDim.getMatchTag()) && this.sDim.getMatchTag().equals(iSDim.getMatchTag())) {
                return true;
            }
            if (!featureInputEvent.sDim.sharesFrameTypeWithSystem(iSDim) && this.sDim.sharesFrameTypeWithSystem(iSDim)) {
                return true;
            }
            if (!featureInputEvent.sDim.sharesBasisWithSystem(iSDim) && this.sDim.sharesBasisWithSystem(iSDim)) {
                return true;
            }
        }
        return false;
    }

    public boolean sDimMatches(FeatureInputEvent featureInputEvent) {
        return this.sDimMatches(featureInputEvent.sDim);
    }

    public boolean sDimMatches(ISDim iSDim) {
        return this.sDim == null || iSDim == null || this.sDim.equals(iSDim);
    }

    public IModelEntity getProvider() {
        return this.info.getProvider();
    }

    public ISDim getSDim() {
        return this.sDim;
    }

    public boolean overwrites(FeatureInputEvent featureInputEvent) {
        return this.getDomainLevel() > featureInputEvent.getDomainLevel() || !this.isEmpty() && featureInputEvent.isEmpty() || !this.isGenericDeclaration() && featureInputEvent.isGenericDeclaration();
    }

    public boolean isGenericDeclaration() {
        return this.info.matchDeclared() && this.isEmpty() && this.info.type() == VariableInfo.Type.XMesh;
    }

    public static enum Match {
        AlwaysMatch("alwaysMatch", "Always_match"),
        Synchronized("syncronized", "Synchronized"),
        PhysicsMatch("physicsMatch", "Always_match_within_physics_interfaces"),
        ModelInputMatch("modelInputMatch", "Model_input_match"),
        Disable("disable", "Never_match");

        private final String value;
        private final String descr;

        private Match(String string2, String string3) {
            this.value = string2;
            this.descr = string3;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.descr;
        }

        public static String[] getValues() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Match[] matchArray = Match.values();
            int n2 = matchArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Match match = matchArray[n3];
                arrayList.add(match.getValue());
                ++n3;
            }
            return arrayList.toArray(new String[0]);
        }

        public static String[] getDescriptions() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Match[] matchArray = Match.values();
            int n2 = matchArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Match match = matchArray[n3];
                arrayList.add(match.getDescription());
                ++n3;
            }
            return arrayList.toArray(new String[0]);
        }

        public static Match fromValue(String string) {
            Match match = null;
            Match[] matchArray = Match.values();
            int n2 = matchArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Match match2 = matchArray[n3];
                if (match2.getValue().equals(string)) {
                    match = match2;
                    break;
                }
                ++n3;
            }
            return match;
        }
    }
}

