/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.applapi;

public interface IPhysicalQuantity {
    public String fieldName();

    public String varName();

    public String descr();

    public int[] size();

    public String symbol();

    public boolean isMaterialProp();

    public boolean isSymmetric();

    public boolean isShowAllComponents();

    public int[] dimension();

    public boolean hasSameID(IPhysicalQuantity var1);

    public Type getType();

    public PQCategory getCategory();

    public String[][] getDefaultValue();

    public boolean sameDefaultValue(Object var1);

    public boolean isValidForModeInput();

    public static PQCategory getCategory(String string) {
        if (string == null) {
            return PQCategory.GENERAL;
        }
        PQCategory[] pQCategoryArray = PQCategory.values();
        int n2 = pQCategoryArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PQCategory pQCategory = pQCategoryArray[n3];
            if (pQCategory.name().equals(string)) {
                return pQCategory;
            }
            ++n3;
        }
        return PQCategory.HIDDEN;
    }

    public static enum PQCategory {
        GENERAL("General", "comsol_small.png"),
        ACOUSTICS("Acoustics", "modnav_acoustics.png"),
        MAXWELL("Electromagnetics", "matlib_magnetic.png"),
        SOLID("Solid_mechanics", "build_all.png"),
        TRANSPORT("Transport[Category]", "solute_transport.png"),
        HIDDEN("Hidden", "comsol_small.png");

        private final String descr;
        private final String iconName;

        private PQCategory(String string2, String string3) {
            this.descr = string2;
            this.iconName = string3;
        }

        public String getDescr() {
            return this.descr;
        }

        public String getIcon() {
            return this.iconName;
        }
    }

    public static enum Type {
        STATIC,
        BUILTIN,
        DYNAMIC;

    }
}

