/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.applapi;

import com.comsol.model.applapi.ApplAPIUtil;
import com.comsol.model.applapi.ApplModeCreatorListener;
import com.comsol.model.applapi.ApplModeCreatorManager;
import com.comsol.model.applapi.BuilderTensorFunctionInfo;
import com.comsol.model.applapi.IFunctionOperatorInfo;
import com.comsol.model.applapi.IMultiphysicsItem;
import com.comsol.model.applapi.IPhysicalQuantity;
import com.comsol.model.applapi.IPhysicalQuantityProvider;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.MaterialDB;
import com.comsol.model.applapi.PhysicalConstant;
import com.comsol.model.applapi.PhysicalConstantID;
import com.comsol.model.applapi.PhysicalQuantity;
import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.dbimodel.Information;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.dbimodel.MaterialModelList;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.functions.FunctionFactory;
import com.comsol.model.matlib.IExternalMaterialSocket;
import com.comsol.model.matlib.MaterialFunction;
import com.comsol.model.param.ParamSpec;
import com.comsol.model.plugin.internal.CsPlugin;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.simple.SimpleMaterialModelList;
import com.comsol.model.util.BuilderAreaManager;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsAbstractPlugin;
import com.comsol.util.classes.StringStringPair;
import com.comsol.util.classes.exprparser.BuiltInFunctions;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.exceptions.PhysicsAPIException;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.PluginUtil;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public final class PhysicalQuantityManager {
    private static Map<String, String[][]> a = new HashMap<String, String[][]>();
    private static List<String> b = new ArrayList<String>(1);
    public static final String PHYSICAL_QUANTITY_PROVIDER_EXTENSION = "com.comsol.model.physicalquantityprovider";

    private static IPhysicalQuantityProvider[] c() {
        IPhysicalQuantityProvider[] iPhysicalQuantityProviderArray = (IPhysicalQuantityProvider[])PluginUtil.a((String)PHYSICAL_QUANTITY_PROVIDER_EXTENSION, IPhysicalQuantityProvider.class);
        return iPhysicalQuantityProviderArray;
    }

    public static PhysicalConstant getPhysConstant(PhysicalConstantID physicalConstantID) {
        return PhysicalQuantityManager.e().get(physicalConstantID.name());
    }

    public static Collection<PhysicalConstant> getPhysConstants() {
        return PhysicalQuantityManager.e().values();
    }

    public static Exception getInitError() {
        if (!b.isEmpty()) {
            PhysicsAPIException physicsAPIException = new PhysicsAPIException("Errors_during_physical_quantity_initialization");
            for (String string : b) {
                physicsAPIException.appendMessage(string);
            }
            b.clear();
            return physicsAPIException;
        }
        return null;
    }

    public static Map<IPhysicalQuantity.PQCategory, List<IPhysicalQuantity>> getPQFieldNamesByCategory(boolean bl2) {
        HashMap<IPhysicalQuantity.PQCategory, List<IPhysicalQuantity>> hashMap = new HashMap<IPhysicalQuantity.PQCategory, List<IPhysicalQuantity>>();
        PhysicalQuantityManager.d().forEach((string, physicalQuantity) -> {
            IPhysicalQuantity.PQCategory pQCategory = physicalQuantity.getCategory();
            if (pQCategory != IPhysicalQuantity.PQCategory.HIDDEN || bl2) {
                ArrayList<PhysicalQuantity> arrayList = (ArrayList<PhysicalQuantity>)hashMap.get((Object)pQCategory);
                if (arrayList == null) {
                    arrayList = new ArrayList<PhysicalQuantity>();
                    hashMap.put(pQCategory, arrayList);
                }
                arrayList.add((PhysicalQuantity)physicalQuantity);
            }
        });
        return hashMap;
    }

    public static String[] getPQFieldNames() {
        Set<String> set = PhysicalQuantityManager.d().keySet();
        return set.toArray(new String[set.size()]);
    }

    public static List<String> getSortedPQFieldNames() {
        Comparator<String> comparator = new Comparator<String>(){

            public int a(String string, String string2) {
                String string3 = FlLocale.getString((String)PhysicalQuantityManager.getID(string).descr());
                String string4 = FlLocale.getString((String)PhysicalQuantityManager.getID(string2).descr());
                return string3.compareTo(string4);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((String)object, (String)object2);
            }
        };
        ArrayList<String> arrayList = new ArrayList<String>(PhysicalQuantityManager.d().keySet());
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static void setManagerInvalid() {
        if (com.comsol.model.applapi.PhysicalQuantityManager$b.a != null) {
            com.comsol.model.applapi.PhysicalQuantityManager$b.a.b();
        }
        if (com.comsol.model.applapi.PhysicalQuantityManager$a.a != null) {
            com.comsol.model.applapi.PhysicalQuantityManager$a.a.creatorMapInvalid();
        }
        if (c.a != null) {
            c.a.creatorMapInvalid();
        }
    }

    private static Map<String, PhysicalQuantity> d() {
        return com.comsol.model.applapi.PhysicalQuantityManager$b.a().c;
    }

    private static Map<String, PhysicalConstant> e() {
        return com.comsol.model.applapi.PhysicalQuantityManager$b.a().f;
    }

    private static Map<String, PhysicalQuantity> f() {
        return com.comsol.model.applapi.PhysicalQuantityManager$b.a().g;
    }

    public static IPhysicalQuantity getID(String string) {
        PhysicalQuantity physicalQuantity = PhysicalQuantityManager.d().get(string.toLowerCase(Locale.ENGLISH));
        if (physicalQuantity != null) {
            return physicalQuantity;
        }
        FlException flException = new FlException("Unknown_physical_quantity.");
        flException.addParameterPair("Physical_quantity", string);
        throw flException;
    }

    public static Collection<PhysicalQuantity> getID() {
        return PhysicalQuantityManager.d().values();
    }

    public static IPhysicalQuantity[] getID(Predicate<IPhysicalQuantity> predicate) {
        return (IPhysicalQuantity[])PhysicalQuantityManager.d().values().stream().filter(predicate).toArray(IPhysicalQuantity[]::new);
    }

    public static IPhysicalQuantity getIDByVarName(String string) {
        return PhysicalQuantityManager.f().get(string);
    }

    public static boolean isID(String string) {
        return string != null && PhysicalQuantityManager.d().containsKey(string.toLowerCase(Locale.ENGLISH));
    }

    public static IVariableData getVariableData(com.comsol.util.interfaces.b b2, IModel iModel) {
        IPhysicalQuantityProvider[] iPhysicalQuantityProviderArray;
        IPhysicalQuantityProvider[] iPhysicalQuantityProviderArray2 = iPhysicalQuantityProviderArray = PhysicalQuantityManager.c();
        int n2 = iPhysicalQuantityProviderArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IPhysicalQuantityProvider iPhysicalQuantityProvider = iPhysicalQuantityProviderArray2[n3];
            IVariableData iVariableData = iPhysicalQuantityProvider.getVariableData(b2, iModel);
            if (iVariableData != null) {
                return iVariableData;
            }
            ++n3;
        }
        return null;
    }

    public static MaterialModel getApplMaterialModel(String string) {
        return (MaterialModel)com.comsol.model.applapi.PhysicalQuantityManager$a.c().c.get(string);
    }

    public static String[] getAllMaterialModelTags() {
        return com.comsol.model.applapi.PhysicalQuantityManager$a.c().c.keySet().toArray(new String[0]);
    }

    public static MaterialModel getMaterialModelFromIdentifier(String string) {
        return (MaterialModel)com.comsol.model.applapi.PhysicalQuantityManager$a.c().d.get(string);
    }

    public static boolean isDynamicMaterialModel(String string) {
        return com.comsol.model.applapi.PhysicalQuantityManager$a.c().a(string);
    }

    public static IVariableData getVariableData(IModel iModel) {
        IPhysicalQuantityProvider[] iPhysicalQuantityProviderArray;
        IPhysicalQuantityProvider[] iPhysicalQuantityProviderArray2 = iPhysicalQuantityProviderArray = PhysicalQuantityManager.c();
        int n2 = iPhysicalQuantityProviderArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IPhysicalQuantityProvider iPhysicalQuantityProvider = iPhysicalQuantityProviderArray2[n3];
            IVariableData iVariableData = iPhysicalQuantityProvider.getVariableData(iModel);
            if (iVariableData != null) {
                return iVariableData;
            }
            ++n3;
        }
        return null;
    }

    public static IMultiphysicsItem createMultiphysicsInstance(ModelEntity modelEntity) {
        IPhysicalQuantityProvider[] iPhysicalQuantityProviderArray = PhysicalQuantityManager.c();
        int n2 = iPhysicalQuantityProviderArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IPhysicalQuantityProvider iPhysicalQuantityProvider = iPhysicalQuantityProviderArray[n3];
            IMultiphysicsItem iMultiphysicsItem = iPhysicalQuantityProvider.createMultiphysicsInstance(modelEntity);
            if (iMultiphysicsItem != null) {
                return iMultiphysicsItem;
            }
            ++n3;
        }
        return null;
    }

    public static String[][] getMMPropertyFor3XProperty(String string) {
        String[][] stringArray = new String[][]{{MaterialDB.MatRes.def.name(), string}};
        String[][] stringArray2 = a.get(string);
        if (stringArray2 == null) {
            IPhysicalQuantityProvider[] iPhysicalQuantityProviderArray = PhysicalQuantityManager.c();
            int n2 = iPhysicalQuantityProviderArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IPhysicalQuantityProvider iPhysicalQuantityProvider = iPhysicalQuantityProviderArray[n3];
                stringArray2 = iPhysicalQuantityProvider.getMMPropertyFor3XProperty(string);
                if (stringArray2 != null) break;
                ++n3;
            }
        }
        if (stringArray2 != null) {
            a.put(string, stringArray2);
        }
        if (stringArray2 != null) {
            stringArray = (String[][])stringArray2.clone();
        }
        return stringArray;
    }

    public static List<IExternalMaterialSocket> getAllExternalMaterialSockets() {
        ArrayList<IExternalMaterialSocket> arrayList = new ArrayList<IExternalMaterialSocket>();
        HashSet<String> hashSet = new HashSet<String>();
        IPhysicalQuantityProvider[] iPhysicalQuantityProviderArray = PhysicalQuantityManager.c();
        int n2 = iPhysicalQuantityProviderArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IPhysicalQuantityProvider iPhysicalQuantityProvider = iPhysicalQuantityProviderArray[n3];
            List<IExternalMaterialSocket> list = iPhysicalQuantityProvider.getExternalMaterialSockets();
            if (list != null) {
                for (IExternalMaterialSocket iExternalMaterialSocket : list) {
                    if (hashSet.contains(iExternalMaterialSocket.getID())) {
                        throw new RuntimeException("Duplicate_external_material_model_ID_X#" + iExternalMaterialSocket.getID());
                    }
                    arrayList.add(iExternalMaterialSocket);
                    hashSet.add(iExternalMaterialSocket.getID());
                }
            }
            ++n3;
        }
        return arrayList;
    }

    public static Map<String, IFunctionOperatorInfo> getPhysicsBuilderFunctions() {
        Map map = c.a().c;
        FlException flException = c.a().g();
        if (flException != null) {
            throw flException;
        }
        return map;
    }

    private static class a
    implements ApplModeCreatorListener {
        private static a a = null;
        private boolean b = true;
        private Map<String, MaterialModel> c;
        private Map<String, MaterialModel> d;
        private Map<String, MaterialModel> e;
        private Collection<IPhysicalQuantityProvider> f = new ArrayList<IPhysicalQuantityProvider>();

        private a() {
        }

        private static a c() {
            if (a == null) {
                com.comsol.model.applapi.PhysicalQuantityManager$a.d();
            }
            if (com.comsol.model.applapi.PhysicalQuantityManager$a.a.b && !BuilderAreaManager.isPreventLoadingOfDevelopmentFiles()) {
                com.comsol.model.applapi.PhysicalQuantityManager$a.e();
            }
            return a;
        }

        private static synchronized void d() {
            a = new a();
            a.g();
            a.h();
            ApplModeCreatorManager.getInstance().addListener(a);
        }

        private static synchronized void e() {
            a.f();
            a.h();
        }

        private void f() {
            Map.Entry<String, MaterialModel> entry;
            this.b = false;
            MaterialModelList<MaterialModel> materialModelList = null;
            for (Map.Entry<String, MaterialModel> object2 : this.c.entrySet()) {
                if (!"dynamicGroups".equals(object2.getValue().getContainer().getTag())) continue;
                materialModelList = (MaterialModelList)object2.getValue().getContainer();
                break;
            }
            if (materialModelList == null) {
                materialModelList = new SimpleMaterialModelList("dynamicGroups");
            } else {
                Iterator iterator = materialModelList.iterator();
                while (iterator.hasNext()) {
                    entry = (MaterialModel)iterator.next();
                    this.c.remove(entry.getTag());
                    this.d.remove(entry.getIdentifier());
                    iterator.remove();
                }
            }
            Iterator<Map.Entry<String, MaterialModel>> iterator = this.e.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (this.c.containsKey(entry.getKey())) continue;
                this.c.put((String)entry.getKey(), (MaterialModel)entry.getValue());
                this.a((MaterialModel)entry.getValue());
                iterator.remove();
            }
            if (this.c.containsKey(MaterialDB.MatRes.def.name())) {
                MaterialModel materialModel = this.c.get(MaterialDB.MatRes.def.name());
                materialModelList.add(materialModel);
            }
            for (IPhysicalQuantityProvider iPhysicalQuantityProvider : this.f) {
                try {
                    iPhysicalQuantityProvider.addMaterialModels(materialModelList);
                    for (IExternalMaterialSocket iExternalMaterialSocket : iPhysicalQuantityProvider.getExternalMaterialSockets()) {
                        iExternalMaterialSocket.addPropertyGroup(materialModelList);
                    }
                }
                catch (RuntimeException runtimeException) {
                    FlLogger.b((Throwable)runtimeException);
                }
            }
            for (MaterialModel materialModel : materialModelList) {
                MaterialModel materialModel2 = this.c.put(materialModel.tag(), materialModel);
                if (materialModel2 != null) {
                    this.e.put(materialModel2.tag(), materialModel2);
                }
                this.a(materialModel);
            }
        }

        private void g() {
            this.c = new LinkedHashMap<String, MaterialModel>();
            this.d = new HashMap<String, MaterialModel>();
            this.e = new LinkedHashMap<String, MaterialModel>();
            SimpleMaterialModelList simpleMaterialModelList = new SimpleMaterialModelList("builtinGroups");
            simpleMaterialModelList.create(MaterialDB.MatRes.def.name(), FlLocale.getString((String)MaterialDB.MatRes.def.descr()));
            boolean bl2 = SystemUtil.isDevelop();
            IExtensionPoint iExtensionPoint = PluginUtil.c((String)PhysicalQuantityManager.PHYSICAL_QUANTITY_PROVIDER_EXTENSION);
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n2 = iExtensionArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                Object object2 = iExtensionArray[n3];
                Object object3 = null;
                IConfigurationElement[] iConfigurationElementArray = object2.getConfigurationElements();
                int n4 = iConfigurationElementArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IConfigurationElement iConfigurationElement;
                    Object object4;
                    IConfigurationElement[] iConfigurationElementArray2;
                    Object object5;
                    object = iConfigurationElementArray[n5];
                    if (object.getName().equals("materialmodel")) {
                        this.a((IConfigurationElement)object, simpleMaterialModelList);
                    } else if (object.getName().equals("synchronizationrule")) {
                        IConfigurationElement iConfigurationElement2;
                        object5 = new HashMap();
                        iConfigurationElementArray2 = new HashMap();
                        object4 = object.getAttribute("propertygroup");
                        iConfigurationElement = object.getChildren("neededproperties");
                        ArrayList<String> arrayList = new ArrayList<String>();
                        IConfigurationElement iConfigurationElement3 = iConfigurationElement;
                        int n6 = ((IConfigurationElement[])iConfigurationElement3).length;
                        int n7 = 0;
                        while (n7 < n6) {
                            iConfigurationElement2 = iConfigurationElement3[n7];
                            arrayList.add(iConfigurationElement2.getAttribute("name"));
                            ++n7;
                        }
                        IConfigurationElement iConfigurationElement4 = iConfigurationElement2 = object.getChildren("synchmaterialproperty");
                        int n8 = ((IConfigurationElement)iConfigurationElement4).length;
                        n6 = 0;
                        while (n6 < n8) {
                            IConfigurationElement iConfigurationElement5 = iConfigurationElement4[n6];
                            String string = iConfigurationElement5.getAttribute("name");
                            String string2 = iConfigurationElement5.getAttribute("expr");
                            object5.put(string, string2);
                            String string3 = iConfigurationElement5.getAttribute("symmetry");
                            iConfigurationElementArray2.put(string, PropAnnotationInfo.EditFieldInfo.MatrixSymmetry.a((String)string3));
                            ++n6;
                        }
                        ((MaterialModel)simpleMaterialModelList.get(MaterialDB.MatRes.def.name())).setSynchronizationRule((String)object4, arrayList.toArray(new String[0]), (Map<String, String>)object5, (Map<String, PropAnnotationInfo.EditFieldInfo.MatrixSymmetry>)iConfigurationElementArray2);
                    } else if (object.getName().equals("identityrule")) {
                        object5 = object.getAttribute("materialproperty");
                        iConfigurationElementArray2 = object.getChildren("idmaterialproperty");
                        object4 = new ArrayList();
                        IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElementArray2;
                        int n9 = iConfigurationElementArray2.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            iConfigurationElement = iConfigurationElementArray3[n10];
                            String string = iConfigurationElement.getAttribute("propertygroup");
                            String string4 = iConfigurationElement.getAttribute("idmaterialproperty");
                            object4.add(new StringStringPair(string, string4));
                            ++n10;
                        }
                        ((MaterialModel)simpleMaterialModelList.get(MaterialDB.MatRes.def.name())).setIdentityRule(object4.toArray(new StringStringPair[0]), (String)object5);
                    } else if (object.getName().equals("class")) {
                        object3 = object;
                    }
                    ++n5;
                }
                if (object3 != null && (object = (IPhysicalQuantityProvider)PluginUtil.a(object3, (boolean)bl2)) != null) {
                    if (object.isDynamic()) {
                        this.f.add((IPhysicalQuantityProvider)object);
                    } else {
                        object.addMaterialModels(simpleMaterialModelList);
                        for (IExternalMaterialSocket iExternalMaterialSocket : object.getExternalMaterialSockets()) {
                            iExternalMaterialSocket.addPropertyGroup(simpleMaterialModelList);
                        }
                    }
                }
                ++n3;
            }
            for (Object object2 : simpleMaterialModelList) {
                this.c.put(object2.tag(), (MaterialModel)object2);
                this.a((MaterialModel)object2);
            }
        }

        private boolean a(String string) {
            return Optional.ofNullable(this.c.get(string)).filter(materialModel -> "dynamicGroups".equals(materialModel.getContainer().getTag())).isPresent();
        }

        private void a(MaterialModel materialModel) {
            Optional.ofNullable(this.d.put(materialModel.getIdentifier(), materialModel)).filter(materialModel2 -> !materialModel2.tag().equals(materialModel.tag())).ifPresent(materialModel2 -> FlLogger.c((String)String.format("The same identifier '%s' is used for the built-in property groups '%s' and '%s'.\nMay cause a potential conflict if they are used in the same material.", materialModel2.getIdentifier(), materialModel2.tag(), materialModel.tag())));
        }

        private void a(IConfigurationElement iConfigurationElement, MaterialModelList materialModelList) {
            Object object;
            IConfigurationElement iConfigurationElement2;
            Object object2;
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2;
            IConfigurationElement[] iConfigurationElementArray3;
            IConfigurationElement[] iConfigurationElementArray4;
            Object object3;
            Object object4;
            Object object5;
            IConfigurationElement[] iConfigurationElementArray5;
            IConfigurationElement[] iConfigurationElementArray6;
            Object object6;
            IConfigurationElement iConfigurationElement3;
            IConfigurationElement[] iConfigurationElementArray7;
            String string2 = iConfigurationElement.getAttribute("name");
            String string3 = iConfigurationElement.getAttribute("descr");
            MaterialModel materialModel = materialModelList.create(string2, FlLocale.getString((String)string3));
            Optional.ofNullable(iConfigurationElement.getAttribute("shortname")).ifPresent(string -> materialModel.setIdentifier((String)string));
            materialModel.addFlag(ModelEntity.Flags.NORETAG);
            String string4 = iConfigurationElement.getAttribute("parent");
            if (string4.length() > 0) {
                ((Information)materialModel.info().create("category")).body(string4);
            }
            IConfigurationElement[] iConfigurationElementArray8 = iConfigurationElementArray7 = iConfigurationElement.getChildren("materialproperty");
            int n2 = iConfigurationElementArray7.length;
            int n3 = 0;
            while (n3 < n2) {
                iConfigurationElement3 = iConfigurationElementArray8[n3];
                object6 = iConfigurationElement3.getAttribute("materialtype");
                iConfigurationElementArray6 = iConfigurationElement3.getAttribute("name");
                if ("custom".equals(object6)) {
                    iConfigurationElementArray5 = iConfigurationElement3.getAttribute("descr");
                    object5 = iConfigurationElement3.getAttribute("symbol");
                    object4 = q.b((String[])iConfigurationElement3.getAttribute("size").split("x"));
                    object3 = iConfigurationElement3.getAttribute("physicalquantity");
                    iConfigurationElementArray4 = ParamSpec.fromSize((int[])object4, (String)iConfigurationElementArray5, false);
                    if (object5.length() > 0) {
                        iConfigurationElementArray4.setSymbol((String)object5);
                    }
                    if (object3 != null && PhysicalQuantityManager.isID((String)object3)) {
                        iConfigurationElementArray4.setPhysicalIdentifier(PhysicalQuantityManager.getID((String)object3));
                    } else {
                        iConfigurationElementArray4.setUnit(iConfigurationElement3.getAttribute("unit"));
                    }
                    materialModel.setOutput((String)iConfigurationElementArray6, (ParamSpec)iConfigurationElementArray4);
                }
                materialModel.set((String)iConfigurationElementArray6, Optional.ofNullable(iConfigurationElement3.getAttribute("expr")).orElse(""));
                ++n3;
            }
            object6 = iConfigurationElement3 = iConfigurationElement.getChildren("modelinput");
            int n4 = ((IConfigurationElement)object6).length;
            n2 = 0;
            while (n2 < n4) {
                IConfigurationElement iConfigurationElement4 = object6[n2];
                Optional.ofNullable(iConfigurationElement4.getAttribute("physicalquantity")).ifPresent(string -> {
                    MaterialModel materialModel2 = materialModel.addInput((String)string);
                });
                ++n2;
            }
            iConfigurationElementArray6 = iConfigurationElementArray3 = iConfigurationElement.getChildren("function");
            int n5 = iConfigurationElementArray3.length;
            n4 = 0;
            while (n4 < n5) {
                IConfigurationElement iConfigurationElement5 = iConfigurationElementArray6[n4];
                MaterialFunction.addFromConfigurationElement(materialModel, iConfigurationElement5);
                ++n4;
            }
            iConfigurationElementArray5 = iConfigurationElementArray2 = iConfigurationElement.getChildren("localproperty");
            int n6 = iConfigurationElementArray2.length;
            n5 = 0;
            while (n5 < n6) {
                IConfigurationElement iConfigurationElement6 = iConfigurationElementArray5[n5];
                object5 = iConfigurationElement6.getAttribute("name");
                materialModel.set((String)object5, Optional.ofNullable(iConfigurationElement6.getAttribute("expr")).orElse(""));
                materialModel.descr((String)object5, Optional.ofNullable(FlLocale.getString((String)iConfigurationElement6.getAttribute("descr"))).orElse(""));
                ++n5;
            }
            object5 = iConfigurationElementArray = iConfigurationElement.getChildren("synchronizationrule");
            int n7 = iConfigurationElementArray.length;
            n6 = 0;
            while (n6 < n7) {
                IConfigurationElement iConfigurationElement7;
                IConfigurationElement iConfigurationElement8 = object5[n6];
                object4 = new HashMap();
                object3 = new HashMap();
                iConfigurationElementArray4 = iConfigurationElement8.getAttribute("propertygroup");
                object2 = iConfigurationElement8.getChildren("neededproperties");
                iConfigurationElement2 = new ArrayList();
                IConfigurationElement[] iConfigurationElementArray9 = object2;
                int n8 = ((IConfigurationElement[])object2).length;
                int n9 = 0;
                while (n9 < n8) {
                    iConfigurationElement7 = iConfigurationElementArray9[n9];
                    iConfigurationElement2.add(iConfigurationElement7.getAttribute("name"));
                    ++n9;
                }
                object = iConfigurationElement7 = iConfigurationElement8.getChildren("synchmaterialproperty");
                int n10 = ((IConfigurationElement)object).length;
                n8 = 0;
                while (n8 < n10) {
                    IConfigurationElement iConfigurationElement9 = object[n8];
                    String string5 = iConfigurationElement9.getAttribute("name");
                    String string6 = iConfigurationElement9.getAttribute("expr");
                    object4.put(string5, string6);
                    String string7 = iConfigurationElement9.getAttribute("symmetry");
                    object3.put(string5, PropAnnotationInfo.EditFieldInfo.MatrixSymmetry.a((String)string7));
                    ++n8;
                }
                materialModel.setSynchronizationRule((String)iConfigurationElementArray4, iConfigurationElement2.toArray(new String[0]), (Map<String, String>)object4, (Map<String, PropAnnotationInfo.EditFieldInfo.MatrixSymmetry>)object3);
                ++n6;
            }
            IConfigurationElement[] iConfigurationElementArray10 = iConfigurationElement.getChildren("identityrule");
            object4 = iConfigurationElementArray10;
            int n11 = iConfigurationElementArray10.length;
            n7 = 0;
            while (n7 < n11) {
                int n12 = object4[n7];
                object3 = n12.getAttribute("materialproperty");
                iConfigurationElementArray4 = n12.getChildren("idmaterialproperty");
                object2 = new ArrayList();
                IConfigurationElement[] iConfigurationElementArray11 = iConfigurationElementArray4;
                int n13 = iConfigurationElementArray4.length;
                int n14 = 0;
                while (n14 < n13) {
                    iConfigurationElement2 = iConfigurationElementArray11[n14];
                    String string8 = iConfigurationElement2.getAttribute("propertygroup");
                    object = iConfigurationElement2.getAttribute("idmaterialproperty");
                    object2.add(new StringStringPair(string8, (String)object));
                    ++n14;
                }
                materialModel.setIdentityRule(object2.toArray(new StringStringPair[0]), (String)object3);
                ++n7;
            }
        }

        private void h() {
            for (MaterialModel materialModel : this.c.values()) {
                String string;
                for (Map.Entry<String, String> entry : materialModel.getAllIdentityRules().entrySet()) {
                    string = entry.getKey().substring(0, entry.getKey().indexOf(":"));
                    String string2 = entry.getKey().substring(entry.getKey().indexOf(":") + 1);
                    String string3 = entry.getValue();
                    if (this.c.containsKey(string)) {
                        MaterialModel materialModel2 = this.c.get(string);
                        if (!materialModel2.hasParam(string2) && !string.equals("def")) {
                            throw new PhysicsAPIException("#The material parameter " + string2 + " does not exist in the property group " + string);
                        }
                        if (!materialModel.hasParam(string3) && !materialModel.tag().equals("def")) {
                            throw new PhysicsAPIException("#The material parameter " + string3 + " does not exist in the property group " + materialModel.tag());
                        }
                        if (materialModel2.getIdentityRule(materialModel.tag(), string3) != null) continue;
                        materialModel2.setIdentityRule(new StringStringPair[]{new StringStringPair(materialModel.tag(), string3)}, string2);
                        continue;
                    }
                    throw new PhysicsAPIException("#The property group " + string + " does not exist");
                }
                for (Map.Entry<String, Object> entry : materialModel.getAllSynchronizationRules().entrySet()) {
                    string = entry.getKey();
                    if (this.c.containsKey(string)) continue;
                    throw new PhysicsAPIException("#The property group " + string + " does not exist");
                }
            }
        }

        @Override
        public void creatorMapChanged() {
        }

        @Override
        public void creatorMapInvalid() {
            this.b = true;
        }
    }

    private static class b {
        private static b a = null;
        private boolean b = true;
        private Map<String, PhysicalQuantity> c;
        private Map<String, PhysicalQuantity> d;
        private Map<String, String> e = new HashMap<String, String>();
        private Map<String, PhysicalConstant> f;
        private Map<String, PhysicalQuantity> g;
        private Collection<IPhysicalQuantityProvider> h = new ArrayList<IPhysicalQuantityProvider>();

        private b() {
        }

        public static b a() {
            if (a == null) {
                com.comsol.model.applapi.PhysicalQuantityManager$b.d();
            }
            if (com.comsol.model.applapi.PhysicalQuantityManager$b.a.b && !BuilderAreaManager.isPreventLoadingOfDevelopmentFiles()) {
                b.clear();
                com.comsol.model.applapi.PhysicalQuantityManager$b.e();
            }
            return a;
        }

        private static synchronized void d() {
            a = new b();
            a.f();
        }

        public synchronized void b() {
            this.b = true;
        }

        private static synchronized void e() {
            a.g();
        }

        private void f() {
            this.h();
            this.a(PhysicalQuantityManager.c());
        }

        private void g() {
            Map.Entry<String, PhysicalQuantity> entry;
            this.b = false;
            Iterator<Map.Entry<String, PhysicalQuantity>> object2 = this.c.entrySet().iterator();
            while (object2.hasNext()) {
                entry = object2.next();
                if (!entry.getValue().isDynamic()) continue;
                object2.remove();
            }
            Iterator<Map.Entry<String, PhysicalQuantity>> iterator = this.d.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (this.c.containsKey(entry.getKey())) continue;
                this.c.put(entry.getKey(), entry.getValue());
                iterator.remove();
            }
            for (IPhysicalQuantityProvider iPhysicalQuantityProvider : this.h) {
                this.a(iPhysicalQuantityProvider);
            }
        }

        private void h() {
            this.c = new LinkedHashMap<String, PhysicalQuantity>();
            this.g = new HashMap<String, PhysicalQuantity>();
            this.d = new HashMap<String, PhysicalQuantity>();
            IExtensionPoint iExtensionPoint = PluginUtil.c((String)PhysicalQuantityManager.PHYSICAL_QUANTITY_PROVIDER_EXTENSION);
            boolean bl2 = SystemUtil.isDevelop();
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n2 = iExtensionArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                IExtension iExtension = iExtensionArray[n3];
                Object object2 = null;
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n4 = iConfigurationElementArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    object = iConfigurationElementArray[n5];
                    if (object.getName().equals("physicalquantity")) {
                        try {
                            this.a((IConfigurationElement)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            b.add(numberFormatException.getMessage());
                        }
                    } else if (object.getName().equals("class")) {
                        object2 = object;
                    }
                    ++n5;
                }
                if (object2 != null && (object = (IPhysicalQuantityProvider)PluginUtil.a(object2, (boolean)bl2)) != null) {
                    if (object.isDynamic()) {
                        this.h.add((IPhysicalQuantityProvider)object);
                    } else {
                        this.a((IPhysicalQuantityProvider)object);
                    }
                }
                ++n3;
            }
            if (bl2) {
                this.i();
            }
        }

        private void a(IConfigurationElement iConfigurationElement) {
            Object[] objectArray;
            String string = iConfigurationElement.getAttribute("name").toLowerCase(Locale.ENGLISH);
            String string2 = iConfigurationElement.getAttribute("varname");
            String string3 = iConfigurationElement.getAttribute("descr");
            String string4 = iConfigurationElement.getAttribute("symbol");
            String string5 = iConfigurationElement.getAttribute("category");
            int[] nArray = q.b((String[])iConfigurationElement.getAttribute("size").split("x"));
            boolean bl2 = Boolean.valueOf(iConfigurationElement.getAttribute("material"));
            String string6 = iConfigurationElement.getAttribute("modelinput");
            boolean bl3 = string6 != null ? Boolean.valueOf(string6) : false;
            String string7 = iConfigurationElement.getAttribute("defaultvalue");
            String[][] stringArray = null;
            if (string7 != null && string7.length() > 0) {
                objectArray = string7.split(",");
                stringArray = new String[nArray[0]][nArray[1]];
                int n2 = 0;
                int n3 = 0;
                while (n3 < nArray[0]) {
                    int n4 = 0;
                    while (n4 < nArray[1]) {
                        stringArray[n3][n4] = objectArray[n2++];
                        ++n4;
                    }
                    ++n3;
                }
            }
            objectArray = q.b((String[])iConfigurationElement.getAttribute("physicaldimension").split(","));
            if (string2.equals(string4)) {
                string2 = FlStringUtil.getVarNameFromSymbol((String)string4);
            }
            PhysicalQuantity physicalQuantity = new PhysicalQuantity(string, string2, string3, string4, nArray, (int[])objectArray, bl2, stringArray).setCategory(IPhysicalQuantity.getCategory(string5));
            if (!bl3) {
                physicalQuantity = physicalQuantity.doNotUseForModelInput();
            }
            this.c.put(string, physicalQuantity);
            this.a(physicalQuantity);
        }

        private void a(IPhysicalQuantityProvider iPhysicalQuantityProvider) {
            List<PhysicalQuantity> list = iPhysicalQuantityProvider.create();
            for (PhysicalQuantity physicalQuantity : list) {
                String string = physicalQuantity.fieldName();
                PhysicalQuantity physicalQuantity2 = this.c.put(string, physicalQuantity);
                if (physicalQuantity2 != null) {
                    String string2 = "Duplicate definition of the physical quantity with name: " + string;
                    b.add(string2);
                    CsPlugin.log(CsAbstractPlugin.LogLevel.ERROR, string2);
                    if (!this.d.containsKey(string) || !physicalQuantity2.isDynamic()) {
                        this.d.put(string, physicalQuantity2);
                    }
                    if (physicalQuantity.isMaterialProp() && !iPhysicalQuantityProvider.isDynamic()) {
                        if (this.e.containsKey(physicalQuantity.varName()) && SystemUtil.isDevelop()) {
                            throw new RuntimeException("Duplicate definition of material parameter variable '" + physicalQuantity.varName() + "'\n" + "id 1: " + this.e.get(physicalQuantity.varName()) + "\n" + "id 2: " + string);
                        }
                        this.e.put(physicalQuantity.varName(), physicalQuantity.fieldName());
                    }
                }
                if (physicalQuantity.getCategory() == null) {
                    physicalQuantity.setCategory(iPhysicalQuantityProvider.defaultCategory());
                }
                this.a(physicalQuantity);
            }
        }

        public void a(PhysicalQuantity physicalQuantity) {
            String string = physicalQuantity.varName();
            if ("".equals(string)) {
                physicalQuantity.doNotUseForModelInput();
                return;
            }
            PhysicalQuantity physicalQuantity2 = this.g.get(string);
            if (physicalQuantity2 != null && physicalQuantity.isValidForModeInput()) {
                throw new RuntimeException("Duplicate variable name definition '" + string + "' of the physical quantities:\n" + "previous: " + physicalQuantity2.fieldName() + "\n" + "current: " + physicalQuantity.fieldName());
            }
            if (physicalQuantity.isValidForModeInput()) {
                this.g.put(string, physicalQuantity);
            }
        }

        private void a(IPhysicalQuantityProvider[] iPhysicalQuantityProviderArray) {
            IPhysicalQuantityProvider iPhysicalQuantityProvider;
            this.f = new HashMap<String, PhysicalConstant>();
            Object[] objectArray = iPhysicalQuantityProviderArray;
            int n2 = iPhysicalQuantityProviderArray.length;
            int n3 = 0;
            while (n3 < n2) {
                iPhysicalQuantityProvider = objectArray[n3];
                List<PhysicalConstant> list = iPhysicalQuantityProvider.createConstants();
                for (PhysicalConstant physicalConstant : list) {
                    String string = physicalConstant.getIdentifier().name();
                    if (this.f.containsKey(string) && SystemUtil.isDevelop()) {
                        throw new RuntimeException("Duplicate definition of " + string);
                    }
                    this.f.put(string, physicalConstant);
                }
                ++n3;
            }
            if (this.f.size() < PhysicalConstantID.values().length) {
                objectArray = PhysicalConstantID.values();
                n2 = objectArray.length;
                n3 = 0;
                while (n3 < n2) {
                    iPhysicalQuantityProvider = objectArray[n3];
                    if (!this.f.containsKey(((Enum)((Object)iPhysicalQuantityProvider)).name()) && SystemUtil.isDevelop()) {
                        throw new RuntimeException("Physical constant ID '" + ((Enum)((Object)iPhysicalQuantityProvider)).name() + "' does not belong to an object.");
                    }
                    ++n3;
                }
            }
        }

        private void i() {
            if (SystemUtil.isDevelop()) {
                PhysicalQuantityID[] physicalQuantityIDArray = PhysicalQuantityID.values();
                int n2 = physicalQuantityIDArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    PhysicalQuantityID physicalQuantityID = physicalQuantityIDArray[n3];
                    if (!this.c.containsKey(physicalQuantityID.fieldName())) {
                        throw new RuntimeException("Physical quantity ID '" + physicalQuantityID.fieldName() + "' does not belong to an object.");
                    }
                    ++n3;
                }
            }
        }
    }

    private static class c
    implements ApplModeCreatorListener {
        private static c a = null;
        private boolean b = true;
        private Map<String, IFunctionOperatorInfo> c;
        private Map<String, IFunctionOperatorInfo> d;
        private Collection<IPhysicalQuantityProvider> e = new ArrayList<IPhysicalQuantityProvider>();

        private c() {
        }

        public static c a() {
            if (a == null) {
                com.comsol.model.applapi.PhysicalQuantityManager$c.c();
            }
            if (com.comsol.model.applapi.PhysicalQuantityManager$c.a.b && !BuilderAreaManager.isPreventLoadingOfDevelopmentFiles()) {
                b.clear();
                com.comsol.model.applapi.PhysicalQuantityManager$c.d();
            }
            return a;
        }

        private static synchronized void c() {
            a = new c();
            a.e();
            ApplModeCreatorManager.getInstance().addListener(a);
        }

        private static synchronized void d() {
            a.f();
        }

        @Override
        public void creatorMapChanged() {
        }

        @Override
        public void creatorMapInvalid() {
            this.b = true;
        }

        private void e() {
            this.h();
        }

        private void f() {
            Map.Entry<String, IFunctionOperatorInfo> entry;
            this.b = false;
            Iterator<Map.Entry<String, IFunctionOperatorInfo>> object2 = this.c.entrySet().iterator();
            while (object2.hasNext()) {
                entry = object2.next();
                if (entry.getValue().type() != IFunctionOperatorInfo.Type.BUILDERFUNC) continue;
                object2.remove();
            }
            Iterator<Map.Entry<String, IFunctionOperatorInfo>> iterator = this.d.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (this.c.containsKey(entry.getKey())) continue;
                this.c.put(entry.getKey(), entry.getValue());
                iterator.remove();
            }
            for (IPhysicalQuantityProvider iPhysicalQuantityProvider : this.e) {
                this.a(iPhysicalQuantityProvider);
            }
        }

        private FlException g() {
            PhysicsAPIException physicsAPIException = new PhysicsAPIException("Encountered_duplicate_Physics_Builder_functions");
            for (Map.Entry<String, IFunctionOperatorInfo> entry : this.d.entrySet()) {
                IFunctionOperatorInfo iFunctionOperatorInfo = this.c.get(entry.getKey());
                if (iFunctionOperatorInfo == null || iFunctionOperatorInfo.type() == IFunctionOperatorInfo.Type.BUILDERFUNC) continue;
                physicsAPIException.addParameterPair("Function", entry.getKey());
            }
            if (physicsAPIException.getParameterPairs().size() == 0 || physicsAPIException.getParameterPairs().get(0) == null) {
                return null;
            }
            return physicsAPIException;
        }

        private void h() {
            this.c = new HashMap<String, IFunctionOperatorInfo>();
            this.d = new HashMap<String, IFunctionOperatorInfo>();
            IExtensionPoint iExtensionPoint = PluginUtil.c((String)PhysicalQuantityManager.PHYSICAL_QUANTITY_PROVIDER_EXTENSION);
            boolean bl2 = SystemUtil.isDevelop();
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n2 = iExtensionArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                IExtension iExtension = iExtensionArray[n3];
                Object object2 = null;
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n4 = iConfigurationElementArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    object = iConfigurationElementArray[n5];
                    if (object.getName().equals("tensorfunction")) {
                        try {
                            this.a((IConfigurationElement)object, bl2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            b.add(numberFormatException.getMessage());
                        }
                    } else if (object.getName().equals("class")) {
                        object2 = object;
                    }
                    ++n5;
                }
                if (object2 != null && (object = (IPhysicalQuantityProvider)PluginUtil.a(object2, (boolean)bl2)) != null) {
                    if (object.isDynamic()) {
                        this.e.add((IPhysicalQuantityProvider)object);
                    } else {
                        this.a((IPhysicalQuantityProvider)object);
                    }
                }
                ++n3;
            }
        }

        private void a(IConfigurationElement iConfigurationElement, boolean bl2) {
            Object object;
            String string = iConfigurationElement.getNamespaceIdentifier();
            String string2 = iConfigurationElement.getAttribute("name");
            if (!string2.startsWith("phb.")) {
                string2 = "phb." + string2;
            }
            String string3 = iConfigurationElement.getAttribute("description");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            BuilderTensorFunctionInfo builderTensorFunctionInfo = new BuilderTensorFunctionInfo(string2, IFunctionOperatorInfo.Type.STATICBUILDERFUNC);
            builderTensorFunctionInfo.descriptions(string3);
            String string4 = iConfigurationElement.getAttribute("outputType");
            arrayList.add(string4);
            String[] stringArray = FlStringUtil.split((CharSequence)iConfigurationElement.getAttribute("arguments"), (char)',', (boolean)true);
            arrayList.add(stringArray);
            builderTensorFunctionInfo.allowedNArgs(new int[]{stringArray.length});
            String[] stringArray2 = FlStringUtil.split((CharSequence)iConfigurationElement.getAttribute("useSize"), (char)',', (boolean)true);
            arrayList.add(stringArray2);
            String[] stringArray3 = FlStringUtil.split((CharSequence)iConfigurationElement.getAttribute("sizeArray"), (char)',', (boolean)true);
            arrayList.add(stringArray3);
            if ("template".equals(string4)) {
                arrayList.add(iConfigurationElement.getAttribute("expression"));
                object = ApplAPIUtil.parseSize(iConfigurationElement.getAttribute("size"));
                arrayList.add(object);
            } else {
                arrayList.add(iConfigurationElement.getAttribute("expression"));
            }
            builderTensorFunctionInfo.constructorArgs(arrayList.toArray());
            object = iConfigurationElement.getAttribute("hide");
            if (!bl2 && "developoff".equals(object) || "on".equals(object)) {
                builderTensorFunctionInfo.plotGroup((BuiltInFunctions.a)BuiltInFunctions.Group.z);
            } else if (string != null) {
                Map map = PluginUtil.e((String)string);
                String string5 = (String)map.get("Bundle-Name");
                string5 = string5 == null || string5.trim().length() == 0 ? "Archive_X#" + string : "#" + string5;
                FunctionFactory.FunctionGroup functionGroup = new FunctionFactory.FunctionGroup(string, string5, null);
                builderTensorFunctionInfo.plotGroup(functionGroup);
            }
            this.c.put(string2, builderTensorFunctionInfo);
        }

        private void a(IPhysicalQuantityProvider iPhysicalQuantityProvider) {
            Map<String, IFunctionOperatorInfo> map = iPhysicalQuantityProvider.getPhysicsBuilderFunctions();
            map.values().forEach(iFunctionOperatorInfo -> {
                IFunctionOperatorInfo iFunctionOperatorInfo2;
                String string = iFunctionOperatorInfo.getKey();
                if (!string.startsWith("phb.")) {
                    b.add("Illegal name for Physics Builder function: " + string);
                }
                if (!iFunctionOperatorInfo.isVirtual()) {
                    b.add("Illegal type of Physics Builder function with name: " + string);
                }
                if ((iFunctionOperatorInfo2 = this.c.put(string, (IFunctionOperatorInfo)iFunctionOperatorInfo)) != null) {
                    String string2 = "Duplicate definition of the physics builder function with name: " + string;
                    b.add(string2);
                    CsPlugin.log(CsAbstractPlugin.LogLevel.ERROR, string2);
                    if (!this.d.containsKey(string) || iFunctionOperatorInfo2.type() == IFunctionOperatorInfo.Type.STATICBUILDERFUNC) {
                        this.d.put(string, iFunctionOperatorInfo2);
                    }
                }
            });
        }
    }
}

